/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.ListKeyListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends JList {
    protected static Border sNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addKeyListener(new ListKeyListener(this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object e;
                if (keyEvent.getKeyCode() == 32 && (e = CheckBoxList.this.getSelectedValue()) instanceof JCheckBox) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)e).isSelected());
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = CheckBoxList.this.getItemUnderPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if (CheckBoxList.this.pointOnCheckBox(mouseEvent.getPoint(), n)) {
                        JCheckBox jCheckBox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(n);
                        if (!jCheckBox.isEnabled()) {
                            return;
                        }
                        jCheckBox.setSelected(!jCheckBox.isSelected());
                        CheckBoxList.this.repaint();
                    }
                } else {
                    CheckBoxList.this.getSelectionModel().clearSelection();
                }
            }
        });
        this.setSelectionMode(0);
    }

    private int getItemUnderPoint(Point point) {
        Rectangle rectangle;
        int n = this.locationToIndex(point);
        if (n > -1 && !(rectangle = this.getCellBounds(n, n)).contains(point)) {
            n = -1;
        }
        return n;
    }

    private boolean pointOnCheckBox(Point point, int n) {
        if (n < 0 || n >= this.getModel().getSize()) {
            return false;
        }
        Rectangle rectangle = this.getCellBounds(n, n);
        rectangle.width = 20;
        return rectangle.contains(point);
    }

    protected class CellRenderer
    implements ListCellRenderer {
        protected CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JCheckBox jCheckBox = (JCheckBox)object;
            jCheckBox.setBackground(bl ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            jCheckBox.setForeground(bl ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
            jCheckBox.setEnabled(jCheckBox.isEnabled());
            jCheckBox.setFont(CheckBoxList.this.getFont());
            jCheckBox.setFocusPainted(true);
            jCheckBox.setBorderPainted(true);
            jCheckBox.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : sNoFocusBorder);
            return jCheckBox;
        }
    }
}

