/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.charteditor.template.ApplyFileChooser;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.CheckBoxList;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ChartTemplates
extends JPanel
implements ListSelectionListener {
    private static final String TEMPLATE_COUNT = "templ_count";
    private static final String TEMPLATE_ITEM = "templ_";
    private static final String ITEM_SELECTED = "item_selected";
    private static ResourceBundle sResourceBoundle = ResUtil.getBundle(GraphsResBundle.getDefaultResourceBundleName(), null);
    private FileTextField mTemplatePathField;
    private DefaultListModel mTemplateListModel;
    private TemplatesArrowButton mUpButton;
    private TemplatesArrowButton mDnButton;
    private ExcludeButton mExcludeButton;
    private CheckBoxList mTemplatesList;
    private JEditorPane mTemplateDescriptionField;
    private String mSelectTemplatePrompt;
    private JButton mAddButton;
    private SpssButtonGroup mGroup = new SpssButtonGroup();
    private static File sCurrentDirectory = null;
    private JFrame mSpssFrame;
    private int mWidth;
    private boolean mNeedInfo;

    public ChartTemplates(JFrame jFrame, String string, int n, boolean bl) {
        super(new GridBagLayout(), true);
        this.setBorder(new TitledBorder(string));
        this.mSpssFrame = jFrame;
        this.mWidth = n;
        this.mNeedInfo = bl;
        this.mSelectTemplatePrompt = sResourceBoundle.getString("IDS_SELECT_TEMPLATE");
        this.init();
        this.initializeData();
        this.mTemplatesList.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateListButtons();
    }

    public void saveState(DialogDataModel dialogDataModel) {
        int n = this.mTemplateListModel.getSize();
        dialogDataModel.putInteger(TEMPLATE_COUNT, n);
        for (int i = 0; i < n; ++i) {
            TemplateItem templateItem = (TemplateItem)this.mTemplateListModel.getElementAt(i);
            dialogDataModel.putString(TEMPLATE_ITEM + i, templateItem.toString());
            dialogDataModel.putBoolean(ITEM_SELECTED + i, templateItem.isSelected());
        }
    }

    public void loadState(DialogDataModel dialogDataModel) {
        this.mTemplateListModel.clear();
        Integer n = dialogDataModel.getInteger(TEMPLATE_COUNT);
        if (n == null) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            String string = dialogDataModel.getString(TEMPLATE_ITEM + i);
            boolean bl = dialogDataModel.getBoolean(ITEM_SELECTED + i);
            if (string.length() <= 0) continue;
            TemplateItem templateItem = new TemplateItem(string);
            templateItem.setSelected(bl);
            this.mTemplateListModel.addElement(templateItem);
        }
        this.updateListButtons();
    }

    @Deprecated
    public Vector<String> getSelectedTempPathString() {
        Vector<String> vector = new Vector<String>();
        if (this.mTemplateListModel != null) {
            int n = this.mTemplateListModel.getSize();
            for (int i = 0; i < n; ++i) {
                TemplateItem templateItem = (TemplateItem)this.mTemplateListModel.getElementAt(i);
                if (!templateItem.isSelected()) continue;
                vector.add(templateItem.toString());
            }
        }
        return vector;
    }

    public void reset() {
        this.mTemplateListModel.clear();
        this.initializeData();
    }

    private String getTemplateDescription(String string) {
        String string2 = "";
        File file = new File(string);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                char[] cArray = new char[2048];
                inputStreamReader.read(cArray, 0, cArray.length);
                inputStreamReader.close();
                fileInputStream.close();
                String string3 = new String(cArray);
                int n = string3.indexOf("description=\"");
                if (n > -1) {
                    int n2 = string3.indexOf("\"", n += "description=\"".length());
                    string2 = string3.substring(n, n2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    private JPanel setupDefualtValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = new JLabel(sResourceBoundle.getString("IDS_DEF_TEMPLATE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTemplatePathField = new FileTextField();
        this.mTemplatePathField.setOpaque(false);
        this.mTemplatePathField.setEditable(false);
        this.mTemplatePathField.setBorder(null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTemplatePathField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTemplateFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = new JLabel(sResourceBoundle.getString("IDS_TEMPLATE_FILES"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic((Integer)UIToolResUtil.getObject((String)"IDK_TEMPLATE_FILES_KEY", (ResourceBundle)sResourceBoundle));
        }
        jLabel.setVerticalAlignment(3);
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, n2, 1, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 25, insets);
        this.mAddButton = new JButton(new BrowseAction());
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 1, 0, 1, 1, 24, insets);
        this.mTemplateListModel = new DefaultListModel();
        this.mTemplatesList = new CheckBoxList();
        this.mTemplatesList.setModel(this.mTemplateListModel);
        this.mTemplatesList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mTemplatesList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = n2;
        insets.bottom = n2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 3, n, insets);
        this.mTemplatesList.setMinimumSize(new Dimension(this.mWidth, 75));
        this.mTemplatesList.setPreferredSize(new Dimension(this.mWidth, 75));
        jScrollPane.setMinimumSize(new Dimension(this.mWidth + 10, 80));
        jScrollPane.setPreferredSize(new Dimension(this.mWidth + 10, 80));
        Dimension dimension = new Dimension(24, 22);
        this.mUpButton = new TemplatesArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mUpButton.setPreferredSize(dimension);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left -= 2;
        insets.bottom += 2;
        DialogUtil.addUsingGBL(jPanel, this.mUpButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mDnButton = new TemplatesArrowButton(SpssArrowButton.ButtonOrientation.down);
        gridBagConstraints.weighty = 0.0;
        this.mDnButton.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mDnButton, gridBagConstraints, 2, 2, 1, 1, n, insets);
        this.mExcludeButton = new ExcludeButton();
        this.mExcludeButton.setPreferredSize(dimension);
        insets.top += 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExcludeButton, gridBagConstraints, 2, 3, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(sResourceBoundle.getString("IDS_DESCRIPTION"));
        jLabel2.setVerticalAlignment(3);
        insets = new Insets(1, n2, 1, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 4, 2, 1, n, insets);
        this.mGroup.add(this.mUpButton);
        this.mGroup.add(this.mDnButton);
        this.mGroup.add(this.mExcludeButton);
        this.mTemplateDescriptionField = new JEditorPane();
        this.mTemplateDescriptionField.setFont(this.getFont());
        this.mTemplateDescriptionField.setEditorKit(this.mTemplateDescriptionField.getEditorKitForContentType("text/html"));
        JScrollPane jScrollPane2 = new JScrollPane(this.mTemplateDescriptionField);
        this.mTemplateDescriptionField.setMinimumSize(new Dimension(this.mWidth, 36));
        this.mTemplateDescriptionField.setPreferredSize(new Dimension(this.mWidth, 36));
        jScrollPane2.setMinimumSize(new Dimension(this.mWidth + 10, 38));
        jScrollPane2.setPreferredSize(new Dimension(this.mWidth + 10, 38));
        this.mTemplateDescriptionField.setBorder(null);
        this.mTemplateDescriptionField.setOpaque(false);
        this.mTemplateDescriptionField.setFocusable(true);
        this.mTemplateDescriptionField.setEditable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 5, 2, 1, n, insets);
        return jPanel;
    }

    public JTextArea setupInfoArea() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = new JTextArea(sResourceBoundle.getString("IDS_TEMPLATE_INFO"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jTextArea.setMinimumSize(new Dimension(this.mWidth, 46));
        jTextArea.setPreferredSize(new Dimension(this.mWidth, 46));
        return jTextArea;
    }

    @Deprecated
    public Vector<Object> getTraversalComponents() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mAddButton);
        vector.add(this.mUpButton);
        vector.add(this.mDnButton);
        vector.add(this.mExcludeButton);
        vector.add(this.mTemplatesList);
        return vector;
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(3, n2, n2, n2);
        int n3 = 0;
        if (this.mNeedInfo) {
            DialogUtil.addUsingGBL(this, this.setupInfoArea(), gridBagConstraints, 0, n3++, 1, 1, n, insets);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = n2;
        insets.top += 2;
        DialogUtil.addUsingGBL(this, this.setupDefualtValuePanel(), gridBagConstraints, 0, n3++, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupTemplateFilePanel(), gridBagConstraints, 0, n3, 1, 1, n, new Insets(0, 0, 0, 0));
    }

    private void initializeData() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("charts");
        String string = preferences2.get("use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
        boolean bl = string.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]);
        if (bl) {
            string = preferences2.get("custom_template_path", "None");
            boolean bl2 = bl = !string.equals("None");
        }
        if (bl) {
            this.mTemplatePathField.setText(string);
        } else {
            this.mTemplatePathField.setText(sResourceBoundle.getString("IDS_NONE"));
        }
    }

    private void excludeSelected() {
        int n = this.mTemplatesList.getSelectedIndex();
        if (n > -1) {
            this.mTemplateListModel.removeElementAt(n);
            this.updateListButtons();
        }
    }

    private void updateListButtons() {
        int n = this.mTemplatesList.getSelectedIndex();
        int n2 = this.mTemplateListModel.getSize();
        boolean bl = n > 0;
        boolean bl2 = n > -1 && n < n2 - 1;
        this.mUpButton.setEnabled(bl);
        this.mDnButton.setEnabled(bl2);
        this.mExcludeButton.setEnabled(n > -1);
        this.updateDescriptionField();
    }

    private void updateDescriptionField() {
        String string = this.getFontFaceHTML();
        int n = this.mTemplatesList.getSelectedIndex();
        String string2 = n > -1 ? "<HTML>" + string + this.getTemplateDescription(this.mTemplateListModel.getElementAt(n).toString()) + "</FONT></HTML>" : "<HTML><P ALIGN=CENTER><I>" + string + this.mSelectTemplatePrompt + "</FONT></I></P></HTML>";
        this.mTemplateDescriptionField.setText(string2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartTemplates.this.mTemplateDescriptionField.scrollRectToVisible(new Rectangle(0, 0, 20, 20));
            }
        });
    }

    private String getFontFaceHTML() {
        String string = this.mTemplateDescriptionField.getFont().getFamily();
        String string2 = "3";
        return "<FONT FACE=\"" + string + "\" SIZE=\"" + string2 + "\">";
    }

    class SimpleFileFilter
    extends FileFilter {
        String description;
        String filter;

        public SimpleFileFilter(String string, String string2) {
            this.filter = string;
            this.description = string2;
        }

        @Override
        public boolean accept(File file) {
            boolean bl;
            if (file.isDirectory()) {
                bl = true;
            } else {
                String string = file.getName().toLowerCase();
                bl = string.endsWith(this.filter);
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    class TemplateItem
    extends JCheckBox {
        private String mFilePath;

        public TemplateItem(String string) {
            super(string);
            this.mFilePath = string;
            this.setToolTipText(this.mFilePath);
        }

        @Override
        public String toString() {
            return this.mFilePath;
        }
    }

    class ExcludeButton
    extends JButton {
        public ExcludeButton() {
            this.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChartTemplates.this.excludeSelected();
                }
            });
            String string = ResUtil.getCommonDlgString("IDS_EXCLUDE_IMAGE");
            ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(string));
            this.setIcon(imageIcon);
            string = ResUtil.getCommonDlgString("IDS_EXCLUDE_DISABLED_IMAGE");
            this.setDisabledIcon(new ImageIcon(ResUtil.getCommonDlgImageResource(string)));
            Image image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() + 1, imageIcon.getIconHeight() + 1, 4);
            this.setRolloverIcon(new ImageIcon(image));
            image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() - 1, imageIcon.getIconHeight() - 1, 4);
            this.setPressedIcon(new ImageIcon(image));
        }
    }

    class BrowseAction
    extends AbstractAction
    implements PropertyChangeListener {
        public BrowseAction() {
            this.putValue("Name", sResourceBoundle.getString("IDS_ADD"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", UIToolResUtil.getObject((String)"IDK_ADD_KEY", (ResourceBundle)sResourceBoundle));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            ApplyFileChooser applyFileChooser = new ApplyFileChooser(ChartTemplates.this.mSpssFrame, VersionInfo.allowPES(), string);
            applyFileChooser.setMultiSelectionEnabled(true);
            applyFileChooser.setDialogTitle(sResourceBoundle.getString("IDS_FIND_TEMPLATE_FILES"));
            applyFileChooser.addChoosableFileFilter((FileFilter)new SimpleFileFilter(".sgt", "Templates (*.sgt)"));
            if (sCurrentDirectory != null) {
                applyFileChooser.setCurrentDirectory(sCurrentDirectory);
            } else {
                applyFileChooser.setCurrentDirectory(new File(System.getProperty("application.home")));
            }
            applyFileChooser.addPropertyChangeListener((PropertyChangeListener)this);
            int n = applyFileChooser.showOpenDialog((Component)ChartTemplates.this.mSpssFrame);
            if (n == 0) {
                File[] fileArray;
                for (File file : fileArray = applyFileChooser.getSelectedFiles()) {
                    sCurrentDirectory = new File(file.getParentFile().getPath());
                    String string2 = file.getPath();
                    if (!file.exists()) continue;
                    TemplateItem templateItem = new TemplateItem(string2);
                    templateItem.setSelected(true);
                    ChartTemplates.this.mTemplateListModel.addElement(templateItem);
                    ChartTemplates.this.updateListButtons();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ApplyFileChooser applyFileChooser;
            File file;
            Object object;
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("SelectedFileChangedProperty") && (object = propertyChangeEvent.getSource()) instanceof ApplyFileChooser && (file = (applyFileChooser = (ApplyFileChooser)object).getSelectedFile()) != null && file.isFile() && file.getName().endsWith(".sgt")) {
                try {
                    String string2 = ChartTemplates.this.getTemplateDescription(file.getPath());
                    applyFileChooser.setDescription(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    class TemplatesArrowButton
    extends PlainListArrowButton {
        public TemplatesArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ChartTemplates.this.mTemplatesList.getSelectedIndex();
            if (this.mArrowOrientation == SpssArrowButton.ButtonOrientation.up) {
                if (n > 0) {
                    TemplateItem templateItem = (TemplateItem)ChartTemplates.this.mTemplateListModel.getElementAt(n);
                    ChartTemplates.this.mTemplateListModel.removeElementAt(n);
                    ChartTemplates.this.mTemplateListModel.insertElementAt(templateItem, n - 1);
                    ChartTemplates.this.mTemplatesList.setSelectedIndex(n - 1);
                }
            } else if (n < ChartTemplates.this.mTemplateListModel.getSize() - 1) {
                TemplateItem templateItem = (TemplateItem)ChartTemplates.this.mTemplateListModel.getElementAt(n);
                ChartTemplates.this.mTemplateListModel.removeElementAt(n);
                ChartTemplates.this.mTemplateListModel.insertElementAt(templateItem, n + 1);
                ChartTemplates.this.mTemplatesList.setSelectedIndex(n + 1);
            }
        }
    }
}

