/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.BaseDataList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoriesList
extends BaseDataList
implements ListSelectionListener {
    public static Icon sNormalIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NORMAL_CAT_IMAGE")));
    public static Icon sMissingIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_MISSING_CAT_IMAGE")));
    private VariableList mVarList = null;
    private Font mNormalFont;
    private Font mItalicFont;
    private String mEmptyText = "";

    public CategoriesList(VariableList variableList) {
        this.mVarList = variableList;
        this.setBackground(SystemColor.control);
        this.setModel(new DefaultListModel());
        this.setCellRenderer(new CatlistCellRenderer());
        this.updateUI();
    }

    @Override
    public void updateUI() {
        if (this.mVarList != null) {
            this.mVarList.removeListSelectionListener(this);
        }
        super.updateUI();
        if (this.mVarList != null) {
            this.mNormalFont = this.getFont();
            HashMap hashMap = new HashMap(this.mNormalFont.getAttributes());
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            this.mItalicFont = new Font(hashMap);
            this.mVarList.addListSelectionListener(this);
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.getModel().getSize() == 0 && this.mEmptyText.length() > 0 && graphics instanceof Graphics2D) {
            TextLayout textLayout;
            Rectangle rectangle = this.getBounds();
            rectangle.grow(-4, -4);
            Font font = graphics.getFont();
            graphics.setFont(this.mItalicFont);
            AttributedString attributedString = new AttributedString(this.mEmptyText);
            attributedString.addAttribute(TextAttribute.FONT, this.mItalicFont);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), new FontRenderContext(null, false, true));
            Vector<TextLayout> vector = new Vector<TextLayout>();
            while ((textLayout = lineBreakMeasurer.nextLayout(rectangle.width)) != null) {
                vector.add(textLayout);
            }
            float f = rectangle.y;
            for (TextLayout textLayout2 : vector) {
                float f2 = textLayout2.getAdvance();
                float f3 = (float)rectangle.x + ((float)rectangle.width - f2) / 2.0f;
                textLayout2.draw((Graphics2D)graphics, f3, f += textLayout2.getAscent());
                f += textLayout2.getDescent() + textLayout2.getLeading();
            }
            graphics.setFont(font);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = 0;
        boolean bl = false;
        GatherType gatherType = GatherType.gt_NoCats;
        Vector<VarCatItem> vector = new Vector<VarCatItem>();
        ISpssVariable[] iSpssVariableArray = this.mVarList.getSelectedValues();
        for (ISpssVariable object : iSpssVariableArray) {
            MeasurementLevel measurementLevel = object.getDisplayMeasurementLevel();
            if (measurementLevel.equals((Object)MeasurementLevel.nominal) || measurementLevel.equals((Object)MeasurementLevel.ordinal)) {
                bl = true;
                gatherType = this.analyzeCategories(object, vector, n == 0);
                if (gatherType.equals((Object)GatherType.gt_MixedSelection)) {
                    break;
                }
            } else if (gatherType.equals((Object)GatherType.gt_CatsPresent)) {
                gatherType = GatherType.gt_MixedSelection;
                vector.clear();
                break;
            }
            ++n;
        }
        Collections.sort(vector);
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.clear();
        ArrayList<VarCatItem> arrayList = new ArrayList<VarCatItem>();
        arrayList.ensureCapacity(vector.size());
        for (VarCatItem varCatItem : vector) {
            if (varCatItem.isMissing()) continue;
            arrayList.add(varCatItem);
        }
        for (VarCatItem varCatItem : vector) {
            if (!varCatItem.isMissing()) continue;
            arrayList.add(varCatItem);
        }
        defaultListModel.setSize(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultListModel.set(i, arrayList.get(i));
        }
        String string = "";
        if (defaultListModel.size() == 0) {
            if (gatherType.equals((Object)GatherType.gt_MixedSelection)) {
                string = ResUtil.getCommonDlgString("IDS_MIXED_SELECTION");
            } else if (!this.mVarList.getSelectionModel().isSelectionEmpty()) {
                string = ResUtil.getCommonDlgString("IDS_NO_CATEGORIES");
                if (!bl) {
                    string = string + " " + ResUtil.getCommonDlgString("IDS_SCALE_VARIABLE");
                }
            } else {
                string = ResUtil.getCommonDlgString("IDS_NO_SELECTIONS");
            }
        } else {
            this.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.setEmptyText(string);
        this.setFont(gatherType.equals((Object)GatherType.gt_PseudoCats) ? this.mItalicFont : this.mNormalFont);
        this.repaint();
    }

    private GatherType analyzeCategories(ISpssVariable iSpssVariable, Vector<VarCatItem> vector, boolean bl) {
        Object object;
        Object object2;
        GatherType gatherType = GatherType.gt_CatsPresent;
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        int n = 0;
        if (!bl && iValueLabelMap.size() != vector.size()) {
            gatherType = GatherType.gt_MixedSelection;
            vector.clear();
        } else {
            object2 = iValueLabelMap.getValueLabelEntries();
            object = object2.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                OBS oBS = (OBS)entry.getKey();
                String string = (String)entry.getValue();
                if (!iSpssVariable.isMissing(oBS)) {
                    ++n;
                }
                VarCatItem varCatItem = new VarCatItem(string, iSpssVariable.isMissing(oBS), oBS);
                if (bl) {
                    vector.add(varCatItem);
                    continue;
                }
                int n2 = vector.indexOf(varCatItem);
                if (n2 >= 0) continue;
                gatherType = GatherType.gt_MixedSelection;
                vector.clear();
                break;
            }
        }
        if (n == 0 && gatherType != GatherType.gt_MixedSelection) {
            if (iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.scale) {
                object2 = ResUtil.getCommonDlgString("IDS_CATEGORY_NUM");
                object = new VarCatItem(String.format((String)object2, 1), false, new OBS(1.0));
                vector.insertElementAt((VarCatItem)object, 0);
                object = new VarCatItem(String.format((String)object2, 2), false, new OBS(2.0));
                vector.insertElementAt((VarCatItem)object, 1);
                gatherType = GatherType.gt_PseudoCats;
            } else {
                gatherType = GatherType.gt_NoCats;
            }
        }
        return gatherType;
    }

    public String getEmptyText() {
        return this.mEmptyText;
    }

    public void setEmptyText(String string) {
        this.mEmptyText = string;
    }

    static enum GatherType {
        gt_NoCats,
        gt_CatsPresent,
        gt_PseudoCats,
        gt_MixedSelection;

    }

    public class CatlistCellRenderer
    extends JLabel
    implements ListCellRenderer {
        CatlistCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof VarCatItem;
            if (bl3) {
                VarCatItem varCatItem = (VarCatItem)object;
                this.setIcon(varCatItem.getIcon());
                this.setText(varCatItem.getName());
            }
            if (bl) {
                if (CategoriesList.this.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    public static class VarCatItem
    implements Comparable<Object> {
        private String mName;
        private OBS mObs;
        private boolean mIsMissing;

        public VarCatItem(String string, boolean bl, OBS oBS) {
            this.mName = string;
            this.mIsMissing = bl;
            this.mObs = oBS;
        }

        public String getName() {
            return this.mName;
        }

        public OBS getObs() {
            return this.mObs;
        }

        public boolean isMissing() {
            return this.mIsMissing;
        }

        public boolean isString() {
            return this.mObs.isString();
        }

        public Icon getIcon() {
            return this.mIsMissing ? sMissingIcon : sNormalIcon;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public int compareTo(Object object) {
            if (!(object instanceof VarCatItem)) {
                return -1;
            }
            VarCatItem varCatItem = (VarCatItem)object;
            if (this.isString() != varCatItem.isString()) {
                return this.isString() ? 1 : -1;
            }
            if (this.isString()) {
                int n;
                int n2;
                int n3;
                String string = this.mObs.getString();
                String string2 = varCatItem.mObs.getString();
                ArrayList<String> arrayList = this.split(string);
                ArrayList<String> arrayList2 = this.split(string2);
                if (arrayList.size() == 0 || arrayList.size() != arrayList2.size()) {
                    return string.compareTo(string2);
                }
                String string3 = "";
                String string4 = "";
                for (n3 = 0; n3 < arrayList.size() && (string3 = arrayList.get(n3)).equals(string4 = arrayList2.get(n3)); ++n3) {
                }
                if (n3 == arrayList.size()) {
                    return 0;
                }
                try {
                    n2 = Integer.parseInt(string3);
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2);
                }
                ++n3;
                while (n3 < arrayList.size()) {
                    string3 = arrayList.get(n3);
                    if (!string3.equals(string4 = arrayList2.get(n3))) {
                        return string.compareTo(string2);
                    }
                    ++n3;
                }
                return n2 < n ? -1 : 1;
            }
            if (this.mObs.getNum() < varCatItem.mObs.getNum()) {
                return -1;
            }
            if (this.mObs.getNum() > varCatItem.mObs.getNum()) {
                return 1;
            }
            return 0;
        }

        private ArrayList<String> split(String string) {
            Pattern pattern = Pattern.compile("(\\d+|\\D+)");
            ArrayList<String> arrayList = new ArrayList<String>();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1);
                arrayList.add(string2);
            }
            return arrayList;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VarCatItem)) {
                return false;
            }
            VarCatItem varCatItem = (VarCatItem)object;
            return this.isMissing() == varCatItem.isMissing() && this.getName().equals(varCatItem.getName()) && this.mObs.equals((Object)varCatItem.mObs);
        }
    }
}

