/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CalcWidget
extends JPanel {
    protected static Map<Integer, String> operatorMap;
    protected static final int OPERATOR_PLUS = 1;
    protected static final int OPERATOR_MINUS = 2;
    protected static final int OPERATOR_MULTIPLICATION = 3;
    protected static final int OPERATOR_DIVISION = 4;
    protected static final int OPERATOR_DOUBLE_CROSS = 5;
    private static final int OPERATOR_LESS_THAN = 6;
    private static final int OPERATOR_LESS_THAN_EQUAL = 7;
    private static final int OPERATOR_GREATER_THAN = 8;
    private static final int OPERATOR_GREATER_THAN_EQUAL = 9;
    private static final int OPERATOR_EQUAL = 10;
    private static final int OPERATOR_AND = 11;
    private static final int OPERATOR_OR = 12;
    private static final int OPERATOR_NEGATION = 13;
    private static final int OPERATOR_NEGATION_EQUAL = 14;
    private static final int OPERATOR_POWER = 15;
    protected static final int KEY_SETS_GAP = 9;
    protected static final int BUTTON_HORIZONTAL_GAP = 4;
    protected static final int BUTTON_VERTICAL_GAP = 4;
    protected JTextArea mTextArea;
    protected CalcType mCalcType;
    protected Vector<AbstractButton> mButtonsGroup = new Vector();
    protected ButtonGroupKeylistener mArrowKeyListener = new ButtonGroupKeylistener();
    protected JButton mPlusButton;
    protected JButton mMinusButton;
    protected JButton mMultiplicationButton;
    protected JButton mDivisionButton;
    protected JButton mDoubleCrossButton;
    private JButton mLessThanButton;
    private JButton mLessThanEqualsButton;
    private JButton mEqualButton;
    private JButton mAndButton;
    private JButton mCapOrNegationButton;
    private JButton mGreaterThanButton;
    private JButton mGreaterThanEqualsButton;
    private JButton mCapNegationEqualsButton;
    private JButton mOrButton;
    protected JButton mRoundBracketButton;
    private JButton mSevenButton;
    private JButton mFourButton;
    private JButton mOneButton;
    private JButton mZeroButton;
    private JButton mDeleteButton;
    private JButton mEightButton;
    private JButton mFiveButton;
    private JButton mTwoButton;
    private JButton mNineButton;
    private JButton mSixButton;
    private JButton mThreeButton;
    private JButton mDotButton;

    public CalcWidget(JTextArea jTextArea) {
        this(jTextArea, CalcType.eRelationalWithTilde);
    }

    public CalcWidget(JTextArea jTextArea, CalcType calcType) {
        this.mTextArea = jTextArea;
        this.setCalcType(calcType);
        if (null == operatorMap) {
            this.initOperatorMap();
        }
        this.init();
    }

    public void changeTextAreaAssociation(JTextArea jTextArea) {
        this.mTextArea = jTextArea;
    }

    public JTextArea getCurrentTextArea() {
        return this.mTextArea;
    }

    public void setCalcType(CalcType calcType) {
        this.mCalcType = calcType;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.recursiveEnableDisable(this, bl);
    }

    public JButton getDefaultFocusButton() {
        return this.mPlusButton;
    }

    private void recursiveEnableDisable(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof JButton) {
                component.setEnabled(bl);
            }
            if (!(component instanceof Container)) continue;
            this.recursiveEnableDisable((Container)component, bl);
        }
    }

    protected void initOperatorMap() {
        operatorMap = new HashMap<Integer, String>();
        operatorMap.put(1, "+");
        operatorMap.put(2, "-");
        operatorMap.put(3, "*");
        operatorMap.put(4, "/");
        operatorMap.put(5, "**");
        operatorMap.put(6, "<");
        operatorMap.put(7, "<=");
        operatorMap.put(10, "=");
        operatorMap.put(11, "&");
        operatorMap.put(13, "~");
        operatorMap.put(8, ">");
        operatorMap.put(9, ">=");
        operatorMap.put(15, "^");
        operatorMap.put(14, "~=");
        operatorMap.put(12, "|");
    }

    protected void init() {
        this.setupCalcPanel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.populateButtonGroupVector();
    }

    protected void setupCalcPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        int n2 = 1;
        Insets insets = new Insets(0, 0, 0, 9);
        DialogUtil.addUsingGBL(this, this.setupOperatorPanel(), gridBagConstraints, n2++, 0, 1, 1, n, insets);
        if (this.mCalcType == CalcType.eRelationalOperator || this.mCalcType == CalcType.eRelationalWithTilde) {
            DialogUtil.addUsingGBL(this, this.setupRelationalPanel(), gridBagConstraints, n2, 0, 2, 1, n, insets);
            n2 += 2;
        }
        DialogUtil.addUsingGBL(this, this.setupDigitsPanel(), gridBagConstraints, n2, 0, 3, 1, n, null);
        Dimension dimension = this.mCalcType == CalcType.eRelationalOperator ? new Dimension(190, 165) : new Dimension(131, 165);
        this.setMinimumSize(dimension);
    }

    private JPanel setupDigitsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = new Insets(4, 0, 0, 4);
        this.mSevenButton = this.createButtonWithAction("7");
        Insets insets2 = new Insets(0, 0, 0, 4);
        DialogUtil.addUsingGBL(jPanel, this.mSevenButton, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mEightButton = this.createButtonWithAction("8");
        DialogUtil.addUsingGBL(jPanel, this.mEightButton, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        this.mNineButton = this.createButtonWithAction("9");
        DialogUtil.addUsingGBL(jPanel, this.mNineButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        insets2 = new Insets(4, 0, 0, 4);
        Insets insets3 = new Insets(4, 0, 0, 4);
        this.mFourButton = this.createButtonWithAction("4");
        DialogUtil.addUsingGBL(jPanel, this.mFourButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mFiveButton = this.createButtonWithAction("5");
        DialogUtil.addUsingGBL(jPanel, this.mFiveButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mSixButton = this.createButtonWithAction("6");
        DialogUtil.addUsingGBL(jPanel, this.mSixButton, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        this.mOneButton = this.createButtonWithAction("1");
        DialogUtil.addUsingGBL(jPanel, this.mOneButton, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mTwoButton = this.createButtonWithAction("2");
        DialogUtil.addUsingGBL(jPanel, this.mTwoButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mThreeButton = this.createButtonWithAction("3");
        DialogUtil.addUsingGBL(jPanel, this.mThreeButton, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        this.mZeroButton = this.createButtonWithAction("0");
        DialogUtil.addUsingGBL(jPanel, this.mZeroButton, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.mDotButton = this.createButtonWithAction(".");
        DialogUtil.addUsingGBL(jPanel, this.mDotButton, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        if (this.mCalcType == CalcType.eRelationalOperator || this.mCalcType == CalcType.eRelationalWithTilde) {
            this.mDeleteButton = this.createButtonWithAction(ResUtil.getCommonDlgString("IDS_DELETE"));
            DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 0, 4, 3, 1, n, insets3);
        } else {
            this.mRoundBracketButton = this.createButtonWithAction("( )");
            DialogUtil.addUsingGBL(jPanel, this.mRoundBracketButton, gridBagConstraints, 0, 4, 1, 1, n, insets2);
            this.mDeleteButton = this.createButtonWithAction(ResUtil.getCommonDlgString("IDS_DELETE"));
            DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 1, 4, 2, 1, n, insets3);
        }
        return jPanel;
    }

    protected JPanel setupRelationalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = new Insets(0, 0, 0, 4);
        this.mLessThanButton = this.createButtonWithAction(operatorMap.get(6));
        DialogUtil.addUsingGBL(jPanel, this.mLessThanButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mGreaterThanButton = this.createButtonWithAction(operatorMap.get(8));
        DialogUtil.addUsingGBL(jPanel, this.mGreaterThanButton, gridBagConstraints, 1, 0, 1, 1, n, null);
        insets = new Insets(4, 0, 0, 4);
        Insets insets2 = new Insets(4, 0, 0, 0);
        this.mLessThanEqualsButton = this.createButtonWithAction(operatorMap.get(7));
        DialogUtil.addUsingGBL(jPanel, this.mLessThanEqualsButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mGreaterThanEqualsButton = this.createButtonWithAction(operatorMap.get(9));
        DialogUtil.addUsingGBL(jPanel, this.mGreaterThanEqualsButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mEqualButton = this.createButtonWithAction(operatorMap.get(10));
        DialogUtil.addUsingGBL(jPanel, this.mEqualButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mCapNegationEqualsButton = this.createButtonWithAction(operatorMap.get(14));
        DialogUtil.addUsingGBL(jPanel, this.mCapNegationEqualsButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mAndButton = this.createButtonWithAction(operatorMap.get(11));
        DialogUtil.addUsingGBL(jPanel, this.mAndButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mOrButton = this.createButtonWithAction(operatorMap.get(12));
        DialogUtil.addUsingGBL(jPanel, this.mOrButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        if (this.mCalcType == CalcType.eRelationalWithTilde) {
            this.mCapOrNegationButton = this.createButtonWithAction(operatorMap.get(13));
            DialogUtil.addUsingGBL(jPanel, this.mCapOrNegationButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        } else {
            this.mCapOrNegationButton = this.createButtonWithAction(operatorMap.get(15));
            DialogUtil.addUsingGBL(jPanel, this.mCapOrNegationButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        }
        this.mRoundBracketButton = this.createButtonWithAction("( )");
        DialogUtil.addUsingGBL(jPanel, this.mRoundBracketButton, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        return jPanel;
    }

    protected JPanel setupOperatorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = new Insets(4, 0, 0, 0);
        this.mPlusButton = this.createButtonWithAction(operatorMap.get(1));
        DialogUtil.addUsingGBL(jPanel, this.mPlusButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mMinusButton = this.createButtonWithAction(operatorMap.get(2));
        DialogUtil.addUsingGBL(jPanel, this.mMinusButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMultiplicationButton = this.createButtonWithAction(operatorMap.get(3));
        DialogUtil.addUsingGBL(jPanel, this.mMultiplicationButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mDivisionButton = this.createButtonWithAction(operatorMap.get(4));
        DialogUtil.addUsingGBL(jPanel, this.mDivisionButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mDoubleCrossButton = this.createButtonWithAction(operatorMap.get(5));
        DialogUtil.addUsingGBL(jPanel, this.mDoubleCrossButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    protected JButton createButtonWithAction(String string) {
        CalcButtonAction calcButtonAction = new CalcButtonAction();
        JButton jButton = new JButton(calcButtonAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        int n = 35;
        int n2 = 30;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 35;
            n2 = 30;
            jButton.putClientProperty("JButton.buttonType", "square");
        }
        jButton.setPreferredSize(new Dimension(n, n2));
        jButton.setText(string);
        return jButton;
    }

    protected void populateButtonGroupVector() {
        this.mButtonsGroup.addElement(this.mPlusButton);
        this.mButtonsGroup.addElement(this.mMinusButton);
        this.mButtonsGroup.addElement(this.mMultiplicationButton);
        this.mButtonsGroup.addElement(this.mDivisionButton);
        this.mButtonsGroup.addElement(this.mDoubleCrossButton);
        this.mPlusButton.addKeyListener(this.mArrowKeyListener);
        this.mMinusButton.addKeyListener(this.mArrowKeyListener);
        this.mMultiplicationButton.addKeyListener(this.mArrowKeyListener);
        this.mDivisionButton.addKeyListener(this.mArrowKeyListener);
        this.mDoubleCrossButton.addKeyListener(this.mArrowKeyListener);
        if (this.mCalcType == CalcType.eRelationalOperator || this.mCalcType == CalcType.eRelationalWithTilde) {
            this.mButtonsGroup.addElement(this.mLessThanButton);
            this.mButtonsGroup.addElement(this.mLessThanEqualsButton);
            this.mButtonsGroup.addElement(this.mEqualButton);
            this.mButtonsGroup.addElement(this.mAndButton);
            this.mButtonsGroup.addElement(this.mCapOrNegationButton);
            this.mButtonsGroup.addElement(this.mGreaterThanButton);
            this.mButtonsGroup.addElement(this.mGreaterThanEqualsButton);
            this.mButtonsGroup.addElement(this.mCapNegationEqualsButton);
            this.mButtonsGroup.addElement(this.mOrButton);
            this.mButtonsGroup.addElement(this.mRoundBracketButton);
            this.mLessThanButton.addKeyListener(this.mArrowKeyListener);
            this.mLessThanEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mEqualButton.addKeyListener(this.mArrowKeyListener);
            this.mAndButton.addKeyListener(this.mArrowKeyListener);
            this.mCapOrNegationButton.addKeyListener(this.mArrowKeyListener);
            this.mGreaterThanButton.addKeyListener(this.mArrowKeyListener);
            this.mGreaterThanEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mCapNegationEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mOrButton.addKeyListener(this.mArrowKeyListener);
            this.mRoundBracketButton.addKeyListener(this.mArrowKeyListener);
        }
        this.mButtonsGroup.addElement(this.mSevenButton);
        this.mButtonsGroup.addElement(this.mFourButton);
        this.mButtonsGroup.addElement(this.mOneButton);
        this.mButtonsGroup.addElement(this.mZeroButton);
        this.mButtonsGroup.addElement(this.mDeleteButton);
        this.mButtonsGroup.addElement(this.mEightButton);
        this.mButtonsGroup.addElement(this.mFiveButton);
        this.mButtonsGroup.addElement(this.mTwoButton);
        this.mButtonsGroup.addElement(this.mNineButton);
        this.mButtonsGroup.addElement(this.mSixButton);
        this.mButtonsGroup.addElement(this.mThreeButton);
        this.mButtonsGroup.addElement(this.mDotButton);
        this.mSevenButton.addKeyListener(this.mArrowKeyListener);
        this.mFourButton.addKeyListener(this.mArrowKeyListener);
        this.mOneButton.addKeyListener(this.mArrowKeyListener);
        this.mZeroButton.addKeyListener(this.mArrowKeyListener);
        this.mDeleteButton.addKeyListener(this.mArrowKeyListener);
        this.mEightButton.addKeyListener(this.mArrowKeyListener);
        this.mFiveButton.addKeyListener(this.mArrowKeyListener);
        this.mTwoButton.addKeyListener(this.mArrowKeyListener);
        this.mNineButton.addKeyListener(this.mArrowKeyListener);
        this.mSixButton.addKeyListener(this.mArrowKeyListener);
        this.mThreeButton.addKeyListener(this.mArrowKeyListener);
        this.mDotButton.addKeyListener(this.mArrowKeyListener);
    }

    private class ButtonGroupKeylistener
    extends KeyAdapter {
        private ButtonGroupKeylistener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            AbstractButton abstractButton = (AbstractButton)keyEvent.getComponent();
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
                AbstractButton abstractButton2;
                int n = CalcWidget.this.mButtonsGroup.indexOf(abstractButton) + 1;
                do {
                    if (n != CalcWidget.this.mButtonsGroup.size()) continue;
                    n = 0;
                } while (!(abstractButton2 = CalcWidget.this.mButtonsGroup.elementAt(n++)).isEnabled());
                this.focusButton(abstractButton2);
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                AbstractButton abstractButton3;
                int n = CalcWidget.this.mButtonsGroup.indexOf(abstractButton) - 1;
                do {
                    if (n != -1) continue;
                    n += CalcWidget.this.mButtonsGroup.size();
                } while (!(abstractButton3 = CalcWidget.this.mButtonsGroup.elementAt(n--)).isEnabled());
                this.focusButton(abstractButton3);
            }
        }

        private void focusButton(AbstractButton abstractButton) {
            abstractButton.requestFocusInWindow();
        }
    }

    private class CalcButtonAction
    extends AbstractAction {
        private CalcButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JButton)actionEvent.getSource()).getText();
            if (!string.equalsIgnoreCase(ResUtil.getCommonDlgString("IDS_DELETE"))) {
                if (operatorMap.containsValue(string)) {
                    string = " " + string + " ";
                }
                if (string.equals("( )")) {
                    String string2 = CalcWidget.this.mTextArea.getSelectedText();
                    if (string2 != null && string2.length() > 0) {
                        CalcWidget.this.mTextArea.replaceSelection("(" + string2 + ")");
                    } else {
                        int n = CalcWidget.this.mTextArea.getSelectionStart();
                        CalcWidget.this.mTextArea.replaceSelection("()");
                        CalcWidget.this.mTextArea.setCaretPosition(n + 1);
                    }
                } else if (string.equals("[ ]")) {
                    String string3 = CalcWidget.this.mTextArea.getSelectedText();
                    if (string3 != null && string3.length() > 0) {
                        CalcWidget.this.mTextArea.replaceSelection("[" + string3 + "]");
                    } else {
                        int n = CalcWidget.this.mTextArea.getSelectionStart();
                        CalcWidget.this.mTextArea.replaceSelection("[]");
                        CalcWidget.this.mTextArea.setCaretPosition(n + 1);
                    }
                } else {
                    CalcWidget.this.mTextArea.replaceSelection(string);
                }
            } else {
                CalcWidget.this.mTextArea.replaceSelection("");
            }
            CalcWidget.this.mTextArea.requestFocus();
        }
    }

    public static enum CalcType {
        eRelationalOperator,
        eNoRelationalOperator,
        eRelationalWithTilde;

    }
}

