/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasicACRWidget
extends JPanel
implements ListSelectionListener,
FocusListener,
ListDataListener {
    private JButton mAddButton;
    private JButton mChangeButton;
    private JButton mRemoveButton;
    protected SerializableList mItemList;
    protected JScrollPane mScrollPane;
    protected Action mAddAction;
    protected Action mChangeAction;
    protected Action mRemoveAction;
    private List<IBasicACRListener> mListeners = new ArrayList<IBasicACRListener>();
    private boolean mAllowDuplicates = false;
    protected ButtonOrienation mButtonOrienation;
    protected String mListKey;

    public BasicACRWidget(String string) {
        this(ButtonOrienation.eWEST, string);
    }

    public BasicACRWidget(ButtonOrienation buttonOrienation, String string) {
        super(true);
        this.mButtonOrienation = buttonOrienation;
        this.mListKey = string;
        this.init();
    }

    public boolean isSerializable() {
        return this.mItemList.isSerializable();
    }

    public void setSerializable(boolean bl) {
        this.mItemList.setSerializable(bl);
    }

    public void setListPreferredSize(Dimension dimension) {
        this.mScrollPane.setPreferredSize(dimension);
    }

    public void clearListModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        defaultListModel.clear();
    }

    public int getListItemCount() {
        return this.mItemList.getModel().getSize();
    }

    public Object[] getListItems() {
        int n = this.mItemList.getModel().getSize();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.mItemList.getModel().getElementAt(i);
        }
        return objectArray;
    }

    public void setListItems(Object[] objectArray) {
        this.clearListModel();
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        for (Object object : objectArray) {
            if (this.mAllowDuplicates) {
                defaultListModel.addElement(object);
                continue;
            }
            if (defaultListModel.contains(object)) continue;
            defaultListModel.addElement(object);
        }
    }

    public void setListSelectedIndex(int n) {
        this.mItemList.setSelectedIndex(n);
    }

    public int getListSelectedIndex() {
        if (this.mItemList.getModel().getSize() == 0) {
            return -1;
        }
        return this.mItemList.getSelectedIndex();
    }

    public void removeListItemAt(int n) {
        ((DefaultListModel)this.mItemList.getModel()).removeElementAt(n);
    }

    public Object getListItemAt(int n) {
        return this.mItemList.getModel().getElementAt(n);
    }

    public int indexOf(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        return defaultListModel.indexOf(object);
    }

    public void addListItemAt(int n, Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        if (!this.mAllowDuplicates && defaultListModel.contains(object)) {
            return;
        }
        defaultListModel.add(n, object);
    }

    public void clearItemListSelection() {
        ListSelectionModel listSelectionModel = this.mItemList.getSelectionModel();
        listSelectionModel.setAnchorSelectionIndex(0);
        listSelectionModel.setLeadSelectionIndex(0);
        listSelectionModel.clearSelection();
    }

    public SerializableList getList() {
        return this.mItemList;
    }

    public void setAddEnabled(boolean bl) {
        this.mAddAction.setEnabled(bl);
    }

    public void setChangeEnabled(boolean bl) {
        this.mChangeAction.setEnabled(bl);
    }

    public void setRemoveEnabled(boolean bl) {
        this.mRemoveAction.setEnabled(bl);
    }

    public boolean isAddEnabled() {
        return this.mAddAction.isEnabled();
    }

    public boolean isChangeEnabled() {
        return this.mChangeAction.isEnabled();
    }

    public boolean isRemoveEnabled() {
        return this.mRemoveAction.isEnabled();
    }

    public boolean getAllowDuplicates() {
        return this.mAllowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    public void addBasicACRListener(IBasicACRListener iBasicACRListener) {
        this.mListeners.add(iBasicACRListener);
    }

    public void removeBasicACRListener(IBasicACRListener iBasicACRListener) {
        this.mListeners.remove(iBasicACRListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listSelectionValueChange, listSelectionEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listGotFocus, focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listLostFocus, focusEvent);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listItemAdd, listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listItemRemove, listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireBasicACREvent(BasicACREvent.EventType.listItemChange, listDataEvent);
    }

    public void setAddMnemonic(int n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != 0) {
            this.mAddAction.putValue("MnemonicKey", n);
        }
    }

    public void setAddText(String string) {
        this.mAddButton.setText(string);
    }

    public void setRemoveText(String string) {
        this.mRemoveButton.setText(string);
    }

    public void setChangeText(String string) {
        this.mChangeButton.setText(string);
    }

    public void setChangeMnemonic(int n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != 0) {
            this.mChangeAction.putValue("MnemonicKey", n);
        }
    }

    public void setRemoveMnemonic(int n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != 0) {
            this.mRemoveAction.putValue("MnemonicKey", n);
        }
    }

    public void enableListScrollPane(boolean bl) {
        this.mScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mScrollPane.setWheelScrollingEnabled(bl);
    }

    protected void fireBasicACREvent(BasicACREvent.EventType eventType, EventObject eventObject) {
        BasicACREvent basicACREvent = new BasicACREvent(this, eventType, eventObject);
        for (IBasicACRListener iBasicACRListener : this.mListeners) {
            iBasicACRListener.acrEventOccured(basicACREvent);
        }
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mAddAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_ADD")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicACRWidget.this.fireBasicACREvent(BasicACREvent.EventType.addButtonPress, actionEvent);
            }
        };
        this.mChangeAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_CHANGE")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicACRWidget.this.fireBasicACREvent(BasicACREvent.EventType.changeButtonPress, actionEvent);
            }
        };
        this.mRemoveAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_REMOVE")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicACRWidget.this.fireBasicACREvent(BasicACREvent.EventType.removeButtonPress, actionEvent);
            }
        };
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mAddAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_ADD"));
            this.mChangeAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CHANGE"));
            this.mRemoveAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_REMOVE"));
        }
        this.mAddButton = new JButton(this.mAddAction);
        this.mChangeButton = new JButton(this.mChangeAction);
        this.mRemoveButton = new JButton(this.mRemoveAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (this.mButtonOrienation == ButtonOrienation.eWEST) {
            DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        }
        if (this.mButtonOrienation == ButtonOrienation.eSOUTH) {
            DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        }
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        gridBagConstraints = new GridBagConstraints();
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        if (this.mButtonOrienation == ButtonOrienation.eWEST) {
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.fill = 3;
            DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        }
        if (this.mButtonOrienation == ButtonOrienation.eSOUTH) {
            DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, 0, 0, 0));
        }
        this.mItemList = new SerializableList(this.mListKey);
        this.mItemList.setSelectionMode(0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mItemList);
        this.mScrollPane.setPreferredSize(new Dimension(50, 100));
        Insets insets2 = new Insets(insets.top, insets.left, insets.top, 0);
        if (this.mButtonOrienation == ButtonOrienation.eWEST) {
            DialogUtil.addUsingGBL(this, this.mScrollPane, gridBagConstraints, 1, 0, 1, 3, n, insets2);
        }
        if (this.mButtonOrienation == ButtonOrienation.eSOUTH) {
            DialogUtil.addUsingGBL(this, this.mScrollPane, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        }
        this.mAddAction.setEnabled(false);
        this.mChangeAction.setEnabled(false);
        this.mRemoveAction.setEnabled(false);
        this.mItemList.addListSelectionListener(this);
        this.mItemList.addFocusListener(this);
        this.mItemList.getModel().addListDataListener(this);
    }

    public JButton getAddButton() {
        return this.mAddButton;
    }

    public JButton getChangeButton() {
        return this.mChangeButton;
    }

    public JButton getRemoveButton() {
        return this.mRemoveButton;
    }

    public Point getListboxLocation() {
        Point point = new Point();
        if (this.mButtonOrienation == ButtonOrienation.eWEST) {
            Insets insets = DialogUtil.getStandardButtonInsets();
            int n = insets.left + (int)this.getAddButton().getPreferredSize().getWidth() + insets.right;
            point.x = n + insets.left;
        }
        return point;
    }

    public static enum ButtonOrienation {
        eWEST,
        eSOUTH;

    }
}

