/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SimpleMoveList;
import com.spss.uitools.util.ComparatorFactory;
import com.spss.uitools.util.IOptionConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.JList;

public class BaseMoveListModel
extends AbstractListModel {
    protected SimpleMoveList mList = null;
    protected Vector<Object> mListObjects = new Vector();
    protected boolean mShowVarLabels = false;
    protected boolean mSortAscending = true;

    protected BaseMoveListModel(SimpleMoveList simpleMoveList) {
        this.mList = simpleMoveList;
        this.readDisplayPrefs();
    }

    @Override
    public int getSize() {
        return this.mListObjects.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (n < 0 || n >= this.mListObjects.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.mListObjects.get(n);
    }

    public void setElementAt(int n, Object object) {
        if (n < 0 || n >= this.mListObjects.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.mListObjects.set(n, object);
    }

    public Object removeElementAt(int n) {
        if (n < 0 || n >= this.mListObjects.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object object = this.mListObjects.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return object;
    }

    public boolean removeElement(Object object) {
        int n = this.mListObjects.indexOf(object);
        boolean bl = this.mListObjects.removeElement(object);
        if (n >= 0) {
            this.fireIntervalRemoved(this, n, n);
        }
        return bl;
    }

    public void removeAll() {
        int n = this.mListObjects.size();
        this.mListObjects.clear();
        if (n > 0) {
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    public void reset() {
        this.removeAll();
        this.readDisplayPrefs();
    }

    public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
        if (!this.mList.canIncludeObject(iSpssVariable)) {
            return false;
        }
        this.mListObjects.insertElementAt(iSpssVariable, n);
        this.fireIntervalAdded(this, n, n);
        if (this.mList instanceof JList) {
            this.sort();
        }
        return true;
    }

    public boolean addElement(Object object) {
        return this.addElement(object, true);
    }

    public boolean addElement(Object object, boolean bl) {
        if (!this.mList.canIncludeObject(object)) {
            return false;
        }
        int n = this.mListObjects.size();
        this.mListObjects.addElement(object);
        this.fireIntervalAdded(this, n, n);
        if (bl && this.mList instanceof JList) {
            this.sort();
        }
        return true;
    }

    public boolean getShowVarLabels() {
        return this.mShowVarLabels;
    }

    public void setShowVarLabels(boolean bl) {
        this.mShowVarLabels = bl;
        if (this.mList instanceof JList) {
            this.sort();
        }
    }

    public Integer[] findElementIndexesByName(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mListObjects.size(); ++i) {
            Object object = this.mListObjects.get(i);
            if (!object.toString().equalsIgnoreCase(string)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public int findElementIndex(Object object) {
        int n = -1;
        for (int i = 0; i < this.mListObjects.size(); ++i) {
            Object object2 = this.mListObjects.get(i);
            if (!object.toString().equals(object2.toString())) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean isSortAscending() {
        return this.mSortAscending;
    }

    public void setSortDirection(boolean bl) {
        this.mSortAscending = bl;
        if (this.mList instanceof JList) {
            this.sort();
        }
    }

    public void sort() {
        try {
            Object[] objectArray = this.mList.getSelectedValues();
            ComparatorFactory.AscendingComparator ascendingComparator = this.mSortAscending ? this.getAscendingComparator(true) : this.getAscendingComparator(false);
            Collections.sort(this.mListObjects, ascendingComparator);
            this.mList.clearSelection();
            this.mList.setSelection(objectArray);
            this.fireContentsChanged(this, 0, this.getSize());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ComparatorFactory.AscendingComparator getAscendingComparator(boolean bl) {
        ComparatorFactory.AscendingComparator ascendingComparator = ComparatorFactory.getCaseInsensitiveStringComparator();
        ascendingComparator.setAscending(bl);
        return ascendingComparator;
    }

    void setListCtrl(SimpleMoveList simpleMoveList) {
        this.mList = simpleMoveList;
    }

    public boolean containsAll(List list) {
        return this.mListObjects != null && this.mListObjects.containsAll(list);
    }

    public boolean contains(Object object) {
        return this.mListObjects != null && this.mListObjects.contains(object);
    }

    private void readDisplayPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        this.mShowVarLabels = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
    }
}

