/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class AutoSearchComboBox
extends JComboBox {
    private static final int DEFAULT_MAX_COUNT_ALLOWED = 25;
    private final Searchable<String, String> mSearchable;
    private String mInitialDes;
    private int mMaxCount;
    private boolean mSkipSearch;
    private boolean mDoingLayingOut = false;
    private int mWidestItemStringLength = 0;
    private boolean mDrawWidePopup = false;

    public AutoSearchComboBox(Searchable<String, String> searchable) {
        this(searchable, null, 25);
    }

    public AutoSearchComboBox(Searchable<String, String> searchable, String string) {
        this(searchable, string, 25);
    }

    public AutoSearchComboBox(Searchable<String, String> searchable, int n) {
        this(searchable, null, n);
    }

    public AutoSearchComboBox(Searchable<String, String> searchable, String string, int n) {
        JTextComponent jTextComponent;
        this.mSearchable = searchable;
        this.mMaxCount = n;
        this.setEditable(true);
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component;
            jTextComponent.setFocusTraversalKeysEnabled(false);
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AutoSearchComboBox.this.validateEntry()) {
                        jTextComponent.transferFocus();
                    }
                }
            };
            jTextComponent.getActionMap().put("tab-action", abstractAction);
            jTextComponent.getInputMap(1).put(KeyStroke.getKeyStroke("TAB"), "tab-action");
        }
        if (this.mSearchable instanceof StringSearchable) {
            this.addListIn(((StringSearchable)this.mSearchable).getOriginalList());
        }
        if (string != null && string.length() > 0) {
            this.mInitialDes = string;
            component.setForeground(Color.gray);
            this.getEditor().setItem(string);
            if (component instanceof JTextComponent) {
                jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
                jTextComponent.setCaretPosition(0);
            }
        }
        this.setUseWidePopup(true);
        this.addListeners();
    }

    public void setEditorItem(Object object) {
        this.getEditor().setItem(object);
    }

    @Override
    public void setSelectedItem(Object object) {
        this.prepareTextField(false);
        if (object instanceof String) {
            if (!object.equals("...")) {
                super.setSelectedItem(object);
            } else {
                super.setSelectedItem("");
            }
            if (this.isEditable) {
                JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
                jTextField.setToolTipText((String)object);
            }
            boolean bl = this.mSkipSearch = this.getSelectedIndex() > 0;
            if (!this.mSkipSearch) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AutoSearchComboBox.this.validateEntry()) {
                            AutoSearchComboBox.this.getEditor().getEditorComponent().transferFocus();
                        }
                    }
                });
            }
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (!this.mDoingLayingOut && this.mDrawWidePopup) {
            dimension.width = Math.max(this.mWidestItemStringLength, dimension.width);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.mDoingLayingOut = true;
            super.doLayout();
        }
        finally {
            this.mDoingLayingOut = false;
        }
    }

    public void setUseWidePopup(boolean bl) {
        this.mDrawWidePopup = bl;
        this.mWidestItemStringLength = this.getWidestItemWidth();
    }

    public Object getEditorValue() {
        Object object = this.getEditor().getItem();
        if (object instanceof String && object.equals(this.mInitialDes)) {
            return "";
        }
        return object;
    }

    private int getWidestItemWidth() {
        int n = this.getItemCount();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object e = this.getItemAt(i);
            int n3 = fontMetrics.stringWidth(e.toString());
            n2 = Math.max(n2, n3);
        }
        return n2 + 20;
    }

    protected String getNotFoundMessage() {
        return "The name " + this.getSelectedItem() + " is not found.";
    }

    private void addListeners() {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            final JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                public void update() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String string2;
                            if (AutoSearchComboBox.this.mSkipSearch) {
                                return;
                            }
                            ArrayList arrayList = new ArrayList(AutoSearchComboBox.this.mSearchable.search(jTextComponent.getText()));
                            HashSet<String> hashSet = new HashSet<String>();
                            for (String string2 : arrayList) {
                                hashSet.add(string2.toLowerCase());
                            }
                            Collections.sort(arrayList);
                            AutoSearchComboBox.this.setEditable(false);
                            AutoSearchComboBox.this.removeAllItems();
                            boolean bl = true;
                            if (!hashSet.contains(jTextComponent.getText().toLowerCase())) {
                                AutoSearchComboBox.this.addItem(jTextComponent.getText());
                                bl = false;
                            }
                            AutoSearchComboBox.this.addListIn(arrayList);
                            string2 = jTextComponent.getText();
                            AutoSearchComboBox.this.setEditable(true);
                            if (bl) {
                                AutoSearchComboBox.this.setSelectedItem(string2);
                            }
                            if (jTextComponent.getText().length() > 0) {
                                AutoSearchComboBox.this.setPopupVisible(true);
                            }
                            jTextComponent.requestFocus();
                        }
                    });
                }
            });
            jTextComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    String string = jTextComponent.getText();
                    if (string.length() > 0 && !string.equals(AutoSearchComboBox.this.mInitialDes)) {
                        AutoSearchComboBox.this.setPopupVisible(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AutoSearchComboBox.this.setPopupVisible(false);
                }
            });
            jTextComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String string = jTextComponent.getText();
                    AutoSearchComboBox.this.prepareTextField(string.equals(AutoSearchComboBox.this.mInitialDes));
                    if (string.length() > 0 && !string.equals(AutoSearchComboBox.this.mInitialDes)) {
                        AutoSearchComboBox.this.setPopupVisible(true);
                        if (mouseEvent.getClickCount() == 1) {
                            jTextComponent.selectAll();
                        } else if (mouseEvent.getClickCount() == 2) {
                            int n = jTextComponent.viewToModel(mouseEvent.getPoint());
                            jTextComponent.setCaretPosition(n);
                        }
                    }
                }
            });
            jTextComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    AutoSearchComboBox.this.prepareTextField(keyEvent.getKeyChar() != '\n');
                    AutoSearchComboBox.this.mSkipSearch = keyEvent.getKeyChar() == '\n';
                }
            });
            JButton jButton = this.getButtonSubComponent(this);
            if (jButton != null) {
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AutoSearchComboBox.this.prepareTextField(false);
                        jTextComponent.selectAll();
                        jTextComponent.requestFocus();
                    }
                });
            }
        } else {
            throw new IllegalStateException("Editing component is NOT JTextComponent!");
        }
    }

    private JButton getButtonSubComponent(Container container) {
        Component[] componentArray;
        if (container instanceof JButton) {
            return (JButton)container;
        }
        for (Component component : componentArray = container.getComponents()) {
            if (!(component instanceof Container)) continue;
            return this.getButtonSubComponent((Container)component);
        }
        return null;
    }

    private void prepareTextField(boolean bl) {
        if (this.getEditor().getEditorComponent().getForeground().equals(Color.gray)) {
            this.getEditor().getEditorComponent().setForeground(Color.black);
            if (bl) {
                this.getEditor().setItem("");
            }
        }
    }

    private boolean validateEntry() {
        List<String> list;
        JTextComponent jTextComponent;
        String string;
        Component component = this.getEditor().getEditorComponent();
        boolean bl = true;
        if (component instanceof JTextComponent && !(string = (jTextComponent = (JTextComponent)component).getText()).equals(this.mInitialDes) && string.length() > 0 && this.mSearchable instanceof StringSearchable && (list = ((StringSearchable)this.mSearchable).getOriginalList()).indexOf(string) < 0) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), this.getNotFoundMessage(), "", 0);
            bl = false;
        }
        return bl;
    }

    private void addListIn(List<String> list) {
        int n = 0;
        String string = (String)this.getItemAt(0);
        if (string == null || string.length() > 0) {
            this.addItem("");
        }
        for (String string2 : list) {
            if (n < this.mMaxCount) {
                this.addItem(string2);
            }
            ++n;
        }
        if (n >= this.mMaxCount) {
            this.addItem("...");
        }
    }

    public static interface Searchable<E, V> {
        public Collection<E> search(V var1);
    }

    public static class StringSearchable
    implements Searchable<String, String> {
        private List<String> originalList = new ArrayList<String>();

        public StringSearchable(List<String> list) {
            this.originalList.addAll(list);
        }

        public List<String> getOriginalList() {
            return this.originalList;
        }

        @Override
        public Collection<String> search(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : this.originalList) {
                if (string2.indexOf(string) != 0) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
    }
}

