/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.SimpleMoveList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetMoveList;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class ArrowMoveListButton
extends SpssArrowButton
implements IDoubleClickListener {
    private IVarMoveHandler mVarMoveHandler;

    public ArrowMoveListButton() {
    }

    public ArrowMoveListButton(boolean bl) {
        super(bl);
    }

    public ArrowMoveListButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(buttonOrientation);
    }

    public ArrowMoveListButton(boolean bl, SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(bl, buttonOrientation);
    }

    public boolean registerVariableList(SimpleMoveList simpleMoveList, SpssArrowButton.ButtonOrientation buttonOrientation) {
        simpleMoveList.addDoubleClickListener(this);
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] != null) continue;
            this.mRegisteredContainers[i] = new ListHolder(simpleMoveList, buttonOrientation);
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.setAccessibleContextName();
        simpleMoveList.addFocusListener(this);
        simpleMoveList.addListSelectionListener(this);
        return true;
    }

    public void unRegisterVariableList(SimpleMoveList simpleMoveList) {
        simpleMoveList.removeDoubleClickListener(this);
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] == null || ((ListHolder)this.mRegisteredContainers[i]).mList != simpleMoveList) continue;
            this.mRegisteredContainers[i] = null;
            simpleMoveList.removeFocusListener(this);
            simpleMoveList.removeListSelectionListener(this);
            break;
        }
    }

    public void unRegisterAllVariableLists() {
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] == null) continue;
            SimpleMoveList simpleMoveList = ((ListHolder)this.mRegisteredContainers[i]).mList;
            simpleMoveList.removeDoubleClickListener(this);
            this.mRegisteredContainers[i] = null;
            simpleMoveList.removeFocusListener(this);
            simpleMoveList.removeListSelectionListener(this);
        }
    }

    public void setVarMoveHandler(IVarMoveHandler iVarMoveHandler) {
        this.mVarMoveHandler = iVarMoveHandler;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("arrowPressed".equals(actionEvent.getActionCommand())) {
            ListHolder listHolder = (ListHolder)this.getSourceVarHolder();
            ListHolder listHolder2 = (ListHolder)this.getTargetVarHolder();
            if (listHolder != null && listHolder2 != null) {
                int n = listHolder2.mList.getModel().getSize();
                Object[] objectArray = listHolder.mList.getSelectedValues();
                if (listHolder2.mList instanceof TargetMoveList) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object;
                        Object object2 = objectArray[i];
                        if (((TargetMoveList)listHolder2.mList).isAllowDuplicates() || listHolder2.mList.getModel().findElementIndex(object2) == -1) {
                            if (listHolder2.mList.mMaxLimitOfList != -1) {
                                if (listHolder2.mList.mMaxLimitOfList >= objectArray.length - i + listHolder2.mList.getModel().getSize()) {
                                    listHolder2.mList.getModel().addElement(object2);
                                    continue;
                                }
                                listHolder.mList.setSelection(objectArray);
                                object = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), listHolder2.mList.mMaxLimitOfList);
                                SpssAlertOptionPane.showInformationMessageDialog((Window)listHolder.mList.getBaseDialogParent(), (String)object, VersionInfo.getAppVersionString());
                                final SimpleMoveList simpleMoveList = listHolder.mList;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        simpleMoveList.requestFocus();
                                    }
                                });
                                return;
                            }
                            listHolder2.mList.getModel().addElement(object2);
                            object = listHolder.mList;
                            SwingUtilities.invokeLater(new Runnable((SimpleMoveList)object){
                                final /* synthetic */ SimpleMoveList val$varList;
                                {
                                    this.val$varList = simpleMoveList;
                                }

                                @Override
                                public void run() {
                                    this.val$varList.clearSelection();
                                }
                            });
                            continue;
                        }
                        object = listHolder.mList;
                        SwingUtilities.invokeLater(new Runnable((SimpleMoveList)object){
                            final /* synthetic */ SimpleMoveList val$varList;
                            {
                                this.val$varList = simpleMoveList;
                            }

                            @Override
                            public void run() {
                                this.val$varList.clearSelection();
                            }
                        });
                    }
                } else if (listHolder.mList.getDragType() != SimpleMoveList.ListMoveType.eKeepOriginal) {
                    for (Object object : objectArray) {
                        listHolder2.mList.getModel().addElement(object);
                    }
                }
                if (listHolder2.mList instanceof TargetMoveList && ((TargetMoveList)listHolder2.mList).isAllowDuplicates()) {
                    int[] nArray = new int[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        nArray[i] = n + i;
                    }
                    listHolder2.mList.setSelectedIndices(nArray);
                } else {
                    listHolder2.mList.setSelection(objectArray);
                }
                if (listHolder2.mList.getDragType() != SimpleMoveList.ListMoveType.eKeepOriginal) {
                    for (Object object : objectArray) {
                        listHolder.mList.getModel().removeElement(object);
                    }
                }
                final SimpleMoveList simpleMoveList = listHolder2.mList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        simpleMoveList.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public void doDoubleClickAction() {
        ListHolder listHolder = (ListHolder)this.getTargetVarHolder();
        final SimpleMoveList simpleMoveList = listHolder.mList;
        final Object[] objectArray = ((ListHolder)this.getSourceVarHolder()).mList.getSelectedValues();
        final ActionEvent actionEvent = new ActionEvent(this, 1234567890, "arrowPressed");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionListener[] actionListenerArray = ArrowMoveListButton.this.getActionListeners();
                if (ArrowMoveListButton.this.canMoveVars(simpleMoveList, objectArray)) {
                    for (ActionListener actionListener : actionListenerArray) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
        boolean bl;
        ListHolder listHolder = (ListHolder)srcDestHolder;
        if (srcDestHolder == null) {
            return;
        }
        ListSelectionModel listSelectionModel = listHolder.mList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        boolean bl2 = bl = n >= 0 && n2 >= 0;
        if (bl) {
            ListHolder listHolder2 = (ListHolder)this.getTargetVarHolder();
            Object[] objectArray = listHolder.mList.getSelectedValues();
            if (listHolder2.getVarList().isEnabled() && listHolder.getVarList().isEnabled() && objectArray.length > 0) {
                if (listHolder2.mList instanceof TargetMoveList && ((TargetMoveList)listHolder2.mList).getTargetType() == TargetMoveList.TargetListType.single_item) {
                    bl = objectArray.length <= 1 && listHolder2.mList.getModel().getSize() == 0;
                }
            } else {
                bl = false;
            }
        }
        this.setEnabled(bl);
    }

    protected boolean canMoveVars(SimpleMoveList simpleMoveList, Object[] objectArray) {
        return true;
    }

    protected class ListHolder
    extends SpssArrowButton.SrcDestHolder {
        public SimpleMoveList mList;

        ListHolder(SimpleMoveList simpleMoveList, SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(ArrowMoveListButton.this, buttonOrientation);
            this.mList = simpleMoveList;
        }

        public SimpleMoveList getVarList() {
            return this.mList;
        }

        @Override
        protected Component getComponent() {
            return this.mList;
        }
    }
}

