/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListFilterUtil;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class ArrowButton
extends SpssArrowButton
implements IDoubleClickListener {
    private IVarMoveHandler mVarMoveHandler;

    public ArrowButton() {
    }

    public ArrowButton(boolean bl) {
        super(bl);
    }

    public ArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(buttonOrientation);
    }

    public ArrowButton(boolean bl, SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(bl, buttonOrientation);
    }

    public boolean registerVariableList(VariableList variableList, SpssArrowButton.ButtonOrientation buttonOrientation) {
        variableList.addDoubleClickListener(this);
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] != null) continue;
            this.mRegisteredContainers[i] = new VarListHolder(variableList, buttonOrientation);
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.setAccessibleContextName();
        variableList.addFocusListener(this);
        variableList.addListSelectionListener(this);
        return true;
    }

    public void unRegisterVariableList(VariableList variableList) {
        variableList.removeDoubleClickListener(this);
        for (int i = 0; i < 2; ++i) {
            if (this.mRegisteredContainers[i] == null || ((VarListHolder)this.mRegisteredContainers[i]).mVarList != variableList) continue;
            this.mRegisteredContainers[i] = null;
            variableList.removeFocusListener(this);
            variableList.removeListSelectionListener(this);
            break;
        }
    }

    public void setVarMoveHandler(IVarMoveHandler iVarMoveHandler) {
        this.mVarMoveHandler = iVarMoveHandler;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("arrowPressed".equals(actionEvent.getActionCommand())) {
            VarListHolder varListHolder = (VarListHolder)this.getSourceVarHolder();
            VarListHolder varListHolder2 = (VarListHolder)this.getTargetVarHolder();
            if (varListHolder != null && varListHolder2 != null) {
                int n = varListHolder2.mVarList.getModel().getSize();
                ISpssVariable[] iSpssVariableArray = varListHolder.mVarList.getSelectedValues();
                if (this.mVarMoveHandler != null && !this.mVarMoveHandler.preMoveVariables(iSpssVariableArray, varListHolder2.mVarList)) {
                    final VariableList variableList = varListHolder.mVarList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            variableList.requestFocus();
                        }
                    });
                    return;
                }
                if (!this.showFilterError(varListHolder2.mVarList, iSpssVariableArray, this)) {
                    final VariableList variableList = varListHolder.mVarList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            variableList.requestFocus();
                        }
                    });
                    return;
                }
                if (varListHolder2.mVarList instanceof TargetVariableList && !((TargetVariableList)varListHolder2.mVarList).isDataSource()) {
                    for (int i = 0; i < iSpssVariableArray.length; ++i) {
                        Object object;
                        ISpssVariable iSpssVariable = iSpssVariableArray[i];
                        if (((TargetVariableList)varListHolder2.mVarList).isAllowDuplicates() || varListHolder2.mVarList.getModel().findElementIndex(iSpssVariable) == -1) {
                            if (((VarListHolder)varListHolder2).mVarList.mMaxLimitOfList != -1) {
                                if (((VarListHolder)varListHolder2).mVarList.mMaxLimitOfList >= iSpssVariableArray.length - i + varListHolder2.mVarList.getModel().getSize()) {
                                    varListHolder2.mVarList.getModel().addElement(iSpssVariable);
                                    continue;
                                }
                                varListHolder.mVarList.setSelection(iSpssVariableArray);
                                object = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), ((VarListHolder)varListHolder2).mVarList.mMaxLimitOfList);
                                SpssAlertOptionPane.showInformationMessageDialog((Window)varListHolder.mVarList.getBaseDialogParent(), (String)object, VersionInfo.getAppVersionString());
                                final VariableList variableList = varListHolder.mVarList;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        variableList.requestFocus();
                                    }
                                });
                                return;
                            }
                            varListHolder2.mVarList.getModel().addElement(iSpssVariable);
                            object = varListHolder.mVarList;
                            SwingUtilities.invokeLater(new Runnable((VariableList)object){
                                final /* synthetic */ VariableList val$varList;
                                {
                                    this.val$varList = variableList;
                                }

                                @Override
                                public void run() {
                                    this.val$varList.clearSelection();
                                }
                            });
                            continue;
                        }
                        object = varListHolder.mVarList;
                        SwingUtilities.invokeLater(new Runnable((VariableList)object){
                            final /* synthetic */ VariableList val$varList;
                            {
                                this.val$varList = variableList;
                            }

                            @Override
                            public void run() {
                                this.val$varList.clearSelection();
                            }
                        });
                    }
                } else if (varListHolder.mVarList.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        varListHolder2.mVarList.getModel().addElement(iSpssVariable);
                    }
                }
                if (varListHolder2.mVarList instanceof TargetVariableList && ((TargetVariableList)varListHolder2.mVarList).isAllowDuplicates()) {
                    int[] nArray = new int[iSpssVariableArray.length];
                    for (int i = 0; i < iSpssVariableArray.length; ++i) {
                        nArray[i] = n + i;
                    }
                    varListHolder2.mVarList.setSelectedIndices(nArray);
                } else {
                    varListHolder2.mVarList.setSelection(iSpssVariableArray);
                }
                if (varListHolder.mVarList instanceof TargetVariableList && !((TargetVariableList)varListHolder.mVarList).isDataSource()) {
                    if (!((TargetVariableList)varListHolder.mVarList).isAllowDuplicates()) {
                        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                            varListHolder.mVarList.getModel().removeElement(iSpssVariable);
                        }
                    } else {
                        int[] nArray = varListHolder.mVarList.getSelectedIndices();
                        if (nArray != null && nArray.length > 0) {
                            if (nArray.length == 1) {
                                varListHolder.mVarList.getModel().removeElementAt(nArray[0]);
                            } else {
                                Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
                                int n2 = varListHolder.mVarList.getModel().getSize();
                                for (int i = 0; i < n2; ++i) {
                                    boolean bl = false;
                                    for (int n3 : nArray) {
                                        if (i != n3) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) continue;
                                    vector.add(varListHolder.mVarList.getModel().getElementAt(i));
                                }
                                if (vector.size() > 0) {
                                    varListHolder.mVarList.getModel().removeAll();
                                    for (ISpssVariable iSpssVariable : vector) {
                                        varListHolder.mVarList.getModel().addElement(iSpssVariable);
                                    }
                                } else {
                                    varListHolder.mVarList.getModel().removeAll();
                                }
                            }
                        }
                    }
                } else if (varListHolder2.mVarList.getDragType() != VariableList.VarMoveType.eKeepOriginal) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        varListHolder.mVarList.getModel().removeElement(iSpssVariable);
                    }
                }
                final VariableList variableList = varListHolder2.mVarList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        variableList.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    public void doDoubleClickAction() {
        VarListHolder varListHolder = (VarListHolder)this.getTargetVarHolder();
        final VariableList variableList = varListHolder.mVarList;
        final ISpssVariable[] iSpssVariableArray = ((VarListHolder)this.getSourceVarHolder()).mVarList.getSelectedValues();
        final ActionEvent actionEvent = new ActionEvent(this, 1234567890, "arrowPressed");
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (variableList.canIncludeVariable(iSpssVariable)) continue;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionListener[] actionListenerArray = ArrowButton.this.getActionListeners();
                if (ArrowButton.this.canMoveVars(variableList, iSpssVariableArray)) {
                    for (ActionListener actionListener : actionListenerArray) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
        boolean bl;
        VarListHolder varListHolder = (VarListHolder)srcDestHolder;
        if (srcDestHolder == null) {
            return;
        }
        ListSelectionModel listSelectionModel = varListHolder.mVarList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        boolean bl2 = bl = n >= 0 && n2 >= 0;
        if (bl) {
            VarListHolder varListHolder2 = (VarListHolder)this.getTargetVarHolder();
            ISpssVariable[] iSpssVariableArray = varListHolder.mVarList.getSelectedValues();
            if (varListHolder2.getVarList().isEnabled() && varListHolder.getVarList().isEnabled() && iSpssVariableArray.length > 0) {
                if (varListHolder2.mVarList instanceof TargetVariableList && ((TargetVariableList)varListHolder2.mVarList).getTargetType() == TargetVariableList.TargetListType.single_item) {
                    bl = iSpssVariableArray.length <= 1 && varListHolder2.mVarList.getModel().getSize() == 0;
                }
            } else {
                bl = false;
            }
        }
        this.setEnabled(bl);
    }

    protected boolean canMoveVars(VariableList variableList, ISpssVariable[] iSpssVariableArray) {
        if (!variableList.isEnabled()) {
            return false;
        }
        if (variableList instanceof TargetVariableList && ((TargetVariableList)variableList).getTargetType() == TargetVariableList.TargetListType.single_item && (variableList.getModel().getSize() > 0 || iSpssVariableArray.length > 1)) {
            return false;
        }
        return this.showFilterError(variableList, iSpssVariableArray, this);
    }

    public boolean showFilterError(VariableList variableList, ISpssVariable[] iSpssVariableArray, JComponent jComponent) {
        String string = VarListFilterUtil.getVarListFilterErrorMessage(variableList, iSpssVariableArray);
        if (string != null) {
            SpssAlertOptionPane.showInformationMessageDialog(jComponent, string, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    protected class VarListHolder
    extends SpssArrowButton.SrcDestHolder {
        private VariableList mVarList;

        VarListHolder(VariableList variableList, SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(ArrowButton.this, buttonOrientation);
            this.mVarList = variableList;
        }

        public VariableList getVarList() {
            return this.mVarList;
        }

        @Override
        protected Component getComponent() {
            return this.mVarList;
        }
    }
}

