/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.SpssAddDeleteButtons;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListFilterUtil;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class AddDeleteButton
extends SpssAddDeleteButtons
implements IDoubleClickListener {
    public AddDeleteButton() {
    }

    public AddDeleteButton(SpssAddDeleteButtons.ButtonType buttonType) {
        super(buttonType);
    }

    public boolean registerVariableList(VariableList variableList, SpssAddDeleteButtons.ButtonType buttonType) {
        variableList.addDoubleClickListener(this);
        this.mRegisteredContainers[0] = new VarListHolder(variableList, buttonType);
        this.setAccessibleContextName();
        variableList.addFocusListener(this);
        variableList.addListSelectionListener(this);
        return true;
    }

    public void unRegisterVariableList(VariableList variableList) {
        variableList.removeDoubleClickListener(this);
        this.mRegisteredContainers[0] = null;
        variableList.removeFocusListener(this);
        variableList.removeListSelectionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        VarListHolder varListHolder;
        if (!"addDeletePressed".equals(actionEvent.getActionCommand()) || (varListHolder = (VarListHolder)this.getSourceVarHolder()) == null || varListHolder.mVarList instanceof TargetVariableList || this.getButtonType() == SpssAddDeleteButtons.ButtonType.add) {
            // empty if block
        }
    }

    @Override
    public void doDoubleClickAction() {
        ISpssVariable[] iSpssVariableArray = ((VarListHolder)this.getSourceVarHolder()).mVarList.getSelectedValues();
        final ActionEvent actionEvent = new ActionEvent(this, 1234567890, "addDeletePressed");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionListener[] actionListenerArray;
                for (ActionListener actionListener : actionListenerArray = AddDeleteButton.this.getActionListeners()) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    @Override
    protected void updateEnable(SpssAddDeleteButtons.SrcDestHolder srcDestHolder) {
        boolean bl;
        VarListHolder varListHolder = (VarListHolder)srcDestHolder;
        if (srcDestHolder == null) {
            return;
        }
        ListSelectionModel listSelectionModel = varListHolder.mVarList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        boolean bl2 = bl = n >= 0 && n2 >= 0;
        if (bl) {
            ISpssVariable[] iSpssVariableArray = varListHolder.mVarList.getSelectedValues();
            if (varListHolder.mVarList instanceof TargetVariableList && ((TargetVariableList)varListHolder.mVarList).getTargetType() == TargetVariableList.TargetListType.single_item) {
                bl = iSpssVariableArray.length == 1;
            }
        } else if (!(varListHolder.mVarList instanceof TargetVariableList) && this.getButtonType() == SpssAddDeleteButtons.ButtonType.add) {
            bl = true;
        }
        this.setEnabled(bl);
    }

    public boolean showFilterError(VariableList variableList, ISpssVariable[] iSpssVariableArray, JComponent jComponent) {
        String string = VarListFilterUtil.getVarListFilterErrorMessage(variableList, iSpssVariableArray);
        if (string != null) {
            SpssAlertOptionPane.showInformationMessageDialog(jComponent, string, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    protected class VarListHolder
    extends SpssAddDeleteButtons.SrcDestHolder {
        private VariableList mVarList;

        VarListHolder(VariableList variableList, SpssAddDeleteButtons.ButtonType buttonType) {
            super(AddDeleteButton.this, buttonType);
            this.mVarList = variableList;
        }

        public VariableList getVarList() {
            return this.mVarList;
        }

        @Override
        protected Component getComponent() {
            return this.mVarList;
        }
    }
}

