/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controls;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.IntDocument;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ACRWidget
extends JPanel
implements ListSelectionListener,
DocumentListener,
FocusListener,
ListDataListener {
    public static final String LIST_ACTION_KEY = "LIST_ACTION";
    private JTextField mTextField;
    protected SerializableList mItemList;
    private JScrollPane mScrollPane;
    private Action mAddAction;
    private Action mChangeAction;
    private Action mRemoveAction;
    private Vector<IACRListener> mListeners = new Vector(1);
    protected boolean mAllowDuplicates = false;
    private boolean mTrimBlanks = false;
    private boolean mTrimQuotes = false;
    private List<JComponent> mComponents;

    public ACRWidget(JTextField jTextField) {
        super(true);
        this.mTextField = jTextField;
        this.init();
        this.mTextField.getDocument().addDocumentListener(this);
        this.mTextField.addFocusListener(this);
    }

    public void setListPreferredSize(Dimension dimension) {
        this.mScrollPane.setPreferredSize(dimension);
    }

    public void clear() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        defaultListModel.clear();
    }

    public boolean isSerializable() {
        return this.mItemList.isSerializable();
    }

    public void setSerializable(boolean bl) {
        this.mItemList.setSerializable(bl);
    }

    public int getListItemCount() {
        return this.mItemList.getModel().getSize();
    }

    public String[] getListItems() {
        int n = this.mItemList.getModel().getSize();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.mItemList.getModel().getElementAt(i);
        }
        return stringArray;
    }

    public void setListItems(String[] stringArray) {
        this.clear();
        DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
        for (String string : stringArray) {
            defaultListModel.addElement(string);
        }
    }

    public SerializableList getList() {
        return this.mItemList;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.mTextField.getText().length() > 0;
        boolean bl3 = this.mItemList.getSelectedIndex() > -1;
        this.mAddAction.setEnabled(bl && bl2);
        this.mChangeAction.setEnabled(bl && bl2 && bl3);
        this.mRemoveAction.setEnabled(bl && bl3);
        this.mItemList.setEnabled(bl);
        this.mItemList.setOpaque(bl);
    }

    public boolean getAllowDuplicates() {
        return this.mAllowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    public boolean getTrimBlanks() {
        return this.mTrimBlanks;
    }

    public void setTrimBlanks(boolean bl) {
        this.mTrimBlanks = bl;
    }

    public boolean getTrimQuotes() {
        return this.mTrimQuotes;
    }

    public void setTrimQuotes(boolean bl) {
        this.mTrimQuotes = bl;
    }

    public void addACRListener(IACRListener iACRListener) {
        this.mListeners.add(iACRListener);
    }

    public void removeACRListener(IACRListener iACRListener) {
        this.mListeners.remove(iACRListener);
    }

    public boolean isAddEnabled() {
        return this.mAddAction.isEnabled();
    }

    public boolean isChangeEnabled() {
        return this.mChangeAction.isEnabled();
    }

    public boolean isRemoveEnabled() {
        return this.mRemoveAction.isEnabled();
    }

    public void setAddEnabled(boolean bl) {
        this.mAddAction.setEnabled(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.mRemoveAction.setEnabled(this.mItemList.getSelectedIndex() > -1);
        String string = "";
        if (this.mItemList.getSelectedIndex() > -1) {
            string = (String)this.mItemList.getSelectedValue();
            this.mAddAction.setEnabled(false);
            this.mChangeAction.setEnabled(false);
        }
        this.mTextField.removeFocusListener(this);
        this.mTextField.getDocument().removeDocumentListener(this);
        this.mTextField.setText(string);
        this.mTextField.getDocument().addDocumentListener(this);
        this.mTextField.addFocusListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTextChange();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.mTextField || focusEvent.getComponent() == this.mItemList) {
            // empty if block
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireItemListChangedEvent(ACREvent.EventType.listItemAdd);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireItemListChangedEvent(ACREvent.EventType.listItemRemove);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireItemListChangedEvent(ACREvent.EventType.listItemChange);
    }

    public List<JComponent> getTraversalComponents() {
        return this.mComponents;
    }

    public void setAddMnemonic(int n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != 0) {
            this.mAddAction.putValue("MnemonicKey", n);
        }
    }

    public void setChangeMnemonic(int n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != 0) {
            this.mChangeAction.putValue("MnemonicKey", n);
        }
    }

    public void setRemoveMnemonic(int n) {
        if (n != 0) {
            this.mRemoveAction.putValue("MnemonicKey", n);
        }
    }

    protected void fireItemListChangedEvent(ACREvent.EventType eventType) {
        ACREvent aCREvent = new ACREvent(this, eventType);
        for (IACRListener iACRListener : this.mListeners) {
            iACRListener.listChanged(aCREvent);
        }
    }

    protected void doAdd() {
        String string = this.mTextField.getText();
        this.mTextField.setText("");
        assert (string.length() > 0);
        string = this.trimBlanks(string);
        if ((string = this.trimQuotes(string)).length() > 0 && !this.isDuplicate(string)) {
            this.mItemList.clearSelection();
            DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
            defaultListModel.add(defaultListModel.getSize(), string);
            this.mItemList.requestFocus();
        }
    }

    protected void doRemove() {
        int n = this.mItemList.getSelectedIndex();
        if (n > -1) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
            defaultListModel.removeElementAt(n);
            this.mTextField.requestFocus();
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 12;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mAddAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_ADD")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ACRWidget.this.doAdd();
            }
        };
        this.mChangeAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_CHANGE")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ACRWidget.this.doChange();
            }
        };
        this.mRemoveAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_REMOVE")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ACRWidget.this.doRemove();
            }
        };
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mAddAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_ADD"));
            this.mChangeAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CHANGE"));
            this.mRemoveAction.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_REMOVE"));
        }
        this.mComponents = new ArrayList<JComponent>();
        JButton jButton = new JButton(this.mAddAction);
        this.mComponents.add(this.mTextField);
        this.mComponents.add(jButton);
        DialogUtil.addUsingGBL(this, jButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JButton jButton2 = new JButton(this.mChangeAction);
        this.mComponents.add(jButton2);
        DialogUtil.addUsingGBL(this, jButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JButton jButton3 = new JButton(this.mRemoveAction);
        this.mComponents.add(jButton3);
        DialogUtil.addUsingGBL(this, jButton3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)this);
        String string = LIST_ACTION_KEY;
        this.mItemList = new SerializableList(string);
        this.mItemList.setCellRenderer(new ACRWidgetListCellRenderer());
        this.mComponents.add(this.mItemList);
        this.mItemList.setSelectionMode(0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mItemList);
        this.mScrollPane.setPreferredSize(new Dimension(70, 110));
        Insets insets2 = new Insets(insets.top, insets.left, insets.top, 0);
        DialogUtil.addUsingGBL(this, this.mScrollPane, gridBagConstraints, 1, 0, 1, 3, n, insets2);
        this.mAddAction.setEnabled(false);
        this.mChangeAction.setEnabled(false);
        this.mRemoveAction.setEnabled(false);
        this.mItemList.addListSelectionListener(this);
        this.mItemList.addFocusListener(this);
        this.mItemList.getModel().addListDataListener(this);
    }

    private void doChange() {
        int n = this.mItemList.getSelectedIndex();
        String string = this.mTextField.getText();
        this.mTextField.setText("");
        string = this.trimBlanks(string);
        string = this.trimQuotes(string);
        if (n > -1 && string.length() > -1 && !this.isDuplicate(string)) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mItemList.getModel();
            defaultListModel.removeElementAt(n);
            if (string.length() > 0) {
                defaultListModel.insertElementAt(string, n);
            }
        }
    }

    public boolean isDuplicate(String string) {
        boolean bl = false;
        if (!this.mAllowDuplicates) {
            for (int i = 0; i < this.mItemList.getModel().getSize(); ++i) {
                Object e = this.mItemList.getModel().getElementAt(i);
                if (!string.equals(e)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String trimBlanks(String string) {
        if (!this.mTrimBlanks) {
            return string;
        }
        return string.trim();
    }

    public String trimQuotes(String string) {
        if (!this.mTrimQuotes) {
            return string;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\"'");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2;
    }

    public Point getListboxLocation() {
        Point point = new Point();
        JButton jButton = (JButton)this.getComponent(0);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + (int)jButton.getPreferredSize().getWidth() + insets.right;
        point.x = n + insets.left;
        return point;
    }

    private void doTextChange() {
        boolean bl = this.mTextField.getText().length() > 0;
        this.mAddAction.setEnabled(bl);
        int n = this.mItemList.getSelectedIndex();
        this.mChangeAction.setEnabled(bl && n > -1);
        this.mRemoveAction.setEnabled(false);
    }

    class ACRWidgetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

        ACRWidgetListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Document document = ACRWidget.this.mTextField.getDocument();
            String string = object.toString();
            if (document instanceof FloatDocument || document instanceof IntDocument || document instanceof FixedLengthNumericDocument) {
                string = UIToolResUtil.addLocale((String)string);
            }
            this.setText(string);
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2 && jList.isEnabled()) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.mNoFocusBorder;
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                Document document = ACRWidget.this.mTextField.getDocument();
                if (!(document instanceof FloatDocument || document instanceof IntDocument || document instanceof FixedLengthNumericDocument)) {
                    super.setText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setText(string);
                }
            } else {
                super.setText(string);
            }
        }
    }
}

