/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controlbar;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.controlbar.ToolbarDefaults;
import com.spss.java_client.ui.controlbar.ToolbarFactory;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ToolbarsUtil {
    private static LinkedHashMap<String, UserTool> sUserDefinedToolsMap;

    public static UserTool getUserDefinedTool(String string) {
        if (sUserDefinedToolsMap == null) {
            ToolbarsUtil.loadUserDefinedToolsMapFromPrefs();
        }
        return sUserDefinedToolsMap.get(string);
    }

    public static LinkedHashMap<String, UserTool> loadUserDefinedToolsMapFromPrefs() {
        LinkedHashMap<String, UserTool> linkedHashMap = new LinkedHashMap<String, UserTool>();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("other_apps");
        try {
            String[] stringArray;
            for (String string : stringArray = preferences2.childrenNames()) {
                Preferences preferences3 = preferences2.node(string);
                UserTool userTool = new UserTool();
                userTool.setActionId(string);
                userTool.setName(preferences3.get("menu", ""));
                userTool.setMnemonicKey(preferences3.getInt("mnemonic_key", 0));
                userTool.setLaunchType(preferences3.get("launch_type", ""));
                if (userTool.getLaunchType().equals("application")) {
                    userTool.setDataExportFormat(preferences3.get("data_export_format", ""));
                    userTool.setImageKey("application");
                } else if (userTool.getLaunchType().equals("syntax")) {
                    userTool.setImageKey("syntax");
                } else if (userTool.getLaunchType().equals("script")) {
                    userTool.setImageKey("script");
                    userTool.setScriptLangType(preferences3.get("script_type", ""));
                }
                userTool.setFileName(preferences3.get("launch", ""));
                userTool.setToolbarOnly(preferences3.getBoolean("tb_only", false));
                linkedHashMap.put(userTool.getActionId(), userTool);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        sUserDefinedToolsMap = (LinkedHashMap)linkedHashMap.clone();
        return linkedHashMap;
    }

    public static LinkedHashMap<String, UserTool> loadUserDefinedToolsMapFromSysPrefs() {
        LinkedHashMap<String, UserTool> linkedHashMap = new LinkedHashMap<String, UserTool>();
        HashSet<UserTool> hashSet = new HashSet<UserTool>();
        try {
            String[] stringArray;
            Preferences preferences = PrefsMgr.getPrefsMgr().getUISystemPrefs();
            if (preferences == null || !preferences.nodeExists("other_apps")) {
                return linkedHashMap;
            }
            Preferences preferences2 = preferences.node("other_apps");
            for (String string : stringArray = preferences2.childrenNames()) {
                Preferences preferences3 = preferences2.node(string);
                UserTool userTool = new UserTool();
                userTool.setActionId(string);
                userTool.setName(preferences3.get("menu", ""));
                userTool.setMnemonicKey(preferences3.getInt("mnemonic_key", 0));
                userTool.setLaunchType(preferences3.get("launch_type", ""));
                if (userTool.getLaunchType().equals("application")) {
                    userTool.setDataExportFormat(preferences3.get("data_export_format", ""));
                    userTool.setImageKey("application");
                } else if (userTool.getLaunchType().equals("syntax")) {
                    userTool.setImageKey("syntax");
                } else if (userTool.getLaunchType().equals("script")) {
                    userTool.setImageKey("script");
                    userTool.setScriptLangType(preferences3.get("script_type", ""));
                }
                userTool.setFileName(preferences3.get("launch", ""));
                userTool.setToolbarOnly(preferences3.getBoolean("tb_only", false));
                linkedHashMap.put(userTool.getActionId(), userTool);
                hashSet.add(userTool);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        sUserDefinedToolsMap = (LinkedHashMap)linkedHashMap.clone();
        ToolbarsUtil.saveUserDefinedToolsMapMenuEditorToPrefs(hashSet, 0L);
        return linkedHashMap;
    }

    public static List<ToolbarObject> loadToolBarsFromPrefs() {
        ArrayList<ToolbarObject> arrayList = new ArrayList<ToolbarObject>();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        try {
            if (preferences.nodeExists("toolbars")) {
                String[] stringArray;
                Preferences preferences2 = preferences.node("toolbars");
                for (String string : stringArray = preferences2.childrenNames()) {
                    if (!preferences2.nodeExists(string)) continue;
                    Preferences preferences3 = preferences2.node(string);
                    ToolbarObject toolbarObject = new ToolbarObject();
                    toolbarObject.setPreferencesNode(string);
                    toolbarObject.setBarId(preferences3.getLong("toolbar_id", 0L));
                    toolbarObject.setName(preferences3.get("name", ""));
                    List<ToolbarItem> list = toolbarObject.getToolbarItems();
                    Preferences preferences4 = preferences3.node("items");
                    String[] stringArray2 = preferences4.keys();
                    Arrays.sort(stringArray2, new Comparator<Object>(){

                        @Override
                        public int compare(Object object, Object object2) {
                            if (object instanceof String && object2 instanceof String) {
                                try {
                                    int n = Integer.parseInt((String)object);
                                    int n2 = Integer.parseInt((String)object2);
                                    return n - n2;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    numberFormatException.printStackTrace();
                                }
                            }
                            return 0;
                        }
                    });
                    for (String string2 : stringArray2) {
                        StringTokenizer stringTokenizer = new StringTokenizer(preferences4.get(string2, ""), ",");
                        ToolbarItem toolbarItem = new ToolbarItem();
                        toolbarItem.setUserDefinedTool(Boolean.parseBoolean(stringTokenizer.nextToken()));
                        toolbarItem.setActionId(stringTokenizer.nextToken());
                        toolbarItem.setUserDefinedImage(Boolean.parseBoolean(stringTokenizer.nextToken()));
                        toolbarItem.setImageKey(stringTokenizer.nextToken());
                        list.add(toolbarItem);
                    }
                    Set<DocType> set = toolbarObject.getDocTypes();
                    StringTokenizer stringTokenizer = new StringTokenizer(preferences3.get("doc_types", ""));
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (string3.equals(DocType.DE_DOC.toString())) {
                            set.add(DocType.DE_DOC);
                            continue;
                        }
                        if (string3.equals(DocType.OUTPUT_DOC.toString())) {
                            set.add(DocType.OUTPUT_DOC);
                            continue;
                        }
                        if (!string3.equals(DocType.SYNTAX_DOC.toString())) continue;
                        set.add(DocType.SYNTAX_DOC);
                    }
                    toolbarObject.setVisible(preferences3.getBoolean("visible", true));
                    toolbarObject.setUserDefinedToolbar(string.startsWith("user"));
                    arrayList.add(toolbarObject);
                }
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        return arrayList;
    }

    public static void saveToolbarToPrefs(List<ToolbarObject> list, boolean bl, boolean bl2) {
        if (list.size() >= ToolbarFactory.defaultToolbarCount) {
            try {
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("toolbars");
                long l = preferences2.getLong("user_defined_toolbars", 0L);
                long l2 = ToolbarsUtil.getMaxToolbarId(list);
                for (ToolbarObject toolbarObject : list) {
                    String string = toolbarObject.getPreferencesNode();
                    if (toolbarObject.isUserDefinedToolbar() && (string == null || string.length() == 0)) {
                        string = "user" + ++l;
                        toolbarObject.setPreferencesNode(string);
                    }
                    Preferences preferences3 = preferences2.node(string);
                    Long l3 = toolbarObject.getBarId();
                    if (l3 == null || l3 < 1L) {
                        l3 = ++l2;
                        toolbarObject.setBarId(l3);
                    }
                    preferences3.putLong("toolbar_id", l3);
                    preferences3.put("name", toolbarObject.getName());
                    Preferences preferences4 = preferences3.node("items");
                    String[] stringArray = preferences4.keys();
                    for (String string2 : stringArray) {
                        preferences4.remove(string2);
                    }
                    List<ToolbarItem> list2 = toolbarObject.getToolbarItems();
                    for (int i = 0; i < list2.size(); ++i) {
                        ToolbarItem toolbarItem = (ToolbarItem)list2.get(i);
                        preferences4.put(Integer.toString(i), toolbarItem.isUserDefinedTool() + "," + toolbarItem.getActionId() + "," + toolbarItem.isUserDefinedImage() + "," + toolbarItem.getImageKey());
                    }
                    Set<DocType> set = toolbarObject.getDocTypes();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (DocType docType : set) {
                        stringBuilder.append(docType).append(" ");
                    }
                    preferences3.put("doc_types", stringBuilder.toString().trim());
                    preferences3.putBoolean("visible", toolbarObject.isVisible());
                }
                preferences2.putBoolean("large_buttons", bl);
                preferences2.putBoolean("tool_tips", bl2);
                preferences2.putLong("user_defined_toolbars", l);
                ToolbarsUtil.cleanUpToolbars(list, preferences2);
                preferences2.flush();
            }
            catch (Exception exception) {
                TraceSettings.trace1((String)exception.getMessage(), (int)15);
            }
        }
    }

    public static boolean isUniqueToolbarName(String string, List<ToolbarObject> list) {
        boolean bl = true;
        for (ToolbarObject toolbarObject : list) {
            if (!toolbarObject.getName().trim().equals(string.trim())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static long getUserToolNodeSuffx() {
        long l = 0L;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        try {
            if (preferences.nodeExists("other_apps")) {
                l = preferences.node("other_apps").getLong("node_suffix", 0L);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        return l;
    }

    public static boolean getShowLargeButtons() {
        boolean bl = false;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        try {
            if (preferences.nodeExists("toolbars")) {
                bl = preferences.node("toolbars").getBoolean("large_buttons", true);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        return bl;
    }

    public static boolean getShowToolTips() {
        boolean bl = false;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        try {
            if (preferences.nodeExists("toolbars")) {
                bl = preferences.node("toolbars").getBoolean("tool_tips", false);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        return bl;
    }

    public static void saveUserDefinedToolsMapMenuEditorToPrefs(Set<UserTool> set, long l) {
        if (sUserDefinedToolsMap == null) {
            ToolbarsUtil.loadUserDefinedToolsMapFromPrefs();
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("other_apps");
        for (UserTool userTool : set) {
            Preferences preferences3 = preferences2.node(userTool.getActionId());
            preferences3.put("menu", userTool.getName());
            preferences3.putInt("mnemonic_key", userTool.getMnemonicKey());
            preferences3.put("launch_type", userTool.getLaunchType());
            preferences3.put("launch", userTool.getFileName());
            preferences3.put("script_type", userTool.getScriptLangType());
            String string = userTool.getDataExportFormat();
            if (string != null) {
                preferences3.put("data_export_format", string);
            }
            preferences3.putBoolean("tb_only", userTool.isToolbarOnly());
            sUserDefinedToolsMap.put(userTool.getActionId(), userTool);
        }
        preferences2.putLong("node_suffix", l);
        try {
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    public static void saveUserDefinedToolsMapToPrefs(LinkedHashMap<String, UserTool> linkedHashMap, long l) {
        Collection<UserTool> collection = linkedHashMap.values();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("other_apps");
        for (UserTool userTool : collection) {
            try {
                if (!preferences2.nodeExists(userTool.getActionId())) {
                    Preferences preferences3 = preferences2.node(userTool.getActionId());
                    preferences3.put("menu", userTool.getName());
                    preferences3.put("launch_type", userTool.getLaunchType());
                    preferences3.put("launch", userTool.getFileName());
                    String string = userTool.getDataExportFormat();
                    if (string != null) {
                        preferences3.put("data_export_format", string);
                    }
                    preferences3.putBoolean("tb_only", userTool.isToolbarOnly());
                }
            }
            catch (Exception exception) {
                TraceSettings.trace1((String)exception.getMessage(), (int)15);
            }
            sUserDefinedToolsMap.put(userTool.getActionId(), userTool);
        }
        preferences2.putLong("node_suffix", l);
        try {
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    public static void deleteUserTools(Set<String> set) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("other_apps");
        try {
            for (String string : set) {
                if (!preferences2.nodeExists(string)) continue;
                preferences2.node(string).removeNode();
            }
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    public static ImageIcon getUserImageIcon(String string, Dimension dimension) {
        String string2 = System.getProperty("user.home.spss");
        String string3 = string2 + File.separatorChar + "toolbar_images" + File.separatorChar + string;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(string3));
        }
        catch (IOException iOException) {
            TraceSettings.trace1((String)iOException.getMessage(), (int)15);
        }
        if (bufferedImage != null) {
            if (bufferedImage.getWidth() != bufferedImage.getHeight()) {
                int n = bufferedImage.getWidth() < bufferedImage.getHeight() ? bufferedImage.getWidth() : bufferedImage.getHeight();
                bufferedImage = bufferedImage.getSubimage(0, 0, n, n);
            }
            BufferedImage bufferedImage2 = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, (int)dimension.getWidth(), (int)dimension.getHeight(), null);
            return new ImageIcon(bufferedImage2);
        }
        URL uRL = ResUtil.getImageURL("generic_menu_icon");
        return new ImageIcon(uRL);
    }

    public static void deleteUserTools(List<UserTool> list) {
        Object object;
        Object backingStoreException;
        Object object2;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("other_apps");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (UserTool serializable2 : list) {
            object2 = serializable2.getActionId();
            try {
                if (object2 != null && ((String)object2).length() > 0 && preferences2.nodeExists((String)object2)) {
                    backingStoreException = preferences2.node((String)object2);
                    ((Preferences)backingStoreException).removeNode();
                    arrayList.add(object2);
                }
            }
            catch (BackingStoreException backingStoreException2) {
                TraceSettings.trace1((String)backingStoreException2.getMessage(), (int)15);
            }
            sUserDefinedToolsMap.remove(object2);
        }
        List<ToolbarObject> list2 = ToolbarsUtil.loadToolBarsFromPrefs();
        HashSet<Object> hashSet = new HashSet<Object>();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            backingStoreException = (ToolbarObject)object2.next();
            List<ToolbarItem> backingStoreException2 = ((ToolbarObject)backingStoreException).getToolbarItems();
            Object object3 = backingStoreException2.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                if (!arrayList.contains(((ToolbarItem)object).getActionId())) continue;
                object3.remove();
                hashSet.add(backingStoreException);
            }
        }
        object2 = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        backingStoreException = ((Preferences)object2).node("toolbars");
        for (Object object3 : hashSet) {
            object = ((Preferences)backingStoreException).node(((ToolbarObject)object3).getPreferencesNode());
            Preferences preferences3 = ((Preferences)object).node("items");
            List<ToolbarItem> list3 = ((ToolbarObject)object3).getToolbarItems();
            for (int i = 0; i < list3.size(); ++i) {
                ToolbarItem toolbarItem = list3.get(i);
                preferences3.put(Integer.toString(i), toolbarItem.isUserDefinedTool() + "," + toolbarItem.getActionId() + "," + toolbarItem.isUserDefinedImage() + "," + toolbarItem.getImageKey());
            }
        }
        try {
            ((Preferences)object2).flush();
        }
        catch (BackingStoreException backingStoreException3) {
            backingStoreException3.printStackTrace();
        }
    }

    public static void saveToolbarVisibleState(ToolbarObject toolbarObject) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("toolbars");
        Preferences preferences3 = preferences2.node(toolbarObject.getPreferencesNode());
        preferences3.putBoolean("visible", toolbarObject.isVisible());
        try {
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    public static void saveActiveDatasetToolbarVisibleState(boolean bl) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("toolbars");
        Preferences preferences3 = preferences2.node(ToolbarDefaults.getSyntaxPrefNodeKey());
        preferences3.putBoolean("active_dataset_visible", bl);
        try {
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    @Deprecated
    public static boolean getShowActiveDatasetToolbar() {
        boolean bl = true;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        try {
            Preferences preferences2;
            Preferences preferences3;
            if (preferences.nodeExists("toolbars") && (preferences3 = preferences.node("toolbars")).nodeExists(ToolbarDefaults.getSyntaxPrefNodeKey()) && (preferences2 = preferences3.node(ToolbarDefaults.getSyntaxPrefNodeKey())) != null) {
                bl = preferences2.getBoolean("active_dataset_visible", true);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)exception.getMessage(), (int)15);
        }
        return bl;
    }

    private static void cleanUpToolbars(List<ToolbarObject> list, Preferences preferences) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            hashSet.add(stringArray2.getPreferencesNode());
        }
        try {
            for (String string : stringArray = preferences.childrenNames()) {
                if (hashSet.contains(string)) continue;
                preferences.node(string).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            TraceSettings.trace1((String)backingStoreException.getMessage(), (int)15);
        }
    }

    private static long getMaxToolbarId(List<ToolbarObject> list) {
        long l = 0L;
        for (ToolbarObject toolbarObject : list) {
            Long l2 = toolbarObject.getBarId();
            if (l2 == null || l2 <= -1L || l2 <= l) continue;
            l = l2;
        }
        return l;
    }
}

