/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controlbar;

import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.laf.LookAndFeelManager;
import com.spss.java_client.ui.resources.ResUtil;
import java.util.ArrayList;
import java.util.List;

public class ToolbarDefaults {
    private static final String DATA_DEFAULT1_PREF_NODE_KEY = "tbde1";
    private static final String OUTPUT_DEFAULT1_PREF_NODE_KEY = "tbout1";
    private static final String OUTPUT_DEFAULT2_PREF_NODE_KEY = "tbout2";
    public static final String SYNTAX_DEFAULT_PREF_NODE_KEY = "tbsyn1";
    public static final String SYNTAX_TOOLS_PREF_NODE_KEY = "tbsyn2";
    private static String DATA_DEFAULT1_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_DATA_EDITOR");
    private static String OUTPUT_DEFAULT1_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_VIEWER_STANDARD");
    private static String OUTPUT_DEFAULT2_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_VIEWER_OUTLINE");
    private static String SYNTAX_DEFAULT_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_SYNTAX_EDITOR");
    private static String SYNTAX_TOOLS_DEFAULT_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_SYNTAX_TOOLS");

    public List<ToolbarObject> getDefaultToolbars() {
        ArrayList<ToolbarObject> arrayList = new ArrayList<ToolbarObject>();
        arrayList.add(this.createToolbarObject(DATA_DEFAULT1_PREF_NODE_KEY, DATA_DEFAULT1_NAME, 1L, this.createTbItems(this.getDataEditorDefaults1()), DocType.DE_DOC));
        arrayList.add(this.createToolbarObject(OUTPUT_DEFAULT1_PREF_NODE_KEY, OUTPUT_DEFAULT1_NAME, 2L, this.createTbItems(this.getOutputDefaults1()), DocType.OUTPUT_DOC));
        ToolbarObject toolbarObject = this.createToolbarObject(OUTPUT_DEFAULT2_PREF_NODE_KEY, OUTPUT_DEFAULT2_NAME, 3L, this.createTbItems(this.getOutputDefaults2()), DocType.OUTPUT_DOC);
        toolbarObject.setVisible(false);
        arrayList.add(toolbarObject);
        arrayList.add(this.createToolbarObject(SYNTAX_DEFAULT_PREF_NODE_KEY, SYNTAX_DEFAULT_NAME, 4L, this.createTbItems(this.getSyntaxDefaults1()), DocType.SYNTAX_DOC));
        arrayList.add(this.createToolbarObject(SYNTAX_TOOLS_PREF_NODE_KEY, SYNTAX_TOOLS_DEFAULT_NAME, 5L, this.createTbItems(this.getSyntaxToolsDefaults()), DocType.SYNTAX_DOC));
        return arrayList;
    }

    public ToolbarObject getDefaultToolbar(String string) {
        ToolbarObject toolbarObject = null;
        if (string.equals(DATA_DEFAULT1_PREF_NODE_KEY)) {
            toolbarObject = this.createToolbarObject(DATA_DEFAULT1_PREF_NODE_KEY, DATA_DEFAULT1_NAME, 1L, this.createTbItems(this.getDataEditorDefaults1()), DocType.DE_DOC);
        } else if (string.equals(OUTPUT_DEFAULT1_PREF_NODE_KEY)) {
            toolbarObject = this.createToolbarObject(OUTPUT_DEFAULT1_PREF_NODE_KEY, OUTPUT_DEFAULT1_NAME, 2L, this.createTbItems(this.getOutputDefaults1()), DocType.OUTPUT_DOC);
        } else if (string.equals(OUTPUT_DEFAULT2_PREF_NODE_KEY)) {
            toolbarObject = this.createToolbarObject(OUTPUT_DEFAULT2_PREF_NODE_KEY, OUTPUT_DEFAULT2_NAME, 3L, this.createTbItems(this.getOutputDefaults2()), DocType.OUTPUT_DOC);
        } else if (string.equals(SYNTAX_DEFAULT_PREF_NODE_KEY)) {
            toolbarObject = this.createToolbarObject(SYNTAX_DEFAULT_PREF_NODE_KEY, SYNTAX_DEFAULT_NAME, 4L, this.createTbItems(this.getSyntaxDefaults1()), DocType.SYNTAX_DOC);
        } else if (string.equals(SYNTAX_TOOLS_PREF_NODE_KEY)) {
            toolbarObject = this.createToolbarObject(SYNTAX_TOOLS_PREF_NODE_KEY, SYNTAX_TOOLS_DEFAULT_NAME, 5L, this.createTbItems(this.getSyntaxToolsDefaults()), DocType.SYNTAX_DOC);
        }
        return toolbarObject;
    }

    public static String getSyntaxPrefNodeKey() {
        return SYNTAX_DEFAULT_PREF_NODE_KEY;
    }

    private List<ToolbarItem> createTbItems(List<String> list) {
        ArrayList<ToolbarItem> arrayList = new ArrayList<ToolbarItem>();
        for (String string : list) {
            if (string.equals("file_open_data") || string.equals("file_open_output") || string.equals("file_open_syntax") || string.equals("file_open_script")) {
                arrayList.add(new ToolbarItem(string, false, "script", false));
                continue;
            }
            arrayList.add(new ToolbarItem(string, false, string, false));
        }
        return arrayList;
    }

    private ToolbarObject createToolbarObject(String string, String string2, long l, List<ToolbarItem> list, DocType docType) {
        ToolbarObject toolbarObject = new ToolbarObject();
        toolbarObject.setPreferencesNode(string);
        toolbarObject.setName(string2);
        toolbarObject.setBarId(l);
        toolbarObject.setToolbarItems(list);
        toolbarObject.getDocTypes().add(docType);
        toolbarObject.setUserDefinedToolbar(false);
        toolbarObject.setVisible(true);
        return toolbarObject;
    }

    private List<String> getDataEditorDefaults1() {
        LookAndFeelManager lookAndFeelManager = SpssMgr.getSpssMgr().getLookAndFeelManager();
        String string = lookAndFeelManager.getLookAndFeel().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("file_open_data");
        arrayList.add("file_save");
        arrayList.add("file_print");
        arrayList.add("separator");
        arrayList.add("dialog_recall");
        arrayList.add("separator");
        arrayList.add("edit_undo");
        arrayList.add("edit_redo");
        arrayList.add("separator");
        arrayList.add("edit_goto_case");
        arrayList.add("edit_goto_variable");
        arrayList.add("utilities_variables");
        arrayList.add("context_data_descriptives");
        arrayList.add("separator");
        arrayList.add("edit_find");
        arrayList.add("separator");
        arrayList.add("data_split_file");
        arrayList.add("data_select_cases");
        arrayList.add("separator");
        arrayList.add("view_value_labels");
        arrayList.add("utilities_use_variable_sets");
        arrayList.add("view_customize_toolbar");
        arrayList.add("separator");
        return arrayList;
    }

    private List<String> getOutputDefaults1() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("file_open_output");
        arrayList.add("file_save");
        arrayList.add("file_print");
        arrayList.add("file_print_preview");
        arrayList.add("separator");
        arrayList.add("file_export_output");
        arrayList.add("separator");
        arrayList.add("dialog_recall");
        arrayList.add("separator");
        arrayList.add("edit_undo");
        arrayList.add("edit_redo");
        arrayList.add("separator");
        arrayList.add("go_to_data");
        arrayList.add("edit_goto_case");
        arrayList.add("edit_goto_variable");
        arrayList.add("utilities_variables");
        arrayList.add("separator");
        arrayList.add("utilities_create_edit_script");
        arrayList.add("utilities_run_script");
        arrayList.add("separator");
        arrayList.add("utilities_designate_window");
        arrayList.add("view_customize_toolbar");
        arrayList.add("separator");
        return arrayList;
    }

    private List<String> getOutputDefaults2() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("edit_outline_promote");
        arrayList.add("edit_outline_demote");
        arrayList.add("separator");
        arrayList.add("view_expand");
        arrayList.add("view_collapse");
        arrayList.add("separator");
        arrayList.add("view_show_item");
        arrayList.add("view_hide_item");
        arrayList.add("separator");
        arrayList.add("insert_new_heading");
        arrayList.add("insert_new_title");
        arrayList.add("insert_new_text");
        return arrayList;
    }

    private List<String> getSyntaxDefaults1() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("file_open_syntax");
        arrayList.add("file_save");
        arrayList.add("file_print");
        arrayList.add("dialog_recall");
        arrayList.add("separator");
        arrayList.add("edit_undo");
        arrayList.add("edit_redo");
        arrayList.add("separator");
        arrayList.add("go_to_data");
        arrayList.add("utilities_variables");
        arrayList.add("separator");
        arrayList.add("edit_find");
        arrayList.add("separator");
        arrayList.add("run_selection");
        arrayList.add("run_continue");
        arrayList.add("separator");
        arrayList.add("syntax_help");
        arrayList.add("separator");
        arrayList.add("utilities_create_edit_script");
        arrayList.add("utilities_run_script");
        arrayList.add("separator");
        arrayList.add("utilities_designate_window");
        arrayList.add("view_customize_toolbar");
        arrayList.add("separator");
        return arrayList;
    }

    private List<String> getSyntaxToolsDefaults() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("syntax_comment_selection");
        arrayList.add("separator");
        arrayList.add("syntax_auto_indent");
        arrayList.add("syntax_toggle_breakpoint");
        arrayList.add("syntax_honor_breakpoints");
        arrayList.add("separator");
        arrayList.add("window_split");
        return arrayList;
    }

    public static void resetToolbarResources() {
        DATA_DEFAULT1_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_DATA_EDITOR");
        OUTPUT_DEFAULT1_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_VIEWER_STANDARD");
        OUTPUT_DEFAULT2_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_VIEWER_OUTLINE");
        SYNTAX_DEFAULT_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_SYNTAX_EDITOR");
        SYNTAX_TOOLS_DEFAULT_NAME = ResUtil.getCommonDlgString("IDS_TOOLBAR_DEFAUT_SYNTAX_TOOLS");
    }
}

