/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controlbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToolBarUI;

public class MultiDockToolBarUI
extends BasicToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected String constraintBeforeFloating = "North";
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    @Override
    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        boolean bl = false;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        jComponent.setOpaque(true);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    @Override
    protected void installDefaults() {
        Object object;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((object = this.toolBar.getClientProperty(IS_ROLLOVER)) != null) {
            this.rolloverBorders = (Boolean)object;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    @Override
    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
    }

    @Override
    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.toolBar, actionMap);
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("ToolBar.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ToolBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ToolBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        return actionMapUIResource;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    @Override
    protected void navigateFocusedComp(int n) {
        int n2 = this.toolBar.getComponentCount();
        block0 : switch (n) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n3 = this.focusedCompIndex + 1;
                while (n3 != this.focusedCompIndex) {
                    Component component;
                    if (n3 >= n2) {
                        n3 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n3++)) == null || !component.isFocusable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n4 = this.focusedCompIndex - 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 < 0) {
                        n4 = n2 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4--)) == null || !component.isFocusable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    protected Border createRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight")), new RolloverMarginBorderEx());
    }

    @Override
    protected Border createNonRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight")), new RolloverMarginBorderEx());
    }

    private Border createNonRolloverToggleBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RadioButtonBorder(uIDefaults.getColor("ToggleButton.shadow"), uIDefaults.getColor("ToggleButton.darkShadow"), uIDefaults.getColor("ToggleButton.light"), uIDefaults.getColor("ToggleButton.highlight")), new RolloverMarginBorderEx());
    }

    @Override
    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JFrame jFrame = new JFrame(jToolBar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        };
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame frame, String string, boolean bl) {
                super(frame, string, bl);
            }

            public ToolBarDialog(Dialog dialog, String string, boolean bl) {
                super(dialog, string, bl);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, jToolBar.getName(), false) : new ToolBarDialog((Frame)null, jToolBar.getName(), false));
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(true);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    protected DragWindow createDragWindowEx(JToolBar jToolBar) {
        Window window = null;
        if (this.toolBar != null) {
            Container container;
            for (container = this.toolBar.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null) {
                window = (Window)container;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            window = (Window)((Object)this.floatingToolBar);
        }
        return new DragWindow(window);
    }

    @Override
    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    @Override
    public void setRolloverBorders(boolean bl) {
        this.rolloverBorders = bl;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    @Override
    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).updateUI();
            this.setBorderToRollover(componentArray[i]);
        }
    }

    @Override
    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).updateUI();
            this.setBorderToNonRollover(componentArray[i]);
        }
    }

    @Override
    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.setBorderToNormal(componentArray[i]);
        }
    }

    @Override
    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() != null) {
                abstractButton.setBorder(rolloverBorder);
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(true);
        }
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() != null) {
                if (abstractButton instanceof JToggleButton) {
                    abstractButton.setBorder(nonRolloverToggleBorder);
                } else {
                    abstractButton.setBorder(nonRolloverBorder);
                }
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(false);
        }
    }

    @Override
    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.remove(abstractButton);
            abstractButton.setBorder(border);
            Boolean bl = (Boolean)this.rolloverTable.remove(abstractButton);
            if (bl != null) {
                abstractButton.setRolloverEnabled(bl);
            }
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public void setFloatingLocation(int n, int n2) {
        this.floatingX = n;
        this.floatingY = n2;
    }

    @Override
    public boolean isFloating() {
        return this.floating;
    }

    public Point getFloatingWinLocation() {
        Point point = null;
        if (this.isFloating()) {
            Container container = this.floatingToolBar.getRootPane().getParent();
            int n = container.getLocation().x;
            int n2 = container.getLocation().y;
            point = new Point(n, n2);
        }
        return point;
    }

    @Override
    public void setFloating(boolean bl, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl;
            if (bl) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                object = new Point();
                this.toolBar.getLocation((Point)object);
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, (Point)object);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(true);
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                int n = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(String string) {
        int n = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n);
        }
    }

    @Override
    public Color getDockingColor() {
        return this.dockingColor;
    }

    @Override
    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    @Override
    public Color getFloatingColor() {
        return this.floatingColor;
    }

    @Override
    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    @Override
    public boolean canDock(Component component, Point point) {
        boolean bl = false;
        Rectangle rectangle = component.getBounds();
        rectangle.width += 20;
        rectangle.height += 20;
        if (rectangle.contains(point)) {
            int n;
            int n2 = n = this.toolBar.getOrientation() == 0 ? (int)((double)this.toolBar.getSize().height * 1.5) : (int)((double)this.toolBar.getSize().width * 1.5);
            if (point.y < n) {
                bl = true;
            }
            if (point.y > component.getSize().height - n) {
                bl = true;
            }
            if (point.x < n) {
                bl = true;
            }
            if (point.x > component.getSize().width - n) {
                bl = true;
            }
        }
        return bl;
    }

    private String calculateConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n;
            int n2 = n = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - n) {
                string = "South";
            } else if (point.x < n && this.toolBar.getOrientation() == 1) {
                string = "West";
            } else if (point.x >= this.dockingSource.getSize().width - n && this.toolBar.getOrientation() == 1) {
                string = "East";
            } else if (point.y < n) {
                string = "North";
            }
        }
        return string;
    }

    private String getDockingConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n;
            int n2 = n = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - n) {
                string = "South";
            }
            if (point.x < n) {
                string = "West";
            }
            if (point.x >= this.dockingSource.getSize().width - n) {
                string = "East";
            }
            if (point.y < n) {
                string = "North";
            }
        }
        return string;
    }

    @Override
    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Object object;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindowEx(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getPreferredSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                Point point5 = new Point(point2);
                SwingUtilities.convertPointFromScreen(point5, this.toolBar.getParent());
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, point5);
                Point point6 = this.dockingSource.getLocationOnScreen();
                Point point7 = new Point(((Point)cloneable).x - point6.x, ((Point)cloneable).y - point6.y);
                if (this.canDock(this.dockingSource, point7)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    object = this.getDockingConstraint(this.dockingSource, point7);
                    int n = this.mapConstraintToOrientation((String)object);
                    this.dragWindow.setOrientation(n);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setOrientation(0);
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    object = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(((Dimension)object).width, ((Dimension)object).height);
                    this.dragWindow.setVisible(true);
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    @Override
    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    @Override
    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    static class RolloverMarginBorderEx
    extends EmptyBorder {
        public RolloverMarginBorderEx() {
            super(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    protected class DragWindow
    extends Window {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window window) {
            super(window);
            this.borderColor = Color.gray;
            this.orientation = MultiDockToolBarUI.this.toolBar.getOrientation();
        }

        public void setOrientation(int n) {
            if (this.isShowing()) {
                if (n == this.orientation) {
                    return;
                }
                this.orientation = n;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (MultiDockToolBarUI.this.toolBar.getComponentOrientation().isLeftToRight()) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(color);
            super.paint(graphics);
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                MultiDockToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            MultiDockToolBarUI.this.dragTo(point, this.origin);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("lookAndFeel")) {
                MultiDockToolBarUI.this.toolBar.updateUI();
            } else if (string.equals("orientation")) {
                Component[] componentArray = MultiDockToolBarUI.this.toolBar.getComponents();
                int n = (Integer)propertyChangeEvent.getNewValue();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)componentArray[i];
                    separator.setOrientation(n);
                    Dimension dimension = separator.getSize();
                    if (dimension.width == dimension.height) continue;
                    Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                    separator.setSeparatorSize(dimension2);
                }
            } else if (string.equals(IS_ROLLOVER)) {
                MultiDockToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            MultiDockToolBarUI.this.focusedCompIndex = MultiDockToolBarUI.this.toolBar.getComponentIndex(component);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (MultiDockToolBarUI.this.toolBarFocusListener != null) {
                component.addFocusListener(MultiDockToolBarUI.this.toolBarFocusListener);
            }
            if (MultiDockToolBarUI.this.isRolloverBorders()) {
                MultiDockToolBarUI.this.setBorderToRollover(component);
            } else {
                MultiDockToolBarUI.this.setBorderToNonRollover(component);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (MultiDockToolBarUI.this.toolBarFocusListener != null) {
                component.removeFocusListener(MultiDockToolBarUI.this.toolBarFocusListener);
            }
            MultiDockToolBarUI.this.setBorderToNormal(component);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (MultiDockToolBarUI.this.toolBar.isFloatable()) {
                if (MultiDockToolBarUI.this.dragWindow != null) {
                    MultiDockToolBarUI.this.dragWindow.setVisible(false);
                }
                MultiDockToolBarUI.this.floating = false;
                if (MultiDockToolBarUI.this.floatingToolBar == null) {
                    MultiDockToolBarUI.this.floatingToolBar = MultiDockToolBarUI.this.createFloatingWindow(MultiDockToolBarUI.this.toolBar);
                }
                if (MultiDockToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)MultiDockToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                MultiDockToolBarUI.this.floatingToolBar.getContentPane().remove(MultiDockToolBarUI.this.toolBar);
                String string = MultiDockToolBarUI.this.constraintBeforeFloating;
                int n = MultiDockToolBarUI.this.mapConstraintToOrientation(string);
                MultiDockToolBarUI.this.setOrientation(n);
                if (MultiDockToolBarUI.this.dockingSource == null) {
                    MultiDockToolBarUI.this.dockingSource = MultiDockToolBarUI.this.toolBar.getParent();
                }
                if (MultiDockToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(MultiDockToolBarUI.this.propertyListener);
                }
                MultiDockToolBarUI.this.dockingSource.add(string, MultiDockToolBarUI.this.toolBar);
                MultiDockToolBarUI.this.dockingSource.invalidate();
                Container container = MultiDockToolBarUI.this.dockingSource.getParent();
                if (container != null) {
                    container.validate();
                }
                MultiDockToolBarUI.this.dockingSource.repaint();
                MultiDockToolBarUI.this.setFloating(false, null);
            }
        }
    }

    private static class DownAction
    extends KeyAction {
        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            MultiDockToolBarUI multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
            multiDockToolBarUI.navigateFocusedComp(5);
        }
    }

    private static class UpAction
    extends KeyAction {
        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            MultiDockToolBarUI multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
            multiDockToolBarUI.navigateFocusedComp(1);
        }
    }

    private static class LeftAction
    extends KeyAction {
        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            MultiDockToolBarUI multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
            multiDockToolBarUI.navigateFocusedComp(7);
        }
    }

    private static class RightAction
    extends KeyAction {
        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            MultiDockToolBarUI multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
            multiDockToolBarUI.navigateFocusedComp(3);
        }
    }

    private static abstract class KeyAction
    extends AbstractAction {
        private KeyAction() {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

