/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.controlbar;

import com.ibm.statistics.lighttable.ui.LtResUtil;
import com.ibm.statistics.lighttable.ui.util.LtEditorUtil;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controlbar.IToolbarConstants;
import com.spss.java_client.ui.controlbar.MultiDockToolBarUI;
import com.spss.java_client.ui.controlbar.ToolbarContextMenu;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.DropButtonDrawer;
import com.spss.uitools.drop_menu_button.DropButtonEx;
import com.spss.uitools.drop_menu_button.FillButtonDrawer;
import com.spss.uitools.drop_menu_button.TextButtonDrawer;
import com.spss.uitools.toolbar.RaisedToolBarBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BaseToolbar
extends JToolBar
implements MouseListener {
    private ToolbarObject mToolbarObject;
    private SpssFrame mFrame;
    private static final String TEXT_CHAR = LtResUtil.getString((String)"ToolbarTextColorSampleChar");

    public BaseToolbar(String string) {
        super(string, 0);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        RaisedToolBarBorder raisedToolBarBorder = new RaisedToolBarBorder(uIDefaults.getColor("ToolBar.shadow"), uIDefaults.getColor("ToolBar.highlight"));
        this.setBorder((Border)raisedToolBarBorder);
    }

    public AbstractButton createButton(ToolbarItem toolbarItem, SpssFrame spssFrame) {
        ToolbarButton toolbarButton = null;
        try {
            SpssAction spssAction = spssFrame.getToolbarAction(toolbarItem, true);
            if (spssAction != null) {
                toolbarButton = new ToolbarButton(spssAction);
                toolbarButton.setText(null);
                toolbarButton.setMnemonic('\u0000');
                toolbarButton.setMargin(new Insets(0, 0, 0, 0));
                toolbarButton.setFocusable(false);
                toolbarButton.putClientProperty("hideActionText", true);
                ImageIcon imageIcon = this.getImageIcon(toolbarItem, spssFrame);
                if (imageIcon != null) {
                    toolbarButton.setIcon(imageIcon);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return toolbarButton;
    }

    public AbstractButton createToggleButton(ToolbarItem toolbarItem, SpssFrame spssFrame) {
        ToolbarToggleButton toolbarToggleButton = null;
        try {
            SpssAction spssAction = spssFrame.getToolbarAction(toolbarItem, true);
            if (spssAction != null) {
                toolbarToggleButton = new ToolbarToggleButton(spssAction);
                toolbarToggleButton.setText(null);
                toolbarToggleButton.setMnemonic('\u0000');
                toolbarToggleButton.setMargin(new Insets(0, 0, 0, 0));
                toolbarToggleButton.setFocusable(false);
                toolbarToggleButton.putClientProperty("hideActionText", true);
                ImageIcon imageIcon = this.getImageIcon(toolbarItem, spssFrame);
                if (imageIcon != null) {
                    toolbarToggleButton.setIcon(imageIcon);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return toolbarToggleButton;
    }

    public void showLargeButton(boolean bl) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ImageIcon imageIcon;
            Component component = this.getComponentAtIndex(i);
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            SpssAction spssAction = (SpssAction)abstractButton.getAction();
            String string = spssAction.getActionId();
            if (spssAction instanceof CFCommandAction) {
                String string2 = ((CFCommandAction)spssAction).getExtensionId();
                imageIcon = bl ? FrameworkMgr.get().getLargeExtensionIcon(string2, string) : FrameworkMgr.get().getExtensionIcon(string2, string);
            } else {
                imageIcon = bl ? new ImageIcon(ResUtil.getLargeImageURL(string)) : new ImageIcon(ResUtil.getImageURL(string));
            }
            abstractButton.setIcon(imageIcon);
            abstractButton.setDisabledIcon(null);
        }
    }

    public void checkButton(String string, boolean bl) {
        JToggleButton jToggleButton = this.findCheckButton(string);
        if (jToggleButton != null) {
            jToggleButton.setSelected(bl);
        }
    }

    public JToggleButton findCheckButton(String string) {
        JToggleButton jToggleButton = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            AbstractButton abstractButton;
            SpssAction spssAction;
            Component component = this.getComponentAtIndex(i);
            if (!(component instanceof AbstractButton) || !(spssAction = (SpssAction)(abstractButton = (AbstractButton)component).getAction()).getActionId().equals(string) || !(abstractButton instanceof JToggleButton)) continue;
            jToggleButton = (JToggleButton)abstractButton;
            break;
        }
        return jToggleButton;
    }

    public void setupToolbar(SpssFrame spssFrame, ToolbarObject toolbarObject) {
        this.mFrame = spssFrame;
        this.mToolbarObject = toolbarObject;
        this.setRollover(true);
        this.setMargin(new Insets(0, 4, 0, 4));
        if (!UIManager.getLookAndFeel().getName().contains("CobaltLookAndFeel") && !UIManager.getLookAndFeel().getName().contains("AnalyticsLafLookAndFeel")) {
            this.setUI(new MultiDockToolBarUI());
        }
        for (ToolbarItem toolbarItem : toolbarObject.getToolbarItems()) {
            if ("separator".equals(toolbarItem.getActionId())) {
                this.addSeparator();
                continue;
            }
            AbstractButton abstractButton = this.isToggleButton(toolbarItem.getActionId()) ? this.createToggleButton(toolbarItem, spssFrame) : (this.isColorButton(toolbarItem.getActionId()) ? this.createColorButton(spssFrame, toolbarItem, spssFrame.isShowLargeButtonsToolbar()) : this.createButton(toolbarItem, spssFrame));
            if (abstractButton == null) continue;
            if (toolbarItem.getActionId().equals("dialog_recall")) {
                abstractButton.setFocusable(true);
            }
            abstractButton.addMouseListener(this);
            this.add(abstractButton);
        }
        this.addMouseListener(this);
    }

    private AbstractButton createColorButton(SpssFrame spssFrame, ToolbarItem toolbarItem, boolean bl) {
        DropButton dropButton = null;
        SpssAction spssAction = spssFrame.getToolbarAction(toolbarItem, true);
        if (spssAction != null) {
            boolean bl2 = toolbarItem.getActionId().equals("edit_color_text");
            dropButton = bl2 ? this.createTextDropButton(bl) : this.createFillDropButton(bl);
            dropButton.addActionListener((ActionListener)spssAction);
            final DropButton dropButton2 = dropButton;
            spssAction.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        dropButton2.setEnabled(bl);
                        dropButton2.repaint();
                    }
                }
            });
        }
        return dropButton;
    }

    public DropButton createTextDropButton(boolean bl) {
        TextButtonDrawer textButtonDrawer = new TextButtonDrawer(TEXT_CHAR, 0);
        textButtonDrawer.setFontSize(bl ? 24 : 16);
        ToolbarColorButton toolbarColorButton = new ToolbarColorButton((DropButtonDrawer)textButtonDrawer, bl);
        LtEditorUtil.setDropButtonColors((DropButton)toolbarColorButton);
        toolbarColorButton.setToolTipText(LtResUtil.getString((String)"DropBtnTextColor"));
        toolbarColorButton.setFocusable(false);
        return toolbarColorButton;
    }

    public DropButton createFillDropButton(boolean bl) {
        FillButtonDrawer fillButtonDrawer = new FillButtonDrawer();
        ToolbarColorButton toolbarColorButton = new ToolbarColorButton((DropButtonDrawer)fillButtonDrawer, bl);
        LtEditorUtil.setDropButtonColors((DropButton)toolbarColorButton);
        toolbarColorButton.setToolTipText(LtResUtil.getString((String)"DropBtnFillColor"));
        toolbarColorButton.setFocusable(false);
        toolbarColorButton.setUserSelectedColor(Color.WHITE);
        return toolbarColorButton;
    }

    public void setActiveDatasetToolBar(SpssFrame spssFrame) {
        this.mFrame = spssFrame;
        this.mToolbarObject = null;
        this.setRollover(true);
        this.setMargin(new Insets(0, 4, 0, 4));
        this.addMouseListener(this);
    }

    public void closeToolBar() {
        this.mFrame = null;
        this.mToolbarObject = null;
        this.removeMouseListener(this);
    }

    private boolean isToggleButton(String string) {
        return string.equals("view_grid_lines") || string.equals("view_imputation") || string.equals("view_value_labels") || string.equals("utilities_use_variable_sets") || string.equals("syntax_honor_breakpoints") || string.equals("edit_font_bold") || string.equals("window_split");
    }

    private boolean isColorButton(String string) {
        return string.equals("edit_color_text") || string.equals("edit_color_cell");
    }

    private ImageIcon getImageIcon(ToolbarItem toolbarItem, SpssFrame spssFrame) {
        ImageIcon imageIcon = null;
        if (toolbarItem.isUserDefinedImage()) {
            imageIcon = spssFrame.isShowLargeButtonsToolbar() ? ToolbarsUtil.getUserImageIcon(toolbarItem.getImageKey(), IToolbarConstants.LARGE_IMAGE_SIZE) : ToolbarsUtil.getUserImageIcon(toolbarItem.getImageKey(), IToolbarConstants.SMALL_IMAGE_SIZE);
        } else {
            SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction(toolbarItem.getActionId());
            if (spssAction instanceof CFCommandAction) {
                String string = ((CFCommandAction)spssAction).getExtensionId();
                imageIcon = spssFrame.isShowLargeButtonsToolbar() ? FrameworkMgr.get().getLargeExtensionIcon(string, toolbarItem.getActionId()) : FrameworkMgr.get().getExtensionIcon(string, toolbarItem.getActionId());
            } else {
                URL uRL = spssFrame.isShowLargeButtonsToolbar() ? ResUtil.getLargeImageURL(toolbarItem.getImageKey()) : ResUtil.getImageURL(toolbarItem.getImageKey());
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
            }
        }
        return imageIcon;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopUp(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopUp(mouseEvent);
        }
    }

    private void showPopUp(MouseEvent mouseEvent) {
        ToolbarContextMenu toolbarContextMenu = new ToolbarContextMenu(this.mFrame);
        toolbarContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public String getPreferencesNode() {
        return this.mToolbarObject.getPreferencesNode();
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = n; i < n + n3; i += 3) {
            graphics.drawLine(i, n2, i + 1, n2);
            graphics.drawLine(i, n2 + n4 - 1, i + 1, n2 + n4 - 1);
        }
        for (int i = n2; i < n2 + n4; i += 3) {
            graphics.drawLine(n, i, n, i + 1);
            graphics.drawLine(n + n3 - 1, i, n + n3 - 1, i + 1);
        }
    }

    class ToolbarColorButton
    extends DropButtonEx {
        private Dimension mDimension;

        ToolbarColorButton(DropButtonDrawer dropButtonDrawer, boolean bl) {
            super(dropButtonDrawer);
            this.mDimension = bl ? new Dimension(40, 35) : new Dimension(30, 25);
        }

        public Dimension getPreferredSize() {
            return this.mDimension;
        }
    }

    class ToolbarButton
    extends JButton {
        public ToolbarButton(Action action) {
            super(action);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hasFocus()) {
                BaseToolbar.drawDashedRect(graphics, 2, 2, this.getWidth() - 4, this.getHeight() - 4);
            }
        }
    }

    class ToolbarToggleButton
    extends JToggleButton {
        public ToolbarToggleButton(Action action) {
            super(action);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hasFocus()) {
                BaseToolbar.drawDashedRect(graphics, 2, 2, this.getWidth() - 2, this.getHeight() - 2);
            }
        }
    }
}

