/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.command.executor;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.CommandAction;
import com.spss.java_client.ui.command.CustomCommandAction;
import com.spss.java_client.ui.controls.CFMenu;
import com.spss.java_client.ui.dialogs.base.custom_gui.DialogExecutor;
import com.spss.java_client.ui.dialogs.base.utilities.MissingAddOnsDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.DummyAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.UserMenuAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.DomUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandExecutor {
    private static final String EXT_FOLDER_PATH = "ext" + File.separator + "lib";
    private static CommandExecutor sInstance = null;
    private Vector<MenuItemContainer> mMenuItems = new Vector();
    private final Object LOCK_MENU_ITEMS = new Object();
    private Properties mProperties = null;
    private List<MenuItemContainer> mCustomMenuItems = Collections.synchronizedList(new LinkedList());
    private final Object LOCK_CUSTOM_MENU_ITEMS = new Object();
    private List<MenuItemContainer> mExtensionsMenuItems = Collections.synchronizedList(new LinkedList());
    private final Object LOCK_EXTENSIONS_MENU_ITEMS = new Object();
    private HashMap<String, String> mCustomMenuActions = new HashMap();

    public static synchronized CommandExecutor get() {
        if (sInstance == null) {
            sInstance = new CommandExecutor();
            sInstance.scanCommands(true);
        }
        return sInstance;
    }

    public void addCustomCommands(SpssFrame spssFrame) {
        JMenuBar jMenuBar = spssFrame.getJMenuBar();
        this.addCustomCommands(jMenuBar, spssFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomCommands(JMenuBar jMenuBar, SpssFrame spssFrame) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                this.addMenuItem(jMenuBar, menuItemContainer, spssFrame);
            }
        }
        this.addCustomMenuItems(jMenuBar);
        this.addExtensionsMenuItems(jMenuBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCommand(String string, String string2, String string3) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (!menuItemContainer.getSpssMenu().equals(string) || !menuItemContainer.getAction().getActionId().equals(string2) || !string3.equals(menuItemContainer.getOffset())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCommand(CommandAction commandAction, CommandLocation commandLocation) {
        this.removeCustomAction(commandAction);
        MenuItemContainer menuItemContainer = new MenuItemContainer(commandAction, commandLocation);
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            this.mMenuItems.add(menuItemContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAction(CommandAction commandAction) {
        String string = commandAction instanceof CustomCommandAction ? ((CustomCommandAction)commandAction).getClefFileName() : "";
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                CommandAction commandAction2 = menuItemContainer.getAction();
                if (!commandAction2.getActionId().equals(commandAction.getActionId()) && (!(commandAction2 instanceof CustomCommandAction) || !((CustomCommandAction)commandAction2).getClefFileName().equalsIgnoreCase(string))) continue;
                this.mMenuItems.remove(menuItemContainer);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hasMenuItem(String string, String string2, String string3) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (!menuItemContainer.getAction().getActionId().equals(string) || !menuItemContainer.getSpssMenu().equals(string2) || !menuItemContainer.getAction().getName().equalsIgnoreCase(string3)) continue;
                return menuItemContainer.getAction().getActionId();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMenuItemExist(String string, String string2, String string3) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (!menuItemContainer.getAction().getActionId().equals(string) || !menuItemContainer.getSpssMenu().equals(string2) || !menuItemContainer.getAction().getName().equalsIgnoreCase(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean executeCustomDialog(JFrame jFrame, String string, File file) {
        if (!file.exists() || file.isDirectory() || !this.isCLEF(file)) {
            return false;
        }
        DialogDefinition dialogDefinition = this.readClefFileSpec(file);
        if (dialogDefinition == null || !dialogDefinition.getDialogId().equals(string)) {
            return false;
        }
        if (!MissingAddOnsDlg.checkForMissingAddOns(jFrame, dialogDefinition)) {
            return false;
        }
        DialogExecutor dialogExecutor = new DialogExecutor();
        return dialogExecutor.runDialog(jFrame, dialogDefinition);
    }

    public DialogDefinition readClefFileSpec(File file) {
        try {
            Document document = this.buildDOM(file);
            if (document == null) {
                return null;
            }
            String string = file.getParentFile().getPath();
            SpecificationBuilder specificationBuilder = new SpecificationBuilder(document, string);
            return specificationBuilder.getSpecification(AppType.STATS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return null;
    }

    public static String getUIExtensionsFolderPath() {
        return SpecificationBuilder.getUIExtensionsFolderPath();
    }

    public static String[] getSecondaryExtensionFolders() {
        return SpecificationBuilder.getSecondaryExtensionFolders();
    }

    public static String getAppdataCustomDialogDirectory() {
        return SpecificationBuilder.getAppdataCustomDialogDirectory();
    }

    public static String getAppdataCustomDialogDirectoryForAllUsers() {
        return SpecificationBuilder.getAppdataCustomDialogDirectoryForAllUsers();
    }

    public Vector<MenuItemContainer> getCustomMenuItems() {
        return this.mMenuItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MenuItemContainer> getNonAnalyzeCustomMenuItems() {
        Vector<MenuItemContainer> vector = new Vector<MenuItemContainer>();
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (menuItemContainer.mSpssMenu.toLowerCase(Locale.ENGLISH).startsWith("analyze") || CommandLine.isClementineCaller() && menuItemContainer.getAction().getActionId().equals("cognos_import")) continue;
                vector.add(menuItemContainer);
            }
            return vector;
        }
    }

    public static boolean isClefFolder(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(new XmlFilter())) {
            if (!SpecificationBuilder.isCLEF((File)file2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariableList(File file) {
        return SpecificationBuilder.hasVariableList((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanCommands(boolean bl) {
        String[] stringArray = this.LOCK_MENU_ITEMS;
        synchronized (this.LOCK_MENU_ITEMS) {
            String string;
            File file;
            File file2;
            this.mMenuItems.clear();
            // ** MonitorExit[stringArray] (shouldn't be in output)
            for (String string2 : stringArray = CommandExecutor.getSecondaryExtensionFolders()) {
                this.checkFolders(new File(string2));
            }
            String string3 = CommandExecutor.getAppdataCustomDialogDirectoryForAllUsers();
            if (string3 != null) {
                File file22 = new File(string3);
                this.checkFolders(file22);
            }
            if (!(file2 = new File(CommandExecutor.getAppdataCustomDialogDirectory())).exists() || !file2.isDirectory()) {
                return;
            }
            int n = 1;
            for (String string4 : stringArray) {
                if (!string4.equals(file2.getAbsolutePath().toString())) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                this.checkFolders(file2);
            }
            if (!(file = new File(string = CommandExecutor.getUIExtensionsFolderPath())).exists() || !file.isDirectory()) {
                return;
            }
            this.checkFolders(file);
            this.scanCFPath(bl && !CommandLine.isExternalCaller());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMenuItem(MenuItemContainer menuItemContainer) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            this.mMenuItems.add(menuItemContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMenuItem(String string) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (!menuItemContainer.getAction().getActionId().equals(string)) continue;
                this.mMenuItems.remove(menuItemContainer);
            }
        }
    }

    public Vector<String> getMenuLabelHierarchy(JComponent jComponent, String string) {
        Vector<String> vector = this.retrieveMenuLabelHierarchy(jComponent, string);
        if (vector != null && !vector.isEmpty()) {
            return vector;
        }
        return null;
    }

    public void addMenuItem(JMenuBar jMenuBar, MenuItemContainer menuItemContainer, SpssFrame spssFrame) {
        this.doAddMenuItem(jMenuBar, menuItemContainer, spssFrame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMenuItem(JMenuBar jMenuBar, MenuItemContainer menuItemContainer, SpssFrame spssFrame, boolean bl) {
        boolean bl2 = menuItemContainer.getAction() instanceof CFCommandAction;
        Integer n = menuItemContainer.getVersion();
        if (n != null && n >= 2 && menuItemContainer.mInstallToGlobalCustomMenu) {
            this.getCustomMenu(jMenuBar);
        }
        if (this.isMenuPartOfThisFrameType(spssFrame, menuItemContainer)) {
            try {
                CFCommandAction cFCommandAction;
                Component component;
                int n2;
                String string;
                int n3;
                Object object;
                if (bl2) {
                    object = (CFCommandAction)menuItemContainer.getAction();
                    if ((spssFrame instanceof SyntaxFrame || spssFrame instanceof ViewerFrame) && ((CFCommandAction)object).getExtensionId().equals("spss.tm1") && ((SpssAction)object).getActionId().equals("tm1_export")) {
                        return;
                    }
                    LicenseManager.Status status = LicenseManager.getLicenseManager().getStatus(((CFCommandAction)object).getLicenseOption());
                    if (status != LicenseManager.Status.VALID) {
                        TraceSettings.trace1((String)("**** Invalid license for " + menuItemContainer.getAction().getActionId()), (int)15);
                        return;
                    }
                }
                Object object2 = (n3 = ((String)(object = menuItemContainer.getSpssMenu())).lastIndexOf(".")) > -1 ? ((String)object).substring(n3 + 1) : object;
                JMenu jMenu = null;
                try {
                    jMenu = this.findMenu(jMenuBar, (String)object2);
                }
                catch (Exception exception) {
                    TraceSettings.trace1((String)("*** ==> Error placing menu item: " + menuItemContainer.getAction().getActionId()), (int)15);
                    exception.printStackTrace();
                }
                if (jMenu == null) {
                    if (bl2) {
                        if (n == null || n <= 2) {
                            jMenu = this.buildMenu(jMenuBar, menuItemContainer);
                        }
                    } else {
                        if (((String)object).startsWith("Custom")) {
                            Object object3 = this.LOCK_CUSTOM_MENU_ITEMS;
                            synchronized (object3) {
                                this.mCustomMenuItems.add(menuItemContainer);
                            }
                            return;
                        }
                        Object object4 = this.LOCK_EXTENSIONS_MENU_ITEMS;
                        synchronized (object4) {
                            this.mExtensionsMenuItems.add(menuItemContainer);
                        }
                        return;
                    }
                }
                String string2 = string = menuItemContainer != null ? menuItemContainer.getPreviousMenuId() : null;
                if (string == null || string.isEmpty()) {
                    string = this.getMenuActionId(spssFrame, menuItemContainer.getSpssMenu(), Integer.parseInt(menuItemContainer.getOffset()));
                }
                if (jMenu == null) {
                    jMenu = this.findMenu(jMenuBar, "Extensions");
                    n2 = jMenu.getItemCount();
                } else {
                    int n4 = this.getInsertOffset(jMenuBar, string, menuItemContainer);
                    int n5 = n2 = n4 >= 0 ? n4 : 0;
                }
                if (menuItemContainer.isSepBefore() && n2 > 0) {
                    jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer), n2++);
                }
                if (bl && n2 < jMenu.getItemCount() && (component = jMenu.getMenuComponent(n2)) instanceof JMenuItem && ((JMenuItem)component).getAction() instanceof CFCommandAction && (cFCommandAction = (CFCommandAction)((JMenuItem)component).getAction()).getActionId().equals(menuItemContainer.getAction().getActionId())) {
                    return;
                }
                jMenu.insert(menuItemContainer.getAction(), n2++);
                if (menuItemContainer.isSepAfter()) {
                    jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer), n2);
                }
                this.loadCustomMenuPath(menuItemContainer, jMenu);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isMenuPartOfThisFrameType(SpssFrame spssFrame, MenuItemContainer menuItemContainer) {
        boolean bl = true;
        CommandLocation.InstallToFrame installToFrame = menuItemContainer.getInstallToFrame();
        if (installToFrame != null && (installToFrame == CommandLocation.InstallToFrame.data && !(spssFrame instanceof DataFrame) || installToFrame == CommandLocation.InstallToFrame.syntax && !(spssFrame instanceof SyntaxFrame) || installToFrame == CommandLocation.InstallToFrame.ouput && !(spssFrame instanceof ViewerFrame))) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getCustomMenuPathes() {
        return this.mCustomMenuActions.keySet();
    }

    public String getCustomActionId(String string) {
        return this.mCustomMenuActions.get(string);
    }

    private String getMenuActionId(SpssFrame spssFrame, String string, int n) {
        MenuItemCache menuItemCache = spssFrame.getMenuTreeCache();
        int n2 = string.lastIndexOf(".");
        String string2 = n2 > -1 ? string.substring(n2 + 1) : string;
        Vector<String> vector = new Vector<String>(1);
        this.getMenuActionId(menuItemCache, string2, n, vector);
        return vector.size() > 0 ? vector.get(0) : null;
    }

    private void getMenuActionId(MenuItemCache menuItemCache, String string, int n, Vector<String> vector) {
        int n2 = menuItemCache.getItemCount();
        for (int i = 0; i < n2; ++i) {
            MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
            if (!(menuItemCache2 instanceof MenuCache)) continue;
            if (menuItemCache2.getItemId().equals(string)) {
                String string2;
                int n3 = menuItemCache2.getItemCount();
                if (n == 0) {
                    string2 = menuItemCache2.getItemId();
                    vector.add(0, string2);
                } else if (n >= n3 || n < 0) {
                    string2 = menuItemCache2.getItem(n3 - 1).getItemId();
                    vector.add(0, string2);
                } else {
                    string2 = menuItemCache2.getItem(n - 1).getItemId();
                    if (string2.equals("separator")) {
                        int n4 = n - 2;
                        while (n4 >= 0) {
                            String string3;
                            if ((string3 = menuItemCache2.getItem(n4--).getItemId()).equals("separator")) continue;
                            String string4 = string3 + ".separator";
                            vector.add(0, string4);
                            break;
                        }
                    } else {
                        vector.add(0, string2);
                    }
                }
            }
            this.getMenuActionId(menuItemCache2, string, n, vector);
        }
    }

    private int getInsertOffset(JMenuBar jMenuBar, String string, MenuItemContainer menuItemContainer) {
        int n;
        Vector<Integer> vector = new Vector<Integer>(1);
        for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
            JMenu jMenu = jMenuBar.getMenu(n);
            SpssAction spssAction = (SpssAction)jMenu.getAction();
            if (spssAction != null && spssAction.getActionId().equals(string)) {
                return 0;
            }
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                SpssAction spssAction2;
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem != null) {
                    spssAction2 = (SpssAction)jMenuItem.getAction();
                    if (spssAction2 != null && spssAction2.getActionId().equals(string)) {
                        if (Integer.parseInt(menuItemContainer.getOffset()) > 0) {
                            return i + 1;
                        }
                        return 0;
                    }
                } else {
                    spssAction2 = (SpssAction)jMenu.getItem(i - 1).getAction();
                    if (spssAction2 != null && (spssAction2.getActionId() + ".separator").equals(string)) {
                        return i + 1;
                    }
                }
                if (!(jMenuItem instanceof JMenu)) continue;
                this.getInsertOffset((JMenu)jMenuItem, string, vector);
                if (vector.size() <= 0) continue;
                return vector.get(0);
            }
        }
        n = menuItemContainer != null ? Integer.parseInt(menuItemContainer.getOffset()) : -1;
        return n > 0 ? n : 0;
    }

    private void getInsertOffset(JMenu jMenu, String string, Vector<Integer> vector) {
        String string2;
        Action action = jMenu.getAction();
        if (action instanceof SpssAction && (string2 = ((SpssAction)action).getActionId()).equals(string)) {
            vector.add(0, 0);
            return;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem instanceof JMenu) {
                this.getInsertOffset((JMenu)jMenuItem, string, vector);
                continue;
            }
            if (jMenuItem == null) {
                int n = i - 1;
                while (n > 1) {
                    String string3;
                    Action action2;
                    JMenuItem jMenuItem2;
                    if ((jMenuItem2 = jMenu.getItem(n--)) == null || !((action2 = jMenuItem2.getAction()) instanceof SpssAction) || !(string3 = ((SpssAction)action2).getActionId() + ".separator").equals(string)) continue;
                    vector.add(0, i + 1);
                    return;
                }
                continue;
            }
            Action action3 = jMenuItem.getAction();
            if (!(action3 instanceof SpssAction) || !((SpssAction)action3).getActionId().equals(string)) continue;
            vector.add(0, i + 1);
            return;
        }
    }

    private void loadCustomMenuPath(MenuItemContainer menuItemContainer, JMenu jMenu) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        Container container = jMenu;
        if (null == container) {
            return;
        }
        do {
            String string = container instanceof JMenu ? container.getText() : menuItemContainer.getSpssMenu().substring(0, menuItemContainer.getSpssMenu().indexOf("."));
            stringBuilder.insert(0, string);
            container = container.getParent();
            boolean bl2 = bl = container instanceof JMenu || container instanceof JPopupMenu;
            if (!bl) continue;
            stringBuilder.insert(0, ">");
        } while (bl);
        stringBuilder.append(">");
        stringBuilder.append(menuItemContainer.getAction().getName());
        this.mCustomMenuActions.put(stringBuilder.toString(), menuItemContainer.getAction().getActionId());
    }

    private JMenu buildMenu(JMenuBar jMenuBar, MenuItemContainer menuItemContainer) {
        String[] stringArray;
        JMenu jMenu = null;
        JComponent jComponent = jMenuBar;
        String string = menuItemContainer.getSpssMenu();
        for (String string2 : stringArray = string.split("\\.")) {
            int n;
            int n2 = string2.indexOf(35);
            if (n2 > -1) {
                try {
                    n = Integer.valueOf(string2.substring(n2 + 1));
                    string2 = string2.substring(0, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    n = -1;
                }
            } else {
                n = -1;
            }
            int n3 = -1;
            jMenu = this.findMenu(jComponent, string2);
            if (jMenu == null) {
                Object object;
                Object object2;
                Serializable serializable;
                DummyAction dummyAction = new DummyAction(string2, false);
                CommandAction commandAction = menuItemContainer.getAction();
                if (commandAction instanceof CFCommandAction) {
                    serializable = (CFCommandAction)commandAction;
                    object2 = FrameworkMgr.get();
                    if (object2 == null) continue;
                    object = menuItemContainer.getVersion();
                    if (object != null && (Integer)object >= 2) {
                        n3 = new Integer(menuItemContainer.getOffset());
                    } else {
                        ((FrameworkMgr)object2).configureCFAction(dummyAction, ((CFCommandAction)serializable).getExtensionId(), string2);
                    }
                }
                if ((serializable = menuItemContainer.getVersion()) != null && (Integer)serializable >= 2) {
                    object2 = (CFCommandAction)commandAction;
                    object = FrameworkMgr.get();
                    if (object == null) continue;
                    ((FrameworkMgr)object).configureCFMenuAction(dummyAction, ((CFCommandAction)object2).getExtensionId(), dummyAction.getActionId(), menuItemContainer.getNameForActionID(dummyAction.getActionId()));
                    jMenu = new CFMenu(dummyAction);
                } else {
                    jMenu = new JMenu(dummyAction);
                }
                if (n3 == -1) {
                    n3 = jComponent instanceof JMenu ? ((JMenu)jComponent).getMenuComponentCount() : jComponent.getComponentCount();
                }
                jComponent.add((Component)jMenu, n > -1 ? Math.min(n, n3) : n3);
            }
            jComponent = jMenu;
        }
        return jMenu;
    }

    public void addCustomMenuItems(SpssFrame spssFrame) {
        JMenuBar jMenuBar = spssFrame.getJMenuBar();
        this.addCustomMenuItems(jMenuBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomMenuItems(JMenuBar jMenuBar) {
        Object object = this.LOCK_CUSTOM_MENU_ITEMS;
        synchronized (object) {
            if (this.mCustomMenuItems.isEmpty()) {
                return;
            }
            JMenu jMenu = this.getCustomMenu(jMenuBar);
            this.addUserMenuItems(jMenu, "Custom", this.mCustomMenuItems);
            this.mCustomMenuItems.clear();
        }
    }

    private String getMenuId(MenuItemContainer menuItemContainer) {
        int n;
        String string = menuItemContainer.getSpssMenu();
        int n2 = string.lastIndexOf(".", (n = string.lastIndexOf(".")) - 1);
        return n2 > -1 ? string.substring(n2 + 1, n) : null;
    }

    private JMenu getCustomMenu(JMenuBar jMenuBar) {
        JMenu jMenu = this.findMenu(jMenuBar, "Custom");
        if (jMenu == null) {
            jMenu = new JMenu(new DummyAction("Custom"));
            int n = this.findUtilitiesIndex(jMenuBar);
            jMenuBar.add((Component)jMenu, n);
        }
        return jMenu;
    }

    private int findUtilitiesIndex(JMenuBar jMenuBar) {
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            String string;
            JMenu jMenu = jMenuBar.getMenu(i);
            Action action = jMenu.getAction();
            if (!(action instanceof DummyAction) || (string = ((DummyAction)action).getActionId()) == null || !string.equalsIgnoreCase("Utilities")) continue;
            n = i;
            break;
        }
        return n;
    }

    private JMenu findMenu(JComponent jComponent, String string) {
        if (string == null) {
            return null;
        }
        JMenu jMenu = null;
        Component[] componentArray = jComponent instanceof JMenu ? ((JMenu)jComponent).getMenuComponents() : jComponent.getComponents();
        for (Component component : componentArray) {
            String string2;
            if (!(component instanceof JMenu)) continue;
            JMenu jMenu2 = (JMenu)component;
            Action action = jMenu2.getAction();
            if (action instanceof DummyAction) {
                string2 = ((DummyAction)action).getActionId();
                if (string2 != null && string2.equalsIgnoreCase(string)) {
                    jMenu = jMenu2;
                }
            } else if (action instanceof UserMenuAction && (string2 = ((UserMenuAction)action).getActionId()) != null && string2.equalsIgnoreCase(string)) {
                jMenu = jMenu2;
            }
            if (jMenu == null) {
                jMenu = this.findMenu(jMenu2.getPopupMenu(), string);
            }
            if (jMenu != null) break;
        }
        return jMenu;
    }

    private Vector<String> retrieveMenuLabelHierarchy(JComponent jComponent, String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = null;
        Component[] componentArray = jComponent instanceof JMenu ? ((JMenu)jComponent).getMenuComponents() : jComponent.getComponents();
        for (Component component : componentArray) {
            String string2;
            JMenuItem jMenuItem;
            Action action;
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                vector = this.getMenuLabelHierarchy(jMenu.getPopupMenu(), string);
                if (vector == null) continue;
                vector.add(0, jMenu.getText());
                break;
            }
            if (!(component instanceof JMenuItem) || !((action = (jMenuItem = (JMenuItem)component).getAction()) instanceof SpssAction) || (string2 = ((SpssAction)action).getActionId()) == null || !string2.equalsIgnoreCase(string)) continue;
            vector = new Vector();
            vector.add(jMenuItem.getText());
            break;
        }
        return vector;
    }

    private void checkFolders(File file) {
        File[] fileArray;
        block0: for (File file2 : fileArray = file.listFiles()) {
            File[] fileArray2;
            if (!file2.isDirectory()) continue;
            for (File file3 : fileArray2 = file2.listFiles(new XmlFilter())) {
                if (!this.isCLEF(file3)) continue;
                this.processCLEFCommands(file3);
                continue block0;
            }
        }
    }

    private void scanCFPath(boolean bl) {
        long l = System.currentTimeMillis();
        if (bl) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CommandExecutor.this.doCFPathScan();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommandExecutor.this.addCFMenuItems();
                        }
                    });
                }
            }, "CF Load Thread").start();
        } else {
            this.doCFPathScan();
        }
        long l2 = System.currentTimeMillis();
        TraceSettings.trace1((String)String.format("Time to load CF extensions: %d", l2 - l), (int)16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCFMenuItems() {
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            JMenuBar jMenuBar = spssFrame.getJMenuBar();
            Object object = this.LOCK_MENU_ITEMS;
            synchronized (object) {
                for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                    if (!(menuItemContainer.getAction() instanceof CFCommandAction)) continue;
                    this.doAddMenuItem(jMenuBar, menuItemContainer, spssFrame, true);
                }
            }
        }
    }

    private void doCFPathScan() {
        String string = System.getProperty("common_deployment.home");
        if (string != null && string.length() > 0) {
            File file = new File(string + File.separator + EXT_FOLDER_PATH);
            if (file.exists()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    if (!file2.isDirectory()) continue;
                    FrameworkMgr.get().loadModules(file2);
                    TraceSettings.trace1((String)(file2.getAbsolutePath() + ": loadModule XML"), (int)16);
                }
                for (File file2 : fileArray) {
                    if (!file2.isDirectory()) continue;
                    FrameworkMgr.get().loadExtensions(file2);
                    TraceSettings.trace1((String)(file2.getAbsolutePath() + ": Extension XML"), (int)16);
                }
            }
            this.scanCDBDlgPath();
        } else {
            TraceSettings.trace1((String)"System.getProperty( \"common_deployment.home\" ) doesn't exist!!!!", (int)16);
        }
    }

    private void scanCDBDlgPath() {
        String string;
        String[] stringArray;
        for (String string2 : stringArray = CommandExecutor.getSecondaryExtensionFolders()) {
            this.processCDBDlg(string2);
        }
        String string3 = CommandExecutor.getAppdataCustomDialogDirectoryForAllUsers();
        if (string3 != null) {
            this.processCDBDlg(string3);
        }
        if ((string = CommandExecutor.getAppdataCustomDialogDirectory()) != null) {
            for (String string4 : stringArray) {
                if (!string4.equals(string)) continue;
                return;
            }
            this.processCDBDlg(string);
        }
    }

    private void processCDBDlg(String string) {
        String string2 = string + File.separator + "spss.enhanced";
        File file = new File(string2);
        if (file.exists()) {
            FrameworkMgr.get().loadExtensions(file, true);
            TraceSettings.trace1((String)(file.getAbsolutePath() + ": Extension XML"), (int)16);
        }
    }

    private boolean isCLEF(File file) {
        return SpecificationBuilder.isCLEF((File)file);
    }

    private void processCLEFCommands(File file) {
        Document document = this.buildDOM(file);
        if (document != null) {
            this.traverse(document, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDOM(File file) {
        Document document = null;
        FileInputStream fileInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            fileInputStream = new FileInputStream(file);
            document = documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return document;
    }

    private void traverse(Document document, File file) {
        Node node = document.getFirstChild();
        if (node.getNodeName().equals("Extension")) {
            String string = file.getParentFile().getPath();
            Element element = DomUtil.getElementByName((Node)node, (String)"Resources", (boolean)false);
            this.mProperties = element != null ? SpecificationBuilder.extractResources((Element)element, (String)string) : new Properties();
            Element element2 = DomUtil.getElementByName((Node)node, (String)"UserInterface", (boolean)false);
            if (element2 != null) {
                this.processUINode(element2, file);
            }
            this.mProperties = null;
        }
    }

    private void processUINode(Element element, File file) {
        Element element2 = DomUtil.getElementByName((Node)element, (String)"MenuItem", (boolean)true);
        if (element2 != null) {
            String string = element2.getAttribute("action");
            if ("".equals(string)) {
                return;
            }
            boolean bl = element2.getAttribute("showIcon").equals("true");
            String string2 = element2.getAttribute("showLabel");
            boolean bl2 = "".equals(string2) || string2.equals("true");
            Element element3 = DomUtil.getElementByNameAndAttribute((Node)element.getOwnerDocument(), (String)"Action", (String)"id", (String)string);
            String string3 = this.getLabel(element3);
            String string4 = this.getDescription(element3);
            Icon icon = this.getIcon(element3, file);
            Element element4 = DomUtil.getElementByName((Node)element.getParentNode(), (String)"Node", (boolean)false);
            if (element4 == null) {
                return;
            }
            String string5 = element4.getAttribute("id");
            if (this.hasAction(string5)) {
                return;
            }
            CustomCommandAction customCommandAction = new CustomCommandAction(string5, file);
            if (bl2 && !"".equals(string3)) {
                customCommandAction.setName(string3);
            }
            if (!"".equals(string4)) {
                customCommandAction.setTooltip(string4);
            }
            if (bl && icon != null) {
                customCommandAction.setIcon(icon);
            }
            ActionCatalog.getActionCatalog().registerAction(customCommandAction);
            this.setupMenuItem(element2, customCommandAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAction(String string) {
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            for (MenuItemContainer menuItemContainer : this.mMenuItems) {
                if (!menuItemContainer.getAction().getActionId().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMenuItem(Element element, CustomCommandAction customCommandAction) {
        String string = element.getAttribute("spssMenu");
        String string2 = element.getAttribute("offset");
        boolean bl = element.getAttribute("separatorBefore").equals("true");
        boolean bl2 = element.getAttribute("separatorAfter").equals("true");
        String string3 = element.getAttribute("previousId");
        String string4 = element.getAttribute("actionIDToName");
        String string5 = element.getAttribute("installToGlobalCustomMenu");
        boolean bl3 = string5 != null ? string5.equalsIgnoreCase("true") : false;
        MenuItemContainer menuItemContainer = new MenuItemContainer(customCommandAction, string, string2, bl, bl2, string3, string4, bl3);
        Object object = this.LOCK_MENU_ITEMS;
        synchronized (object) {
            this.mMenuItems.add(menuItemContainer);
        }
    }

    private String getLabel(Element element) {
        String string = null;
        String string2 = element.getAttribute("labelKey");
        if (string2.length() > 0) {
            string = this.mProperties.getProperty(string2);
        }
        if (string == null) {
            string = element.getAttribute("label");
        }
        return string;
    }

    private String getDescription(Element element) {
        String string = null;
        String string2 = element.getAttribute("descriptionKey");
        if (string2.length() > 0) {
            string = this.mProperties.getProperty(string2);
        }
        if (string == null) {
            string = element.getAttribute("description");
        }
        return string;
    }

    private Icon getIcon(Element element, File file) {
        ImageIcon imageIcon = null;
        String string = null;
        String string2 = element.getAttribute("imagePathKey");
        if (string2.length() > 0) {
            string = this.mProperties.getProperty(string2);
        }
        if (string == null) {
            string = element.getAttribute("imagePath");
        }
        if (!"".equals(string)) {
            String string3;
            File file2;
            if (string.contains(File.separator)) {
                int n = string.lastIndexOf(File.separator);
                string = string.substring(n + 1);
            }
            if ((file2 = new File(string3 = file.getParentFile().getPath() + File.separator + string)).exists() && !file2.isDirectory()) {
                imageIcon = new ImageIcon(string3);
            }
        }
        return imageIcon;
    }

    private CommandExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionsMenuItems(JMenuBar jMenuBar) {
        Object object = this.LOCK_EXTENSIONS_MENU_ITEMS;
        synchronized (object) {
            if (this.mExtensionsMenuItems.isEmpty()) {
                return;
            }
            JMenu jMenu = this.findMenu(jMenuBar, "Extensions");
            if (null == jMenu) {
                return;
            }
            int n = jMenu.getMenuComponentCount();
            jMenu.getPopupMenu().insert(new SpssCustomSeparator(), n++);
            this.addUserMenuItems(jMenu, "Extensions", this.mExtensionsMenuItems);
            this.mExtensionsMenuItems.clear();
        }
    }

    private void addUserMenuItems(JMenu jMenu, String string, List<MenuItemContainer> list) {
        String string2;
        MenuItemContainer menuItemContainer22;
        TreeMap<Integer, MenuItemContainer> treeMap = new TreeMap<Integer, MenuItemContainer>();
        for (MenuItemContainer menuItemContainer22 : list) {
            if (menuItemContainer22.getOffset().length() == 0 || (string2 = this.getMenuId(menuItemContainer22)) == null || !string2.equals(string)) continue;
            treeMap.put(Integer.valueOf(menuItemContainer22.getOffset()), menuItemContainer22);
        }
        menuItemContainer22 = null;
        for (Map.Entry object : treeMap.entrySet()) {
            menuItemContainer22 = (MenuItemContainer)object.getValue();
            int n = Integer.valueOf(menuItemContainer22.getOffset());
            if (menuItemContainer22.isSepBefore()) {
                jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer22), n++);
            }
            jMenu.insert(menuItemContainer22.getAction(), n++);
            if (!menuItemContainer22.isSepAfter()) continue;
            jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer22), n++);
        }
        int n = jMenu.getMenuComponentCount();
        for (MenuItemContainer menuItemContainer : list) {
            string2 = this.getMenuId(menuItemContainer);
            if (string2 != null && string2.equals(string) && menuItemContainer.getOffset().length() != 0) continue;
            if (menuItemContainer.isSepBefore()) {
                jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer22), n++);
            }
            jMenu.insert(menuItemContainer.getAction(), n++);
            if (!menuItemContainer.isSepAfter()) continue;
            jMenu.getPopupMenu().insert(new SpssCustomSeparator(menuItemContainer22), n++);
        }
    }

    public static class MenuItemContainer {
        private CommandAction mAction;
        private String mSpssMenu;
        private boolean mSepBefore;
        private boolean mSepAfter;
        private String mOffset;
        private String mPreviousMenuId;
        private CommandLocation.InstallToFrame mInstallToFrame;
        private Integer mVersion;
        private boolean mIsSpssNative;
        public HashMap<String, String> mCFMenuActionIDToNameMap = new HashMap();
        private boolean mInstallToGlobalCustomMenu = false;

        public MenuItemContainer(CommandAction commandAction, String string, String string2, boolean bl, boolean bl2) {
            this.mAction = commandAction;
            this.mSpssMenu = string;
            this.mOffset = string2;
            this.mSepBefore = bl;
            this.mSepAfter = bl2;
            this.mPreviousMenuId = "";
            this.mIsSpssNative = true;
            this.mCFMenuActionIDToNameMap = new HashMap();
        }

        public MenuItemContainer(CommandAction commandAction, String string, String string2, boolean bl, boolean bl2, CommandLocation.InstallToFrame installToFrame, Integer n, String string3, String string4, boolean bl3) {
            this.mAction = commandAction;
            this.mSpssMenu = string;
            this.mOffset = string2;
            this.mSepBefore = bl;
            this.mSepAfter = bl2;
            this.mPreviousMenuId = string3;
            this.mInstallToFrame = installToFrame;
            this.mVersion = n;
            this.mIsSpssNative = true;
            if (string4 != null && string4.length() > 0) {
                this.mCFMenuActionIDToNameMap = CommandLocation.createMenuActionIDToNameMap((String)string4);
            }
            this.mInstallToGlobalCustomMenu = bl3;
        }

        public MenuItemContainer(CommandAction commandAction, CommandLocation commandLocation) {
            this.mAction = commandAction;
            this.mSpssMenu = commandLocation.getCommandPath();
            this.mOffset = "" + commandLocation.getMenuItemOffset();
            this.mSepBefore = commandLocation.getSeparator() == CommandLocation.CommandSeparator.above || commandLocation.getSeparator() == CommandLocation.CommandSeparator.both;
            this.mSepAfter = commandLocation.getSeparator() == CommandLocation.CommandSeparator.below || commandLocation.getSeparator() == CommandLocation.CommandSeparator.both;
            this.mPreviousMenuId = "";
            this.mPreviousMenuId = commandLocation.getPreviousItemActionId();
            this.mInstallToFrame = commandLocation.getInstallToFrame();
            this.mVersion = commandLocation.getVersionNumber();
            this.mIsSpssNative = true;
            this.mCFMenuActionIDToNameMap = commandLocation.getMenuActionIDToNameMap();
            this.mInstallToGlobalCustomMenu = commandLocation.mInstallToGlobalCustomMenu;
        }

        public MenuItemContainer(CommandAction commandAction, String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3) {
            this.mAction = commandAction;
            this.mSpssMenu = string;
            this.mOffset = string2;
            this.mSepBefore = bl;
            this.mSepAfter = bl2;
            this.mPreviousMenuId = "";
            this.mPreviousMenuId = string3;
            this.mVersion = null;
            this.mIsSpssNative = true;
            if (string4 != null && string4.length() > 0) {
                this.mCFMenuActionIDToNameMap = CommandLocation.createMenuActionIDToNameMap((String)string4);
            }
            this.mInstallToGlobalCustomMenu = bl3;
        }

        public CommandAction getAction() {
            return this.mAction;
        }

        public String getOffset() {
            return this.mOffset;
        }

        public boolean isSepAfter() {
            return this.mSepAfter;
        }

        public boolean isSepBefore() {
            return this.mSepBefore;
        }

        public String getSpssMenu() {
            return this.mSpssMenu;
        }

        public String getPreviousMenuId() {
            return this.mPreviousMenuId;
        }

        public CommandLocation.InstallToFrame getInstallToFrame() {
            return this.mInstallToFrame;
        }

        public void setInstallToFrame(CommandLocation.InstallToFrame installToFrame) {
            this.mInstallToFrame = installToFrame;
        }

        public Integer getVersion() {
            return this.mVersion;
        }

        public void setVersion(Integer n) {
            this.mVersion = n;
        }

        public boolean isSpssNative() {
            return this.mIsSpssNative;
        }

        public void setIsSpssNative(boolean bl) {
            this.mIsSpssNative = bl;
        }

        public String getNameForActionID(String string) {
            return this.mCFMenuActionIDToNameMap.get(string);
        }
    }

    static class XmlFilter
    implements FilenameFilter {
        XmlFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toUpperCase().endsWith(".XML");
        }
    }

    public class SpssCustomSeparator
    extends JPopupMenu.Separator {
        private MenuItemContainer mMenuItemContainer = null;

        public SpssCustomSeparator() {
        }

        public SpssCustomSeparator(MenuItemContainer menuItemContainer) {
            this.mMenuItemContainer = menuItemContainer;
        }

        public MenuItemContainer getParentMenuItemContainer() {
            return this.mMenuItemContainer;
        }
    }
}

