/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.syntax_generator;

import com.pasw.core.condition.ConditionOperators;
import com.pasw.core.extension.SpecificationElement;
import com.pasw.core.extension.feature.FeatureImpl;
import com.pasw.core.extension.runtime.FrameworkAction;
import com.pasw.core.extension.specification.AbstractSpecificationElement;
import com.pasw.core.property.PropertySetProvider;
import com.pasw.core.property.descriptor.DateProperty;
import com.pasw.core.property.descriptor.DefaultStructure;
import com.pasw.core.property.descriptor.DoubleProperty;
import com.pasw.core.property.descriptor.EncryptedStringProperty;
import com.pasw.core.property.descriptor.EnumProperty;
import com.pasw.core.property.descriptor.EnumSetProperty;
import com.pasw.core.property.descriptor.IntegerProperty;
import com.pasw.core.property.descriptor.StringProperty;
import com.pasw.core.property.descriptor.StructureListProperty;
import com.pasw.framework.common.core.CFEnum;
import com.pasw.framework.common.core.Properties;
import com.pasw.framework.common.core.ResourceProvider;
import com.pasw.framework.common.core.Structure;
import com.pasw.framework.common.core.StructureDefinition;
import com.pasw.framework.common.core.ValueDescriptor;
import com.pasw.framework.common.core.ValueType;
import com.pasw.framework.common.extension.ExtensionManager;
import com.pasw.framework.common.extension.ExtensionObject;
import com.pasw.framework.common.extension.Feature;
import com.pasw.framework.common.extension.XMLElement;
import com.pasw.framework.ui.swing.SwingResourceProvider;
import com.pasw.ui.common.FeatureUI;
import com.pasw.ui.common.FrameworkUISupportImpl;
import com.pasw.ui.common.control.Control;
import com.pasw.ui.swing.common.SimpleFileFilter;
import com.pasw.ui.swing.common.effect.EffectHelper;
import com.pasw.ui.swing.control.ClientFileChooserControl;
import com.pasw.ui.swing.control.ColorPickerButtonControl;
import com.pasw.ui.swing.control.ComboBoxEnumControl;
import com.pasw.ui.swing.control.CustomSwingControl;
import com.pasw.ui.swing.control.DatasetSelectorControl;
import com.pasw.ui.swing.control.ListBoxEnumSetControl;
import com.pasw.ui.swing.control.PasswordBoxControl;
import com.pasw.ui.swing.control.ServerFileChooserControl;
import com.pasw.ui.swing.control.SingleFieldValueChooserControl;
import com.pasw.ui.swing.control.StructureMapTableControl;
import com.pasw.ui.swing.control.TextBoxControl;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.cf_integration.instance.CFSession;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class CFSyntaxGenerator {
    static String sLabelEscapeStart = "%^";
    static String sLabelEscapeEnd = "^%";
    static String sActiveDatasetName = "%+ACTIVE_DATASET+%";
    static String sUniqueDatasetName = "%@UNIQUE_DATASET_NAME@%";
    static String sTempFileName = "%+TEMPFILE+%";
    static String sSyntaxGeneration = "SyntaxGeneration";
    static String sSyntaxTemplate = "syntaxTemplate";
    static String sSyntaxProperty = "SyntaxProperty";
    static String sSyntaxItem = "SyntaxItem";
    static String sSyntaxCondition = "SyntaxCondition";
    static String sProperty = "property";
    static String sCondition = "condition";
    static String sOperand = "operand";
    static String sName = "name";
    static String sDelimiter = "delimiter";
    static String sQuoteType = "quoteType";
    static String sExteriorQuote = "exteriorQuotes";
    static String sSyntax = "syntax";
    static String sSyntax_off = "syntax_off";
    static String sIsMeasureDiscrete = "isMeasureDiscrete";
    static String sIsMeasureContinuous = "isMeasureContinuous";
    static String sIsStorageString = "isStorageString";
    static String sIsStorageNumeric = "isStorageNumeric";
    static String sOrCondition = "Or";
    static String sAndCondition = "And";
    static String sGetFromResource = ".properties";
    static String sMathMultiply = "%@MULTIPLY@%";
    static String sForEachVar = ".FOR_EACH_VAR";
    static String sSyntaxGenerationCommand = "SyntaxGenerationCommand";
    static String sInputContainer = "inputContainer";
    static String sFallbackAction = "fallbackAction";
    static String sEmptySyntaxError = "emptySyntaxError";
    static String sNoTransMesg = "No transformations or role changes were requested.";
    static String sNameDataset = "%+NAME_DATASET+%";
    static String sNameDatasetSyntax = "DATASET NAME %+ACTIVE_DATASET+%.\n";
    static String sRepeated = "@@REPEATED@@";
    static String sRepeatedSyntax = "@@REPEATED_COMMAND@@";
    static String sNoRepeat = "##NOREPEAT##";
    static String sEquals = "equals";
    static String sNotEquals = "notEquals";
    static String sPeer = "$$PEER$$";
    private Vector<SpecificationElement> mSyntaxProperties;
    private Vector<String> mPropertyNames;
    private Vector<SpecificationElement> mSyntaxItems;
    private Vector<String> mSyntaxItemNames;
    private Properties mPropertyValues;
    private String mSyntaxTemplate = "";
    private Hashtable<String, Boolean> mPropertyStatus = new Hashtable();
    private Hashtable<String, Vector<String>> mPropertyKeyValues = new Hashtable();
    private String mTempFileName = null;
    private FeatureUI mFeatureUI;
    private boolean mHasInifinite;
    private String mActiveDatasetName = null;
    private String mNextUniqDatasetName = null;
    private Feature mFeature;
    private ResourceProvider mResourceProvider = null;
    private AbstractSpecificationElement mSyntaxCommand;
    private DecimalFormat mDoubleFormat = new DecimalFormat("###.###############", new DecimalFormatSymbols(Locale.US));
    private boolean mIsBackEndSyntaxOK;
    private Hashtable<String, String> mDelimiters = null;
    private Hashtable<String, String> mQuoteType = null;
    private Hashtable<String, String> mExteriorQuote = null;
    private Hashtable<String, String> mRepositorySyntax = new Hashtable();
    private Hashtable<String, Hashtable<String, Vector<String>>> mRandomEffectSyntax = null;
    private Hashtable<String, Vector<Pair<String, String>>> mSubCommands = new Hashtable();
    private Hashtable<String, Hashtable<String, String>> mSyntaxPropertyValue = new Hashtable();
    private Hashtable<String, String> mSyntaxItemAndStructName = new Hashtable();

    public CFSyntaxGenerator(Feature feature, FeatureUI featureUI) {
        Object object;
        Properties properties;
        XMLElement xMLElement;
        this.mSyntaxProperties = new Vector();
        this.mSyntaxItems = new Vector();
        this.mPropertyNames = new Vector();
        this.mSyntaxItemNames = new Vector();
        this.mDelimiters = new Hashtable();
        this.mQuoteType = new Hashtable();
        this.mExteriorQuote = new Hashtable();
        this.mFeatureUI = featureUI;
        this.mFeature = feature;
        this.mSyntaxCommand = null;
        this.mSyntaxTemplate = "";
        this.mIsBackEndSyntaxOK = true;
        ExtensionManager extensionManager = feature.getSession().getApplication().getFrameworkApplicationSupport().getExtensionManager();
        XMLElement xMLElement2 = extensionManager.getExtensionObjectDescriptor((ExtensionObject)feature).getAppDetails();
        Iterator iterator = xMLElement2.getChildElements(sSyntaxGeneration);
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                xMLElement = (XMLElement)iterator.next();
                if (!(xMLElement instanceof PropertySetProvider)) continue;
                properties = ((PropertySetProvider)xMLElement).getProperties();
                object = properties.getProperty(sSyntaxTemplate);
                if (object != null) {
                    this.mSyntaxTemplate = object.toString();
                }
                iterator2 = xMLElement.getChildElements(sSyntaxProperty);
                iterator3 = xMLElement.getChildElements(sSyntaxItem);
                iterator4 = xMLElement.getChildElements(sSyntaxGenerationCommand);
                break;
            }
        }
        while (iterator2 != null && iterator2.hasNext()) {
            Object object2;
            Object object3;
            xMLElement = (AbstractSpecificationElement)iterator2.next();
            properties = xMLElement.getProperties();
            object = properties.getProperty(sName);
            if (object == null) continue;
            this.mPropertyNames.add(object.toString());
            Object object4 = properties.getProperty(sDelimiter);
            if (object4 != null) {
                this.mDelimiters.put(object.toString(), object4.toString());
            }
            if ((object3 = properties.getProperty(sQuoteType)) != null) {
                this.mQuoteType.put(object.toString(), object3.toString());
            }
            if ((object2 = properties.getProperty(sExteriorQuote)) != null) {
                String string = "\"";
                if (object2.toString().equals("&apos;") || object2.toString().equals("'")) {
                    string = "'";
                }
                this.mExteriorQuote.put(object.toString(), string);
            }
            this.mSyntaxProperties.add((SpecificationElement)xMLElement);
        }
        while (iterator3 != null && iterator3.hasNext()) {
            xMLElement = (AbstractSpecificationElement)iterator3.next();
            properties = xMLElement.getProperties();
            object = properties.getProperty(sName);
            if (object == null) continue;
            this.mSyntaxItemNames.add(object.toString());
            this.mSyntaxItems.add((SpecificationElement)xMLElement);
        }
        if (iterator4 != null && iterator4.hasNext()) {
            this.mSyntaxCommand = (AbstractSpecificationElement)iterator4.next();
        }
        this.mHasInifinite = this.hasInfiniteReference();
    }

    public void updateProperty(Properties properties) {
        this.mPropertyValues = properties;
    }

    public String generateSyntax() {
        String string;
        if (this.mSyntaxProperties == null || this.mPropertyValues == null || this.mSyntaxTemplate == null || this.mSyntaxTemplate.length() == 0) {
            return "";
        }
        if (this.mHasInifinite) {
            return "";
        }
        StringBuffer stringBuffer = this.parse("", this.mSyntaxTemplate);
        if (!this.mIsBackEndSyntaxOK) {
            return "";
        }
        int n = stringBuffer.lastIndexOf(".");
        if (n > 0 && CharacterUtil.rightTrim((String)(string = stringBuffer.subSequence(n + 1, stringBuffer.length()).toString())).length() == 0) {
            char c = stringBuffer.charAt(n - 1);
            while (n > 0 && Character.isWhitespace(c) && --n != 0) {
                c = stringBuffer.charAt(n - 1);
            }
            stringBuffer.replace(n, stringBuffer.length(), ".");
        }
        string = "";
        String[] stringArray = stringBuffer.toString().split("\n");
        if (stringArray.length == 1) {
            stringArray = stringBuffer.toString().split("\\\\n");
        }
        for (String string2 : stringArray) {
            if (CharacterUtil.rightTrim((String)string2).length() == 0) continue;
            string = string + string2 + "\n";
        }
        if (!CharacterUtil.rightTrim((String)string).endsWith(".")) {
            string = CharacterUtil.rightTrim((String)string) + ".\n";
        }
        string = this.replaceUnquotedNewlineEscapes(string);
        Collection<String> collection = this.mRepositorySyntax.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            string = string + string3;
        }
        return string;
    }

    private StringBuffer parse(String string, String string2) {
        int n = 0;
        String string3 = DialogDefinition.getEscapeSequence();
        String string4 = DialogDefinition.getSelfValue();
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer(string2);
        boolean bl = false;
        String string5 = "";
        while (n > -1) {
            boolean bl2 = false;
            boolean bl3 = false;
            String string6 = "";
            String string7 = "";
            if ((n = stringBuffer.indexOf(string3, n)) > -1) {
                Object object;
                int n3 = stringBuffer.indexOf(string3, n + 1);
                if (n3 == -1) {
                    n3 = stringBuffer.length();
                }
                if (n3 < n + n2) {
                    return new StringBuffer("");
                }
                String string8 = stringBuffer.subSequence(n + n2, n3).toString();
                if (string.length() > 0 && string4.equalsIgnoreCase(string3 + string8 + string3)) {
                    object = this.getControlValue(string);
                    string7 = object != null ? this.propertyValueToString(string, object) : "";
                    bl2 = true;
                } else {
                    object = this.getControlValue(string8);
                    if (this.mSyntaxItemNames.contains(string8)) {
                        string6 = this.getSyntaxValueFromSyntaxItems(string8);
                        CDBControlType cDBControlType = this.getCDBControlTypeForStringType(string8);
                        if (cDBControlType == CDBControlType.StringUnknown) {
                            string6 = this.correctForEmptySyntax(object, string6);
                        }
                        bl2 = true;
                        bl3 = true;
                    } else if (this.mPropertyNames.contains(string8)) {
                        string6 = this.getSyntaxValueFromSyntaxProperties(string8, object);
                        bl2 = true;
                    } else {
                        String string9 = this.isRepeatedSyntax(string8);
                        if (string9.length() > 0) {
                            string6 = this.getSyntaxValueFromSyntaxItems(string9);
                            string6 = this.setupSyntaxCommandAndProperyTable(string6, string8);
                            bl2 = true;
                            bl3 = true;
                            bl = true;
                        }
                    }
                    if (!bl2) {
                        n = n3 + n2;
                    } else if (string6.startsWith(sLabelEscapeStart) && string6.endsWith(sLabelEscapeEnd)) {
                        string7 = this.getVariableLabelReplacement(string6);
                    } else if (string4.equalsIgnoreCase(string6)) {
                        string7 = this.propertyValueToString(string8, object);
                    } else {
                        int n4 = string6.indexOf(string3);
                        if (n4 > -1) {
                            if (bl3) {
                                if (bl) {
                                    string5 = string6.substring(0, n4);
                                }
                                string7 = this.parse("", string6).toString();
                            } else {
                                string7 = this.parse(string8, string6).toString();
                            }
                        } else {
                            string7 = string6;
                        }
                    }
                }
                if (bl2) {
                    boolean bl4;
                    if (bl) {
                        object = this.mSyntaxItemAndStructName.get(string8);
                        if (object == null || object != null && ((String)object).length() == 0) {
                            object = string8;
                        }
                        string7 = this.handleRepeatedCommand((String)object, string5);
                    } else {
                        string7 = this.doMath(string7);
                    }
                    if (string7.length() > 0 && string7.charAt(string7.length() - 1) == '=') {
                        string7 = "";
                    }
                    if (bl4 = this.isFileChooserControl(string8)) {
                        if (n - 1 >= 0 && n3 + n2 < stringBuffer.length() && string7.length() > 0 && string7.charAt(0) == '\'' && stringBuffer.charAt(n - 1) == '\'' && stringBuffer.charAt(n3 + n2) == '\'') {
                            stringBuffer.replace(n - 1, n3 + n2 + 1, string7);
                        } else if (string7.length() <= 0) {
                            stringBuffer.setLength(1);
                            stringBuffer.replace(0, 1, " ");
                        } else {
                            stringBuffer.replace(n, n3 + n2, string7);
                        }
                    } else {
                        stringBuffer.replace(n, n3 + n2, string7);
                    }
                    if (string7.length() == 0 && (n += string7.length()) < stringBuffer.length() && stringBuffer.charAt(n) == ' ') {
                        stringBuffer.replace(n, n + 1, "");
                    }
                }
            }
            bl = false;
        }
        if (stringBuffer.indexOf(sActiveDatasetName) > -1 || stringBuffer.indexOf(sUniqueDatasetName) > -1 || stringBuffer.indexOf(sTempFileName) > -1) {
            stringBuffer = new StringBuffer(this.replaceDataSetName(stringBuffer));
        } else if (stringBuffer.indexOf(sForEachVar) == 0) {
            stringBuffer = new StringBuffer(this.handleStructureTable(stringBuffer));
        }
        return stringBuffer;
    }

    private String correctForEmptySyntax(Object object, String string) {
        String[] stringArray = object.toString().split(DialogDefinition.getSelfValue());
        String string2 = string;
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
            }
            if (stringBuffer.toString().trim().equalsIgnoreCase(string.trim())) {
                string2 = "";
            }
        }
        return string2;
    }

    boolean isFileChooserControl(String string) {
        boolean bl = false;
        Control control = this.mFeatureUI.getControlManager().getControl(string);
        if (control != null && (control instanceof ServerFileChooserControl || control instanceof ClientFileChooserControl)) {
            bl = true;
        }
        return bl;
    }

    private String handleStructureTable(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return stringBuffer.toString();
        }
        String string = stringBuffer.toString();
        int n = sForEachVar.length();
        int n2 = stringBuffer.indexOf(sForEachVar);
        int n3 = stringBuffer.lastIndexOf(sForEachVar);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string2 = "@@REPLACED@@";
        int n4 = 1;
        int n5 = 0;
        String string3 = stringBuffer.toString();
        Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
        if (n2 == 0 && n3 + n == stringBuffer.length()) {
            StringBuffer stringBuffer2 = new StringBuffer(string3);
            stringBuffer2 = stringBuffer2.replace(0, n, "");
            n3 = stringBuffer2.lastIndexOf(sForEachVar);
            stringBuffer2 = stringBuffer2.replace(n3, n3 + n, "");
            string3 = stringBuffer2.toString();
            int n6 = string3.indexOf(91);
            int n7 = string3.indexOf(93);
            while (n6 != -1 && n7 != -1) {
                String string4 = stringBuffer2.substring(n6 + 1, n7);
                if (string4.length() > 0) {
                    String string5 = string2 + "_" + n4;
                    hashtable.put(string5, this.getTokenValues(string4, ","));
                    ++n4;
                    stringBuffer2.replace(n6, n7 + 1, string5);
                    string3 = stringBuffer2.toString();
                }
                n6 = string3.indexOf(91);
                n7 = string3.indexOf(93);
            }
            if (hashtable.size() > 0) {
                string = "";
                n5 = ((Vector)hashtable.get(string2 + "_" + 1)).size();
                int n8 = string2.length() + 2;
                for (int i = 0; i < n5; ++i) {
                    StringBuffer stringBuffer3 = new StringBuffer(stringBuffer2);
                    for (int j = 1; j < n4; ++j) {
                        String string6 = string2 + "_" + j;
                        Vector vector3 = (Vector)hashtable.get(string6);
                        int n9 = stringBuffer3.indexOf(string6);
                        stringBuffer3 = stringBuffer3.replace(n9, n9 + n8, (String)vector3.get(i));
                    }
                    string = string + stringBuffer3 + " ";
                }
            }
        }
        return string;
    }

    private Vector<String> getTokenValues(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    private String replaceDataSetName(StringBuffer stringBuffer) {
        CharSequence charSequence;
        String string = stringBuffer.toString();
        int n = stringBuffer.indexOf(sNameDataset);
        if (n > -1) {
            charSequence = "";
            if (!this.isCurrentDatasetNamed()) {
                charSequence = sNameDatasetSyntax;
            }
            string = stringBuffer.replace(n, n + sNameDataset.length(), (String)charSequence).toString();
            StringBuffer stringBuffer2 = new StringBuffer(string);
            while ((n = stringBuffer2.indexOf(sNameDataset)) > -1) {
                string = stringBuffer2.replace(n, n + sNameDataset.length(), (String)charSequence).toString();
                stringBuffer2 = new StringBuffer(string);
            }
        }
        if ((n = stringBuffer.indexOf(sActiveDatasetName)) > -1) {
            if (this.mActiveDatasetName == null) {
                this.mActiveDatasetName = this.getActiveDatasetName();
            }
            string = stringBuffer.replace(n, n + sActiveDatasetName.length(), this.mActiveDatasetName).toString();
            charSequence = new StringBuffer(string);
            while ((n = ((StringBuffer)charSequence).indexOf(sActiveDatasetName)) > -1) {
                string = ((StringBuffer)charSequence).replace(n, n + sActiveDatasetName.length(), this.mActiveDatasetName).toString();
                charSequence = new StringBuffer(string);
            }
        }
        if ((n = string.indexOf(sUniqueDatasetName)) > -1) {
            if (this.mNextUniqDatasetName == null) {
                this.mNextUniqDatasetName = this.getNextUniqueDataSetName();
            }
            charSequence = new StringBuffer(string);
            while ((n = ((StringBuffer)charSequence).indexOf(sUniqueDatasetName)) > -1) {
                string = ((StringBuffer)charSequence).replace(n, n + sUniqueDatasetName.length(), this.mNextUniqDatasetName).toString();
                charSequence = new StringBuffer(string);
            }
        }
        if ((n = string.indexOf(sTempFileName)) > -1) {
            if (this.mTempFileName == null) {
                this.mTempFileName = this.getOutfileLocation() + "spss" + this.mFeature.getExtensionObjectID() + ".tmp";
            }
            charSequence = new StringBuffer(string);
            while ((n = ((StringBuffer)charSequence).indexOf(sTempFileName)) > -1) {
                string = ((StringBuffer)charSequence).replace(n, n + sTempFileName.length(), this.mTempFileName).toString();
                charSequence = new StringBuffer(string);
            }
        }
        return string;
    }

    private String getSyntaxValueFromSyntaxProperties(String string, Object object) {
        String string2 = string;
        for (SpecificationElement specificationElement : this.mSyntaxProperties) {
            Properties properties = ((AbstractSpecificationElement)specificationElement).getProperties();
            String string3 = properties.getProperty(sName).toString();
            if (!string3.equals(string)) continue;
            Iterator iterator = specificationElement.getChildElements(sSyntaxCondition);
            if (iterator == null || !iterator.hasNext()) {
                string2 = properties.getProperty(sSyntax).toString();
                if (object == null) {
                    return string2;
                }
                if (object instanceof Boolean) {
                    Boolean bl = (Boolean)object;
                    if (!bl.booleanValue()) {
                        Object object2 = properties.getProperty(sSyntax_off);
                        string2 = object2 != null ? object2.toString() : "";
                    }
                } else if (string2.equals(DialogDefinition.getSelfValue())) {
                    return this.propertyValueToString(string3, object);
                }
                return string2;
            }
            return this.getSyntaxWithCondition(string, object);
        }
        return string2;
    }

    private boolean isPropertyTargetField(String string) {
        return this.isPropertyTargetField(string, null);
    }

    private boolean isPropertyTargetField(String string, ValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            valueDescriptor = this.mFeature.getPropertyValueDescriptor(string);
        }
        return valueDescriptor != null && (valueDescriptor.getValueType() == ValueType.FIELD_NAME || valueDescriptor.getValueType() == ValueType.EFFECT_STRUCTURE || valueDescriptor.getValueType() == ValueType.STRUCTURE && valueDescriptor instanceof StructureListProperty);
    }

    private String getMultiSelectListBoxSyntax(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        String string3 = DialogDefinition.getSelfValue();
        if (this.mSyntaxItems == null || this.mSyntaxItems.size() == 0) {
            return string;
        }
        boolean bl = true;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (SpecificationElement object4 : this.mSyntaxItems) {
            int n;
            StringBuffer stringBuffer;
            int n2;
            Iterator iterator;
            Object object5;
            boolean objectArray = true;
            object3 = ((AbstractSpecificationElement)object4).getProperties();
            object2 = object3.getProperty(sName);
            if (object3.getProperty(sName) == null || !object2.toString().equals(string)) continue;
            Object n3 = object3.getProperty(sSyntax);
            if (n3 == null) {
                return "";
            }
            StringBuffer stringBuffer2 = new StringBuffer(n3.toString());
            int n4 = stringBuffer2.indexOf(sGetFromResource);
            if (n4 > 0) {
                return this.getResString(stringBuffer2.toString());
            }
            int n5 = stringBuffer2.indexOf(string3);
            if (n5 != -1) {
                stringBuffer2.replace(n5, n5 + string3.length(), "");
            }
            if ((object5 = object4.getChildElements(sAndCondition)) != null && object5.hasNext()) {
                objectArray = false;
                if (this.isConditionTrue((Iterator<XMLElement>)object5, false)) {
                    return this.replaceDataSetName(stringBuffer2);
                }
                bl = false;
            }
            if ((object = object4.getChildElements(sOrCondition)) != null && object.hasNext()) {
                objectArray = false;
                if (this.isConditionTrue((Iterator<XMLElement>)object, true)) {
                    return this.replaceDataSetName(stringBuffer2);
                }
                bl = false;
            }
            if ((iterator = object4.getChildElements(sSyntaxCondition)) == null || !iterator.hasNext()) continue;
            Properties properties = ((AbstractSpecificationElement)iterator.next()).getProperties();
            Object object6 = properties.getProperty(sCondition);
            Object object7 = properties.getProperty(sOperand);
            Object object8 = properties.getProperty(sProperty);
            if (object8 == null || object6 == null || object7 == null) {
                return "";
            }
            if (!this.mPropertyNames.contains(object8.toString())) {
                return "";
            }
            if (object6.toString().equals("isNotEmpty") && object7.toString().equals("true") && (n2 = (stringBuffer = new StringBuffer(n3.toString())).indexOf("%%")) >= 0 && (n = stringBuffer.indexOf("%%", n2 + 1)) > 0) {
                String string4 = stringBuffer.subSequence(n2 + 2, n).toString();
                String string5 = this.getMultiSelectListBoxSyntax(stringBuffer.subSequence(n2 + 2, n).toString(), string2);
                if (string5.length() == 0) {
                    return "";
                }
                return stringBuffer.toString().replace("%%" + string4 + "%%", string5);
            }
            if (!object8.equals(string2)) continue;
            hashtable.put(object7.toString(), stringBuffer2.toString());
        }
        Object object10 = this.mPropertyValues.getProperty(string2);
        if (object10 instanceof HashSet) {
            HashSet hashSet = (HashSet)object10;
            if (hashSet.size() == 0) {
                return "";
            }
            Object[] objectArray = hashSet.toArray();
            object3 = "";
            object2 = this.mDelimiters.get(string2);
            int n = 0;
            if (object2 == null) {
                object2 = " ";
            }
            for (Object object5 : objectArray) {
                object = (String)hashtable.get(object5.toString());
                if (object == null || ((String)object).length() == 0) continue;
                object3 = (String)object3 + (String)object;
                if (++n >= objectArray.length) continue;
                object3 = (String)object3 + (String)object2;
            }
            object10 = this.handleInteriorQuote(object3, string2);
        }
        return object10.toString();
    }

    private String getSyntaxValueFromSyntaxItems(String string) {
        String string2 = DialogDefinition.getSelfValue();
        if (this.mSyntaxItems == null || this.mSyntaxItems.size() == 0) {
            return string;
        }
        boolean bl = true;
        for (SpecificationElement specificationElement : this.mSyntaxItems) {
            Iterator iterator;
            Iterator iterator2;
            Iterator iterator3;
            boolean bl2 = true;
            Properties properties = ((AbstractSpecificationElement)specificationElement).getProperties();
            Object object = properties.getProperty(sName);
            if (properties.getProperty(sName) == null || !object.toString().equals(string)) continue;
            Object object2 = properties.getProperty(sSyntax);
            if (object2 == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(object2.toString());
            if (this.mSyntaxCommand != null && object2.toString().equals("%+" + sSyntaxGenerationCommand + "+%")) {
                return this.getSyntaxFromBackend();
            }
            int n = stringBuffer.indexOf(sGetFromResource);
            if (n > 0) {
                return this.getResString(stringBuffer.toString());
            }
            int n2 = stringBuffer.indexOf(string2);
            if (n2 != -1) {
                stringBuffer.replace(n2, n2 + string2.length(), "");
            }
            if ((iterator3 = specificationElement.getChildElements(sAndCondition)) != null && iterator3.hasNext()) {
                bl2 = false;
                if (this.isConditionTrue(iterator3, false)) {
                    return this.replaceDataSetName(stringBuffer);
                }
                bl = false;
            }
            if ((iterator2 = specificationElement.getChildElements(sOrCondition)) != null && iterator2.hasNext()) {
                bl2 = false;
                if (this.isConditionTrue(iterator2, true)) {
                    return this.replaceDataSetName(stringBuffer);
                }
                bl = false;
            }
            if ((iterator = specificationElement.getChildElements(sSyntaxCondition)) != null && iterator.hasNext()) {
                Properties properties2 = ((AbstractSpecificationElement)iterator.next()).getProperties();
                Object object3 = properties2.getProperty(sCondition);
                Object object4 = properties2.getProperty(sOperand);
                Object object5 = properties2.getProperty(sProperty);
                if (object5 == null || object3 == null || object4 == null) {
                    return "";
                }
                if (!this.mPropertyNames.contains(object5.toString())) {
                    return "";
                }
                String string3 = DialogDefinition.getEscapeSequence();
                int n3 = string3.length();
                int n4 = stringBuffer.indexOf(string3, 0);
                int n5 = -1;
                if (n4 > -1) {
                    n5 = stringBuffer.indexOf(string3, n4 + 1);
                }
                ValueDescriptor valueDescriptor = this.mFeature.getPropertyValueDescriptor(object5.toString());
                Object object6 = this.getControlValue(object5.toString());
                if (this.isMultiSelectListBox(object5.toString())) {
                    if (object3.equals("isNotEmpty")) {
                        if (object6 != null && object6.toString().length() > 0) {
                            return this.getMultiSelectListBoxSyntax(string, object5.toString());
                        }
                        bl = false;
                    } else {
                        return this.getMultiSelectListBoxSyntax(string, object5.toString());
                    }
                }
                if (this.isPropertyTargetField(object5.toString())) {
                    boolean bl3;
                    if (object3.equals("isNotEmpty") && !this.isFieldListNotEmpty(valueDescriptor, object6)) {
                        return "";
                    }
                    if (object3.equals("isEmpty")) {
                        if (this.isFieldListNotEmpty(valueDescriptor, object6)) {
                            return "";
                        }
                        return stringBuffer.toString();
                    }
                    boolean bl4 = bl3 = stringBuffer.indexOf(string3 + object5.toString() + string3) >= 0;
                    if (!bl3 && object3.equals("isMeasureContinuous")) {
                        if (this.isTargetVarScale(object6)) {
                            return stringBuffer.toString();
                        }
                        bl = false;
                        continue;
                    }
                    if (!bl3 && object3.equals("isMeasureDiscrete")) {
                        if (this.isTargetVarNominal(object6)) {
                            return stringBuffer.toString();
                        }
                        bl = false;
                        continue;
                    }
                    if (!bl3 && object3.equals(sIsStorageString)) {
                        if (this.isTargetVarString(object6)) {
                            return stringBuffer.toString();
                        }
                        bl = false;
                        continue;
                    }
                    Vector<String> vector = new Vector<String>();
                    String string4 = this.getTargetVarNames(object3.toString(), object5.toString(), object6, vector);
                    if (string4.trim().length() == 0) {
                        return "";
                    }
                    String string5 = stringBuffer.toString();
                    int n6 = string.indexOf(sForEachVar);
                    if (n4 > -1 && n5 > -1 && object5.toString().equalsIgnoreCase(stringBuffer.subSequence(n4 + n3, n5).toString())) {
                        if (n6 > 0 && vector.size() > 1) {
                            String string6 = "";
                            for (String string7 : vector) {
                                StringBuffer stringBuffer2 = new StringBuffer(string5);
                                string6 = string6 + stringBuffer2.replace(n4, n5 + n3, string7).toString();
                            }
                            string5 = string6;
                        } else {
                            string5 = stringBuffer.replace(n4, n5 + n3, string4).toString();
                        }
                    }
                    return string5;
                }
                if (this.isRandomEffectAttribute(object5.toString())) {
                    this.setupEnumTableForRepeatedProperty(string, object5.toString());
                    return stringBuffer.toString();
                }
                if (object3.equals("equals") && object6 != null && this.propertyValueToString(object5.toString(), object6).equalsIgnoreCase(object4.toString())) {
                    return this.replaceDataSetName(stringBuffer);
                }
                if (ConditionOperators.getInstance().getConditionOperator("countGreaterThan").evaluate(object6, object4, null, null)) {
                    return this.replaceDataSetName(stringBuffer);
                }
                if (object3.equals("isNotEmpty")) {
                    if (object6 != null && object6.toString().length() > 0) {
                        if (valueDescriptor instanceof StringProperty || valueDescriptor instanceof DoubleProperty || valueDescriptor instanceof IntegerProperty) {
                            return stringBuffer.replace(n4, n5 + n3, object6.toString()).toString();
                        }
                        if (!(valueDescriptor instanceof EnumSetProperty) || !(this.mFeatureUI.getControlManager().getControl(object5.toString()) instanceof ListBoxEnumSetControl)) continue;
                        return this.getMultiSelectListBoxSyntax(string, object5.toString());
                    }
                    bl = false;
                    continue;
                }
                if (object3.equals("notEquals") && object6 != null && !object6.toString().equals(object4.toString()) && valueDescriptor instanceof EnumProperty) {
                    return stringBuffer.replace(n4, n5 + n3, object2.toString()).toString();
                }
                bl = false;
                continue;
            }
            if (!bl2) continue;
            return this.replaceDataSetName(stringBuffer);
        }
        if (!bl) {
            return "";
        }
        return string;
    }

    private boolean isMultiSelectListBox(String string) {
        HashSet hashSet;
        Object object;
        return this.mFeatureUI.getControlManager().getControl(string) instanceof ListBoxEnumSetControl && (object = this.mPropertyValues.getProperty(string)) instanceof HashSet && (hashSet = (HashSet)object).size() > 1;
    }

    private boolean isConditionTrue(Iterator<XMLElement> iterator, boolean bl) {
        boolean bl2 = true;
        XMLElement xMLElement = iterator.next();
        Iterator iterator2 = xMLElement.getChildElements(sSyntaxCondition);
        while (iterator2 != null && iterator2.hasNext()) {
            boolean bl3;
            Properties properties = ((AbstractSpecificationElement)iterator2.next()).getProperties();
            Object object = properties.getProperty(sCondition);
            Object object2 = properties.getProperty(sOperand);
            Object object3 = properties.getProperty(sProperty);
            Object object4 = this.getControlValue(object3.toString());
            boolean bl4 = bl3 = object4 != null;
            if (bl3) {
                bl3 = object.equals("isNotEmpty") ? !this.isControlEmpty(object3.toString()) : (object.equals("isEmpty") ? this.isControlEmpty(object3.toString()) : (object.equals("notEquals") ? !this.propertyValueToString(object3.toString(), object4).equalsIgnoreCase(object2.toString()) : this.propertyValueToString(object3.toString(), object4).equalsIgnoreCase(object2.toString())));
            }
            if (bl && bl3) {
                return true;
            }
            if (!bl && !bl3) {
                return false;
            }
            bl2 = bl2 && bl3;
        }
        return bl2;
    }

    private boolean isControlEmpty(String string) {
        boolean bl = true;
        Object object = this.getControlValue(string);
        ValueDescriptor valueDescriptor = this.mFeature.getPropertyValueDescriptor(string);
        if (valueDescriptor == null || object == null) {
            return bl;
        }
        if (valueDescriptor.getValueType() == ValueType.FIELD_NAME || valueDescriptor.getValueType() == ValueType.EFFECT_STRUCTURE || valueDescriptor.getValueType() == ValueType.STRUCTURE) {
            return !this.isFieldListNotEmpty(valueDescriptor, object);
        }
        if (object.toString().length() > 0) {
            bl = false;
        }
        return bl;
    }

    private String propertyValueToString(String string, Object object) {
        return this.propertyValueToString(string, object, null);
    }

    private String propertyValueToString(String string, Object object, ValueDescriptor valueDescriptor) {
        String string2 = "";
        String string3 = " ";
        if (object == null) {
            return string2;
        }
        if (this.isPropertyTargetField(string, valueDescriptor)) {
            return this.getTargetVarNames("", string, object, new Vector<String>());
        }
        ArrayList arrayList = null;
        if (!(object instanceof ArrayList)) {
            if (object instanceof Double) {
                return UIToolResUtil.removeLocale((String)this.mDoubleFormat.format((Double)object));
            }
            if (object instanceof DefaultStructure && ((DefaultStructure)object).getStructureValueType() == ValueType.EFFECT_STRUCTURE) {
                return EffectHelper.getEffectString((Structure)((DefaultStructure)object));
            }
            if (object instanceof Boolean) {
                return object.toString().toUpperCase();
            }
            return object.toString();
        }
        arrayList = (ArrayList)object;
        int n = arrayList.size();
        int n2 = 0;
        String string4 = this.mDelimiters.get(string);
        if (string4 != null) {
            string3 = string4;
        }
        for (Object e : arrayList) {
            string2 = string2 + e.toString();
            if (++n2 >= n) continue;
            string2 = string2 + string3;
        }
        return string2;
    }

    private String getVariableLabelReplacement(String string) {
        int n = string.indexOf(sLabelEscapeStart);
        int n2 = string.indexOf(sLabelEscapeEnd);
        if (n > -1 && n2 > 0) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = stringBuffer.subSequence(n + 2, n2).toString();
            for (SpecificationElement specificationElement : this.mSyntaxProperties) {
                Object object;
                String string3;
                Properties properties = ((AbstractSpecificationElement)specificationElement).getProperties();
                if (properties.getProperty("name") == null || !(string3 = properties.getProperty("name").toString()).equals(string2) || (object = this.getControlValue(string2)) == null || !(object instanceof ArrayList)) continue;
                if (((ArrayList)object).size() != 1) {
                    return string;
                }
                String string4 = this.propertyValueToString(string2, object);
                int n3 = iSpssDataSrc.findVarIndex(string4);
                if (n3 <= -1) continue;
                return iSpssDataSrc.getVariable(n3).getLabel();
            }
        }
        return string;
    }

    private String replaceUnquotedNewlineEscapes(String string) {
        String[] stringArray;
        String string2 = "";
        for (String string3 : stringArray = string.split("\n")) {
            int n = string3.indexOf("\\n", 0);
            while (n > -1) {
                if (!this.inQuote(string3, n)) {
                    string3 = string3.replace("\\n", "\n");
                } else {
                    ++n;
                }
                n = string3.indexOf("\\n", n);
            }
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    private boolean inQuote(String string, int n) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\"' && !bl2) {
                bl = !bl;
                continue;
            }
            if (string.charAt(i) != '\'' || bl) continue;
            bl2 = !bl2;
        }
        return bl || bl2;
    }

    private String getSyntaxWithCondition(String string, Object object) {
        String string2 = "";
        for (SpecificationElement specificationElement : this.mSyntaxProperties) {
            Iterator iterator;
            boolean bl = true;
            Properties properties = ((AbstractSpecificationElement)specificationElement).getProperties();
            String string3 = properties.getProperty(sName).toString();
            if (!string3.equals(string) || (iterator = specificationElement.getChildElements(sSyntaxCondition)) == null || !iterator.hasNext()) continue;
            Properties properties2 = ((AbstractSpecificationElement)iterator.next()).getProperties();
            Object object2 = properties2.getProperty(sCondition);
            Object object3 = properties2.getProperty(sOperand);
            Object object4 = properties2.getProperty(sProperty);
            if (object2 == null || object3 == null || object4 == null) continue;
            ValueDescriptor valueDescriptor = this.mFeature.getPropertyValueDescriptor(object4.toString());
            if (valueDescriptor != null && valueDescriptor.getValueType() == ValueType.FIELD_NAME && valueDescriptor.isCollection()) {
                Vector<String> vector = new Vector<String>();
                return this.getTargetVarNames(object2.toString(), object4.toString(), object, vector);
            }
            if (object == null || !this.propertyValueToString(string, object).equalsIgnoreCase(object3.toString())) {
                bl = false;
            }
            if (!bl) continue;
            return properties.getProperty(sSyntax).toString();
        }
        return string2;
    }

    private String getStructureString(Structure structure) {
        String string = "";
        int n = structure.getAttributeCount();
        StructureDefinition structureDefinition = structure.getStructureDefinition();
        for (int i = 0; i < n; ++i) {
            Object object = structure.getAttributeValue(i);
            string = string + structureDefinition.getAttributeName(i) + " ";
        }
        return string;
    }

    private String getTargetVarNames(String string, String string2, Object object, Vector<String> vector) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string3 = "";
        String string4 = " ";
        if (object == null) {
            return "";
        }
        if (!(object instanceof ArrayList) && object instanceof String) {
            return (String)object;
        }
        if (object instanceof DefaultStructure) {
            ValueType valueType = ((DefaultStructure)object).getStructureValueType();
            if (valueType == ValueType.EFFECT_STRUCTURE) {
                return EffectHelper.getEffectString((Structure)((DefaultStructure)object));
            }
            if (valueType == ValueType.STRUCTURE) {
                return this.getStructureString((Structure)((DefaultStructure)object));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.equalsIgnoreCase(sIsMeasureDiscrete)) {
            bl = true;
        } else if (string.equalsIgnoreCase(sIsMeasureContinuous)) {
            bl2 = true;
        } else if (string.equalsIgnoreCase(sIsStorageNumeric)) {
            bl3 = true;
        } else if (string.equalsIgnoreCase(sIsStorageString)) {
            bl4 = true;
        } else {
            bl4 = true;
            bl3 = true;
            bl2 = true;
            bl = true;
        }
        String string5 = this.mDelimiters.get(string2);
        if (string5 != null) {
            string4 = string5;
        }
        ArrayList arrayList = (ArrayList)object;
        int n = 0;
        String string6 = "";
        int n2 = arrayList.size();
        for (Object e : arrayList) {
            ValueType valueType;
            ++n;
            if (e == null) continue;
            if (e instanceof DefaultStructure) {
                valueType = ((DefaultStructure)e).getStructureValueType();
                if (valueType == ValueType.EFFECT_STRUCTURE) {
                    string6 = EffectHelper.getEffectString((Structure)((DefaultStructure)e));
                    string3 = string3 + string6;
                    vector.add(string6);
                } else if (valueType == ValueType.STRUCTURE) {
                    string3 = string3 + this.getStructureString((Structure)((DefaultStructure)e));
                }
            } else {
                valueType = iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(e.toString()));
                if (valueType == null) {
                    string3 = string3 + e.toString();
                    vector.add(e.toString());
                } else {
                    MeasurementLevel measurementLevel = valueType.getMeasurementLevel();
                    short s = valueType.getType();
                    if (bl && (measurementLevel == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal) || bl2 && measurementLevel == MeasurementLevel.scale || bl3 && s == 0 || bl4 && s > 0) {
                        string3 = string3 + e.toString();
                        vector.add(e.toString());
                    }
                }
            }
            if (n >= n2) continue;
            string3 = string3 + string4;
        }
        return string3;
    }

    private boolean hasInfiniteReference() {
        Object object;
        Object object2;
        Object object3;
        for (SpecificationElement object4 : this.mSyntaxProperties) {
            object3 = ((AbstractSpecificationElement)object4).getProperties();
            object2 = object3.getProperty(sName).toString();
            object = object3.getProperty(sSyntax).toString();
            Vector<String> vector = this.getReferencedPropertyNames((String)object);
            if (vector.size() <= 0) continue;
            this.mPropertyKeyValues.put((String)object2, vector);
            this.mPropertyStatus.put((String)object2, false);
        }
        if (this.mPropertyKeyValues.size() > 0) {
            Enumeration<String> enumeration = this.mPropertyKeyValues.keys();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                if (!this.isVectorContains((String)object3, vector)) {
                    vector.add((String)object3);
                }
                if (this.mPropertyStatus.get(object3).booleanValue()) continue;
                object2 = this.mPropertyKeyValues.get(object3);
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (this.mPropertyStatus.get(string) == null || this.mPropertyStatus.get(string).booleanValue()) continue;
                    if (((String)object3).equalsIgnoreCase(string)) {
                        return true;
                    }
                    if (this.hasDirectedCycle(vector, string)) {
                        return true;
                    }
                    this.mPropertyStatus.put(string, true);
                }
                this.mPropertyStatus.put((String)object3, true);
            }
        }
        return false;
    }

    private Vector<String> getReferencedPropertyNames(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = DialogDefinition.getEscapeSequence();
        String string3 = DialogDefinition.getSelfValue();
        int n2 = string2.length();
        int n3 = string.indexOf(string2);
        if (string.equalsIgnoreCase(DialogDefinition.getSelfValue()) || string.startsWith(sLabelEscapeStart) && string.endsWith(sLabelEscapeEnd)) {
            return vector;
        }
        while (n3 > -1 && (n = string.indexOf(string2, n3 + 1)) > -1) {
            String string4 = string.substring(n3 + n2, n);
            if (!string3.equalsIgnoreCase(string2 + string4 + string2)) {
                vector.add(string4);
            }
            n3 = string.indexOf(string2, n + n2);
        }
        return vector;
    }

    private boolean hasDirectedCycle(Vector<String> vector, String string) {
        boolean bl = false;
        if (this.mPropertyKeyValues.get(string) == null || this.mPropertyStatus.get(string) != null && this.mPropertyStatus.get(string).booleanValue()) {
            return bl;
        }
        if (!this.isVectorContains(string, vector)) {
            vector.add(string);
        }
        for (String string2 : this.mPropertyKeyValues.get(string)) {
            if (this.mPropertyStatus.get(string2) == null || this.mPropertyStatus.get(string2).booleanValue()) continue;
            if (this.isVectorContains(string2, vector)) {
                return true;
            }
            if (this.hasDirectedCycle(vector, string2)) {
                return true;
            }
            this.mPropertyStatus.put(string2, true);
        }
        return bl;
    }

    private boolean isVectorContains(String string, Vector<String> vector) {
        boolean bl = false;
        for (String string2 : vector) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return bl;
    }

    private String getNextUniqueDataSetName() {
        return DataDocument.getNextFreeDatasetName((boolean)true);
    }

    private String getActiveDatasetName() {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(SpssMgr.getSpssMgr().getActiveClientDatasetId());
        String string = iSpssDataSrc.getDatasetName();
        if (string == null || string.length() == 0) {
            string = DataDocument.getNextFreeDatasetName();
        }
        return string;
    }

    private boolean isCurrentDatasetNamed() {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(SpssMgr.getSpssMgr().getActiveClientDatasetId());
        String string = iSpssDataSrc.getDatasetName();
        return string != null && string.length() != 0;
    }

    private String getColValueFromTable(String string, Vector<String> vector) {
        String string2 = "";
        String string3 = this.mQuoteType.get(string);
        String string4 = this.mDelimiters.get(string);
        String string5 = this.mExteriorQuote.get(string);
        if (string5 == null) {
            string5 = "";
        }
        if (string3 != null && string4 != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string6 = string5 + this.handleInteriorQuote(vector.get(i).toString(), string) + string5;
                string2 = string2 + string6;
                if (i == vector.size() - 1) continue;
                string2 = string2 + string4;
            }
        }
        return string2;
    }

    private Object getControlValue(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            Object object = this.mPropertyValues.getProperty(string2);
            if (object == null) {
                return null;
            }
            if (object instanceof Structure) {
                Structure structure = (Structure)object;
                Object object2 = structure.getAttributeValue(string3);
                if (object2 != null) {
                    ValueDescriptor valueDescriptor = structure.getStructureDefinition().getAttributeDescriptor(string3);
                    if (valueDescriptor instanceof EncryptedStringProperty && object2 instanceof String) {
                        return new PassEncrypt().encryptString((String)object2, "'");
                    }
                    return object2;
                }
                int n2 = string3.indexOf(":");
                if (n2 >= 0 && (object2 = structure.getAttributeValue(string3.substring(0, n2))) != null && object2 instanceof ArrayList && ((ArrayList)object2).size() > 0) {
                    ArrayList arrayList = (ArrayList)object2;
                    String string4 = "";
                    for (int i = 0; i < arrayList.size() && arrayList.get(i) instanceof Structure; ++i) {
                        structure = (Structure)arrayList.get(i);
                        String string5 = string3.substring(n2 + 1, string3.length());
                        string4 = string5.indexOf(":") > 0 ? string4 + this.getStructureValue(structure, string5) : string4 + structure.getAttributeValue(string5) + " ";
                    }
                    if (string4.length() > 0) {
                        return string4;
                    }
                }
                return object2;
            }
            if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof DefaultStructure) {
                Vector<String> vector;
                Hashtable<String, Vector<String>> hashtable;
                if (this.mRandomEffectSyntax == null) {
                    this.mRandomEffectSyntax = new Hashtable();
                }
                if ((hashtable = this.mRandomEffectSyntax.get(string2)) == null) {
                    hashtable = new Hashtable();
                }
                if ((vector = hashtable.get(string)) == null) {
                    vector = this.getAttrValueFromRandomEffect((ArrayList)object, string3, string);
                    hashtable.put(string, vector);
                    this.mRandomEffectSyntax.put(string2, hashtable);
                    String string6 = this.getColValueFromTable(string, vector);
                    if (vector.size() > 0 && string6.length() > 0) {
                        return string6;
                    }
                }
                return vector.toString();
            }
            if (object instanceof HashMap && ((HashMap)object).size() > 0 && this.mFeatureUI.getControlManager().getControl(string2) instanceof StructureMapTableControl) {
                Object object3;
                HashMap hashMap = (HashMap)object;
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                ArrayList<DefaultStructure> arrayList = new ArrayList<DefaultStructure>();
                while (iterator.hasNext()) {
                    object3 = hashMap.get(iterator.next());
                    if (object3 == null || !(object3 instanceof DefaultStructure)) continue;
                    arrayList.add((DefaultStructure)object3);
                }
                if (arrayList.size() == 0) {
                    return null;
                }
                object3 = this.getAttrValueFromRandomEffect(arrayList, string3, string);
                return this.getColValueFromTable(string, (Vector<String>)object3);
            }
            return null;
        }
        Object object = this.mPropertyValues.getProperty(string);
        if (string.equalsIgnoreCase("glmm.KroneckerMeasure") && !this.mFeatureUI.getControlManager().getControl(string).isEnabled()) {
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            ValueDescriptor valueDescriptor = this.mFeature.getPropertyValueDescriptor(string);
            ValueType valueType = valueDescriptor.getValueType();
            if (valueType == ValueType.DATE) {
                return DateProperty.DATE_FORMATTER.format(date);
            }
            if (valueType == ValueType.TIME) {
                return DateProperty.TIME_FORMATTER.format(date);
            }
            return DateProperty.DATE_TIME_FORMATTER.format(date);
        }
        if (object instanceof String) {
            Control control = this.mFeatureUI.getControlManager().getControl(string);
            if (control instanceof SingleFieldValueChooserControl) {
                return this.makeSmartString((String)object);
            }
            if (control instanceof CustomSwingControl) {
                if (string.equals("cognosReportImporter.reportPath") || string.equals("cognosReportImporter.reportDirectory") || string.equals("cognosImporter.packagePath")) {
                    return CharacterUtil.smartQuote((String)((String)object));
                }
            } else if (control instanceof ServerFileChooserControl) {
                int n3;
                String[] stringArray;
                Object object4;
                String string7;
                PesFile pesFile = PES_Repository.getPesFile((String)((String)object));
                if (pesFile != null && (string7 = pesFile.getPerAttributesSyntax()) != null && this.mRepositorySyntax.get(string) == null) {
                    this.mRepositorySyntax.put(string, string7);
                }
                string7 = (String)object;
                int n4 = string7.lastIndexOf(".");
                ServerFileChooserControl serverFileChooserControl = (ServerFileChooserControl)control;
                List list = serverFileChooserControl.getFileFilters();
                if (list != null && list.size() > 0 && (object4 = (FileFilter)list.get(0)) instanceof SimpleFileFilter && (stringArray = ((SimpleFileFilter)object4).getSuffixes()) != null && (n3 = string7.indexOf(stringArray[0])) < 0) {
                    object = string7.concat(stringArray[0]);
                }
                if ((object4 = serverFileChooserControl.getEntryptedSyntax()) != null && ((String)object4).trim().length() > 0) {
                    object = "'" + object.toString() + "'" + (String)object4;
                }
            } else {
                if (control instanceof PasswordBoxControl) {
                    String string8;
                    if (((PasswordBoxControl)control).encryptSyntax()) {
                        string8 = new PassEncrypt().encryptString(object.toString(), "'");
                    } else {
                        string8 = object.toString();
                        string8 = this.handleInteriorQuote(string8, string);
                    }
                    return string8;
                }
                if (control instanceof TextBoxControl) {
                    String string9 = ((TextBoxControl)control).getControlValue().toString();
                    object = string9.replaceAll("&#10;", "\n");
                    object = this.handleInteriorQuote(object, string);
                } else if (control instanceof ComboBoxEnumControl) {
                    String string10 = ((ComboBoxEnumControl)control).getControlValue().toString();
                    object = this.handleInteriorQuote(string10, string);
                }
            }
            return object;
        }
        if (object instanceof Color) {
            Control control = this.mFeatureUI.getControlManager().getControl(string);
            if (control instanceof ColorPickerButtonControl) {
                return ((ColorPickerButtonControl)control).getControlSyntax();
            }
        } else if (object instanceof HashSet) {
            HashSet hashSet = (HashSet)object;
            if (hashSet.size() == 0) {
                return "";
            }
            Object[] objectArray = hashSet.toArray();
            if (this.mFeatureUI.getControlManager().getControl(string) instanceof DatasetSelectorControl) {
                String string11 = ((CFEnum)objectArray[0]).getLabel();
                int n5 = string11.indexOf("[");
                int n6 = string11.indexOf("]");
                if (n5 >= 0 && n6 >= 0) {
                    return string11.substring(n5 + 1, n6);
                }
            } else if (this.mFeatureUI.getControlManager().getControl(string) instanceof ListBoxEnumSetControl) {
                String string12 = "";
                String string13 = this.mDelimiters.get(string);
                int n7 = 0;
                if (string13 == null) {
                    string13 = " ";
                }
                for (Object object5 : objectArray) {
                    string12 = string12 + object5.toString();
                    if (++n7 >= objectArray.length) continue;
                    string12 = string12 + string13;
                }
                object = this.handleInteriorQuote(string12, string);
            }
        }
        return object;
    }

    private CDBControlType getCDBControlTypeForStringType(String string) {
        CDBControlType cDBControlType = null;
        int n = string.indexOf(":");
        if (n <= 0) {
            Object object = this.mPropertyValues.getProperty(string);
            if (object == null) {
                return null;
            }
            if (object instanceof Date) {
                cDBControlType = CDBControlType.Date;
            } else if (object instanceof String) {
                cDBControlType = CDBControlType.Date;
                Control control = this.mFeatureUI.getControlManager().getControl(string);
                cDBControlType = control instanceof SingleFieldValueChooserControl ? CDBControlType.String_SingleFieldValueChooserControl : (control instanceof CustomSwingControl ? CDBControlType.String_CustomSwingControl : (control instanceof ServerFileChooserControl ? CDBControlType.String_ServerFileChooserControl : (control instanceof PasswordBoxControl ? CDBControlType.String_PasswordBoxControl : (control instanceof TextBoxControl ? CDBControlType.String_TextBoxControl : (control instanceof ComboBoxEnumControl ? CDBControlType.String_ComboBoxEnumControl : CDBControlType.StringUnknown)))));
            } else if (object instanceof Color) {
                cDBControlType = CDBControlType.Color;
            } else if (object instanceof HashSet) {
                HashSet hashSet = (HashSet)object;
                if (hashSet.size() == 0) {
                    cDBControlType = CDBControlType.HashSetEmpty;
                } else {
                    Object[] objectArray = hashSet.toArray();
                    if (this.mFeatureUI.getControlManager().getControl(string) instanceof DatasetSelectorControl) {
                        cDBControlType = CDBControlType.HashSet_DatasetSelectorControl;
                    } else if (this.mFeatureUI.getControlManager().getControl(string) instanceof ListBoxEnumSetControl) {
                        cDBControlType = CDBControlType.HashSet_ListBoxEnumSetControl;
                    }
                }
            }
        }
        return cDBControlType;
    }

    private String handleInteriorQuote(Object object, String string) {
        int n;
        String string2 = object.toString();
        String string3 = this.mExteriorQuote.get(string);
        String string4 = "";
        if (string3 != null && (n = string2.indexOf(string3)) >= 0) {
            string4 = this.mQuoteType.get(string);
        }
        if (string4.equalsIgnoreCase("Python") || string4.equalsIgnoreCase("R") || string4.equalsIgnoreCase("Syntax")) {
            char[] cArray = object.toString().toCharArray();
            char c = string3.charAt(0);
            int n2 = 0;
            for (char n3 : cArray) {
                if (n3 != c) continue;
                ++n2;
            }
            char[] cArray2 = new char[cArray.length + n2];
            int n4 = 0;
            for (char c2 : cArray) {
                if (c2 == c) {
                    if (string4.equalsIgnoreCase("Python") || string4.equalsIgnoreCase("R")) {
                        cArray2[n4++] = 92;
                        cArray2[n4++] = c;
                        continue;
                    }
                    cArray2[n4++] = c;
                    cArray2[n4++] = c;
                    continue;
                }
                cArray2[n4++] = c2;
            }
            string2 = new String(cArray2);
        }
        return string2;
    }

    private Object getStructureValue(Structure structure, String string) {
        int n = string.indexOf(":");
        Object object = structure.getAttributeValue(string.substring(0, n));
        if (object instanceof Structure) {
            object = ((Structure)object).getAttributeValue(string.substring(n + 1, string.length()));
        }
        if (object != null && object instanceof ArrayList && ((ArrayList)object).size() > 0) {
            ArrayList arrayList = (ArrayList)object;
            String string2 = "";
            for (int i = 0; i < arrayList.size() && arrayList.get(i) instanceof Structure; ++i) {
                structure = (Structure)arrayList.get(i);
                string2 = string.indexOf(":") > 0 ? string2 + this.getStructureValue(structure, string) : string2 + structure.getAttributeValue(string.substring(n + 1, string.length())) + " ";
            }
            if (string2.length() > 0) {
                return string2;
            }
        }
        return object;
    }

    private String makeSmartString(String string) {
        String string2 = string;
        if (string.indexOf("'") >= 0) {
            string2 = string2.replaceAll("'", "''");
        }
        return string2;
    }

    private String getOutfileLocation() {
        UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
        return utilityProxy.getServerTemporaryPath();
    }

    private boolean isFieldListNotEmpty(ValueDescriptor valueDescriptor, Object object) {
        if (object == null) {
            return false;
        }
        if (!valueDescriptor.isCollection() && object instanceof String) {
            if (object.toString().length() == 0) {
                return false;
            }
        } else {
            List list;
            if (object instanceof ArrayList && ((ArrayList)object).size() == 0) {
                return false;
            }
            if (object instanceof DefaultStructure && ((list = ConditionOperators.getFieldsInStructure((Structure)((DefaultStructure)object))) == null || list != null && list.size() == 0)) {
                return false;
            }
        }
        return true;
    }

    private boolean isTargetVarScale(Object object) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (object == null || !(object instanceof ArrayList) || ((ArrayList)object).size() != 1) {
            return false;
        }
        int n = iSpssDataSrc.findVarIndex(((ArrayList)object).get(0).toString());
        if (n < 0) {
            return false;
        }
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        return iSpssVariable.getMeasurementLevel() == MeasurementLevel.scale;
    }

    private boolean isTargetVarNominal(Object object) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (object == null || !(object instanceof ArrayList) || ((ArrayList)object).size() != 1) {
            return false;
        }
        int n = iSpssDataSrc.findVarIndex(((ArrayList)object).get(0).toString());
        if (n < 0) {
            return false;
        }
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        return iSpssVariable.getMeasurementLevel() == MeasurementLevel.nominal || iSpssVariable.getMeasurementLevel() == MeasurementLevel.ordinal;
    }

    private boolean isTargetVarString(Object object) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (object == null) {
            return false;
        }
        int n = -1;
        if (object instanceof String) {
            n = iSpssDataSrc.findVarIndex(object.toString());
        } else if (object instanceof ArrayList && ((ArrayList)object).size() == 1) {
            n = iSpssDataSrc.findVarIndex(((ArrayList)object).get(0).toString());
        }
        if (n < 0) {
            return false;
        }
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        return iSpssVariable.getFormat().getFormatType().isStringFormat();
    }

    private boolean getResourceProvider() {
        if (this.mResourceProvider == null) {
            this.mResourceProvider = ((CFSession)this.mFeature.getSession()).getFrameworkSwingSupport().newSwingResourceProvider(this.mFeature.getExtensionID());
        }
        return this.mResourceProvider != null;
    }

    private String getResString(String string) {
        String string2;
        SwingResourceProvider swingResourceProvider;
        if (this.mResourceProvider == null && !this.getResourceProvider()) {
            return string;
        }
        int n = string.indexOf(sGetFromResource);
        String string3 = string;
        if (n > 0 && this.mResourceProvider instanceof SwingResourceProvider && (string3 = (swingResourceProvider = (SwingResourceProvider)this.mResourceProvider).getLabel(string2 = string.substring(0, n))) == null) {
            string3 = string2;
        }
        return string3;
    }

    private String doMath(String string) {
        String string2 = string;
        int n = string.indexOf(sMathMultiply);
        if (n > 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + sMathMultiply.length(), string.length());
            try {
                double d = Double.parseDouble(string3);
                double d2 = Double.parseDouble(string4);
                string2 = String.valueOf(d * d2);
            }
            catch (Exception exception) {
                return string2;
            }
        }
        return string2;
    }

    private String getSyntaxFromBackend() {
        String string;
        InputStreamReader inputStreamReader;
        Object object;
        Object object2;
        this.mIsBackEndSyntaxOK = true;
        Properties properties = this.mSyntaxCommand.getProperties();
        Object object3 = properties.getProperty(sInputContainer);
        if (object3 == null) {
            return "";
        }
        String string2 = object3.toString();
        object3 = properties.getProperty(sFallbackAction);
        if (object3 == null || !object3.toString().equalsIgnoreCase("analyze")) {
            return "";
        }
        object3 = properties.getProperty(sProperty);
        if (object3 == null || !this.mPropertyNames.contains(object3.toString()) || this.mPropertyValues.getProperty(object3.toString()) == null || !(this.mPropertyValues.getProperty(object3.toString()) instanceof Boolean)) {
            return "";
        }
        String string3 = ".";
        Boolean bl = (Boolean)this.mPropertyValues.getProperty(object3.toString());
        if (bl.booleanValue()) {
            string3 = this.getSyntaxValueFromSyntaxProperties(object3.toString(), bl);
        } else {
            Object object4 = properties.getProperty("property2");
            if (object4 != null && object4 instanceof String && (object2 = this.mPropertyValues.getProperty(object4.toString())) != null && object2 instanceof Boolean) {
                bl = (Boolean)object2;
            }
        }
        boolean bl2 = string3.length() > 0 && bl != false;
        object2 = null;
        if (this.mFeature.containsContainer(string2)) {
            object2 = this.mFeature.getContainer(string2);
        }
        if (object2 != null) {
            ((FeatureImpl)this.mFeature).updateContainer(string2);
        } else {
            ((FrameworkUISupportImpl)FrameworkMgr.get().getSession().getFrameworkUISupport()).handleFeatureAction((FeatureImpl)this.mFeature, this.mFeatureUI.getControlManager(), FrameworkAction.executeFeature, string2);
        }
        if (object2 == null) {
            object2 = this.mFeature.getContainer(string2);
        }
        if (object2 == null) {
            this.mIsBackEndSyntaxOK = false;
            return "";
        }
        try {
            int n;
            object = object2.getContentFromInputStream();
            inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
            ((Reader)inputStreamReader).close();
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.mIsBackEndSyntaxOK = false;
            return "";
        }
        if (string.length() == 0) {
            this.mIsBackEndSyntaxOK = false;
            return "";
        }
        string = SysFileProxy.getSysFileProxy().convertPmmlToSyntax(string, !bl2);
        if (string == null) {
            this.mIsBackEndSyntaxOK = false;
            return "";
        }
        if (string.length() == 0) {
            object = sNoTransMesg;
            if (this.mResourceProvider instanceof SwingResourceProvider && (object = (inputStreamReader = (SwingResourceProvider)this.mResourceProvider).getLabel(sEmptySyntaxError)) == null) {
                object = "";
            }
            SpssAlertOptionPane.showWarningMessageDialog(ProcedureDlgMgr.getMgr().getLastDialog().getOwner(), (String)object, VersionInfo.getAppVersionString());
            this.mIsBackEndSyntaxOK = false;
        }
        return string;
    }

    private String handleRepeatedCommand(String string, String string2) {
        String string3;
        String string4 = "";
        Object object = "";
        Boolean bl = false;
        if (this.mRandomEffectSyntax == null) {
            return string4;
        }
        Hashtable<String, Vector<String>> hashtable = this.mRandomEffectSyntax.get(string);
        Vector<Pair<String, String>> vector = this.mSubCommands.get(string);
        if (hashtable == null || vector == null || vector.size() == 0) {
            return string4;
        }
        int n = 0;
        int n2 = hashtable.size();
        int n3 = 0;
        int n4 = hashtable.get(vector.get(0).getSecond()).size();
        String[][] stringArray = new String[n4][n2];
        for (Pair<String, String> pair : vector) {
            Object object2;
            object = "";
            string3 = pair.getSecond().toString();
            Vector<String> vector2 = hashtable.get(pair.getSecond());
            Hashtable<String, Vector<Properties>> hashtable2 = this.getRepeatedPropertyControlCondition(string3);
            if (hashtable2.size() > 0) {
                object2 = hashtable2.keys();
                while (object2.hasMoreElements()) {
                    String string5 = (String)object2.nextElement();
                    Vector<String> vector3 = hashtable.get(string5);
                    this.checkStructValueWithCondition(vector3, hashtable2.get(string5), vector2);
                }
            }
            if ((object2 = this.mDelimiters.get(string3)) != null) {
                if (((String)object2).equals("'='")) {
                    bl = true;
                }
                object = object2;
            }
            n3 = 0;
            int n5 = vector2.size();
            for (String string6 : vector2) {
                String string7;
                Hashtable<String, String> hashtable3 = this.mSyntaxPropertyValue.get(string3);
                stringArray[n3][n] = hashtable3 != null ? ((string7 = hashtable3.get(string6)) != null ? string7 : "") : string6;
                if (stringArray[n3][n].length() > 0 && (((String)object).equals(")") || ((String)object).equals("'='"))) {
                    String[] stringArray2 = stringArray[n3];
                    int n6 = n;
                    stringArray2[n6] = stringArray2[n6] + (String)object;
                }
                ++n3;
            }
            ++n;
        }
        int n7 = string2.indexOf(sNoRepeat);
        boolean bl2 = false;
        string3 = "";
        for (n3 = 0; n3 < n4; ++n3) {
            boolean bl3 = false;
            string3 = "";
            for (n = 0; n < n2; ++n) {
                if (stringArray[n3][n] == null || CharacterUtil.rightTrim((String)stringArray[n3][n]).length() <= 0) continue;
                string3 = bl != false ? string3 + stringArray[n3][n] : string3 + (String)vector.get(n).getFirst() + stringArray[n3][n] + " ";
                bl2 = true;
                bl3 = true;
            }
            if (bl3 && bl.booleanValue()) {
                string3 = "'" + string3 + "'";
            }
            if (n3 < n4 - 1 && bl3 && n7 < 0) {
                string3 = string3 + "\n ";
            }
            if (bl3 && n7 < 0) {
                string4 = string4 + string2 + string3;
                continue;
            }
            if (!bl3) continue;
            string4 = string4 + string3 + " ";
        }
        if (n7 > 0 && string4.length() > 0) {
            string4 = string2.substring(0, n7) + string4;
        } else if (!bl2) {
            return "";
        }
        return string4;
    }

    private Vector<String> getAttrValueFromRandomEffect(ArrayList<DefaultStructure> arrayList, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        for (DefaultStructure defaultStructure : arrayList) {
            Object object = defaultStructure.getAttributeValue(string);
            StructureDefinition structureDefinition = defaultStructure.getStructureDefinition();
            ValueDescriptor valueDescriptor = structureDefinition.getAttributeDescriptor(string);
            if (object instanceof ArrayList && ((ArrayList)object).size() == 0) {
                vector.add("");
                continue;
            }
            vector.add(this.propertyValueToString(string2, object, valueDescriptor));
        }
        return vector;
    }

    private boolean isRandomEffectAttribute(String string) {
        int n = string.indexOf(":");
        if (n < 0) {
            return false;
        }
        if (this.mRandomEffectSyntax == null) {
            return false;
        }
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (this.mRandomEffectSyntax.get(string2) != null && this.mRandomEffectSyntax.get(string2).get(string) != null) {
                return true;
            }
        }
        return false;
    }

    private String isRepeatedSyntax(String string) {
        String string2 = "";
        int n = string.indexOf(sRepeated);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String setupSyntaxCommandAndProperyTable(String string, String string2) {
        String string3 = string;
        int n = string.indexOf(sRepeatedSyntax);
        int n2 = -1;
        String string4 = "";
        int n3 = 0;
        if (n > 0) {
            n2 = string.indexOf(sRepeatedSyntax, n + sRepeatedSyntax.length());
        }
        if (n >= 0 && n2 > 0) {
            Vector<Pair> vector = new Vector<Pair>();
            string3 = n > 0 ? string.substring(0, n) + string.substring(n2 + sRepeatedSyntax.length()) : string.substring(n2 + sRepeatedSyntax.length());
            String string5 = DialogDefinition.getEscapeSequence();
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + sRepeatedSyntax.length(), n2));
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6, string5);
                String string7 = " ";
                String string8 = "";
                if (stringTokenizer2.countTokens() == 2) {
                    string7 = stringTokenizer2.nextToken();
                    string8 = stringTokenizer2.nextToken();
                } else if (stringTokenizer2.countTokens() == 1) {
                    string8 = stringTokenizer2.nextToken();
                }
                if (string8.length() <= 0) continue;
                vector.add(new Pair((Object)string7, (Object)string8));
                if (string4.length() != 0 || (n3 = string8.indexOf(":")) <= 0) continue;
                string4 = string8.substring(0, n3);
            }
            this.mSyntaxItemAndStructName.put(string2, string4);
            if (vector.size() > 0) {
                this.mSubCommands.put(string4, vector);
            }
        }
        return string3;
    }

    private void setupEnumTableForRepeatedProperty(String string, String string2) {
        if (this.mSyntaxPropertyValue.get(string2) != null) {
            return;
        }
        if (!this.isEnumProperty(string2)) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (SpecificationElement specificationElement : this.mSyntaxItems) {
            Properties properties;
            Object object;
            Properties properties2 = ((AbstractSpecificationElement)specificationElement).getProperties();
            Object object2 = properties2.getProperty(sName);
            if (properties2.getProperty(sName) == null || !object2.toString().equals(string)) continue;
            Object object3 = properties2.getProperty(sSyntax);
            Iterator iterator = specificationElement.getChildElements(sSyntaxCondition);
            if (iterator == null || !iterator.hasNext() || !string2.equalsIgnoreCase((object = (properties = ((AbstractSpecificationElement)iterator.next()).getProperties()).getProperty(sProperty)).toString())) continue;
            Object object4 = properties.getProperty(sOperand);
            hashtable.put(object4.toString(), object3.toString());
        }
        if (hashtable.size() > 0) {
            this.mSyntaxPropertyValue.put(string2, hashtable);
        }
    }

    private boolean isEnumProperty(String string) {
        boolean bl = false;
        int n = string.indexOf(":");
        if (n < 0) {
            return bl;
        }
        if (n > 0) {
            DefaultStructure defaultStructure;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            Object object = this.mPropertyValues.getProperty(string2);
            if (object == null) {
                return bl;
            }
            if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof DefaultStructure && (defaultStructure = (DefaultStructure)((ArrayList)object).get(0)).getStructureDefinition().getAttributeDescriptor(string3) instanceof EnumProperty) {
                bl = true;
            }
        }
        return bl;
    }

    private Hashtable<String, Vector<Properties>> getRepeatedPropertyControlCondition(String string) {
        Hashtable<String, Vector<Properties>> hashtable = new Hashtable<String, Vector<Properties>>();
        int n = string.indexOf(":");
        if (n < 0) {
            return hashtable;
        }
        String string2 = string.substring(0, n);
        for (SpecificationElement specificationElement : this.mSyntaxProperties) {
            Properties properties = ((AbstractSpecificationElement)specificationElement).getProperties();
            String string3 = properties.getProperty(sName).toString();
            if (!string3.equals(string)) continue;
            Iterator iterator = specificationElement.getChildElements(sAndCondition);
            if (iterator == null || !iterator.hasNext()) {
                iterator = specificationElement.getChildElements(sOrCondition);
            }
            if (iterator == null || !iterator.hasNext()) {
                iterator = specificationElement.getChildElements(sSyntaxCondition);
            } else {
                XMLElement xMLElement = (XMLElement)iterator.next();
                iterator = xMLElement.getChildElements(sSyntaxCondition);
            }
            if (iterator != null && iterator.hasNext()) {
                this.HandleStructureConditions(string2, iterator, hashtable);
            }
            return hashtable;
        }
        return hashtable;
    }

    private void checkStructValueWithCondition(Vector<String> vector, Vector<Properties> vector2, Vector<String> vector3) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            for (Properties properties : vector2) {
                String string = properties.getProperty(sCondition).toString();
                String string2 = properties.getProperty(sOperand).toString();
                if ((!string.equalsIgnoreCase(sEquals) || vector.get(i).equalsIgnoreCase(string2)) && (!string.equalsIgnoreCase(sNotEquals) || !vector.get(i).equalsIgnoreCase(string2))) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            vector3.setElementAt("", i);
        }
    }

    private void HandleStructureConditions(String string, Iterator<XMLElement> iterator, Hashtable<String, Vector<Properties>> hashtable) {
        while (iterator.hasNext()) {
            Properties properties = ((AbstractSpecificationElement)iterator.next()).getProperties();
            Object object = properties.getProperty(sProperty);
            if (object.toString().indexOf(string) < 0) continue;
            Vector<Object> vector = hashtable.get(object);
            if (vector == null) {
                vector = new Vector();
            }
            vector.add(properties);
            hashtable.put(object.toString(), vector);
        }
    }

    static enum CDBControlType {
        Date,
        String_SingleFieldValueChooserControl,
        String_CustomSwingControl,
        String_ServerFileChooserControl,
        String_PasswordBoxControl,
        String_TextBoxControl,
        String_ComboBoxEnumControl,
        StringUnknown,
        Color,
        HashSetEmpty,
        HashSet_DatasetSelectorControl,
        HashSet_ListBoxEnumSetControl;

    }
}

