/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.instance;

import com.pasw.core.application.callback.ApplicationConditionRequest;
import com.pasw.core.application.callback.CreateDataModelRequest;
import com.pasw.core.application.callback.CreateDataModelResponse;
import com.pasw.core.application.callback.DecryptStringCallbackRequest;
import com.pasw.core.application.callback.DecryptStringCallbackResponse;
import com.pasw.core.application.callback.EncryptStringCallbackRequest;
import com.pasw.core.application.callback.EncryptStringCallbackResponse;
import com.pasw.core.application.callback.ExecutionRequest;
import com.pasw.core.application.callback.ExecutionResponse;
import com.pasw.core.application.callback.FileSystemChooserRequest;
import com.pasw.core.application.callback.GetAttributeCallbackRequest;
import com.pasw.core.application.callback.GetDateTimeFormatsCallbackRequest;
import com.pasw.core.application.callback.GetDateTimeFormatsCallbackResponse;
import com.pasw.core.application.callback.ValidateValueRequest;
import com.pasw.core.application.callback.ValidateValueResponse;
import com.pasw.core.container.ContainerSetProvider;
import com.pasw.core.container.DefaultContainer;
import com.pasw.core.container.DefaultContainerSet;
import com.pasw.core.datamodel.ReplaceDataModelImpl;
import com.pasw.core.extension.feature.FeatureImpl;
import com.pasw.core.extension.runtime.DocItem;
import com.pasw.core.extension.runtime.ExecutionXML;
import com.pasw.core.extension.runtime.ItemContentException;
import com.pasw.core.property.descriptor.DefaultStructure;
import com.pasw.framework.common.FrameworkFactory;
import com.pasw.framework.common.application.Application;
import com.pasw.framework.common.core.Structure;
import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.DataModelProvider;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.FieldSortMode;
import com.pasw.framework.common.data.StorageType;
import com.pasw.framework.common.extension.runtime.ExecutionHandle;
import com.pasw.framework.common.extension.runtime.ExecutionState;
import com.pasw.framework.common.extension.runtime.ExecutionTask;
import com.pasw.framework.common.extension.runtime.Task;
import com.pasw.framework.common.session.FrameworkSessionSupport;
import com.pasw.framework.common.session.Session;
import com.pasw.framework.common.session.SessionCallbackRequest;
import com.pasw.framework.common.session.SessionCallbackResponse;
import com.pasw.framework.common.session.SessionCallbackType;
import com.pasw.framework.ui.common.FrameworkUISupport;
import com.pasw.framework.ui.common.UICallbackRequest;
import com.pasw.framework.ui.common.UISession;
import com.pasw.framework.ui.swing.FrameworkSwingFactory;
import com.pasw.framework.ui.swing.FrameworkSwingSupport;
import com.pasw.ui.common.FeatureUI;
import com.pasw.ui.common.action.RunUIActionRequest;
import com.pasw.ui.common.control.ControlManager;
import com.pasw.ui.swing.common.AlertOptionPane;
import com.pasw.ui.swing.common.SwingFeatureUI;
import com.pasw.ui.swing.control.ServerBrowserControl;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PESRepositoryCredential;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.SaveSyntaxGenerator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.CFExecutionResponse;
import com.spss.java_client.core.server.messages.sysfilemsg.CFInteractionResponse;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.cf_integration.datamodel.CFDataModel;
import com.spss.java_client.ui.cf_integration.datamodel.CFDataModelProvider;
import com.spss.java_client.ui.cf_integration.datamodel.CFField;
import com.spss.java_client.ui.cf_integration.dialog.CFProcedureDialog;
import com.spss.java_client.ui.cf_integration.instance.CFApplication;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.data.RepositoryCredentialListDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.uitools.help.BrowserLaunch;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.EncodingValidator;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CFSession
implements UISession {
    private static final int SYNC_TIMEOUT_VALUE = 3600000;
    private final CFApplication mApplication;
    private FrameworkSessionSupport mFrameworkSessionSupport = null;
    private final FrameworkSwingSupport mFrameworkSwingSupport;
    private EncodingValidator mEncodingValidator;
    private DataModel mDataModel;
    protected File mFileSpec = null;

    public CFSession(CFApplication cFApplication) {
        FrameworkFactory frameworkFactory = null;
        try {
            frameworkFactory = FrameworkFactory.getInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mApplication = cFApplication;
        try {
            this.mFrameworkSessionSupport = frameworkFactory.newFrameworkSessionSupport((Session)this);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        FrameworkSwingFactory frameworkSwingFactory = null;
        try {
            frameworkSwingFactory = FrameworkSwingFactory.getInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mFrameworkSwingSupport = frameworkSwingFactory.newFrameworkSwingSupport((UISession)this);
        this.mEncodingValidator = new EncodingValidator(ComponentState.getCurrentCharset());
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public Locale getResourceLocale() {
        return Locale.getDefault();
    }

    public Locale getNumericLocale() {
        return ComponentState.getSPSSLocale();
    }

    public void setDataModel(DataModel dataModel) {
        this.mDataModel = dataModel;
    }

    public boolean handleCallback(SessionCallbackRequest sessionCallbackRequest, SessionCallbackResponse sessionCallbackResponse) {
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.invoke_native_help) {
            String string = sessionCallbackRequest.getRequest().toString();
            return StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.invoke_CDB_help) {
            String string = sessionCallbackRequest.getRequest().toString();
            return this.showCDBHelpPath(sessionCallbackRequest.getProperty("extension_id").toString(), string);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.invoke_file_chooser) {
            return this.runFileSystemChooser(sessionCallbackRequest, sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.validate_string_encoding) {
            return this.validateString(sessionCallbackRequest.getRequest().toString(), sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.execute_feature) {
            return this.executeBackendFeature((ExecutionRequest)sessionCallbackRequest, (ExecutionResponse)sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.validate_control_value) {
            return this.validateValue((ValidateValueRequest)sessionCallbackRequest, (ValidateValueResponse)sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.application_condition) {
            return this.validateValue((ApplicationConditionRequest)sessionCallbackRequest, sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.run_ui_action) {
            return this.runUIAction(sessionCallbackRequest, sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.interaction_message) {
            return this.runInteraction(sessionCallbackRequest, sessionCallbackResponse);
        }
        if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.encrypt_string) {
            if (sessionCallbackResponse instanceof EncryptStringCallbackResponse) {
                PassEncrypt passEncrypt = new PassEncrypt();
                String string = ((EncryptStringCallbackRequest)sessionCallbackRequest).getString();
                String string2 = passEncrypt.encryptString(string, "");
                ((EncryptStringCallbackResponse)sessionCallbackResponse).setEncryptedString(string2);
                return true;
            }
        } else if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.decrypt_string) {
            if (sessionCallbackResponse instanceof DecryptStringCallbackResponse) {
                PassEncrypt passEncrypt = new PassEncrypt();
                String string = ((DecryptStringCallbackRequest)sessionCallbackRequest).getString();
                String string3 = passEncrypt.decryptPrintableString(string.getBytes(), "");
                ((DecryptStringCallbackResponse)sessionCallbackResponse).setDecryptedString(string3);
                return true;
            }
        } else {
            if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.get_datetime_formats) {
                String string = ((GetDateTimeFormatsCallbackRequest)sessionCallbackRequest).getAttributeName();
                if (string.startsWith("ISO8601_")) {
                    string = string.substring(8, string.length());
                    ((GetDateTimeFormatsCallbackResponse)sessionCallbackResponse).setAtrribute((Object)this.getISO8601DateTimePattern(string));
                } else {
                    ((GetDateTimeFormatsCallbackResponse)sessionCallbackResponse).setAtrribute((Object)this.getDateTimePattern(string));
                }
                return true;
            }
            if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.get_attribute) {
                String string = (String)((GetAttributeCallbackRequest)sessionCallbackRequest).getRequest();
                if (string.equals("session.credentialDescriptor")) {
                    String string4 = (String)sessionCallbackRequest.getProperty("credential");
                    if (string4 != null) {
                        List list = PES_Repository.getCredentialDefinitions();
                        for (PESRepositoryCredential pESRepositoryCredential : list) {
                            if (!pESRepositoryCredential.getDefinitionName().equals(string4)) continue;
                            sessionCallbackResponse.setProperty("definitionName", (Object)pESRepositoryCredential.getDefinitionName());
                            sessionCallbackResponse.setProperty("username", (Object)pESRepositoryCredential.getUserName());
                            sessionCallbackResponse.setProperty("password", (Object)pESRepositoryCredential.getPassword());
                            sessionCallbackResponse.setProperty("credentialDomain", (Object)pESRepositoryCredential.getDomain());
                            return true;
                        }
                    }
                    return false;
                }
            } else if (sessionCallbackRequest.getCallbackType() == SessionCallbackType.data_model) {
                ISpssDataSrc iSpssDataSrc;
                CFDataModel cFDataModel = (CFDataModel)((CreateDataModelRequest)sessionCallbackRequest).getInputDataModel();
                List list = ((CreateDataModelRequest)sessionCallbackRequest).getDataModelOperations();
                if (list == null || list.size() != 1) {
                    return false;
                }
                ReplaceDataModelImpl replaceDataModelImpl = (ReplaceDataModelImpl)list.get(0);
                String string = replaceDataModelImpl.getNewDatasetName();
                String string5 = cFDataModel.sameDataset(string);
                if (string5.length() > 0 && (iSpssDataSrc = this.getDataSource(string5)) != null) {
                    CFDataModelProvider cFDataModelProvider = new CFDataModelProvider(iSpssDataSrc);
                    ((CreateDataModelResponse)sessionCallbackResponse).setDataModelProvider((DataModelProvider)cFDataModelProvider);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean showCDBHelpPath(String string, String string2) {
        String string3;
        boolean bl = false;
        String string4 = string;
        if (string4.startsWith("spss.")) {
            string4 = string.substring(5);
        }
        if ((string3 = string2.contains(File.separator) ? string2 : this.findHelpPath(string4, string2)).length() == 0) {
            return bl;
        }
        File file = new File(string3 = this.getLocalizedURLPath(string3));
        if (file.exists()) {
            BrowserLaunch.getBrowserLaunch().openURL(string3);
            bl = true;
        }
        return bl;
    }

    private String findHelpPath(String string, String string2) {
        File file;
        String[] stringArray;
        String string3 = "";
        for (String string4 : stringArray = CommandExecutor.getSecondaryExtensionFolders()) {
            file = new File(string4 + File.separator + string + File.separator + string2);
            if (!file.exists()) continue;
            return string4 + File.separator + string + File.separator + string2;
        }
        String string5 = CommandExecutor.getAppdataCustomDialogDirectoryForAllUsers();
        if (string5 != null && (file = new File(string5 + File.separator + string + File.separator + string2)).exists()) {
            return string5 + File.separator + string + File.separator + string2;
        }
        String string6 = CommandExecutor.getAppdataCustomDialogDirectory();
        if (string6 != null && (file = new File(string6 + File.separator + string + File.separator + string2)).exists()) {
            return string6 + File.separator + string + File.separator + string2;
        }
        return string3;
    }

    private String getLocalizedURLPath(String string) {
        String string2;
        String string3;
        File file = new File(string);
        Locale locale = Locale.getDefault();
        String string4 = file.getName();
        int n = string4.lastIndexOf(".");
        if (locale.getCountry().length() > 0) {
            string3 = string4.substring(0, n) + "_" + locale.getLanguage() + "_" + locale.getCountry() + string4.substring(n);
            string2 = file.getParent() + File.separator + string3;
            if (new File(string2).exists()) {
                return string2;
            }
        }
        if (locale.getLanguage().length() > 0) {
            string3 = string4.substring(0, n) + "_" + locale.getLanguage() + string4.substring(n);
            string2 = file.getParent() + File.separator + string3;
            if (new File(string2).exists()) {
                return string2;
            }
        }
        return string;
    }

    private ISpssDataSrc getDataSource(String string) {
        SpssFrame[] spssFrameArray;
        for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            DataFrame dataFrame;
            if (!(spssFrame instanceof DataFrame) || !string.equals((dataFrame = (DataFrame)spssFrame).getDatasetName())) continue;
            return dataFrame.getDataSource();
        }
        return null;
    }

    private String getDateTimePattern(String string) {
        Field field;
        if (this.mDataModel != null && (field = this.mDataModel.getField(string)) != null && field instanceof CFField) {
            if (field.getFieldStorage() == StorageType.string) {
                return SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            }
            return ((CFField)field).getDateTimePattern();
        }
        return "";
    }

    private String getISO8601DateTimePattern(String string) {
        Field field;
        if (this.mDataModel != null && (field = this.mDataModel.getField(string)) != null && field instanceof CFField) {
            return ((CFField)field).getISO8601TimePattern();
        }
        return "";
    }

    private boolean validateValue(ApplicationConditionRequest applicationConditionRequest, SessionCallbackResponse sessionCallbackResponse) {
        if (applicationConditionRequest.getCallbackId().equals("byteLengthGreaterThan")) {
            List list = (List)applicationConditionRequest.getRequest();
            String string = list.get(0).toString();
            Integer n = (Integer)list.get(1);
            if (string == null || n == null) {
                return false;
            }
            int n2 = Integer.MAX_VALUE;
            try {
                n2 = string.getBytes(ComponentState.getCurrentCharset().name()).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (n2 > n) {
                sessionCallbackResponse.setErrorMessage("Bad value");
                sessionCallbackResponse.setResponse((Object)false);
            } else {
                sessionCallbackResponse.setResponse((Object)true);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("dont_enable_in_modeler")) {
            if (CommandLine.isClementineCaller()) {
                sessionCallbackResponse.setErrorMessage("Not in Modeler");
                sessionCallbackResponse.setResponse((Object)false);
            } else {
                sessionCallbackResponse.setResponse((Object)true);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("isInClientMode")) {
            sessionCallbackResponse.setErrorMessage(null);
            if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
                sessionCallbackResponse.setResponse((Object)true);
            } else {
                sessionCallbackResponse.setResponse((Object)false);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("is_distributed_mode")) {
            if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
                sessionCallbackResponse.setErrorMessage("distributed=true");
                sessionCallbackResponse.setResponse((Object)false);
            } else {
                sessionCallbackResponse.setResponse((Object)true);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("is_licensed_for")) {
            List list = (List)applicationConditionRequest.getRequest();
            Integer n = (Integer)list.get(0);
            LicenseOption licenseOption = this.codeToLicense(n);
            LicenseManager.Status status = LicenseManager.getLicenseManager().getStatus(licenseOption);
            if (status != LicenseManager.Status.VALID) {
                sessionCallbackResponse.setErrorMessage("Not licensed");
                sessionCallbackResponse.setResponse((Object)true);
            } else {
                sessionCallbackResponse.setResponse((Object)false);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("duplicateFieldName")) {
            List list = (List)applicationConditionRequest.getRequest();
            String string = list.get(0).toString();
            String string2 = list.get(1).toString();
            if (string == null || string == null) {
                return false;
            }
            if (string.equals(string2)) {
                sessionCallbackResponse.setErrorMessage("Bad value");
                sessionCallbackResponse.setResponse((Object)false);
            } else {
                sessionCallbackResponse.setResponse((Object)true);
            }
            return true;
        }
        if (applicationConditionRequest.getCallbackId().equals("duplicateStructureFieldName")) {
            Object object;
            Object object2;
            Vector<String> vector;
            boolean bl = true;
            String string = "";
            List list = (List)applicationConditionRequest.getRequest();
            Vector<Object> vector2 = new Vector<Object>();
            if (list.get(0) instanceof List) {
                vector = (Vector<String>)list.get(0);
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = "";
                    if (vector.get(i) instanceof DefaultStructure) {
                        object = (DefaultStructure)vector.get(i);
                        object2 = (String)object.getAttributeValue("fieldName");
                    } else {
                        object2 = vector.get(i).toString();
                    }
                    vector2.add(object2);
                }
            } else if (list.get(0) instanceof String) {
                vector2.add((String)list.get(0));
            }
            vector = new Vector<String>();
            if (list.get(1) instanceof DefaultStructure) {
                DefaultStructure defaultStructure = (DefaultStructure)list.get(1);
                object2 = (List)defaultStructure.getAttributeValue("items");
                object = object2.iterator();
                while (object.hasNext()) {
                    String string3;
                    Structure structure = (Structure)object.next();
                    Object object3 = structure.getAttributeValue("fieldName");
                    if (object3 == null) {
                        object3 = structure.getAttributeValue("metricfieldname");
                    }
                    if (object3 == null || vector.contains(string3 = object3.toString())) continue;
                    vector.add(string3);
                }
            } else if (list.get(1) instanceof List) {
                List list2 = (List)list.get(1);
                for (int i = 0; i < list2.size(); ++i) {
                    vector.add(list2.get(i).toString());
                }
            }
            block5: for (int i = 0; i < vector2.size() && bl; ++i) {
                String string4 = (String)vector2.get(i);
                for (int j = 0; j < vector.size() && bl; ++j) {
                    if (!string4.equals(vector.get(j))) continue;
                    bl = false;
                    string = string4;
                    continue block5;
                }
            }
            sessionCallbackResponse.setResponse((Object)bl);
            if (!bl) {
                sessionCallbackResponse.setErrorMessage(string);
            }
            return bl;
        }
        return false;
    }

    public FrameworkSessionSupport getFrameworkSessionSupport() {
        return this.mFrameworkSessionSupport;
    }

    public Object getPreferenceValue(String string) {
        if (string.equals("use_customized_roles") || string.equals("use_custom_split_fields")) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            return !preferences.getBoolean("use_roles", true);
        }
        if (string.equals("use_predefined_roles")) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            return preferences.getBoolean("use_roles", true);
        }
        if (string.equals("get_unique_dataset_name")) {
            return DataDocument.getNextFreeDatasetName((boolean)true);
        }
        if (string.equals("show_field_list_labels")) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            String string2 = preferences.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS);
            return string2.equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        }
        if (string.equals("sort_fields_order")) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            String string3 = preferences.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
            if (string3.equals(IOptionConstants.VAR_LIST_SORT_VALUES[0])) {
                return FieldSortMode.name;
            }
            if (string3.equals(IOptionConstants.VAR_LIST_SORT_VALUES[2])) {
                return FieldSortMode.measurement;
            }
            return FieldSortMode.natural;
        }
        if (string.equals("use_frequency_weight")) {
            return false;
        }
        return null;
    }

    public FrameworkUISupport getFrameworkUISupport() {
        return this.mFrameworkSwingSupport;
    }

    public FrameworkSwingSupport getFrameworkSwingSupport() {
        return this.mFrameworkSwingSupport;
    }

    public void notifyCharsetChange(String string) {
        this.mEncodingValidator.setEncoding(Charset.forName(string));
    }

    private boolean runFileSystemChooser(SessionCallbackRequest sessionCallbackRequest, SessionCallbackResponse sessionCallbackResponse) {
        Object object2;
        String string;
        String string2;
        FileSystemChooserRequest fileSystemChooserRequest = (FileSystemChooserRequest)sessionCallbackRequest;
        boolean bl = fileSystemChooserRequest.isServerChooser();
        String string3 = bl ? FileLocationsUtil.getDataFilesDirectoryPath() : FileLocationsUtil.getOtherFilesDirectoryPath();
        String string4 = fileSystemChooserRequest.getInitialDirectory();
        if (string4 != null && string4.length() > 0) {
            string3 = string4;
        }
        boolean bl2 = fileSystemChooserRequest.isDirectoryChooser();
        boolean bl3 = fileSystemChooserRequest.isOpenChooser();
        RemoteFileChooser.ChooserType chooserType = bl2 ? RemoteFileChooser.ChooserType.OpenFolder : (bl3 ? RemoteFileChooser.ChooserType.OpenFile : RemoteFileChooser.ChooserType.SaveFile);
        String string5 = fileSystemChooserRequest.getFileName();
        RemoteFileChooser.ChooserOption chooserOption = RemoteFileChooser.ChooserOption.Generic;
        Vector vector = fileSystemChooserRequest.getFilters();
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, chooserOption, string3, bl, true, string5 != null);
        remoteFileChooser.setAcceptAllFileFilterUsed(fileSystemChooserRequest.getUseAcceptAllFilter());
        if (string5 != null) {
            remoteFileChooser.setFileNameTextField(string5);
        }
        if ((string2 = fileSystemChooserRequest.getTitle()) != null && string2.length() > 0) {
            remoteFileChooser.setDialogTitle(string2);
        }
        if ((string = fileSystemChooserRequest.getApproveButtonText()) != null && string.length() > 0) {
            remoteFileChooser.setApproveButtonText(string);
        }
        SimpleFileFilter simpleFileFilter = null;
        int n = 0;
        int n2 = fileSystemChooserRequest.getDefaultFilterIndex();
        for (Object object2 : vector) {
            SimpleFileFilter simpleFileFilter2 = new SimpleFileFilter(object2.getDescription(), object2.getSuffixes());
            remoteFileChooser.addChoosableFileFilter((FileFilter)((Object)simpleFileFilter2));
            if (n++ != n2) continue;
            simpleFileFilter = simpleFileFilter2;
        }
        if (simpleFileFilter != null) {
            remoteFileChooser.setFileFilter((FileFilter)((Object)simpleFileFilter), true);
        }
        object2 = "";
        int n3 = bl3 ? remoteFileChooser.showOpenDialog(fileSystemChooserRequest.getParentComponent()) : remoteFileChooser.showSaveDialog(fileSystemChooserRequest.getParentComponent());
        if (n3 == 0) {
            sessionCallbackResponse.setResponse((Object)remoteFileChooser.getSelectedFilePath());
            String string6 = remoteFileChooser.getEncryptFilePassword();
            if (string6 != null && string6.length() > 0) {
                String string7 = this.getMangledPassword(string6);
                object2 = SaveSyntaxGenerator.getEncryptFileSyntax((String)string7, (boolean)true);
                sessionCallbackResponse.setProperty(ServerBrowserControl.sENCRYPT_SYNTAX, object2);
            }
        }
        return n3 == 0;
    }

    private String getMangledPassword(String string) {
        PassEncrypt passEncrypt = new PassEncrypt();
        try {
            byte[] byArray = passEncrypt.encryptPrintableString(string.getBytes("UTF-8"), "'\"");
            string = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    private boolean isSaveStatsData(Vector<FileSystemChooserRequest.CFFileFilter> vector) {
        boolean bl = false;
        if (vector.size() > 0) {
            FileSystemChooserRequest.CFFileFilter cFFileFilter = vector.get(0);
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter(cFFileFilter.getDescription(), cFFileFilter.getSuffixes());
            if (!bl) {
                bl = simpleFileFilter.isStatsData();
            }
        }
        return bl;
    }

    private boolean validateString(String string, SessionCallbackResponse sessionCallbackResponse) {
        if (!this.mEncodingValidator.validateString(string)) {
            CoderResult coderResult = this.mEncodingValidator.getResult();
            boolean bl = coderResult.equals(CoderResult.OVERFLOW);
            String string2 = bl ? "ERR_STRING_OVERFLOW_MSG" : "ERR_STRING_UNMAPPABLE_MSG";
            String string3 = UIToolResUtil.getString((String)string2);
            sessionCallbackResponse.setErrorMessage(string3);
            return true;
        }
        return false;
    }

    private boolean validateValue(ValidateValueRequest validateValueRequest, ValidateValueResponse validateValueResponse) {
        String string;
        String string2 = validateValueRequest.getCallbackId();
        String string3 = string = validateValueRequest.getRequest() != null ? validateValueRequest.getRequest().toString() : "";
        if (string2.equals("validate_field_name")) {
            VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
            if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
                validateValueResponse.setErrorMessage("Bad field name");
                validateValueResponse.setResponse((Object)VarNameValidator.generateSPSSRootName((String)string));
            }
            return true;
        }
        if (string2.equals("validate_field_name_suffix")) {
            VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)("a" + string), (boolean)true);
            if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
                validateValueResponse.setErrorMessage("Bad field suffix");
            }
            return true;
        }
        if (string2.equals("is_duplicate_field_name")) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(SpssMgr.getSpssMgr().getActiveClientDatasetId());
            if (iSpssDataSrc.findVarIndex(string) > -1) {
                validateValueResponse.setErrorMessage("Duplicate field name");
            }
            return true;
        }
        if (string2.equals("validate_dataset_name")) {
            VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
            if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
                validateValueResponse.setErrorMessage("Bad dataset name");
            } else if (DataMgr.getDataMgr().getDataSource(string) != null) {
                validateValueResponse.setErrorMessage("Duplicate dataset name");
            }
            return true;
        }
        if (string2.equals("validate_client_path")) {
            if (!FileValidator.validatePath(null, string, false, false)) {
                validateValueResponse.setErrorMessage("Invalid client path");
            }
            return true;
        }
        if (string2.equals("validate_server_path")) {
            int n = FileValidator.validatePath(null, string, false, true, true);
            if (n == -1) {
                validateValueResponse.setErrorMessage("Invalid server path");
            }
            return true;
        }
        if (string2.equals("validate_server_file_exists")) {
            int n = FileValidator.validatePath(null, string, false, true, true);
            if (n == 3) {
                validateValueResponse.setErrorMessage("File exists");
            }
            return true;
        }
        return false;
    }

    private boolean executeBackendFeature(ExecutionRequest executionRequest, ExecutionResponse executionResponse) {
        boolean bl = false;
        ExecutionHandle executionHandle = executionRequest.getRequest();
        executionHandle.setExecutionState(ExecutionState.error);
        Task task = executionHandle.getTask();
        if (!(task instanceof ExecutionTask)) {
            return false;
        }
        ExecutionTask executionTask = (ExecutionTask)task;
        try {
            Element element = ExecutionXML.getExecutionXML((ExecutionTask)executionTask);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ExecutionXML.getInstance().writeDocument((OutputStream)byteArrayOutputStream, element);
            CFExecutionResponse cFExecutionResponse = SysFileProxy.getSysFileProxy().executeBackendFrameworkOperation(SpssMgr.getSpssMgr().getActiveClientDatasetId(), byteArrayOutputStream.toByteArray(), 3600000);
            if (cFExecutionResponse != null) {
                if (cFExecutionResponse.getErrorCode() == 0) {
                    Object object;
                    DefaultContainer defaultContainer = new DefaultContainer(false);
                    Object object2 = cFExecutionResponse.getResponseStream();
                    if (object2 != null && ((byte[])object2).length > 0 && object2[((byte[])object2).length - 1] == 0) {
                        object = new byte[((byte[])object2).length - 1];
                        System.arraycopy(object2, 0, object, 0, ((byte[])object2).length - 1);
                        object2 = object;
                    }
                    defaultContainer.setContentFromInputStream((InputStream)new ByteArrayInputStream((byte[])object2));
                    object = this.getContainerName(element, cFExecutionResponse.getContainerId());
                    if (object != null && !defaultContainer.isEmpty()) {
                        DefaultContainerSet defaultContainerSet = new DefaultContainerSet();
                        defaultContainerSet.setContainer((String)object, (com.pasw.framework.common.container.Container)defaultContainer);
                        executionHandle.setExecutionResult((Object)defaultContainerSet);
                        executionHandle.setExecutionState(ExecutionState.completed);
                        bl = true;
                    } else if (cFExecutionResponse.getErrorXml() != null && cFExecutionResponse.getErrorXml().length > 0) {
                        this.displayMessages((Window)((Object)ProcedureDlgMgr.getMgr().getLastDialog()), new ByteArrayInputStream(cFExecutionResponse.getErrorXml()), -1);
                    }
                } else {
                    String string = cFExecutionResponse.getErrorCode() == 1 ? "ERR_NO_XFORMS" : "ERR_INTERNAL_ERROR";
                    String string2 = ResUtil.getCommonDlgString(string);
                    ErrorDispatcher.getErrorDispatcher().dispatchError(string2, "client-server CF error");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private String getContainerName(Element element, String string) throws ItemContentException {
        DocItem docItem;
        Iterator iterator;
        String string2 = null;
        DocItem docItem2 = new DocItem(element);
        Iterator iterator2 = docItem2.getDocRoot().getItems("Operation");
        if (iterator2.hasNext() && (iterator = (docItem = (DocItem)iterator2.next()).getItems("OutputContainers")).hasNext()) {
            Iterator iterator3 = ((DocItem)iterator.next()).getItems("Container");
            while (iterator3.hasNext()) {
                DocItem docItem3 = (DocItem)iterator3.next();
                String string3 = docItem3.getAttribute("id");
                if (string3.compareTo(string) != 0) continue;
                string2 = docItem3.getAttribute("name");
                break;
            }
        }
        return string2;
    }

    private boolean runUIAction(SessionCallbackRequest sessionCallbackRequest, SessionCallbackResponse sessionCallbackResponse) {
        if (sessionCallbackRequest.getRequest() instanceof String) {
            String string = (String)sessionCallbackRequest.getRequest();
            if (string.equals("savePMML")) {
                if (this.savePMML(sessionCallbackRequest)) {
                    return true;
                }
            } else {
                if (string.equals("stopProcessing")) {
                    SysFileProxy.getSysFileProxy().sendInterruptMsg();
                    return true;
                }
                if (string.equals("invokeCredentialDialog")) {
                    String string2 = this.invokeSelectCredentialDialog((UICallbackRequest)sessionCallbackRequest);
                    if (string2 != null && !"".equals(string2)) {
                        sessionCallbackResponse.setProperty("credential", (Object)string2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private String invokeSelectCredentialDialog(UICallbackRequest uICallbackRequest) {
        String string = null;
        SwingFeatureUI swingFeatureUI = (SwingFeatureUI)uICallbackRequest.getUIHandle();
        JDialog jDialog = null;
        if (swingFeatureUI != null) {
            jDialog = this.findOwningDialog((Component)swingFeatureUI.getUIElement());
        }
        if (jDialog != null) {
            ActionListener actionListener;
            CFProcedureDialog cFProcedureDialog = (CFProcedureDialog)((Object)jDialog);
            Repository repository = PES_Repository.getRepository();
            if (repository == null) {
                actionListener = new PerConnectAction();
                ((PerConnectAction)actionListener).doConnect((SpssFrame)cFProcedureDialog.getParent(), true, false);
                repository = PES_Repository.getRepository();
                PESBrowser.incrementLoginCount();
            }
            if (repository != null) {
                actionListener = new SpssProgressDlg((Window)((Object)cFProcedureDialog), ResUtil.getString("IDS_CREDENTIAL_LOADER_TITLE"), false);
                ((SpssProgressDlg)actionListener).setMessage(ResUtil.getString("IDS_CREDENTIAL_LOADER_MESSAGE"));
                Thread thread = new Thread(new Runnable((SpssProgressDlg)actionListener){
                    final /* synthetic */ SpssProgressDlg val$progressBar;
                    {
                        this.val$progressBar = spssProgressDlg;
                    }

                    @Override
                    public void run() {
                        PES_Repository.getCredentialDefinitions();
                        this.val$progressBar.setWorkDone(true);
                        this.val$progressBar.dispose();
                    }
                });
                thread.start();
                ((Window)((Object)actionListener)).setLocationRelativeTo((Component)((Object)cFProcedureDialog));
                ((Dialog)((Object)actionListener)).setVisible(true);
                List list = PES_Repository.getCredentialDefinitions();
                LinkedList<String> linkedList = new LinkedList<String>();
                for (PESRepositoryCredential pESRepositoryCredential : list) {
                    linkedList.add(pESRepositoryCredential.getDefinitionName());
                }
                RepositoryCredentialListDlg repositoryCredentialListDlg = new RepositoryCredentialListDlg(jDialog, linkedList);
                repositoryCredentialListDlg.setLocationRelativeTo(jDialog);
                repositoryCredentialListDlg.setVisible(true);
                string = repositoryCredentialListDlg.getSelectedCredName();
            }
        }
        return string;
    }

    private JDialog findOwningDialog(Component component) {
        if (component instanceof JDialog) {
            return (JDialog)component;
        }
        Container container = component.getParent();
        if (container != null) {
            return this.findOwningDialog(container);
        }
        return null;
    }

    private boolean runInteraction(SessionCallbackRequest sessionCallbackRequest, SessionCallbackResponse sessionCallbackResponse) {
        boolean bl = true;
        CFInteractionResponse cFInteractionResponse = SysFileProxy.getSysFileProxy().runInteraction(sessionCallbackRequest, sessionCallbackResponse, 3600000);
        return bl;
    }

    private boolean savePMML(SessionCallbackRequest sessionCallbackRequest) {
        boolean bl = false;
        RunUIActionRequest runUIActionRequest = (RunUIActionRequest)sessionCallbackRequest;
        if (runUIActionRequest.getUIHandle() instanceof FeatureUI) {
            FeatureUI featureUI = (FeatureUI)runUIActionRequest.getUIHandle();
            String string = runUIActionRequest.getParameter();
            ControlManager controlManager = featureUI.getControlManager();
            ContainerSetProvider containerSetProvider = controlManager.getContainerSetProvider();
            if (containerSetProvider != null) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
                remoteFileChooser.setDialogTitle(ResUtil.getString("IDS_SAVE_PMML_TITLE"));
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                RefFileFilter refFileFilter = new RefFileFilter(ResUtil.getString("IDS_SAVE_PMML_DESC"), "xml");
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                if (remoteFileChooser.showSaveDialog((Component)((Object)ProcedureDlgMgr.getMgr().getLastDialog())) == 0) {
                    ((FeatureImpl)containerSetProvider).updateContainer(string);
                    com.pasw.framework.common.container.Container container = containerSetProvider.getContainer(string);
                    try {
                        int n;
                        InputStream inputStream = container.getContentFromInputStream();
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[4096];
                        while ((n = inputStreamReader.read(cArray)) != -1) {
                            stringBuffer.append(new String(cArray, 0, n));
                        }
                        ((Reader)inputStreamReader).close();
                        String string2 = stringBuffer.toString();
                        bl = this.savePMMLDocument(remoteFileChooser.getSelectedFile(), ComponentState.getCurrentCharset(), string2);
                    }
                    catch (IOException iOException) {
                        AlertOptionPane.showErrorMessageDialog((Window)((Object)ProcedureDlgMgr.getMgr().getLastDialog()), (String)iOException.getLocalizedMessage(), (String)VersionInfo.getAppVersionString());
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean savePMMLDocument(File object, Charset charset, String string) {
        Object object2;
        Object object3;
        Object object4;
        if (object == null) {
            return false;
        }
        PesFile pesFile = PES_Repository.getPesFile((String)((File)object).getAbsolutePath());
        boolean bl = false;
        if (pesFile == null) {
            if (((File)object).exists() && !((File)object).canWrite()) {
                return false;
            }
        } else if (this.mFileSpec == null || ((File)object).compareTo(this.mFileSpec) != 0) {
            object4 = object;
            object3 = new File(PrefsMgr.getPrefsMgr().getTempPath());
            try {
                if (this.mFileSpec == null) {
                    object2 = new File((File)object3, ((File)object).getName());
                    object = ((File)object2).createNewFile() ? object2 : PASWFileUtil.createTempFile((String)"pes", (String)"", object3);
                } else {
                    object = PASWFileUtil.createTempFile((String)"pes", (String)"", (File)object3);
                    bl = true;
                }
            }
            catch (IOException iOException) {
                object = object4;
                pesFile = null;
            }
        }
        try {
            object4 = new FileOutputStream((File)object);
            if (charset.name().equals("UTF-8")) {
                object3 = new byte[]{-17, -69, -65};
                ((FileOutputStream)object4).write((byte[])object3);
            }
            object3 = new StringBuffer(string);
            ((FileOutputStream)object4).write(((StringBuffer)object3).toString().getBytes(charset.name()));
            ((FileOutputStream)object4).close();
            if (pesFile != null) {
                if (pesFile.getResourceAtrributes() == null) {
                    int n = PES_Repository.MapFilterToMimeType((String)"(*.sps)");
                    object2 = PES_Repository.StoreToPES((File)object, (PesFile)pesFile, (int)n, (String)charset.name());
                } else {
                    object2 = PES_Repository.StoreToPES((File)object, (PesFile)pesFile);
                }
                if (bl) {
                    ((File)object).delete();
                    PES_Repository.removeFromPesCache((File)object);
                } else {
                    this.mFileSpec = object;
                }
                if (object2 != null) {
                    AlertOptionPane.showErrorMessageDialog((Window)((Object)ProcedureDlgMgr.getMgr().getLastDialog()), (String)object2, (String)VersionInfo.getAppVersionString());
                    return false;
                }
            } else {
                this.mFileSpec = object;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void displayMessages(Window window, InputStream inputStream, int n) {
        if (inputStream != null) {
            String string = null;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName("Message");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node = node.getFirstChild();
                    stringBuffer.append(node.getNodeValue());
                    if (i >= n && n != -1) break;
                    if (i >= nodeList.getLength() - 1) continue;
                    stringBuffer.append("\n");
                }
                AlertOptionPane.showErrorMessageDialog((Window)window, (String)stringBuffer.toString(), (String)VersionInfo.getAppVersionString());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = parserConfigurationException.getLocalizedMessage();
            }
            catch (SAXException sAXException) {
                string = sAXException.getLocalizedMessage();
            }
            catch (IOException iOException) {
                string = iOException.getLocalizedMessage();
            }
            if (string != null) {
                AlertOptionPane.showErrorMessageDialog((Window)window, (String)string, (String)VersionInfo.getAppVersionString());
            }
        }
    }

    private LicenseOption codeToLicense(int n) {
        for (LicenseOption licenseOption : LicenseOption.values()) {
            if (licenseOption.getIntValue() != n) continue;
            return licenseOption;
        }
        return LicenseOption.EXTENDED_BASE;
    }

    public class SimpleFileFilter
    extends RefFileFilter {
        private final String mDescription;
        private final String[] mSuffixes;

        public SimpleFileFilter(String string, String string2) {
            this(string, new String[]{string2});
        }

        public SimpleFileFilter(String string, String[] stringArray) {
            super(string, stringArray[0]);
            this.mDescription = string;
            this.mSuffixes = stringArray;
        }

        public boolean accept(File file) {
            return file.isDirectory() || this.hasValidSuffix(file.getName());
        }

        protected boolean hasValidSuffix(String string) {
            for (String string2 : this.mSuffixes) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String[] getSuffixes() {
            return this.mSuffixes;
        }

        boolean isStatsData() {
            boolean bl = false;
            if (this.mSuffixes != null && this.mSuffixes.length == 1) {
                bl = this.mSuffixes[0].equals(".sav");
            }
            return bl;
        }
    }
}

