/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.datamodel;

import com.pasw.framework.common.data.ValidValueDescriptor;
import com.pasw.framework.common.data.ValidValueType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.cf_integration.datamodel.CFField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CFValidValueDescriptor
implements ValidValueDescriptor {
    TreeMap<Object, String> valueLabels = new TreeMap();
    List<Object> values;

    public CFValidValueDescriptor(ISpssVariable iSpssVariable) {
        ArrayList arrayList = null;
        if (iSpssVariable.isDimensionVariable()) {
            arrayList = iSpssVariable.getDimensionValues();
        }
        if (arrayList != null && arrayList.size() > 0) {
            for (Object e : arrayList) {
                this.valueLabels.put(e.toString(), e.toString());
            }
        } else if (iSpssVariable.getValueLabels() != null) {
            boolean bl = iSpssVariable.getType() > 0;
            for (Map.Entry entry : iSpssVariable.getValueLabels().getValueLabelEntries()) {
                OBS oBS = (OBS)entry.getKey();
                if (bl) {
                    this.valueLabels.put(oBS.getString(), (String)entry.getValue());
                    continue;
                }
                this.valueLabels.put(CFField.reconcileDateValue(iSpssVariable, oBS.getNum()), (String)entry.getValue());
            }
        }
        this.values = Collections.unmodifiableList(new ArrayList<Object>(this.valueLabels.keySet()));
    }

    public int getValueCount() {
        return this.valueLabels.size();
    }

    public List<Object> getValues() {
        return new ArrayList<Object>(this.valueLabels.keySet());
    }

    public Object getFlagFalse() {
        return this.values.size() > 0 ? this.values.get(0) : null;
    }

    public Object getFlagTrue() {
        return this.values.size() > 1 ? this.values.get(1) : null;
    }

    public Object getValidValue(ValidValueType validValueType) {
        Object object = null;
        if (validValueType == ValidValueType.flagFalse) {
            object = this.values.size() > 0 ? this.values.get(0) : null;
        } else if (validValueType == ValidValueType.flagTrue) {
            object = this.values.size() > 1 ? this.values.get(1) : null;
        } else if (validValueType == ValidValueType.partitionTraining) {
            object = this.values.size() > 0 ? this.values.get(0) : null;
        } else if (validValueType == ValidValueType.partitionTesting) {
            object = this.values.size() > 1 ? this.values.get(1) : null;
        } else if (validValueType == ValidValueType.partitionValidation) {
            object = this.values.size() > 2 ? this.values.get(2) : null;
        }
        return object;
    }

    public boolean hasRange() {
        return false;
    }

    public Object getRangeLowerBound() {
        return null;
    }

    public Object getRangeUpperBound() {
        return null;
    }
}

