/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.datamodel;

import com.pasw.framework.common.data.MissingValueDescriptor;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.cf_integration.datamodel.CFField;
import java.util.ArrayList;
import java.util.List;

public class CFMissingValueDescriptor
implements MissingValueDescriptor {
    private boolean isString;
    private OBS[] obses;
    private ISpssVariable.Rule rule;
    private ISpssVariable variable;

    public CFMissingValueDescriptor(ISpssVariable iSpssVariable) {
        this.variable = iSpssVariable;
        this.isString = iSpssVariable.getType() > 0;
        this.obses = new OBS[]{new OBS(), new OBS(), new OBS()};
        this.rule = iSpssVariable.getMissingValues(this.obses[0], this.obses[1], this.obses[2]);
    }

    public int getValueCount() {
        if (this.rule.value() < 0) {
            return this.rule == ISpssVariable.Rule.range ? 0 : 1;
        }
        return this.rule.value();
    }

    public List<Object> getValues() {
        int n = this.rule.value();
        n = Math.abs(n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isString) {
            if (n > 0) {
                arrayList.add(this.obses[0].getString());
            }
            if (n > 1) {
                arrayList.add(this.obses[1].getString());
            }
            if (n > 2) {
                arrayList.add(this.obses[2].getString());
            }
        } else {
            if (n > 0) {
                arrayList.add(CFField.reconcileDateValue(this.variable, this.obses[0].getNum()));
            }
            if (n > 1) {
                arrayList.add(CFField.reconcileDateValue(this.variable, this.obses[1].getNum()));
            }
            if (n > 2) {
                arrayList.add(CFField.reconcileDateValue(this.variable, this.obses[2].getNum()));
            }
        }
        return arrayList;
    }

    public boolean hasRange() {
        return this.rule.value() < 0;
    }

    public Object getRangeLowerBound() {
        if (this.rule.value() < 0) {
            return this.isString ? this.obses[0].getString() : CFField.reconcileDateValue(this.variable, this.obses[0].getNum());
        }
        return null;
    }

    public Object getRangeUpperBound() {
        if (this.rule.value() < 0) {
            return this.isString ? this.obses[1].getString() : CFField.reconcileDateValue(this.variable, this.obses[1].getNum());
        }
        return null;
    }

    public boolean isNullIncluded() {
        return false;
    }

    public boolean isWhitespaceIncluded() {
        return false;
    }
}

