/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.datamodel;

import com.pasw.framework.common.ExtendedValue;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.MeasurementType;
import com.pasw.framework.common.data.MissingValueDescriptor;
import com.pasw.framework.common.data.ModelOutputDescriptor;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.pasw.framework.common.data.ValidValueDescriptor;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.ui.cf_integration.datamodel.CFMissingValueDescriptor;
import com.spss.java_client.ui.cf_integration.datamodel.CFValidValueDescriptor;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.shared.core_tools.format.ValueFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class CFField
implements Field {
    private ISpssVariable mVariable;
    private CFMissingValueDescriptor mMissingDef;
    private boolean mIsWeightVar;
    private boolean mIsSplitVar;
    private CFValidValueDescriptor mValueDef;
    private Map<ExtendedValue, Object> extendedValues = new HashMap<ExtendedValue, Object>();
    private boolean mIsDimensionVar;

    public CFField(ISpssVariable iSpssVariable, boolean bl, boolean bl2) {
        this.mVariable = iSpssVariable;
        this.mMissingDef = new CFMissingValueDescriptor(iSpssVariable);
        this.mIsSplitVar = bl;
        this.mIsWeightVar = bl2;
        this.mValueDef = new CFValidValueDescriptor(iSpssVariable);
    }

    public String getFieldName() {
        return this.mVariable.getName();
    }

    public String getFieldLabel() {
        return this.mVariable.getLabel();
    }

    public MeasurementType getFieldMeasurement() {
        return this.measurementLevelToType(this.mVariable.getMeasurementLevel());
    }

    public StorageType getFieldStorage() {
        StorageType storageType = StorageType.real;
        FormatType formatType = this.mVariable.getFormat().getFormatType();
        if (this.mVariable.getType() > 0) {
            storageType = StorageType.string;
        } else if (formatType.isDateOrTimeFormat()) {
            storageType = formatType == FormatType.TIME || formatType == FormatType.DTIME || formatType == FormatType.MTIME ? StorageType.time : (formatType == FormatType.DATETIME || formatType == FormatType.YMDHMS ? StorageType.timestamp : StorageType.date);
        }
        return storageType;
    }

    public String getDateTimePattern() {
        SpssDateFormatHelper spssDateFormatHelper;
        FormatType formatType = this.mVariable.getFormat().getFormatType();
        byte by = this.mVariable.getFormat().getDecimals();
        String string = "";
        if (formatType.isDateOrTimeFormat() && (spssDateFormatHelper = SpssDateFormatHelper.getClosestSpssDateFormatForFormatKey(formatType.toString(), this.mVariable.getFormat().getWidth() - by)) != null) {
            string = spssDateFormatHelper.getSimpleDateFormatPattern();
        }
        return string;
    }

    public String getISO8601TimePattern() {
        FormatType formatType = this.mVariable.getFormat().getFormatType();
        String string = "";
        if (formatType.isDateOrTimeFormat()) {
            byte by = this.mVariable.getFormat().getDecimals();
            if (formatType == FormatType.TIME) {
                SpssDateFormatHelper spssDateFormatHelper = SpssDateFormatHelper.getClosestSpssDateFormatForFormatKey(formatType.toString(), this.mVariable.getFormat().getWidth());
                if (spssDateFormatHelper != null) {
                    string = spssDateFormatHelper.getSimpleDateFormatPattern();
                }
            } else if (formatType == FormatType.DTIME) {
                string = SpssDateFormatHelper.eDEFAULT_ISO_TIME.getSimpleDateFormatPattern();
            } else if (formatType == FormatType.DATETIME) {
                string = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            } else if (formatType == FormatType.YMDHMS || formatType == FormatType.MTIME) {
                SpssDateFormatHelper spssDateFormatHelper = SpssDateFormatHelper.getClosestSpssDateFormatForFormatKey(formatType.toString(), this.mVariable.getFormat().getWidth() - by);
                if (spssDateFormatHelper != null) {
                    string = spssDateFormatHelper.getSimpleDateFormatPattern();
                }
            } else {
                string = SpssDateFormatHelper.eDEFAULT_ISO_DATE.getSimpleDateFormatPattern();
            }
        }
        return string;
    }

    public RoleType getFieldRole() {
        RoleType roleType;
        if (this.mIsSplitVar) {
            return RoleType.split;
        }
        if (this.mIsWeightVar) {
            return RoleType.freqWeight;
        }
        Role role = this.mVariable.getRole();
        switch (role) {
            case both: {
                roleType = RoleType.both;
                break;
            }
            case input: {
                roleType = RoleType.input;
                break;
            }
            case partition: {
                roleType = RoleType.partition;
                break;
            }
            case split: {
                roleType = RoleType.split;
                break;
            }
            case target: {
                roleType = RoleType.target;
                break;
            }
            default: {
                roleType = RoleType.none;
            }
        }
        return roleType;
    }

    public int getStringLength() {
        short s = this.mVariable.getType();
        if (s == 0) {
            return 0;
        }
        return s;
    }

    public boolean isModelOutputField() {
        return false;
    }

    public ModelOutputDescriptor getModelOutputDescriptor() {
        return null;
    }

    public ValidValueDescriptor getValidValueDescriptor() {
        return this.mValueDef;
    }

    public boolean hasValidValueDescriptor() {
        return this.mValueDef.getValueCount() > 0;
    }

    public int getFieldValueCount() {
        int n = 0;
        Iterator<Object> iterator = this.getValueLabelKeys();
        while (iterator.hasNext()) {
            if (this.isMissingValue(iterator.next())) continue;
            ++n;
        }
        return n;
    }

    public Object getFlagFalse() {
        return null;
    }

    public Object getFlagTrue() {
        return null;
    }

    public Number getRangeLowerBound() {
        return null;
    }

    public Number getRangeUpperBound() {
        return null;
    }

    public boolean isRangeKnown() {
        return false;
    }

    public Iterator<Object> getFieldValues() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator<Object> iterator = this.getValueLabelKeys();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.isMissingValue(object)) continue;
            linkedList.add(object);
        }
        return linkedList.iterator();
    }

    public boolean isValidValue(Object object) {
        return this.mVariable.getType() > 0 || object instanceof Number && this.mVariable.getType() == 0;
    }

    public boolean isMissingValue(Object object) {
        if (object instanceof Number) {
            return this.mVariable.isMissing(((Number)object).doubleValue());
        }
        return this.mVariable.isMissing(object.toString());
    }

    public boolean hasMissingValueDescriptor() {
        return this.mMissingDef.getValueCount() > 0;
    }

    public MissingValueDescriptor getMissingValueDescriptor() {
        return this.mMissingDef;
    }

    public boolean isMeasureUnorderedSet() {
        return this.mVariable.getMeasurementLevel() == MeasurementLevel.nominal;
    }

    public boolean isMeasureOrderedSet() {
        return this.mVariable.getMeasurementLevel() == MeasurementLevel.ordinal;
    }

    public boolean isMeasureFlag() {
        return false;
    }

    public boolean isMeasureContinuous() {
        return this.mVariable.getMeasurementLevel() == MeasurementLevel.scale;
    }

    public boolean isMeasureDiscrete() {
        return false;
    }

    public boolean isStorageInteger() {
        return this.mVariable.getType() == 0;
    }

    public boolean isStorageDecimal() {
        return this.mVariable.getType() == 0;
    }

    public boolean isStorageString() {
        return this.mVariable.getType() > 0;
    }

    public boolean isStorageDateTime() {
        FormatType formatType = this.mVariable.getFormat().getFormatType();
        return formatType.isDateOrTimeFormat();
    }

    public boolean isDimensionVar() {
        boolean bl = false;
        if (this.mVariable.getDimensionValues() != null && this.mVariable.getDimensionValues().size() > 0) {
            bl = true;
        }
        return bl;
    }

    public Iterator<Object> getValueLabelKeys() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = this.isStorageString();
        Iterator iterator = this.mVariable.getValueLabels().getValueLabelEntries().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                arrayList.add(((OBS)((Map.Entry)iterator.next()).getKey()).getString());
                continue;
            }
            arrayList.add(((OBS)((Map.Entry)iterator.next()).getKey()).getNum());
        }
        return arrayList.iterator();
    }

    public String getValueLabel(Object object) {
        OBS oBS = object instanceof Number ? new OBS(((Number)object).doubleValue()) : new OBS(object.toString());
        return this.mVariable.getValueLabels().get(oBS);
    }

    public static Object reconcileDateValue(ISpssVariable iSpssVariable, Double d) {
        if (d == null || iSpssVariable.isMissing(d.doubleValue())) {
            return d;
        }
        FormatType formatType = iSpssVariable.getFormat().getFormatType();
        if (!formatType.isDateOrTimeFormat()) {
            return d;
        }
        long l = ValueFormatter.convertDateDoubleToLong((double)d);
        return new Date(l);
    }

    private MeasurementType measurementLevelToType(MeasurementLevel measurementLevel) {
        MeasurementType measurementType;
        switch (measurementLevel) {
            case nominal: {
                measurementType = MeasurementType.nominal;
                break;
            }
            case ordinal: {
                measurementType = MeasurementType.ordinal;
                break;
            }
            case scale: {
                measurementType = MeasurementType.continuous;
                break;
            }
            case unknown: {
                if (this.mVariable.getType() > 0) {
                    measurementType = MeasurementType.nominal;
                    break;
                }
                measurementType = MeasurementType.continuous;
                break;
            }
            default: {
                measurementType = MeasurementType.unknown;
            }
        }
        return measurementType;
    }

    public Object getExtendedValue(ExtendedValue extendedValue) {
        return this.extendedValues.get(extendedValue);
    }

    public void setExtendedValue(ExtendedValue extendedValue, Object object) {
        this.extendedValues.put(extendedValue, object);
    }

    public boolean containsExtendedValue(ExtendedValue extendedValue) {
        return this.extendedValues.containsValue(extendedValue);
    }

    public Iterator<ExtendedValue> extendedValueTypes() {
        return this.extendedValues.keySet().iterator();
    }

    public Vector<String> getAttributeValues(String string) {
        return this.mVariable.getAttributeValues(string);
    }
}

