/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.cf_integration.datamodel;

import com.pasw.core.util.FieldListSorter;
import com.pasw.framework.common.ExtendedValue;
import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.FieldGroup;
import com.pasw.framework.common.data.FieldSortDirection;
import com.pasw.framework.common.data.FieldSortMode;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.cf_integration.datamodel.CFField;
import com.spss.uitools.util.TraceSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CFDataModel
implements DataModel {
    private ISpssDataSrc mDataSource;
    private FieldListSorter mFieldSorter;
    private ArrayList<ISpssVariable> mVariables;
    private Map<ExtendedValue, Object> extendedValues = new HashMap<ExtendedValue, Object>();
    private Map<String, Field> fieldsMap = new HashMap<String, Field>();

    public CFDataModel(ISpssDataSrc iSpssDataSrc) {
        this.mDataSource = iSpssDataSrc;
        this.mFieldSorter = new FieldListSorter();
        this.setupFields();
    }

    public String getDataSrcName() {
        return this.mDataSource.getDatasetName();
    }

    public String sameDataset(String string) {
        String string2;
        String string3 = "";
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n > 0 && n2 > 0 && !(string2 = string.substring(n + 1, n2)).equals(this.getDataSrcName())) {
            string3 = string2;
        }
        return string3;
    }

    public void dispose(IDatasetViewObserver iDatasetViewObserver) {
        if (this.mDataSource == null) {
            return;
        }
        this.mDataSource.removeObserver(iDatasetViewObserver);
        this.mVariables.clear();
        this.fieldsMap.clear();
        this.mDataSource = null;
        this.mFieldSorter = null;
        this.mVariables = null;
        this.fieldsMap = null;
    }

    public Field getField(String string) {
        Field field = this.fieldsMap.get(string);
        if (field != null) {
            return field;
        }
        int n = this.mDataSource.findVarIndex(string);
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(n);
        if (iSpssVariable == null) {
            TraceSettings.trace1((String)("Can't find CF variable: " + string), (int)16);
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.mDataSource.getWeightVarIndex() > -1) {
            bl2 = this.mDataSource.getVariable(this.mDataSource.getWeightVarIndex()) == iSpssVariable;
        }
        for (int i = 0; i < this.mDataSource.getNSplitVars(); ++i) {
            if (n != this.mDataSource.getSplitVarIndex(i)) continue;
            bl = true;
            break;
        }
        field = new CFField(iSpssVariable, bl, bl2);
        this.fieldsMap.put(string, field);
        return field;
    }

    public int getFieldGroupCount() {
        return 0;
    }

    public FieldGroup getFieldGroup(int n) {
        return null;
    }

    public boolean containsField(String string) {
        return this.mDataSource.findVarIndex(string) > -1;
    }

    public int getFieldCount() {
        return this.mVariables.size();
    }

    public String getFieldName(int n) {
        if (n < 0 || n >= this.mVariables.size()) {
            return null;
        }
        return this.mVariables.get(n).getName();
    }

    public Iterator<Field> fieldIterator(FieldSortMode fieldSortMode, FieldSortDirection fieldSortDirection, boolean bl) {
        Vector<Field> vector = new Vector<Field>();
        for (int i = 0; i < this.getFieldCount(); ++i) {
            String string = this.getFieldName(i);
            Field field = this.getField(string);
            if (((CFField)field).isDimensionVar()) continue;
            vector.add(field);
        }
        return this.mFieldSorter.fieldIterator((DataModel)this, vector, fieldSortMode, fieldSortDirection, bl);
    }

    private void setupFields() {
        this.mVariables = new ArrayList(this.mDataSource.columnCount());
        ISpssVariable iSpssVariable = null;
        if (this.mDataSource.getWeightVarIndex() > -1) {
            iSpssVariable = this.mDataSource.getVariable(this.mDataSource.getWeightVarIndex());
        }
        for (int i = 0; i < this.mDataSource.columnCount(); ++i) {
            ISpssVariable iSpssVariable2 = this.mDataSource.getVariable(i);
            if (!this.mDataSource.isVariableInCurrentSet(i)) continue;
            this.mVariables.add(iSpssVariable2);
        }
        this.clearFieldsMap();
    }

    public Object getExtendedValue(ExtendedValue extendedValue) {
        return this.extendedValues.get(extendedValue);
    }

    public void clearFieldsMap() {
        this.fieldsMap.clear();
    }

    public void setExtendedValue(ExtendedValue extendedValue, Object object) {
        this.extendedValues.put(extendedValue, object);
    }

    public boolean containsExtendedValue(ExtendedValue extendedValue) {
        return this.extendedValues.containsValue(extendedValue);
    }

    public Iterator<ExtendedValue> extendedValueTypes() {
        return this.extendedValues.keySet().iterator();
    }
}

