/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui;

import com.ibm.spss.common.licensing.InstallationHandler;
import com.ibm.spss.common.licensing.LicenseManager;
import com.ibm.spss.common.licensing.ProductUpdateInfo;
import com.ibm.spss.common.licensing.util.OSInfo;
import com.ibm.statistics.lighttable.ui.LtResUtil;
import com.spss.charteditor.SpssMsgListener;
import com.spss.charteditor.events.GotoCaseEvent;
import com.spss.java_client.core.common.CheckUpdateInstallationHandler;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ILocaleListener;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.LogonMgr;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OutputCrypt;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.comp_util.SyntaxCrypt;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ISpssUIAgent;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.UpdateUserPrefs;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.data_access.IDataAccessCallback;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDataMgrObserver;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.production.ProductionSymbol;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.error_handler.IErrorHandler;
import com.spss.java_client.core.nps_feedless.CheckForNpsFeedless;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.IReconnectListener;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.core.server.messages.DataEditorMsg.FindValuesMsg;
import com.spss.java_client.core.server.messages.ReportedErrorDataMsg;
import com.spss.java_client.core.server.messages.adminmsg.P2PEventMsg;
import com.spss.java_client.licensing.SPSSLic;
import com.spss.java_client.ui.DAC.DacMgrUICallback;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.controlbar.ToolbarDefaults;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.WelcomeDlg;
import com.spss.java_client.ui.dialogs.base.WelcomeOnPremDlg;
import com.spss.java_client.ui.dialogs.base.file.EncryptionEnterPasswordDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.utilities.bundle_install_utility.InstallExtensionBundle;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionUserPromptsDlg;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.LogonDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.ReconnectDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssP2PMessageDialog;
import com.spss.java_client.ui.dialogs.common.SpssSplashWnd;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.documents.data.DatasourceErrorDlg;
import com.spss.java_client.ui.dialogs.fopen.ChooserUIFactory;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.GotoDataEditorAction;
import com.spss.java_client.ui.doc_types.actions.InstallDlgAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DatasetViewObserver;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.laf.LookAndFeelManager;
import com.spss.java_client.ui.laf.SpssPlasticXPLookAndFeel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.SpssKeyboardMonitor;
import com.spss.pivottable.resources.PTResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.syntaxeditor.resources.SyntaxEditorResUtil;
import com.spss.uitools.help.HelpThread;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IErrorDispatcher;
import com.spss.uitools.util.ISpssAlertHandler;
import com.spss.uitools.util.OutOfMemoryErrorHandler;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.TraceSettings;
import com.spss.uitools.util.UIAlertRegistrar;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SpssMgr
implements ISpssUIAgent,
IDataMgrObserver,
IErrorHandler,
PropertyChangeListener,
ILocaleListener {
    public static final int NUM_DOC_TYPES = 4;
    public static final String INVISIBLE_WINDOW = "InvisibleWelcomeWindow";
    private static final String SPSS_LOAD_HELP_ON_STARTUP = "SpssLoadHelpOnStartup";
    private static SpssMgr sInstance = null;
    private LookAndFeelManager mLafManager = null;
    private SpssSplashWnd mSplashWnd = null;
    private boolean mWelcome = true;
    private boolean mFirstNewDataSet = true;
    private BaseSpssDialog mWelcomeDialog = null;
    private static String CDB_SPD = ".spd";
    private static String CDB_SPDX = ".spdx";
    private static String CDB_SPE = ".spe";
    private ConcurrentHashMap<LocallyUniqueId, DatasetViewObserver> mObserverMap = new ConcurrentHashMap();
    public static boolean mStartupDialogExit = false;
    SpssKeyboardMonitor mSpssKeyboardMonitor = new SpssKeyboardMonitor();
    static Boolean mHasInternetConnection = null;

    public static ISpssUIAgent getInstance() {
        return SpssMgr.getSpssMgr();
    }

    public static SpssMgr getSpssMgr() {
        if (sInstance == null) {
            sInstance = new SpssMgr();
            UIManager.addPropertyChangeListener(sInstance);
            ComponentState.addLocaleListener((ILocaleListener)sInstance);
            SyntaxMgr.initSyntaxCommands();
        }
        return sInstance;
    }

    public static void setSpssMgr(SpssMgr spssMgr) {
        sInstance = spssMgr;
    }

    public LookAndFeelManager getLookAndFeelManager() {
        if (this.mLafManager == null) {
            this.mLafManager = new LookAndFeelManager();
        }
        return this.mLafManager;
    }

    public boolean switchServer(SpssFrame spssFrame) {
        boolean bl;
        ServerObject serverObject = DataServerProxy.getDataProxy().getServerObject();
        OutputManager.getOutputManager().setFirstRun(true);
        LogonDlg logonDlg = new LogonDlg(spssFrame, false);
        logonDlg.setVisible(true);
        boolean bl2 = LogonMgr.getLogonMgr().loggedOn();
        boolean bl3 = bl = !logonDlg.getModalResult();
        if (!bl2 && bl) {
            LogonMgr.getLogonMgr().logon(serverObject);
        }
        if (!bl) {
            this.mWelcome = true;
            PES_Repository.ResetRepository();
        }
        if (!(bl2 = LogonMgr.getLogonMgr().loggedOn())) {
            bl2 = this.localLogon();
        }
        return bl2;
    }

    public void setWelcomeDialog(BaseSpssDialog baseSpssDialog) {
        this.mWelcomeDialog = baseSpssDialog;
    }

    public BaseSpssDialog getWelcomeDialog() {
        return this.mWelcomeDialog;
    }

    public void putDefaultStatusMessage() {
        SpssFrameMgr.getSpssFrameMgr().putDefaultStatusMsg();
    }

    public void showStartupScreen() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.mSplashWnd = new SpssSplashWnd();
            this.mSplashWnd.ensureActive();
            this.mSplashWnd.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.mSplashWnd = new SpssSplashWnd();
                    SpssMgr.this.mSplashWnd.ensureActive();
                    SpssMgr.this.mSplashWnd.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }
    }

    public void destroyStartupScreen() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SpssMgr.this.mSplashWnd != null) {
                    SpssMgr.this.mSplashWnd.setCursor(null);
                    SpssMgr.this.mSplashWnd.dispose();
                    SpssMgr.this.mSplashWnd = null;
                }
            }
        });
    }

    public void showLogonDlg() {
        LogonDlg logonDlg = new LogonDlg(null, false);
        logonDlg.setCursor(Cursor.getDefaultCursor());
        logonDlg.setVisible(true);
    }

    public void showReconnectDlg(int n) {
        ReconnectDialog reconnectDialog = new ReconnectDialog(null, ResUtil.getString("IDS_RECONNECT_ATTEMPT_TITLE"), n);
        AppMgr.getAppMgr().addReconnectListener((IReconnectListener)reconnectDialog);
        reconnectDialog.setDeterminateMode();
        reconnectDialog.setCursor(Cursor.getPredefinedCursor(3));
        reconnectDialog.start();
        reconnectDialog.setVisible(true);
        AppMgr.getAppMgr().removeReconnectListener((IReconnectListener)reconnectDialog);
    }

    public void registerAlertHandler() {
        UIAlertRegistrar.getUIAlertRegistrar().registerAlertHandler((ISpssAlertHandler)new SpssAlertHandler());
    }

    public void registerAsErrorListener(boolean bl) {
        if (bl) {
            ErrorDispatcher.getErrorDispatcher().addListener((IErrorHandler)this);
        } else {
            ErrorDispatcher.getErrorDispatcher().removeListener((IErrorHandler)this);
        }
    }

    public synchronized void handleLogonError(ErrorEventMsg errorEventMsg, ServerObject serverObject, JDialog jDialog) {
        String string = errorEventMsg.getErrorString();
        String string2 = serverObject.getSslProtocolType() == ServerObject.SslProtocolType.SslNotUsed ? "inet" : "ssl";
        string = string + " " + string2 + ":" + serverObject.getName() + ":" + serverObject.getPort() + ".";
        String string3 = CoreResUtil.getString((String)ErrorDispatcher.getErrorDispatcher().errorToStringKey((short)-40));
        if (errorEventMsg.getErrorString().equals(string3) && errorEventMsg.getInternalMsg() != null && errorEventMsg.getInternalMsg().length() > 0) {
            string = string + "\n" + errorEventMsg.getInternalMsg();
        }
        this.destroyStartupScreen();
        if (jDialog != null) {
            SpssAlertOptionPane.showErrorMessageDialog(jDialog, string, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(null, string, VersionInfo.getAppVersionString(), 0);
        }
    }

    public void openOutputDocument(String string) {
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        SpssFrameMgr.getSpssFrameMgr();
        String string2 = "";
        File file2 = file;
        HashMap hashMap = CommandLine.getFilenamesToPasswords();
        if (hashMap.size() > 0 && (string2 = (String)hashMap.get(string)) != null) {
            CommandLine.removeFilenamesToPasswordsKey((String)string);
            object = PrefsMgr.getPrefsMgr().getTempPath();
            try {
                file2 = PASWFileUtil.createTempFile((String)"decrypt", (String)".spv", (File)new File((String)object));
                object = file2.getAbsolutePath();
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            if (!OutputCrypt.decrypt((String)string2, (String)string, (String)object)) {
                return;
            }
        }
        if (string2 != null && string2.isEmpty() && OutputCrypt.isEncrypted((String)string)) {
            object = new EncryptionEnterPasswordDlg(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), file.getName());
            object.setVisible(true);
            if (!((EncryptionEnterPasswordDlg)((Object)object)).isOkSelected()) {
                return;
            }
            string2 = ((EncryptionEnterPasswordDlg)((Object)object)).getEncryptFilePassword();
            String string3 = PrefsMgr.getPrefsMgr().getTempPath();
            try {
                file2 = PASWFileUtil.createTempFile((String)"decrypt", (String)".spv", (File)new File(string3));
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            if (!OutputManager.getOutputManager().decryptDocument(file, file2, string2, IOutputDocument.EncryptPW.CLEAR)) {
                String string4 = ResUtil.getComponentString("ERR_FILE_OPEN_PASSWORD_FAILED");
                SpssAlertOptionPane.showErrorMessageDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), string4, VersionInfo.getAppVersionString());
                return;
            }
        }
        if ((object = OutputManager.getOutputManager().openDocument(file, file2, null, true)) != null && string2 != null) {
            object.setPassword(string2, false);
            this.addToMRUOtherDocumentPath(file);
        }
    }

    public void openSyntaxDocument(String string, boolean bl) {
        ISyntaxDocument iSyntaxDocument;
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (this.checkForOpenDocument(file)) {
            return;
        }
        SpssFrameMgr.getSpssFrameMgr();
        boolean bl2 = SyntaxCrypt.isEncrypted((String)string);
        if (bl2) {
            object = CommandLine.getFilenamesToPasswords();
            String string2 = (String)((HashMap)object).get(string);
            if (string2 != null) {
                File file2;
                CommandLine.removeFilenamesToPasswordsKey((String)string);
                String string3 = PrefsMgr.getPrefsMgr().getTempPath();
                try {
                    file2 = PASWFileUtil.createTempFile((String)"decrypt", (String)".sps", (File)new File(string3));
                    string3 = file2.getAbsolutePath();
                    file2.deleteOnExit();
                    if (!SyntaxCrypt.decrypt((String)string2, (String)string, (String)string3)) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
                iSyntaxDocument = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file, file2);
                if (!file2.delete()) {
                    TraceSettings.trace1((String)("tempFile.delete() failed: " + file2.toString()), (int)15);
                }
                iSyntaxDocument.setPassword(string2, false);
            } else {
                iSyntaxDocument = SyntaxUtil.openEncryptedSyntaxDocument(file);
            }
        } else {
            iSyntaxDocument = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file);
        }
        if (bl && iSyntaxDocument != null) {
            object = iSyntaxDocument.getSyntax();
            if (((String)object).charAt(((String)object).length() - 1) != '\n') {
                object = (String)object + '\n';
            }
            SyntaxMgr.getSyntaxMgr().executeSyntax((String)object);
        }
    }

    private boolean checkForOpenDocument(File file) {
        boolean bl = false;
        try {
            bl = SpssFrameMgr.getSpssFrameMgr().checkForOpenDocument(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public void openDialogBuilderDocument(final File file) {
        if (!file.exists()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
                if (spssFrame == null) {
                    spssFrame = DataFrame.createDataFrame(true);
                }
                try {
                    String string = file.getName();
                    String string2 = string.endsWith(CDB_SPE) ? CoreResUtil.getString((String)"IDS_SPD_COMMAND_LINE_SPE_INQUIRY") : CoreResUtil.getString((String)"IDS_SPD_COMMAND_LINE_SPD_INQUIRY");
                    String string3 = String.format(string2, string);
                    Object[] objectArray = new String[]{ResUtil.getComponentString("IDS_INSTALL"), ResUtil.getCommonDlgString("IDS_CANCEL")};
                    int n = SpssAlertOptionPane.showOptionDialog(spssFrame, string3, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
                    boolean bl = string.endsWith(CDB_SPD);
                    if (n == 0) {
                        SpssFrame spssFrame2 = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
                        if (spssFrame2 == null) {
                            spssFrame2 = spssFrame;
                        }
                        if (string.endsWith(CDB_SPE)) {
                            InstallExtensionBundle installExtensionBundle = new InstallExtensionBundle(spssFrame);
                            installExtensionBundle.doInstall(file);
                        } else {
                            InstallDlgAction installDlgAction = (InstallDlgAction)ActionCatalog.getActionCatalog().getSpssAction("utilities_install_dialog");
                            DialogDefinition dialogDefinition = installDlgAction.readPackageFile(file, bl);
                            if (bl) {
                                if (!installDlgAction.validateSyntaxAndMenuLocation(spssFrame2, dialogDefinition, false)) {
                                    return;
                                }
                                installDlgAction.deploySpecification(spssFrame2, dialogDefinition, true);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    spssFrame.toFront();
                    SpssAlertOptionPane.showErrorMessageDialog(spssFrame, BuilderResUtil.getString((String)"IDS_BAD_CLEF_FILE_MSG"), VersionInfo.getAppVersionString());
                }
            }
        });
    }

    private void addToMRUOtherDocumentPath(File file) {
        try {
            MRUMgr.getMRUMgr().addOtherDocumentPath(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void startUI() {
        DataMgr.getDataMgr().registerObserver((IDataMgrObserver)this);
        if (com.spss.shared.core_tools.system.OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.macOSXRegistration();
        }
        OutOfMemoryErrorHandler.initialize((IErrorDispatcher)ErrorDispatcher.getErrorDispatcher(), (int)2, (String)VersionInfo.getAppVersionString(), (String)CoreResUtil.getString((String)"IDS_ERR_OUT_OF_MEMORY"), (CommandLine.isAutomated() || CommandLine.isProduction() ? 1 : 0) != 0);
    }

    public void stopUI() {
        this.registerAsErrorListener(false);
        DataMgr.getDataMgr().unregisterObserver((IDataMgrObserver)this);
        StatsHelp.getStatsHelp().stopEclipseHelp();
        FrameworkMgr.get().shutdown();
    }

    public boolean closeAllFrames(boolean bl) {
        FunctionList.reset();
        bl = !mStartupDialogExit ? bl : false;
        return SpssFrameMgr.getSpssFrameMgr().closeAllFrames(bl);
    }

    public LinkedHashMap<String, ProductionSymbol> promptForSymbols(String string, LinkedHashMap<String, ProductionSymbol> linkedHashMap) {
        JFrame jFrame = new JFrame();
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageURL("IDI_PRODUCTION_WINDOW_ACTIVE"));
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.setTitle(string);
        jFrame.setExtendedState(1);
        jFrame.setAlwaysOnTop(true);
        jFrame.setLocationRelativeTo(null);
        ProductionUserPromptsDlg productionUserPromptsDlg = new ProductionUserPromptsDlg(jFrame, string, linkedHashMap);
        productionUserPromptsDlg.setAlwaysOnTop(true);
        jFrame.pack();
        jFrame.setVisible(true);
        productionUserPromptsDlg.setVisible(true);
        if (productionUserPromptsDlg.isOk()) {
            return linkedHashMap;
        }
        return null;
    }

    public boolean openDataFromUI(File file) {
        return this.openDataFromUI(file.getPath());
    }

    public boolean openDataFromUI(String string) {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
        RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
        if (remoteFileStatus.errorOccurred() || remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE_BUT_LOCKED) {
            // empty if block
        }
        DacMgrUICallback dacMgrUICallback = new DacMgrUICallback(spssFrame);
        return DacMgr.getDacMgr().openRecentData(string, (IDataAccessCallback)dacMgrUICallback);
    }

    public void setLookAndFeel() {
        this.setLookAndFeel(false);
    }

    public void setLookAndFeel(boolean bl) {
        if (!bl && this.getLookAndFeelManager().getLookAndFeel() != null) {
            return;
        }
        if (!bl) {
            UIManager.installLookAndFeel("SPSS Classic", SpssPlasticXPLookAndFeel.class.getName());
        }
        String string = this.getDefaultLookAndFeelClassName();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("general");
        string = preferences2.get("look_and_feel", string);
        this.getLookAndFeelManager().setLookAndFeel(string);
    }

    public String getDefaultLookAndFeelClassName() {
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        boolean bl = string.indexOf("win") >= 0 || string.startsWith("linux");
        boolean bl2 = string.startsWith("mac os x");
        String string2 = null;
        if (bl2) {
            string2 = UIManager.getSystemLookAndFeelClassName();
            ChooserUIFactory.setUseQuaqua(false);
        } else if (bl) {
            string2 = "com.spss.cobalt_laf.CobaltLookAndFeel";
            ChooserUIFactory.setUseQuaqua(false);
        }
        return string2;
    }

    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        this.getLookAndFeelManager().setLookAndFeel(lookAndFeel);
    }

    public void showP2PEventMessage(P2PEventMsg p2PEventMsg) {
        SpssP2PMessageDialog spssP2PMessageDialog = new SpssP2PMessageDialog(p2PEventMsg);
        spssP2PMessageDialog.setLocationRelativeTo(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame());
        spssP2PMessageDialog.pack();
        spssP2PMessageDialog.setVisible(true);
    }

    public void handleError(ErrorEventMsg errorEventMsg) {
        String string;
        if (!errorEventMsg.isUserNotified()) {
            string = errorEventMsg.getErrorString();
            final short s = errorEventMsg.getErrorCode();
            new ActionListener(){
                Timer timer = null;

                public void start() {
                    this.timer = new Timer(500, this);
                    this.timer.start();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.timer.stop();
                    SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
                    if (spssFrame == null) {
                        spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
                    }
                    if (spssFrame != null) {
                        Object object = SpssMgr.this.getWelcomeDialog() != null ? SpssMgr.this.getWelcomeDialog() : spssFrame;
                        object.toFront();
                        if (s == -31) {
                            SpssAlertOptionPane.showErrorMessageDialog(object, string, VersionInfo.getAppVersionString(), true);
                        } else {
                            SpssAlertOptionPane.showErrorMessageDialog(object, string, VersionInfo.getAppVersionString());
                        }
                    } else {
                        this.timer.restart();
                    }
                }
            }.start();
            errorEventMsg.setUserNotified(true);
        }
        string = CoreResUtil.getString((String)"SRS_ReconnectSuccess");
        if (errorEventMsg.getErrorString().compareTo(string) != 0) {
            SpssFrameMgr.getSpssFrameMgr().putDefaultStatusMsg();
        }
    }

    public void onNewDataSet(LocallyUniqueId locallyUniqueId, boolean bl, String string) {
        final LocallyUniqueId locallyUniqueId2 = locallyUniqueId;
        final String string2 = string;
        DatasetViewObserver datasetViewObserver = new DatasetViewObserver();
        this.mObserverMap.put(locallyUniqueId, datasetViewObserver);
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        iSpssDataSrc.addObserver((IDatasetViewObserver)datasetViewObserver);
        if (SwingUtilities.isEventDispatchThread()) {
            this.newDataSet(locallyUniqueId2, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.newDataSet(locallyUniqueId2, string2);
                    SpssFrameMgr.getSpssFrameMgr().updateSyntaxWindows();
                }
            });
        }
    }

    private void newDataSet(LocallyUniqueId locallyUniqueId, String string) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            return;
        }
        if (!CommandLine.isExternalCaller() && !ProcedureDlgMgr.getMgr().keepCurrentDialogOpen()) {
            ProcedureDlgMgr.getMgr().closeAllProcedureDialogs();
        }
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().createFrame(DocType.DE_DOC, false);
        DatasetViewObserver datasetViewObserver = this.mObserverMap.remove(locallyUniqueId);
        if (datasetViewObserver == null) {
            TraceSettings.trace1((String)("ERROR: No observer for dataset (" + locallyUniqueId.getOriginator().ordinal() + ", " + locallyUniqueId.getSequence() + ")"), (int)15);
            assert (false);
        }
        dataFrame.attach(locallyUniqueId, string, datasetViewObserver);
        dataFrame.setState(1);
        if (locallyUniqueId.getOriginator() == ORIGINATOR_ID.SERVER_ORIGINATOR && locallyUniqueId.getSequence() == 0) {
            DataDocument.runSetDatasetName((boolean)false);
        }
        dataFrame.setVisible(true);
        if (!CommandLine.isExternalCaller()) {
            boolean bl = this.checkForShowWelcomeDlg();
            if (!bl) {
                mStartupDialogExit = true;
                AppMgr.getAppMgr().closeSessionData(false);
                return;
            }
            if (this.mFirstNewDataSet) {
                LicenseManager licenseManager;
                this.mFirstNewDataSet = false;
                if (VersionInfo.IsApplicationOnCloud()) {
                    licenseManager = SPSSLic.getLicenseManager();
                    boolean bl2 = licenseManager.isAutoUpdateEnabled();
                    TraceSettings.trace1((String)("AutoUpdate setting in SpssMgr=" + bl2), (int)15);
                    if (bl2) {
                        CheckForUpdate checkForUpdate = new CheckForUpdate();
                        checkForUpdate.start();
                    }
                }
                licenseManager = new CheckForNpsFeedless();
                licenseManager.start();
            }
        }
        if (CommandLine.isExternalCaller()) {
            SpssFrameMgr.getSpssFrameMgr().designateWindow(dataFrame);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!CommandLine.isExternalCaller()) {
                    SpssFrameMgr.getSpssFrameMgr().removedDisconnectedDataFrames();
                }
            }
        });
    }

    public void onActivateDataSet(LocallyUniqueId locallyUniqueId, boolean bl, boolean bl2, boolean bl3) {
        final LocallyUniqueId locallyUniqueId2 = locallyUniqueId;
        final boolean bl4 = bl;
        final boolean bl5 = bl2;
        if (SwingUtilities.isEventDispatchThread()) {
            this.activateDataSet(locallyUniqueId2, bl4, bl5);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.activateDataSet(locallyUniqueId2, bl4, bl5);
                    SpssFrameMgr.getSpssFrameMgr().updateSyntaxWindows();
                }
            });
        }
    }

    private void activateDataSet(LocallyUniqueId locallyUniqueId, boolean bl, boolean bl2) {
        String string = "( " + locallyUniqueId.getOriginator() + ", " + locallyUniqueId.getSequence() + " )";
        ComponentState.trace1((String)("onActivateDataSet" + string), (int)256);
        DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId);
        if (dataFrame != null) {
            int n;
            int n2 = dataFrame.getState();
            int n3 = n = bl ? 1 : 0;
            if (n2 == 1 && !bl2) {
                n = 1;
            }
            if (n2 != n) {
                dataFrame.setState(n);
            }
            if (bl2) {
                dataFrame.toFront();
            }
        }
    }

    public LocallyUniqueId getActiveClientDatasetId() {
        LocallyUniqueId locallyUniqueId = null;
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (dataFrame != null) {
            locallyUniqueId = dataFrame.getDatasetId();
        }
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        if (locallyUniqueId == null) {
            locallyUniqueId = new LocallyUniqueId();
        }
        return locallyUniqueId;
    }

    public void onError(String string) {
        ErrorDispatcher.getErrorDispatcher().dispatchError(string, "Server error notification");
    }

    public void onInteractiveError(ReportedErrorDataMsg reportedErrorDataMsg) {
        boolean bl = true;
        DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(reportedErrorDataMsg.getDataSetId());
        if (dataFrame != null) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(reportedErrorDataMsg.getDataSetId());
            if (reportedErrorDataMsg.getStrErrorText().length() > 0 && iSpssDataSrc != null && (reportedErrorDataMsg.getSeverityCode().equals((Object)ReportedErrorDataMsg.SeverityCode.kFatalError) || !iSpssDataSrc.getSuppressInteractiveErrors())) {
                DatasourceErrorDlg datasourceErrorDlg = new DatasourceErrorDlg(dataFrame, reportedErrorDataMsg);
                datasourceErrorDlg.setVisible(true);
                bl = datasourceErrorDlg.getDontShowAgain();
            }
        }
        if (bl) {
            DataMgr.getDataMgr().interactiveErrorResponse(reportedErrorDataMsg);
        }
    }

    public void update() {
    }

    public void onVariableInserted(final int n, final LocallyUniqueId locallyUniqueId, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.variableInserted(n, locallyUniqueId, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.variableInserted(n, locallyUniqueId, oRIGINATOR_ID);
                }
            });
        }
    }

    private void variableInserted(int n, LocallyUniqueId locallyUniqueId, ORIGINATOR_ID oRIGINATOR_ID) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyVariableInserted(n, oRIGINATOR_ID);
        }
    }

    public void onServerVariableInserted(final int n, final LocallyUniqueId locallyUniqueId, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.serverVariableInserted(n, locallyUniqueId, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.serverVariableInserted(n, locallyUniqueId, oRIGINATOR_ID);
                }
            });
        }
    }

    private void serverVariableInserted(int n, LocallyUniqueId locallyUniqueId, ORIGINATOR_ID oRIGINATOR_ID) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyServerVariableInserted(n, oRIGINATOR_ID);
        }
    }

    public void onWeightVariableIndex(final int n, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.weightVariableIndex(n, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.weightVariableIndex(n, locallyUniqueId);
                }
            });
        }
    }

    private void weightVariableIndex(int n, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyWeightVarIndex(n);
        }
    }

    public void onFilterVariableIndex(final int n, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.filterVariableIndex(n, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.filterVariableIndex(n, locallyUniqueId);
                }
            });
        }
    }

    private void filterVariableIndex(int n, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyFilterVarIndex(n);
        }
    }

    public void onTrendsInfo(final ITrendsInfo iTrendsInfo, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.trendsInfo(iTrendsInfo, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.trendsInfo(iTrendsInfo, locallyUniqueId);
                }
            });
        }
    }

    private void trendsInfo(ITrendsInfo iTrendsInfo, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyTrendsInfo(iTrendsInfo);
        }
    }

    public void onSplitFile(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.splitFile(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.splitFile(locallyUniqueId);
                }
            });
        }
    }

    private void splitFile(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifySplitFile();
        }
    }

    public void onRowCountEstablished(final LocallyUniqueId locallyUniqueId, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rowCountEstablished(locallyUniqueId, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.rowCountEstablished(locallyUniqueId, oRIGINATOR_ID);
                }
            });
        }
    }

    private void rowCountEstablished(LocallyUniqueId locallyUniqueId, ORIGINATOR_ID oRIGINATOR_ID) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyRowCountEstablished(oRIGINATOR_ID);
        }
    }

    public void onCloseDataSet(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.closeDataSet(locallyUniqueId);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SpssMgr.this.closeDataSet(locallyUniqueId);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void closeDataSet(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyCloseDataSet();
        }
    }

    public void onModified(final boolean bl, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.modified(bl, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.modified(bl, locallyUniqueId);
                }
            });
        }
    }

    private void modified(boolean bl, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyModified(bl);
        }
    }

    public void onStartOfDictionaryMods(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.StartOfDictionaryMods(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.StartOfDictionaryMods(locallyUniqueId);
                }
            });
        }
    }

    private void StartOfDictionaryMods(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyStartOfDictionaryMods();
        }
    }

    public void onEndOfDictionaryMods(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.EndOfDictionaryMods(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.EndOfDictionaryMods(locallyUniqueId);
                }
            });
        }
    }

    private void EndOfDictionaryMods(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyEndOfDictionaryMods();
        }
    }

    public void onVariableModified(final int n, final LocallyUniqueId locallyUniqueId, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.variableModified(n, locallyUniqueId, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.variableModified(n, locallyUniqueId, oRIGINATOR_ID);
                }
            });
        }
    }

    private void variableModified(int n, LocallyUniqueId locallyUniqueId, ORIGINATOR_ID oRIGINATOR_ID) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyVariableModified(n, oRIGINATOR_ID);
        }
    }

    public void onFileName(final String string, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fileName(string, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.fileName(string, locallyUniqueId);
                }
            });
        }
    }

    private void fileName(String string, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyFileName(string);
        }
    }

    public void onResetUndo(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetUndo(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.resetUndo(locallyUniqueId);
                }
            });
        }
    }

    private void resetUndo(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyResetUndo();
        }
    }

    public void onStopFind(final boolean bl, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopFind(bl, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.stopFind(bl, locallyUniqueId);
                }
            });
        }
    }

    private void stopFind(boolean bl, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyStopFind(bl);
        }
    }

    public void onCellValueFound(final LocallyUniqueId locallyUniqueId, final long l, final String string, final LocallyUniqueId locallyUniqueId2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cellValueFound(locallyUniqueId, l, string, locallyUniqueId2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.cellValueFound(locallyUniqueId, l, string, locallyUniqueId2);
                }
            });
        }
    }

    private void cellValueFound(LocallyUniqueId locallyUniqueId, long l, String string, LocallyUniqueId locallyUniqueId2) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId2);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyCellValueFound(locallyUniqueId, l, string);
        }
    }

    private void cellValuesFound(Vector<FindValuesMsg.ColumnFind> vector, String string, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            for (int i = 0; i < vector.size(); ++i) {
                FindValuesMsg.ColumnFind columnFind = vector.get(i);
                LocallyUniqueId locallyUniqueId2 = columnFind.getColumn();
                iSpssDataSrc.notifyCellValuesFound(locallyUniqueId2, columnFind.getRows(), string);
            }
        }
    }

    public void onCellValuesFound(final Vector<FindValuesMsg.ColumnFind> vector, final String string, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cellValuesFound(vector, string, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.cellValuesFound(vector, string, locallyUniqueId);
                }
            });
        }
    }

    public void onDatasetAttributesModified(final ExtensionType extensionType, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.datasetAttributesModified(extensionType, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.datasetAttributesModified(extensionType, locallyUniqueId);
                }
            });
        }
    }

    private void datasetAttributesModified(ExtensionType extensionType, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyDatasetAttributesModified(extensionType);
        }
    }

    public void onReplaceResult(final Vector<CellValue> vector, final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.replaceResult(vector, locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.replaceResult(vector, locallyUniqueId);
                }
            });
        }
    }

    private void replaceResult(Vector<CellValue> vector, LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyReplaceResult(vector);
        }
    }

    public void onVariablesDeleted(final int n, final int n2, final LocallyUniqueId locallyUniqueId, final int n3, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.variablesDeleted(n, n2, locallyUniqueId, n3, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.variablesDeleted(n, n2, locallyUniqueId, n3, oRIGINATOR_ID);
                }
            });
        }
    }

    private void variablesDeleted(int n, int n2, LocallyUniqueId locallyUniqueId, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyVariablesDeleted(n, n2, n3, oRIGINATOR_ID);
        }
    }

    public void onVariablesMoved(final LocallyUniqueId locallyUniqueId, final int n, final int n2, final int n3) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.variablesMoved(locallyUniqueId, n, n2, n3);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.variablesMoved(locallyUniqueId, n, n2, n3);
                }
            });
        }
    }

    private void variablesMoved(LocallyUniqueId locallyUniqueId, int n, int n2, int n3) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyVariablesMoved(n, n2, n3);
        }
    }

    public void onImputationInfo(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.imputationInfo(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.imputationInfo(locallyUniqueId);
                }
            });
        }
    }

    private void imputationInfo(LocallyUniqueId locallyUniqueId) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            iSpssDataSrc.notifyImputationInfo();
        }
    }

    public void onDataPreferenceChange(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.dataPreferenceChange(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssMgr.this.dataPreferenceChange(string, string2);
                }
            });
        }
    }

    private void dataPreferenceChange(String string, String string2) {
        SpssFrameMgr.getSpssFrameMgr().dataPreferenceChange(string, string2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("lookAndFeel")) {
            VariableList.clearBorders();
        }
    }

    private void macOSXRegistration() {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("com.spss.java_client.ui.doc_types.actions.MacApplicationMenuAdaptor");
            Class[] classArray = new Class[]{};
            Method method = clazz.getDeclaredMethod("registerMacOSXApplication", classArray);
            if (method != null) {
                Object[] objectArray = new Object[]{};
                method.invoke(clazz, objectArray);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            TraceSettings.trace1((String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")"), (int)1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceSettings.trace1((String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")"), (int)1);
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)"Exception while loading the OSXAdapter:", (int)1);
            exception.printStackTrace();
        }
    }

    public boolean checkForOpenDataDocument(String string) {
        return SpssFrameMgr.getSpssFrameMgr().isDataDocumentAlreadyOpen(string);
    }

    public String getNextFreeDatasetName() {
        return DataDocument.getNextFreeDatasetName();
    }

    public boolean inSingleDatasetMode() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("general");
        TraceSettings.trace1((String)("SpssMgr.java, setDatasetName, onlyOneDataset = " + preferences2.getBoolean("only_one_dataset", false)), (int)15);
        return preferences2.getBoolean("only_one_dataset", false);
    }

    public boolean proceedWithNewDataset() {
        boolean bl = true;
        boolean bl2 = this.inSingleDatasetMode();
        boolean bl3 = this.activeDSUnnamed();
        if ((bl2 || bl3) && this.isDatasetDirty()) {
            bl = this.promptForSaveDataset();
        }
        return bl;
    }

    private boolean isDatasetDirty() {
        ISpssDataSrc iSpssDataSrc;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        if ((iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId)) != null) {
            bl = iSpssDataSrc.isModified();
        }
        return bl;
    }

    private boolean promptForSaveDataset() {
        ISpssDataSrc iSpssDataSrc;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        if ((iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId)) != null) {
            DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId);
            ISpssDataSrc iSpssDataSrc2 = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (dataFrame != null) {
                bl = iSpssDataSrc2.getDatasetName() != null && iSpssDataSrc2.getDatasetName().trim().length() > 0 ? dataFrame.saveModified() : true;
            }
        }
        return bl;
    }

    private boolean activeDSUnnamed() {
        ISpssDataSrc iSpssDataSrc;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId == null || locallyUniqueId.isNull()) {
            locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        }
        if ((iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId)) != null) {
            String string = iSpssDataSrc.getDatasetName();
            return string == null || string.length() == 0;
        }
        return false;
    }

    public void notifyCharsetChange(String string) {
    }

    public void notifyILangChange(Locale locale) {
        JComponent.setDefaultLocale(locale);
        BuilderResUtil.setLocale((Locale)locale);
        ResUtil.setLocale(locale);
        ActionCatalog.getActionCatalog().reregisterSpssActions();
        PTResUtil.setLocale((Locale)locale);
        LtResUtil.setLocale((Locale)locale);
        Statistics.resetNames();
        DocUtil.resetFiltersMap();
        com.spss.charteditor.util.ResUtil.setLocale((Locale)locale);
        FunctionList.reset();
        SyntaxEditorResUtil.setLocale((Locale)locale);
        PrefsMgr.getPrefsMgr().resetPrefDefaults();
        ImageGenerator2.getImageGenerator().resetWaitImage();
        ToolbarDefaults.resetToolbarResources();
        CommandExecutor.get().scanCommands(false);
    }

    public void notifySpssLocaleChange(Locale locale) {
        UIToolResUtil.setSPSSLocale((Locale)locale);
        com.spss.charteditor.util.ResUtil.setSpssLocale((Locale)locale);
    }

    protected SpssMgr() {
        HelpThread.setDefaultLanguageDir((String)VersionInfo.getNLVTag());
        if (!CommandLine.isAutomated() && !CommandLine.isProduction()) {
            boolean bl;
            StatsHelp.getStatsHelp().setDefaultLocale(VersionInfo.getNLVLocale());
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            Preferences preferences2 = preferences.node("file_locations");
            String string = preferences2.get("temp_dir", PrefDefaults.DEF_GENERAL_TEMP_DIR);
            String string2 = preferences2.get("spss_file_locations_help_config_path", "");
            StatsHelp.getStatsHelp().setTempPath(new File(string));
            StatsHelp.getStatsHelp().setConfigPath(new File(string2));
            StatsHelp.getStatsHelp().setKCURL(VersionInfo.getStatisticKCURL());
            StatsHelp.getStatsHelp().setProductName(VersionInfo.getPreferencesRoot());
            StatsHelp.getStatsHelp().setVersion(VersionInfo.getMajorVersion(), VersionInfo.getMinorVersion());
            if (VersionInfo.IsApplicationOnCloud()) {
                SpecificationBuilder.setMajorVersion((String)"Subscription");
            } else {
                SpecificationBuilder.setMajorVersion((String)VersionInfo.getMajorVersionString());
            }
            preferences2.put("spss_file_locations_help_config_path", StatsHelp.getStatsHelp().getConfigPath());
            String string3 = System.getenv(SPSS_LOAD_HELP_ON_STARTUP);
            boolean bl2 = bl = string3 == null || string3.equalsIgnoreCase("1") || string3.equalsIgnoreCase("YES");
            if (bl) {
                StatsHelp.getStatsHelp().startEclipseHelp(ComponentState.getILangLocale(), Boolean.valueOf(UpdateUserPrefs.firstLaunchAfterInstall()));
            }
        }
    }

    private boolean localLogon() {
        ServerObject serverObject = LogonMgr.getLogonMgr().getLocalServer();
        boolean bl = false;
        if (serverObject != null) {
            bl = LogonMgr.getLogonMgr().logon(serverObject);
        }
        return bl;
    }

    private boolean checkForShowWelcomeDlg() {
        boolean bl = true;
        if (!this.mWelcome) {
            return true;
        }
        boolean bl2 = !VersionInfo.IsApplicationOnCloud();
        boolean bl3 = WelcomeDlg.canShowWelcomeDialog(bl2);
        if (bl3) {
            boolean bl4;
            this.mWelcome = false;
            JFrame jFrame = this.createTempFrame();
            this.setWelcomeDialog(bl2 ? new WelcomeOnPremDlg(jFrame) : new WelcomeDlg(jFrame, false));
            jFrame.pack();
            jFrame.setVisible(false);
            BaseSpssDialog baseSpssDialog = this.getWelcomeDialog();
            baseSpssDialog.setVisible(true);
            boolean bl5 = bl4 = baseSpssDialog instanceof WelcomeOnPremDlg ? ((WelcomeOnPremDlg)baseSpssDialog).canContinueStartup() : ((WelcomeDlg)baseSpssDialog).canContinueStartup();
            if (!bl4) {
                bl4 = false;
            }
        } else {
            this.mWelcome = false;
        }
        return bl;
    }

    private JFrame createTempFrame() {
        JFrame jFrame = new JFrame();
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageURL("IDI_DE_WINDOW_ACTIVE"));
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.setTitle(VersionInfo.getAppVersionString());
        jFrame.setExtendedState(1);
        jFrame.setAlwaysOnTop(com.spss.shared.core_tools.system.OSInfo.getOSType() != OSInfo.OSType.MAC);
        jFrame.setLocationRelativeTo(null);
        jFrame.setName(INVISIBLE_WINDOW);
        return jFrame;
    }

    public void writeToKeyboardMonitor(String string) {
        this.mSpssKeyboardMonitor.writeToKeyboardMonitor(string);
    }

    public void activateKeyboardMonitor(File file) {
        this.mSpssKeyboardMonitor.activateKeyboardMonitor(file);
    }

    public static boolean hasInternetConnection() {
        if (mHasInternetConnection == null) {
            boolean bl = true;
            try {
                URL uRL = new URL("http://www.ibm.com");
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                boolean bl2 = false;
                httpURLConnection.setConnectTimeout(bl2 ? 6000 : 3000);
                Object object = httpURLConnection.getContent();
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getInputStream();
                }
                catch (IOException iOException) {
                    if (httpURLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection2 = httpURLConnection;
                        int n = httpURLConnection2.getResponseCode();
                        TraceSettings.trace1((String)("No internet connection : urlConnect.getInputStream() failed : CODE = " + n), (int)15);
                        if (n != 200) {
                            inputStream = httpURLConnection2.getErrorStream();
                            TraceSettings.trace1((String)("No internet connection : ErrorStream Contents" + n), (int)15);
                            for (int i = 0; i < inputStream.available(); ++i) {
                                TraceSettings.trace1((String)("    " + inputStream.read()), (int)15);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                TraceSettings.trace1((String)"No internet connection : urlConnect.getContent() failed", (int)15);
            }
            mHasInternetConnection = bl;
        }
        return mHasInternetConnection;
    }

    public boolean licensingInitializationRequired() {
        return true;
    }

    public static class ChartMsgHandler
    implements SpssMsgListener {
        public void processMsg(EventObject eventObject) {
            if (eventObject instanceof GotoCaseEvent) {
                GotoCaseEvent gotoCaseEvent = (GotoCaseEvent)eventObject;
                GotoDataEditorAction.selectDataCases(gotoCaseEvent.getCaseNumbers(), gotoCaseEvent.isClearPrevSelection(), gotoCaseEvent.isScrollToCase());
            }
        }
    }

    public class CheckForUpdate
    extends Thread {
        Preferences mOptionsPrefs = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
        final boolean isAutoUpdate = this.mOptionsPrefs.getBoolean("is_auto_update", true);
        boolean isSaaSOffer = VersionInfo.IsApplicationOnCloud();

        @Override
        public void run() {
            if (this.isSaaSOffer) {
                String string;
                LicenseManager licenseManager = SPSSLic.getLicenseManager();
                licenseManager.addInstallationHandler((InstallationHandler)new CheckUpdateInstallationHandler());
                String string2 = VersionInfo.getProductNickNameOnly();
                licenseManager.setProductName(string2);
                boolean bl = this.isAutoUpdate;
                boolean bl2 = false;
                boolean bl3 = false;
                String string3 = VersionInfo.getBuildNumberString();
                OSInfo.OSType oSType = OSInfo.getOSType();
                ProductUpdateInfo.PlatformType platformType = oSType == OSInfo.OSType.MAC ? ProductUpdateInfo.PlatformType.MACOS : (oSType == OSInfo.OSType.WIN ? ((string = System.getProperties().getProperty("os.arch")).contains("64") ? ProductUpdateInfo.PlatformType.WIN64 : ProductUpdateInfo.PlatformType.WIN32) : ProductUpdateInfo.PlatformType.UNKNOWN);
                licenseManager.manageProductUpdate(null, "SPSS_S_TRIAL", platformType, string3, bl, bl3, bl2);
            }
        }
    }
}

