/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputListener;
import com.spss.java_client.core.documents.output.OMS.IOmsEventListener;
import com.spss.java_client.core.documents.output.OMS.OmsViewerSelectType;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.ISyntaxMgrListener;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.MoreWindowsAction;
import com.spss.java_client.ui.doc_types.actions.WindowMenuAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.uitools.util.TraceSettings;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class SpssFrameMgr
implements IOutputListener,
ISyntaxMgrListener,
IOmsEventListener {
    private static final String SPSPROMPT = "STATISTICS>";
    private static final String SPSPROMPT16 = "SPSS>";
    private static final String SPSSCMDFIN = "FIN";
    private static final String SPSDATA = "DATA>";
    private static final String SPSDEFINE = "DEFINE>";
    private static final String SPSMACRO = "MACRO>";
    private static final String SPSMATRIX = "MATRIX>";
    private static final String SPSUSERCODE = "USERCODE>";
    private static final String SPSOPENING = "OPENING>";
    private Component mF10LastFocusComponent;
    private static final int WINDOW_OFFSET = 30;
    private static SpssFrameMgr sInstance = null;
    private static final Object sDocVectorLock = new DocVectorLock();
    protected Vector<SpssFrame> mDocumentVector = new Vector();
    private ImageIcon[] mActiveIcons = new ImageIcon[4];
    private ImageIcon[] mInactiveIcons = new ImageIcon[4];
    private SpssFrame[] mDesignatedFrames = new SpssFrame[5];
    protected SpssFrame mLastActiveFrame = null;
    private boolean mOmsActive = false;
    private HashMap<DocType, SpssFrame> mActiveFrames = new HashMap();
    private Vector<JFrame> mNonDocumentFrames = new Vector();
    private boolean mMinimized = false;

    public static synchronized SpssFrameMgr getSpssFrameMgr() {
        if (sInstance == null) {
            sInstance = new SpssFrameMgr(true);
        }
        return sInstance;
    }

    public static void setSpssFrameMgr(SpssFrameMgr spssFrameMgr) {
        sInstance = spssFrameMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void designateWindow(SpssFrame spssFrame) {
        DocType docType = spssFrame != null ? spssFrame.docType() : DocType.NO_DOC;
        SpssFrame spssFrame2 = this.mDesignatedFrames[docType.ordinal()];
        if (spssFrame2 == spssFrame) {
            return;
        }
        if (this.mActiveIcons[0] == null) {
            this.loadDocumentIcons();
        }
        SpssFrame[] spssFrameArray = new SpssFrame[2];
        boolean bl = spssFrame == null;
        boolean bl2 = spssFrame2 == null;
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame3 : this.mDocumentVector) {
                if (spssFrame3.docType() == docType) {
                    if (spssFrame3 == spssFrame) {
                        this.mDesignatedFrames[docType.ordinal()] = spssFrame;
                        if (spssFrame instanceof DataFrame) {
                            DataMgr.getDataMgr().setActiveDocumentId(((DataFrame)spssFrame).getDatasetId());
                        }
                        spssFrame.setIconImage(this.mActiveIcons[docType.ordinal()].getImage());
                        spssFrameArray[0] = spssFrame;
                        bl = true;
                    } else if (spssFrame3 == spssFrame2) {
                        spssFrame3.setIconImage(this.mInactiveIcons[docType.ordinal()].getImage());
                        spssFrameArray[1] = spssFrame3;
                        bl2 = true;
                    }
                }
                if (!bl || !bl2) continue;
                break;
            }
            if (!CommandLine.isExternalCaller()) {
                if (spssFrameArray[0] != null) {
                    spssFrameArray[0].updateToolbarEnableStatus();
                }
                if (spssFrameArray[1] != null) {
                    spssFrameArray[1].updateToolbarEnableStatus();
                }
            }
        }
        if (docType == DocType.DE_DOC) {
            this.updateSyntaxWindows();
            this.clearChartDataLinks();
        }
    }

    public void designateWindow(String string) {
        SpssFrame spssFrame = null;
        SpssFrame spssFrame2 = null;
        for (SpssFrame spssFrame3 : this.mDocumentVector) {
            if (!spssFrame3.docType().equals((Object)DocType.DE_DOC)) continue;
            String string2 = ((DataFrame)spssFrame3).getDatasetName();
            if (string2 != null) {
                if (string2.equals(string)) {
                    spssFrame = spssFrame3;
                    break;
                }
                if (string2.length() != 0) continue;
                spssFrame2 = spssFrame3;
                continue;
            }
            spssFrame2 = spssFrame3;
        }
        if (spssFrame != null) {
            this.designateWindow(spssFrame);
        } else if (spssFrame2 != null && string.equals(ResUtil.getString("IDS_DATASET_UNNAMED"))) {
            this.designateWindow(spssFrame2);
        }
    }

    public synchronized SpssFrame getDesignatedWindow(DocType docType) {
        SpssFrame spssFrame = this.mDesignatedFrames[docType.ordinal()];
        if (spssFrame == null) {
            if (docType == DocType.SYNTAX_DOC) {
                ISyntaxDocument iSyntaxDocument = SyntaxMgr.getSyntaxMgr().newSyntaxDocument();
                spssFrame = (SyntaxFrame)iSyntaxDocument.getUIAgent();
            } else if (docType == DocType.OUTPUT_DOC) {
                IOutputDocument iOutputDocument = OutputManager.getOutputManager().newDocument();
                spssFrame = (ViewerFrame)iOutputDocument.getUIAgent();
            }
        }
        return spssFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void designateAnotherWindow(SpssFrame spssFrame) {
        boolean bl = false;
        Object object = sDocVectorLock;
        synchronized (object) {
            if (!this.isDesignated(spssFrame)) {
                return;
            }
            DocType docType = spssFrame.docType();
            for (SpssFrame spssFrame2 : this.mDocumentVector) {
                if (spssFrame2 == spssFrame || !spssFrame2.docType().equals((Object)docType)) continue;
                this.designateWindow(spssFrame2);
                bl = true;
                break;
            }
            if (!bl) {
                this.mDesignatedFrames[docType.ordinal()] = null;
                if (docType == DocType.DE_DOC) {
                    DataMgr.getDataMgr().setActiveDocumentId(null);
                }
            }
        }
    }

    public boolean isDesignated(SpssFrame spssFrame) {
        if (spssFrame == null) {
            return false;
        }
        SpssFrame spssFrame2 = this.mDesignatedFrames[spssFrame.docType().ordinal()];
        return spssFrame2 == spssFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForOpenDocument(String string) {
        string = string.toLowerCase();
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                SpssFrame spssFrame2;
                File file;
                if (spssFrame.getCoreDocument() == null || (file = spssFrame.getCoreDocument().getFileSpec()) == null || !file.getAbsolutePath().toLowerCase().equals(string)) continue;
                String string2 = ResUtil.getString("ERR_FILE_ALREADY_OPEN");
                String string3 = String.format(string2, "'" + string + "'");
                SpssFrame spssFrame3 = spssFrame2 = this.mLastActiveFrame != null ? this.mLastActiveFrame : this.getActivatedFrame(DocType.OUTPUT_DOC);
                if (spssFrame2 != null && AppMgr.getAppMgr().alertsEnabled()) {
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame2, string3, VersionInfo.getAppVersionString());
                }
                return true;
            }
        }
        return false;
    }

    public SpssFrame createFrame(DocType docType, boolean bl) {
        SpssFrame spssFrame;
        if (this.mActiveIcons[0] == null) {
            this.loadDocumentIcons();
        }
        if (docType == DocType.DE_DOC) {
            spssFrame = DataFrame.createDataFrame(bl);
        } else if (docType == DocType.OUTPUT_DOC) {
            spssFrame = ViewerFrame.createViewerFrame(bl, this.mMinimized);
        } else if (docType == DocType.SYNTAX_DOC) {
            spssFrame = SyntaxFrame.createSyntaxFrame(bl);
        } else {
            return null;
        }
        this.addDocument(spssFrame);
        if (bl) {
            this.designateWindow(spssFrame);
            if (!spssFrame.isFrameMaximized()) {
                Point point = spssFrame.getLocation();
                Point point2 = point.getY() < 0.0 ? new Point((int)point.getX(), 0) : point;
                spssFrame.setLocation(point2);
            }
            spssFrame.toFront();
        } else {
            spssFrame.setIconImage(this.mInactiveIcons[docType.ordinal()].getImage());
        }
        return spssFrame;
    }

    public SpssFrame getLastActiveFrame() {
        return this.mLastActiveFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openDocumentCount(DocType docType) {
        int n = 0;
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                if (spssFrame == null || !docType.equals((Object)spssFrame.docType())) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedDisconnectedDataFrames() {
        Object object = sDocVectorLock;
        synchronized (object) {
            SpssFrame[] spssFrameArray = new SpssFrame[this.mDocumentVector.size()];
            this.mDocumentVector.toArray(spssFrameArray);
            for (SpssFrame spssFrame : spssFrameArray) {
                if (!(spssFrame instanceof DataFrame) || spssFrame.getCoreDocument() != null) continue;
                this.removeDocument(spssFrame);
                spssFrame.dispose();
            }
        }
    }

    public void positionNewFrame(SpssFrame spssFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        spssFrame.setSize(dimension.width * 2 / 3, dimension.height * 2 / 3);
        this.setFrameSize(spssFrame);
        int n = this.openDocumentCount(spssFrame.docType());
        if (n == 0) {
            spssFrame.setLocationRelativeTo(null);
        } else {
            DocType docType = spssFrame.docType();
            SpssFrame spssFrame2 = this.getLastFrameOfType(docType);
            Point point = null;
            if (spssFrame2.isFrameMaximized()) {
                spssFrame.setExtendedState(6);
            } else {
                point = this.nextStartLocation(spssFrame, spssFrame2);
            }
            if (point != null) {
                spssFrame.setLocation(point);
            }
        }
    }

    public boolean anyModalDialogsRunning() {
        Frame[] frameArray = Frame.getFrames();
        if (TraceSettings.getTrace() == 131072) {
            TraceSettings.trace((String)("AWT Frame Monitor: " + Array.getLength(frameArray) + " frames in the frame list:"));
            for (Frame frame : frameArray) {
                String string = frame.getTitle();
                if (string.length() == 0) {
                    string = "<untitled>";
                }
                TraceSettings.trace((String)("\t" + string));
            }
        }
        for (Frame frame : frameArray) {
            if (!this.checkWindowChildren(frame, false)) continue;
            return true;
        }
        return false;
    }

    public void reactivateCurrentFrame() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            if (!this.checkWindowChildren(frame, true)) continue;
            return;
        }
        if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true) && ProcedureDlgMgr.getMgr().activateLastProcedureDialog()) {
            return;
        }
        if (this.mLastActiveFrame != null) {
            this.mLastActiveFrame.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDocument(SpssFrame spssFrame) {
        if (spssFrame == null) {
            assert (false);
            return false;
        }
        boolean bl = false;
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame2 : this.mDocumentVector) {
                if (spssFrame != spssFrame2) continue;
                this.mDocumentVector.remove(spssFrame2);
                this.mActiveFrames.remove(spssFrame2.docType());
                this.designateAnotherWindow(spssFrame2);
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Deprecated
    public boolean closeAllFrames() {
        return this.closeAllFrames(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeAllFrames(boolean bl) {
        boolean bl2 = true;
        Object object = sDocVectorLock;
        synchronized (object) {
            Object[] objectArray;
            if (bl && ScriptEngine.getScriptEngine().isAnyEditorsOpen()) {
                objectArray = new String[]{ResUtil.getCommonDlgString("IDS_OK"), ResUtil.getCommonDlgString("IDS_CANCEL")};
                int n = SpssAlertOptionPane.showOptionDialog(this.getLastActiveFrame(), ResUtil.getString("ERR_SCRIPT_IDE_OPEN_QUERY"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[1]);
                boolean bl3 = bl2 = 0 == n;
            }
            if (bl2) {
                objectArray = new Vector();
                for (SpssFrame object22 : this.mDocumentVector) {
                    if (object22.docType().equals((Object)DocType.DE_DOC)) {
                        object22.saveFrameSize();
                        continue;
                    }
                    if (bl && !object22.saveModified()) {
                        bl2 = false;
                        break;
                    }
                    objectArray.add(object22);
                    object22.saveFrameSize();
                    object22.setVisible(false);
                    object22.dispose();
                }
                for (SpssFrame spssFrame : objectArray) {
                    this.mDocumentVector.remove(spssFrame);
                    this.mActiveFrames.remove(spssFrame.docType());
                    this.designateAnotherWindow(spssFrame);
                    if (!(spssFrame instanceof ViewerFrame)) continue;
                    ViewerFrame viewerFrame = (ViewerFrame)spssFrame;
                    OutputManager outputManager = OutputManager.getOutputManager();
                    outputManager.closeDocument(viewerFrame.getDocument().getCoreDocument());
                }
                if (!bl2) {
                    return false;
                }
                Vector vector = new Vector();
                for (JFrame jFrame : this.mNonDocumentFrames) {
                    if (jFrame instanceof BuilderFrame && bl && !((BuilderFrame)jFrame).checkModified(true)) {
                        bl2 = false;
                        break;
                    }
                    jFrame.setVisible(false);
                    jFrame.dispose();
                    vector.add(jFrame);
                }
                if (!bl2) {
                    return false;
                }
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    JFrame jFrame = (JFrame)iterator.next();
                    this.mNonDocumentFrames.remove(jFrame);
                }
                objectArray.clear();
                for (SpssFrame spssFrame : this.mDocumentVector) {
                    if (bl && !spssFrame.saveModified()) {
                        bl2 = false;
                        break;
                    }
                    objectArray.add(spssFrame);
                    spssFrame.setVisible(false);
                    spssFrame.dispose();
                }
                for (SpssFrame spssFrame : objectArray) {
                    this.mDocumentVector.remove(spssFrame);
                    this.mActiveFrames.remove(spssFrame.docType());
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFrame getDataFrame(LocallyUniqueId locallyUniqueId) {
        DataFrame dataFrame = null;
        if (locallyUniqueId != null) {
            Object object = sDocVectorLock;
            synchronized (object) {
                for (SpssFrame spssFrame : this.mDocumentVector) {
                    LocallyUniqueId locallyUniqueId2;
                    if (!spssFrame.docType().equals((Object)DocType.DE_DOC) || (locallyUniqueId2 = ((DataFrame)spssFrame).getDatasetId()) == null || !locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
                    dataFrame = (DataFrame)spssFrame;
                    break;
                }
            }
        }
        return dataFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDefaultStatusMsg() {
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                spssFrame.putDefaultStatusMsg();
            }
        }
    }

    public void addDocumentMenuItemsToMenuTable(Vector<String> vector, String string) {
        for (int i = 0; i < this.mDocumentVector.size() && i < 9; ++i) {
            vector.add(string + ">" + String.format("%d %s", i + 1, this.mDocumentVector.get(i).getTitle()));
        }
        if (this.mDocumentVector.size() >= 10) {
            vector.add(string + ">" + ResUtil.getString("more_documents"));
        }
    }

    public void addDocumentMenuItems(JMenu jMenu) {
        LinkedList<SpssFrame> linkedList = new LinkedList<SpssFrame>(this.mDocumentVector);
        for (JFrame jFrame : this.mNonDocumentFrames) {
            linkedList.add((SpssFrame)jFrame);
        }
        for (int i = 0; i < linkedList.size() && i < 9; ++i) {
            jMenu.add(new WindowMenuAction(linkedList.get(i), i).getMenuItem());
        }
        if (linkedList.size() >= 10) {
            jMenu.add(new MoreWindowsAction().getMenuItem());
        }
    }

    public final SpssFrame[] getOpenDocuments() {
        return this.mDocumentVector.toArray(new SpssFrame[this.mDocumentVector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparentSearchDialog(DocType docType) {
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                if (spssFrame == null || docType != spssFrame.docType()) continue;
                if (spssFrame instanceof SyntaxFrame) {
                    SyntaxFindDlg syntaxFindDlg = ((SyntaxFrame)spssFrame).getSearchDialog();
                    syntaxFindDlg.setVisible(true);
                    break;
                }
                if (!(spssFrame instanceof ViewerFrame)) break;
                ViewerFindDlg viewerFindDlg = ((ViewerFrame)spssFrame).getSearchDialog();
                viewerFindDlg.setVisible(true);
                break;
            }
        }
    }

    public OpenInfo checkForSaveFileAlreadyOpen(String string) {
        Object[] objectArray;
        Object object;
        Object object22;
        boolean bl = false;
        string = string == null ? "" : string;
        String string2 = null;
        for (Object object22 : this.mDocumentVector) {
            if (!(object22 instanceof DataFrame)) continue;
            object = ((DataFrame)object22).getDatasetId();
            objectArray = DataMgr.getDataMgr().getDataSource(object);
            if (objectArray == null || !string.equals(objectArray.getFileSpec())) continue;
            bl = true;
            string2 = objectArray.getDatasetName();
            break;
        }
        Object object3 = null;
        object22 = OpenInfo.UserResponse.newWindow;
        if (bl) {
            object = String.format(ResUtil.getString("ERR_ALREADY_OPEN_MSG"), string);
            objectArray = new String[]{ResUtil.getString("IDS_REVERT_TO_SAVED"), ResUtil.getString("IDS_OPEN_NEW_WINDOW"), ResUtil.getCommonDlgString("IDS_CANCEL")};
            int n = SpssAlertOptionPane.showOptionDialog(this.getLastActiveFrame(), (String)object, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            if (n == 0) {
                object22 = OpenInfo.UserResponse.revert;
                object3 = string2;
            } else if (n == 1) {
                object22 = OpenInfo.UserResponse.newWindow;
                object3 = string2;
            } else {
                object22 = OpenInfo.UserResponse.cancel;
            }
        }
        return new OpenInfo((String)object3, (OpenInfo.UserResponse)((Object)object22));
    }

    public boolean isDataDocumentAlreadyOpen(String string) {
        string = string == null ? "" : string;
        for (SpssFrame spssFrame : this.mDocumentVector) {
            if (!(spssFrame instanceof DataFrame)) continue;
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc == null || !(OSInfo.OSType.WIN == OSInfo.getOSType() ? string.equalsIgnoreCase(iSpssDataSrc.getFileSpec()) : string.equals(iSpssDataSrc.getFileSpec()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChartDataLinks() {
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                if (!(spssFrame instanceof ViewerFrame)) continue;
                ((ViewerFrame)spssFrame).clearDataLinkState();
            }
        }
    }

    public void updateSyntaxWindows() {
        for (SpssFrame spssFrame : new Vector<SpssFrame>(this.mDocumentVector)) {
            if (!spssFrame.docType().equals((Object)DocType.SYNTAX_DOC) || !(spssFrame instanceof SyntaxFrame) || !spssFrame.isDisplayable()) continue;
            ((SyntaxFrame)spssFrame).updateDatasetCombo();
        }
    }

    public void addNonDocumentFrame(JFrame jFrame) {
        if (!(jFrame instanceof SpssFrame) && !this.mNonDocumentFrames.contains(jFrame)) {
            this.mNonDocumentFrames.add(jFrame);
        }
    }

    public void removeNonDocumentFrame(JFrame jFrame) {
        if (this.mNonDocumentFrames.contains(jFrame)) {
            this.mNonDocumentFrames.remove(jFrame);
        }
    }

    public final Vector<JFrame> getNonDocumentFrames() {
        return this.mNonDocumentFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataPreferenceChange(String string, String string2) {
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                if (!(spssFrame instanceof DataFrame)) continue;
                ((DataFrame)spssFrame).getDataView().dataPreferenceChange(string, string2);
            }
        }
    }

    public ISyntaxDocument getActiveSyntaxDocument() {
        ISyntaxDocument iSyntaxDocument = null;
        SpssFrame spssFrame = this.mDesignatedFrames[DocType.SYNTAX_DOC.ordinal()];
        if (spssFrame instanceof SyntaxFrame && spssFrame.isDisplayable()) {
            iSyntaxDocument = ((SyntaxFrame)spssFrame).getDocument();
        }
        return iSyntaxDocument;
    }

    public void createNewSyntaxDocument(ISyntaxDocument iSyntaxDocument, boolean bl) {
        SpssFrame spssFrame = this.createFrame(DocType.SYNTAX_DOC, bl);
        if (spssFrame instanceof SyntaxFrame) {
            SyntaxFrame syntaxFrame = (SyntaxFrame)spssFrame;
            syntaxFrame.setCoreDocument(iSyntaxDocument);
        }
    }

    public void notifyOutput() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.output();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpssFrameMgr.this.output();
                }
            });
        }
    }

    private void output() {
        Preferences preferences;
        String string;
        SpssFrame spssFrame = this.getDesignatedWindow(DocType.OUTPUT_DOC);
        if (spssFrame != null && this.getLastActiveFrame() != spssFrame && Boolean.valueOf(string = (preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general")).get("raise_viewer_window", Boolean.toString(true))).booleanValue()) {
            spssFrame.toFront();
        }
    }

    public void notifyStatusEvent(final String string) {
        this.updateProcessorBusy(string);
        if (string.startsWith("_")) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateStatus(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                private String mMessage;
                {
                    this.mMessage = string;
                }

                @Override
                public void run() {
                    SpssFrameMgr.this.updateStatus(this.mMessage);
                }
            });
        }
    }

    public void notifyCaseCountEvent(String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(ResUtil.getString("IDS_EMPTY_CASES"));
        } else if (bl) {
            stringBuilder.append(ResUtil.getString("IDS_ITERATION")).append(" ").append(string);
        } else {
            stringBuilder.append(ResUtil.getString("IDS_CASES")).append(" ").append(string);
        }
        this.putStatusMsg(stringBuilder.toString(), StatusBar.StatusPane.xFormsPane);
    }

    public void notifyStatusMsgEvent(double d, double d2, int n, String string, String string2, String string3) {
        String string4 = FrameworkMgr.get().formatStatusMsg(d, d2, n, string, string2, string3);
        this.putStatusMsg(string4, StatusBar.StatusPane.xFormsPane);
    }

    public void notifyInteractorMsgEvent(String string) {
        FrameworkMgr.get().getSession().getFrameworkSessionSupport().getInteractionSupport().messageReceived(string.getBytes());
    }

    public void notifyNewOutputDocument(final IOutputDocument iOutputDocument, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.newOutputDocument(iOutputDocument, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SpssFrameMgr.this.newOutputDocument(iOutputDocument, bl);
                    }
                });
            }
            catch (Exception exception) {
                TraceSettings.trace1((String)"Interruption in SpssFrameMgr::notifyNewOutputDocument.", (int)15);
            }
        }
    }

    public void notifyNewOutputDocument(IOutputDocument iOutputDocument, String string, boolean bl) {
    }

    private void newOutputDocument(IOutputDocument iOutputDocument, boolean bl) {
        this.mMinimized = iOutputDocument.getMinimized() == IOutputDocument.Minimized.ON;
        ViewerFrame viewerFrame = (ViewerFrame)this.createFrame(DocType.OUTPUT_DOC, bl);
        viewerFrame.setCoreDocument(iOutputDocument);
        viewerFrame.updateTitleBar();
        viewerFrame.updateToolbarEnableStatus();
        this.mMinimized = false;
    }

    public boolean processUserAlert(String string, boolean bl) {
        return this.processUserAlert(string, true, bl);
    }

    public boolean processUserAlert(String string, boolean bl, boolean bl2) {
        if (AppMgr.getAppMgr().alertsEnabled()) {
            if (bl) {
                SpssAlertOptionPane.OptionType optionType = bl2 ? SpssAlertOptionPane.OptionType.YES_NO_OPTION : SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION;
                int n = SpssAlertOptionPane.showConfirmDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), string, VersionInfo.getAppVersionString(), optionType);
                return 1 == n || 0 == n;
            }
            SpssAlertOptionPane.showWarningMessageDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), string, VersionInfo.getAppVersionString());
        }
        return true;
    }

    public void abortVisualizations() {
        SpssFrame spssFrame = this.getDesignatedWindow(DocType.OUTPUT_DOC);
        if (spssFrame instanceof ViewerFrame) {
            ((ViewerFrame)spssFrame).getDocument().abortVisualizations();
        }
    }

    public void notifyOpenOutputDocument(IOutputDocument iOutputDocument, boolean bl) {
        this.mMinimized = iOutputDocument.getMinimized() == IOutputDocument.Minimized.ON;
        ViewerFrame viewerFrame = (ViewerFrame)this.createFrame(DocType.OUTPUT_DOC, bl);
        viewerFrame.setCoreDocument(iOutputDocument);
        viewerFrame.updateTitleBar();
        this.mMinimized = false;
    }

    public void notifyOpenOutputDocument(IOutputDocument iOutputDocument, String string, boolean bl) {
    }

    public void notifyCloseOutputDocument(final IOutputDocument iOutputDocument) {
        if (SwingUtilities.isEventDispatchThread()) {
            SpssFrame[] spssFrameArray;
            for (SpssFrame spssFrame : spssFrameArray = this.getOpenDocuments()) {
                if (!(spssFrame instanceof ViewerFrame) || spssFrame.getCoreDocument() == null || !spssFrame.getCoreDocument().equals(iOutputDocument)) continue;
                spssFrame.performClose();
                break;
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                private IOutputDocument mDoc;
                {
                    this.mDoc = iOutputDocument;
                }

                @Override
                public void run() {
                    SpssFrame[] spssFrameArray;
                    for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.this.getOpenDocuments()) {
                        if (!(spssFrame instanceof ViewerFrame) || spssFrame.getCoreDocument() == null || !spssFrame.getCoreDocument().equals(this.mDoc)) continue;
                        spssFrame.performClose();
                        break;
                    }
                }
            });
        }
    }

    public void notifyCloseOutputDocument(IOutputDocument iOutputDocument, String string) {
    }

    public void notifyDesignateOutputDocument(IOutputDocument iOutputDocument, boolean bl) {
        SpssFrame[] spssFrameArray;
        for (SpssFrame spssFrame : spssFrameArray = this.getOpenDocuments()) {
            if (!(spssFrame instanceof ViewerFrame) || spssFrame.getCoreDocument() == null || !spssFrame.getCoreDocument().equals(iOutputDocument)) continue;
            this.designateWindow(spssFrame);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOmsEvent(OmsViewerSelectType omsViewerSelectType, int n) {
        if (omsViewerSelectType.equals((Object)OmsViewerSelectType.kSelect) || omsViewerSelectType.equals((Object)OmsViewerSelectType.kUnselect)) {
            boolean bl;
            boolean bl2 = bl = n > 0;
            if (bl != this.mOmsActive) {
                this.mOmsActive = bl;
                Object object = sDocVectorLock;
                synchronized (object) {
                    String string = bl ? ResUtil.getString("IDS_OMS") : "     ";
                    for (SpssFrame spssFrame : this.mDocumentVector) {
                        spssFrame.getStatusBar().putPaneMessage(StatusBar.StatusPane.omsPane, string);
                    }
                }
            }
        }
    }

    public void updatePendingTransformation(LocallyUniqueId locallyUniqueId, boolean bl) {
        LocallyUniqueId locallyUniqueId2;
        SpssFrame spssFrame = this.getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame != null && (locallyUniqueId2 = ((DataFrame)spssFrame).getDatasetId()) != null && locallyUniqueId2.equals((Object)locallyUniqueId)) {
            for (SpssFrame spssFrame2 : this.mDocumentVector) {
                if (spssFrame2.docType().equals((Object)DocType.DE_DOC)) continue;
                spssFrame2.updatePendingTransformation(bl);
            }
        }
    }

    public SpssFrame getDesignatedFrame(DocType docType) {
        return this.mDesignatedFrames[docType.ordinal()];
    }

    public void setActivatedFrame(SpssFrame spssFrame) {
        DocType docType;
        if (spssFrame != null && ((docType = spssFrame.docType()) == DocType.DE_DOC || docType == DocType.SYNTAX_DOC || docType == DocType.OUTPUT_DOC)) {
            this.mActiveFrames.put(docType, spssFrame);
        }
    }

    public SpssFrame getActivatedFrame(DocType docType) {
        return this.mActiveFrames.get(docType);
    }

    private void updateProcessorBusy(String string) {
        if (string.startsWith(SPSPROMPT) || string.startsWith(SPSPROMPT16)) {
            ComponentState.setProcessorBusy((boolean)false);
        } else if (string.startsWith(SPSSCMDFIN)) {
            if (CommandLine.isRunSyntax() || CommandLine.isProduction()) {
                AppMgr.getAppMgr().monitoredShutdown();
            }
        } else {
            ComponentState.setProcessorBusy((boolean)true);
        }
    }

    private void updateStatus(String string) {
        if (string.startsWith(SPSPROMPT) || string.startsWith(SPSPROMPT16)) {
            this.putDefaultStatusMsg();
        } else if (string.startsWith(SPSSCMDFIN)) {
            this.putDefaultStatusMsg();
        } else if (string.startsWith(SPSDATA)) {
            this.putStatusMsg(ResUtil.getString("IDS_WAITING_FOR_DATA"), StatusBar.StatusPane.processorPane);
        } else if (string.startsWith(SPSDEFINE)) {
            this.putStatusMsg(ResUtil.getString("IDS_WAITING_FOR_END_DEFINE"), StatusBar.StatusPane.processorPane);
        } else if (string.startsWith(SPSMACRO)) {
            this.putStatusMsg(ResUtil.getString("IDS_MACRO_PROCESSING"), StatusBar.StatusPane.processorPane);
        } else if (string.startsWith(SPSMATRIX)) {
            this.putStatusMsg(ResUtil.getString("IDS_WAITING_FOR_END_MATRIX"), StatusBar.StatusPane.processorPane);
        } else if (string.startsWith(SPSUSERCODE)) {
            this.putStatusMsg(ResUtil.getString("IDS_WAITING_FOR_END_USER"), StatusBar.StatusPane.processorPane);
        } else if (string.startsWith(SPSOPENING)) {
            this.putStatusMsg(ResUtil.getString("IDS_OPENING_DOCUMENT"), StatusBar.StatusPane.processorPane);
        } else {
            String string2 = ResUtil.getString("IDS_RUNNING");
            String string3 = string2 + " " + string.trim() + "...";
            this.putStatusMsg(string3, StatusBar.StatusPane.processorPane);
        }
    }

    private void setFrameSize(SpssFrame spssFrame) {
        DocType docType = spssFrame.docType();
        SpssFrame spssFrame2 = this.getActivatedFrame(docType);
        if (spssFrame2 != null) {
            if (spssFrame2.getExtendedState() == 6) {
                spssFrame.setExtendedState(6);
            } else {
                spssFrame.setSize(spssFrame2.getWidth(), spssFrame2.getHeight());
            }
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            int n = 0;
            int n2 = 0;
            if (docType == DocType.DE_DOC) {
                Preferences preferences2 = preferences.node("doc_types").node("dataeditor");
                n = preferences2.getInt("data_editor_height", 0);
                n2 = preferences2.getInt("data_editor_width", 0);
            } else if (docType == DocType.SYNTAX_DOC) {
                Preferences preferences3 = preferences.node("doc_types").node("syntax");
                n = preferences3.getInt("syntax_editor_height", 0);
                n2 = preferences3.getInt("syntax_editor_width", 0);
            } else if (docType == DocType.OUTPUT_DOC) {
                Preferences preferences4 = preferences.node("doc_types").node("output");
                n = preferences4.getInt("viewer_height", 0);
                n2 = preferences4.getInt("viewer_width", 0);
            }
            if (n == 0 || n2 == 0) {
                spssFrame.setSize(dimension.width * 2 / 3, dimension.height * 2 / 3);
            } else if (n == -1 && n2 == -1) {
                spssFrame.setExtendedState(6);
            } else {
                spssFrame.setSize(n2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putStatusMsg(String string, StatusBar.StatusPane statusPane) {
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame : this.mDocumentVector) {
                StatusBar statusBar = spssFrame.getStatusBar();
                if (statusBar == null || statusPane != StatusBar.StatusPane.xFormsPane && string.trim().length() <= 0) continue;
                statusBar.putPaneMessage(statusPane, string);
            }
        }
    }

    private Point nextStartLocation(SpssFrame spssFrame, SpssFrame spssFrame2) {
        Point point;
        Dimension dimension = spssFrame.getSize();
        Rectangle rectangle = this.getScreenBounds();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (spssFrame2 != null) {
            point = spssFrame2.getLocation();
            point.setLocation(point.x + 30, point.y + 30);
            if (point.x + dimension.width > rectangle.width || point.y + dimension.height > rectangle.height) {
                point.setLocation(1, 1);
            }
        } else {
            point = new Point((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
        return point;
    }

    private Rectangle getScreenBounds() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle rectangle = new Rectangle();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    protected SpssFrameMgr() {
    }

    private SpssFrameMgr(boolean bl) {
        if (!bl) {
            return;
        }
        Arrays.fill(this.mDesignatedFrames, null);
        SyntaxMgr.getSyntaxMgr().addSyntaxMgrListener((ISyntaxMgrListener)this);
        OutputManager.getOutputManager().addOutputListener((IOutputListener)this);
        OutputManager.getOutputManager().getOmsManager().addOmsListener((IOmsEventListener)this);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (((WindowEvent)aWTEvent).getWindow() instanceof SpssFrame) {
                    if (aWTEvent.getID() == 205) {
                        SpssFrameMgr.this.mLastActiveFrame = (SpssFrame)((WindowEvent)aWTEvent).getWindow();
                    } else if ((aWTEvent.getID() == 202 || aWTEvent.getID() == 203) && SpssFrameMgr.this.mLastActiveFrame == ((WindowEvent)aWTEvent).getWindow()) {
                        SpssFrameMgr.this.mLastActiveFrame = null;
                    }
                }
            }
        }, 64L);
        Toolkit.getDefaultToolkit().addAWTEventListener(new MyAWTKeyEventListener(), 8L);
    }

    private SpssFrame findParentFrame(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof SpssFrame); container = container.getParent()) {
        }
        return container != null ? (SpssFrame)container : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpssFrame getLastFrameOfType(DocType docType) {
        SpssFrame spssFrame = null;
        Object object = sDocVectorLock;
        synchronized (object) {
            for (SpssFrame spssFrame2 : this.mDocumentVector) {
                if (!spssFrame2.docType().equals((Object)docType)) continue;
                spssFrame = spssFrame2;
            }
        }
        return spssFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocument(SpssFrame spssFrame) {
        Object object = sDocVectorLock;
        synchronized (object) {
            this.mDocumentVector.add(spssFrame);
        }
    }

    private boolean checkWindowChildren(Window window, boolean bl) {
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray.length > 0) {
            for (int i = windowArray.length - 1; i >= 0; --i) {
                Window window2 = windowArray[i];
                if (this.checkWindowChildren(window2, bl)) {
                    return true;
                }
                if (!window2.isVisible() || !(window2 instanceof Dialog) || !((Dialog)window2).isModal()) continue;
                if (bl) {
                    windowArray[i].toFront();
                }
                return true;
            }
        }
        return false;
    }

    private void loadDocumentIcons() {
        String[] stringArray = new String[]{"IDI_DE_WINDOW_ACTIVE", "IDI_SYNTAX_WINDOW_ACTIVE", "IDI_OUTPUT_WINDOW_ACTIVE", "IDI_DE_WINDOW_ACTIVE"};
        String[] stringArray2 = new String[]{"IDI_DE_WINDOW_INACTIVE", "IDI_SYNTAX_WINDOW_INACTIVE", "IDI_OUTPUT_WINDOW_INACTIVE", "IDI_DE_WINDOW_INACTIVE"};
        for (int i = 0; i < 4; ++i) {
            this.mActiveIcons[i] = new ImageIcon(ResUtil.getImageURL(stringArray[i]));
            this.mInactiveIcons[i] = new ImageIcon(ResUtil.getImageURL(stringArray2[i]));
        }
    }

    public void disableAllFramesButThis(DocType docType) {
        for (SpssFrame spssFrame : this.mDocumentVector) {
            if (spssFrame.docType() == docType) continue;
            spssFrame.disableAllToolbarItems();
            spssFrame.setEnabled(false);
        }
    }

    public void enableAllFrames() {
        for (SpssFrame spssFrame : this.mDocumentVector) {
            spssFrame.setEnabled(true);
            spssFrame.updateToolbarEnableStatus();
        }
    }

    public boolean isModifyOutputDialogActive() {
        boolean bl = false;
        for (SpssFrame spssFrame : this.mDocumentVector) {
            if (!(spssFrame instanceof ViewerFrame) || !((ViewerFrame)spssFrame).isOuputModifyDialogActive()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static class DocVectorLock {
        DocVectorLock() {
        }
    }

    private class MyAWTKeyEventListener
    implements AWTEventListener {
        private MyAWTKeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            SpssFrame spssFrame = SpssFrameMgr.this.findParentFrame(((KeyEvent)aWTEvent).getComponent());
            if (spssFrame != null && aWTEvent.getID() == 401) {
                boolean bl = OSInfo.getOSType() == OSInfo.OSType.MAC;
                int n = ((KeyEvent)aWTEvent).getKeyCode();
                boolean bl2 = ((KeyEvent)aWTEvent).isControlDown();
                if (!bl && n == 121 || bl && n == 116 && bl2) {
                    if (SpssFrameMgr.this.mF10LastFocusComponent == null) {
                        SpssFrameMgr.this.mF10LastFocusComponent = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        spssFrame.setToolbarItemsFocusable(true);
                        spssFrame.setFocusOnToolbars();
                    }
                } else if (n == 9 && SpssFrameMgr.this.mF10LastFocusComponent != null) {
                    if (bl2) {
                        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (menuElementArray != null) {
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                            spssFrame.setFocusOnToolbars();
                        }
                    } else {
                        Component component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        if (component != null && !spssFrame.isToolbarControl(component)) {
                            SpssFrameMgr.this.mF10LastFocusComponent = null;
                            this.clearFocusableState(spssFrame);
                        }
                    }
                } else if (n == 27) {
                    this.clearFocusableState(spssFrame);
                }
            }
        }

        protected void clearFocusableState(SpssFrame spssFrame) {
            if (SpssFrameMgr.this.mF10LastFocusComponent != null) {
                SpssFrameMgr.this.mF10LastFocusComponent.requestFocusInWindow();
                SpssFrameMgr.this.mF10LastFocusComponent = null;
            }
            if (spssFrame != null) {
                spssFrame.setToolbarItemsFocusable(false);
            }
        }
    }

    public static class OpenInfo {
        private String mDataSetName = null;
        private UserResponse mResponse = UserResponse.cancel;

        OpenInfo(String string, UserResponse userResponse) {
            this.mDataSetName = string;
            this.mResponse = userResponse;
        }

        public String getDataSetName() {
            return this.mDataSetName;
        }

        public UserResponse getResponse() {
            return this.mResponse;
        }

        public static enum UserResponse {
            revert,
            newWindow,
            cancel;

        }
    }
}

