/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.DAC.excel;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.ODF.ODFCalcDac;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelDac;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelSheetInfo;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelXDac;
import com.spss.java_client.core.documents.data.data_access.excel.XlsCellRange;
import com.spss.java_client.core.server.messages.DACErrorResponse;
import com.spss.java_client.ui.DAC.DacMgrUICallback;
import com.spss.java_client.ui.DAC.resources.DacResBundle;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SelectRangeDlg
extends BaseDialog {
    private String mFilePath = null;
    private boolean mOkToContinue = false;
    private boolean mFullRangeSelected = false;
    private boolean mReadVarNamesSelected = false;
    private int mMaxStringWidth = Short.MAX_VALUE;
    private String mSelectedSheetName = "";
    private static Vector<ExcelSheetInfo> mSheetInfos = new Vector();
    private XlsCellRange mCellRange = new XlsCellRange();
    private JLabel mFilePathStatic = null;
    private JCheckBox mReadVarNamesCheck = null;
    private JComboBox mWorksheetCombo = null;
    private StringTextField mRangeEdit = null;
    private IntTextField mMaxStringWidthEdit = null;

    public static boolean runExcelRangeDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        ExcelDac.ExcelDacData excelDacData = null;
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof ExcelDac.ExcelDacData) {
            excelDacData = (ExcelDac.ExcelDacData)dataAccessContainer.getDacData();
        }
        assert (dataAccessContainer != null && dataAccessContainer.getDataSpec() != null);
        SelectRangeDlg selectRangeDlg = new SelectRangeDlg(spssFrame, dataAccessContainer.getDataSpec());
        selectRangeDlg.pack();
        selectRangeDlg.setLocationRelativeTo(null);
        selectRangeDlg.setVisible(true);
        boolean bl = selectRangeDlg.isOkToContinue();
        if (bl && excelDacData != null) {
            excelDacData.setCellRange(selectRangeDlg.getCellRange());
            excelDacData.setFullRangeSelected(selectRangeDlg.isFullRangeSelected());
            excelDacData.setMaxStringWidth(selectRangeDlg.getMaxStringWidth());
            excelDacData.setReadVarNames(selectRangeDlg.isReadVarNamesSelected());
            excelDacData.setSheetName(selectRangeDlg.getSelectedSheetName());
        }
        return bl;
    }

    public static boolean runExcelXRangeDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        ExcelXDac.ExcelXDacData excelXDacData = null;
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof ExcelXDac.ExcelXDacData) {
            excelXDacData = (ExcelXDac.ExcelXDacData)dataAccessContainer.getDacData();
        }
        assert (dataAccessContainer != null && dataAccessContainer.getDataSpec() != null);
        SelectRangeDlg selectRangeDlg = new SelectRangeDlg(spssFrame, dataAccessContainer.getDataSpec());
        selectRangeDlg.pack();
        selectRangeDlg.setLocationRelativeTo(null);
        selectRangeDlg.setVisible(true);
        boolean bl = selectRangeDlg.isOkToContinue();
        if (bl && excelXDacData != null) {
            excelXDacData.setCellRange(selectRangeDlg.getCellRange());
            excelXDacData.setFullRangeSelected(selectRangeDlg.isFullRangeSelected());
            excelXDacData.setMaxStringWidth(selectRangeDlg.getMaxStringWidth());
            excelXDacData.setReadVarNames(selectRangeDlg.isReadVarNamesSelected());
            excelXDacData.setSheetName(selectRangeDlg.getSelectedSheetName());
        }
        return bl;
    }

    public static boolean runODFCalcRangeDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        ODFCalcDac.ODFCalcDacData oDFCalcDacData = null;
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof ODFCalcDac.ODFCalcDacData) {
            oDFCalcDacData = (ODFCalcDac.ODFCalcDacData)dataAccessContainer.getDacData();
        }
        assert (dataAccessContainer != null && dataAccessContainer.getDataSpec() != null);
        SelectRangeDlg selectRangeDlg = new SelectRangeDlg(spssFrame, dataAccessContainer.getDataSpec());
        DacMgrUICallback.ExcelReadInfo excelReadInfo = DacMgrUICallback.retrieveXlsSheetVector(dataAccessContainer);
        DACErrorResponse dACErrorResponse = excelReadInfo.getRetVal();
        if (dACErrorResponse.getResourceId() != 0) {
            switch (excelReadInfo.getRetVal().getResourceId()) {
                case 2005: {
                    selectRangeDlg.showErrorMessage(spssFrame, "ERR_JVM_CREATE_ERROR_MSG", dataAccessContainer.getDataSpec());
                    break;
                }
                case 2067: {
                    selectRangeDlg.showErrorMessage(spssFrame, dACErrorResponse.getTextStr(), dataAccessContainer.getDataSpec());
                    break;
                }
                default: {
                    selectRangeDlg.showErrorMessage(spssFrame, "ERR_FILE_ACCESS_ERROR_MSG", dataAccessContainer.getDataSpec());
                }
            }
            return false;
        }
        selectRangeDlg.pack();
        selectRangeDlg.setLocationRelativeTo(null);
        selectRangeDlg.setVisible(true);
        boolean bl = selectRangeDlg.isOkToContinue();
        if (bl && oDFCalcDacData != null) {
            oDFCalcDacData.setCellRange(selectRangeDlg.getCellRange());
            oDFCalcDacData.setFullRangeSelected(selectRangeDlg.isFullRangeSelected());
            oDFCalcDacData.setMaxStringWidth(selectRangeDlg.getMaxStringWidth());
            oDFCalcDacData.setReadVarNames(selectRangeDlg.isReadVarNamesSelected());
            oDFCalcDacData.setSheetName(selectRangeDlg.getSelectedSheetName());
        }
        return bl;
    }

    public String getDialogHelpID() {
        return "idh_idd_xlscellrange";
    }

    public String getSelectedSheetName() {
        return this.mSelectedSheetName;
    }

    public boolean isFullRangeSelected() {
        return this.mFullRangeSelected;
    }

    public XlsCellRange getCellRange() {
        return this.mCellRange;
    }

    public boolean isReadVarNamesSelected() {
        return this.mReadVarNamesSelected;
    }

    public int getMaxStringWidth() {
        return this.mMaxStringWidth;
    }

    private void showErrorMessage(Component component, String string, String string2) {
        String string3 = this.getResString(string);
        if (string3 != null) {
            String string4 = string3 + "\n\"" + string2 + "\"";
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string4, VersionInfo.getAppVersionString());
        } else {
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string, VersionInfo.getAppVersionString());
        }
    }

    private boolean isOkToContinue() {
        return this.mOkToContinue;
    }

    private SelectRangeDlg(SpssFrame spssFrame, String string) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(DacResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DacResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OPEN_XLS_TITLE"));
        this.mFilePath = string;
        this.initialize();
    }

    private boolean continuePressed() {
        if (!this.validateRange()) {
            String string = this.getResString("ERR_INVALID_CELL_RANGE_MSG");
            String string2 = String.format(string, this.mRangeEdit.getText());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            this.mRangeEdit.selectAll();
            this.mRangeEdit.requestFocus();
            return false;
        }
        XlsCellRange xlsCellRange = this.getSelectedSheetRange();
        if (!(this.mFullRangeSelected || xlsCellRange != null && this.mCellRange.isSubset(xlsCellRange))) {
            String string = this.getResString("ERR_BAD_CELL_RANGE_MSG");
            String string3 = String.format(string, this.mRangeEdit.getText());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            this.mRangeEdit.selectAll();
            this.mRangeEdit.requestFocus();
            return false;
        }
        if (!this.validateMaxStringWidth()) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("ERR_MAX_WIDTH_ERROR_MSG"), VersionInfo.getAppVersionString());
            this.mMaxStringWidthEdit.selectAll();
            this.mMaxStringWidthEdit.requestFocus();
            return false;
        }
        this.mReadVarNamesSelected = this.mReadVarNamesCheck.isSelected();
        this.mMaxStringWidth = Integer.valueOf(this.mMaxStringWidthEdit.getText());
        int n = this.mWorksheetCombo.getSelectedIndex();
        assert (n > -1);
        this.mSelectedSheetName = mSheetInfos.get(n).getSheetName();
        return true;
    }

    private XlsCellRange getSelectedSheetRange() {
        int n = this.mWorksheetCombo.getSelectedIndex();
        if (mSheetInfos.size() == 0 || n < 0 || n >= mSheetInfos.size()) {
            return null;
        }
        return mSheetInfos.get(n).getCellRng();
    }

    private boolean validateRange() {
        String string = this.mRangeEdit.getText().toUpperCase();
        this.mCellRange.reset();
        this.mFullRangeSelected = string.length() == 0;
        return string.length() == 0 || this.mCellRange.ExcelCellRngToCellRect(string);
    }

    private boolean validateMaxStringWidth() {
        return this.mMaxStringWidthEdit.getText().length() > 0;
    }

    private void initialize() {
        this.setResizable(true);
        this.addControls();
        this.initializeControls();
    }

    private void initializeControls() {
        this.mFilePathStatic.setText(this.mFilePath);
        this.mReadVarNamesCheck.setSelected(true);
        this.mMaxStringWidthEdit.setText("32767");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        ContinueAction continueAction = new ContinueAction();
        JButton jButton = new JButton(continueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void fillWorksheetCombo() {
        this.mWorksheetCombo.removeAllItems();
        if (mSheetInfos != null) {
            for (ExcelSheetInfo excelSheetInfo : mSheetInfos) {
                String string = excelSheetInfo.getSheetName();
                XlsCellRange xlsCellRange = excelSheetInfo.getCellRng();
                String string2 = String.format("%s [%s]", string, xlsCellRange.toString());
                if (ComponentState.isBtdRtlOrLtr()) {
                    this.mWorksheetCombo.addItem(ComponentState.prepareStringForBidiRendering((String)string2));
                    continue;
                }
                this.mWorksheetCombo.addItem(string2);
            }
        }
    }

    private void addControls() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mFilePathStatic = new JLabel();
        this.mReadVarNamesCheck = new JCheckBox(this.getResString("IDS_READ_VAR_NAMES"));
        JLabel jLabel = new JLabel(this.getResString("IDS_WORKSHEET_COLON"));
        this.mWorksheetCombo = new JComboBox();
        this.fillWorksheetCombo();
        JLabel jLabel2 = new JLabel(this.getResString("IDS_RANGE_COLON"));
        this.mRangeEdit = new StringTextField();
        JLabel jLabel3 = new JLabel(this.getResString("IDS_MAX_STRING_WIDTH"));
        this.mMaxStringWidthEdit = new IntTextField(1, Short.MAX_VALUE, true);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 12, 12, 12);
        jPanel.add((Component)this.mFilePathStatic, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 12, 4, 12);
        jPanel.add((Component)this.mReadVarNamesCheck, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mWorksheetCombo.setEnabled(true);
        this.mWorksheetCombo.setEditable(false);
        jPanel.add((Component)this.mWorksheetCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)((Object)this.mRangeEdit), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.anchor = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.mMaxStringWidthEdit, gridBagConstraints);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public static void setSheetInfos(Vector<ExcelSheetInfo> vector) {
        mSheetInfos = vector;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectRangeDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectRangeDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectRangeDlg.this.continuePressed()) {
                SelectRangeDlg.this.mOkToContinue = true;
                SelectRangeDlg.this.dispose();
            }
        }
    }
}

