/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.DAC;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.SpssSyntaxDacDescriptor;
import com.spss.java_client.ui.DAC.resources.DacResBundle;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OpenFileOptionsDlg
extends BaseDialog {
    private String mFilePath = null;
    private boolean mOkToContinue = false;
    private JLabel mFilePathStatic = null;
    private JCheckBox mReadVarNamesCheck = null;
    private JLabel mRangePrompt = null;
    private StringTextField mRangeEdit = null;

    public static boolean runOpenFileOptionsDlg(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        SpssSyntaxDacDescriptor spssSyntaxDacDescriptor = null;
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof SpssSyntaxDacDescriptor) {
            spssSyntaxDacDescriptor = (SpssSyntaxDacDescriptor)dataAccessContainer.getDacData();
        }
        assert (dataAccessContainer != null && dataAccessContainer.getDataSpec() != null);
        OpenFileOptionsDlg openFileOptionsDlg = new OpenFileOptionsDlg(spssFrame, dataAccessContainer.getDataSpec());
        openFileOptionsDlg.pack();
        openFileOptionsDlg.setLocationRelativeTo(null);
        openFileOptionsDlg.setVisible(true);
        boolean bl = openFileOptionsDlg.isOkToContinue();
        if (bl && spssSyntaxDacDescriptor != null) {
            spssSyntaxDacDescriptor.setRange(openFileOptionsDlg.getCellRange());
            spssSyntaxDacDescriptor.setReadVariables(openFileOptionsDlg.isReadVarNamesSelected());
        }
        return bl;
    }

    public String getDialogHelpID() {
        return "idh_spreadsheet_options_dlg";
    }

    public String getCellRange() {
        return this.mRangeEdit.getText();
    }

    public boolean isReadVarNamesSelected() {
        return this.mReadVarNamesCheck.isSelected();
    }

    private boolean isOkToContinue() {
        return this.mOkToContinue;
    }

    private OpenFileOptionsDlg(SpssFrame spssFrame, String string) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(DacResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DacResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_FILE_OPT_TITLE"));
        this.mFilePath = string;
        this.initialize();
    }

    private boolean continuePressed() {
        if (!this.validateRange()) {
            String string = this.getResString("ERR_INVALID_CELL_RANGE_MSG");
            String string2 = String.format(string, this.mRangeEdit.getText());
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            this.mRangeEdit.selectAll();
            this.mRangeEdit.requestFocus();
            return false;
        }
        return true;
    }

    private boolean validateRange() {
        return true;
    }

    private void initialize() {
        this.setResizable(true);
        this.addControls();
        this.initializeControls();
    }

    private void initializeControls() {
        this.mFilePathStatic.setText(this.mFilePath);
        this.mReadVarNamesCheck.setSelected(true);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        ContinueAction continueAction = new ContinueAction();
        JButton jButton = new JButton(continueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        jButton3.putClientProperty("JButton.buttonType", "help");
        if (OSCheck.getOSType() == OSInfo.OSType.MAC && OSCheck.isMacOSXLeopardOrLater()) {
            jButton3.setText("");
        }
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void addControls() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mFilePathStatic = new JLabel();
        this.mReadVarNamesCheck = new JCheckBox(this.getResString("IDS_OPT_READ_VAR_NAMES"));
        this.mRangePrompt = new JLabel(this.getResString("IDS_RANGE_COLON"));
        this.mRangeEdit = new StringTextField();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 12, 12, 12);
        jPanel.add((Component)this.mFilePathStatic, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 12, 4, 12);
        jPanel.add((Component)this.mReadVarNamesCheck, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.mRangePrompt, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)((Object)this.mRangeEdit), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenFileOptionsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenFileOptionsDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OpenFileOptionsDlg.this.continuePressed()) {
                OpenFileOptionsDlg.this.mOkToContinue = true;
                OpenFileOptionsDlg.this.dispose();
            }
        }
    }
}

