/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.DAC;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.data_access.DacType;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.IDataAccessCallback;
import com.spss.java_client.core.documents.data.data_access.ODF.ODFCalcDataProxy;
import com.spss.java_client.core.documents.data.data_access.SpssSyntaxDacDescriptor;
import com.spss.java_client.core.documents.data.data_access.excel.BaseExcelDacData;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelDataProxy;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelSheetInfo;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelXDataProxy;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.TextDacProxy;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.messages.DACErrorResponse;
import com.spss.java_client.core.server.messages.DataAccess.syntaxmsg.SpssSyntaxDacFileType;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.DAC.OpenFileOptionsDlg;
import com.spss.java_client.ui.DAC.excel.SelectRangeDlg;
import com.spss.java_client.ui.DAC.resources.DacResBundle;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadCSVFileDialog;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadExcelFileDialog;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.res.UIToolResUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class DacMgrUICallback
implements IDataAccessCallback {
    public static final int TEXT_DAC_READ_NO_ERRORS = 0;
    public static final int TEXT_DAC_READ_ERROR_NO_DATA_FILE = -1;
    public static final int TEXT_DAC_READ_ERROR_NO_DATA = -2;
    public static final int TEXT_DAC_READ_ERROR_DATA_TOO_WIDE = -3;
    public static final int ALL_RECORDS_ALREADY_READ = -4;
    public static final int UPDATE_STOPPED = -2;
    static final int MESSAGE_BUFFER_SIZE = 199999;
    static final int MAX_DATA_SIZE = 4000000;
    private SpssFrame mSpssFrame = null;
    private JFrame mJFrame = null;
    public static final int DEFAULT_LINES_TO_SCAN = 200;
    static TextDacProxy mProxy = null;
    static int mOldLastRecordReadLineNum = 0;
    static boolean mEndOfFileReached = false;
    static boolean mKillUpdateDate = false;

    public DacMgrUICallback(SpssFrame spssFrame) {
        this.mSpssFrame = spssFrame;
    }

    public DacMgrUICallback(JFrame jFrame) {
        this.mJFrame = jFrame;
    }

    public boolean browseForFile(DataAccessContainer dataAccessContainer) {
        int n;
        String string;
        FileFilter[] fileFilterArray;
        RemoteFileChooser remoteFileChooser = DocUtil.getDocTypeFileChooser(RemoteFileChooser.ChooserType.OpenFile, DocType.DE_DOC);
        for (FileFilter fileFilter : fileFilterArray = remoteFileChooser.getChoosableFileFilters()) {
            string = this.getDefaultFilterName(dataAccessContainer);
            if (!fileFilter.getDescription().equals(string)) continue;
            remoteFileChooser.setFileFilter(fileFilter);
            break;
        }
        if ((n = remoteFileChooser.showOpenDialog(this.mSpssFrame)) == 0) {
            String string2;
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            if (dataAccessContainer.isOpenTextWizardAction()) {
                remoteFileChooser.getApproveButton().doClick();
            }
            File file = remoteFileChooser.getSelectedFile();
            try {
                String string3;
                boolean bl = true;
                string = file.getAbsolutePath();
                int n2 = string.lastIndexOf(46);
                if (n2 >= 0) {
                    bl = false;
                    string3 = string.substring(string.lastIndexOf(46));
                    if (string3.compareToIgnoreCase(".sav") == 0) {
                        bl = true;
                    }
                }
                if (!remoteFileChooser.isPasteSelected() && bl) {
                    RemoteFileStatus remoteFileStatus;
                    string3 = "";
                    String string4 = null;
                    SpssFrameMgr.OpenInfo openInfo = SpssFrameMgr.getSpssFrameMgr().checkForSaveFileAlreadyOpen(file.getAbsolutePath());
                    if (openInfo.getResponse() == SpssFrameMgr.OpenInfo.UserResponse.revert) {
                        string4 = openInfo.getDataSetName();
                    } else if (openInfo.getResponse() == SpssFrameMgr.OpenInfo.UserResponse.cancel) {
                        return false;
                    }
                    if (string4 != null && string4.length() > 0) {
                        string3 = string3 + "DATASET CLOSE " + string4 + ".\n";
                        SyntaxMgr.getSyntaxMgr().executeSyntax(string3);
                    }
                    if (openInfo.getDataSetName() == null && !(remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(file.getAbsolutePath())).errorOccurred() && remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE_BUT_LOCKED && !RemoteFileChooser.displayConfirmFileInUseAlert(file.getAbsolutePath(), this.mSpssFrame)) {
                        return false;
                    }
                }
                string2 = (string3 = PES_Repository.getPesFile((String)file.getAbsolutePath())) == null ? (remoteFileChooser.isServerFileSystem() ? file.getAbsolutePath() : file.getCanonicalPath()) : string3.getUri();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string2 = file.getPath();
            }
            dataAccessContainer.setDataSpec(string2);
            dataAccessContainer.setIsPaste(remoteFileChooser.isPasteSelected());
            dataAccessContainer.setLockFileOnRetrieve(remoteFileChooser.isLockSelected());
            dataAccessContainer.setMinimizeStringWidths(remoteFileChooser.getIsMinimizeStringWidths());
            if (remoteFileChooser.isEncodingSelectionEnabled()) {
                String string5 = remoteFileChooser.getEncodingSelection();
                dataAccessContainer.setTextFileEncoding(string5.equals("Local") ? "Locale" : string5);
            }
            if (!DacMgr.getDacMgr().determineDacForSource(dataAccessContainer)) {
                if (dataAccessContainer.getTextFileEncoding() != null && dataAccessContainer.getTextFileEncoding().equals("UTF16")) {
                    this.displayDacError(CoreResUtil.getString((String)"ERR_TW_INVALID_ENCODING_ERROR"));
                } else {
                    this.displayDacError(String.format(ResUtil.getString("ERR_FILE_NOT_OF_DATA_TYPE_ERROR"), string2));
                }
                return false;
            }
        }
        return n == 0;
    }

    private String getDefaultFilterName(DataAccessContainer dataAccessContainer) {
        String string = null;
        DacType dacType = dataAccessContainer.getUserSpecifiedDacType();
        if (dataAccessContainer.isOpenTextWizardAction()) {
            string = dacType == DacType.DAC_TXT_CSV ? CoreResUtil.getString((String)"IDS_CSV_TEXT_FILES_FILTER") : CoreResUtil.getString((String)"IDS_TEXT_FILES_FILTER");
        } else if (dacType == DacType.DAC_XLS) {
            string = CoreResUtil.getString((String)"IDS_XLS_FILE_FILTER");
        } else if (dacType == DacType.DAC_STATA) {
            string = CoreResUtil.getString((String)"IDS_STATA_FILE_FILTER");
        } else if (dacType == DacType.DAC_LOTUS) {
            string = CoreResUtil.getString((String)"IDS_LOTUS_FILE_FILTER");
        } else if (dacType == DacType.DAC_SYLK) {
            string = CoreResUtil.getString((String)"IDS_SYLK_FILE_FILTER");
        } else if (dacType == DacType.DAC_OLEDB) {
            string = CoreResUtil.getString((String)"IDS_DBASE_FILE_FILTER");
        } else if (dacType == DacType.DAC_SAS) {
            string = CoreResUtil.getString((String)"IDS_SAS_FILES_FILTER");
        }
        return string;
    }

    public boolean showImportUI(DataAccessContainer dataAccessContainer) {
        boolean bl = false;
        if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_SAV) || dataAccessContainer.getDacType().equals((Object)DacType.DAC_ZSAV)) {
            bl = this.checkSavFileEncoding(dataAccessContainer);
        } else {
            if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_CRYPT_SAV) || dataAccessContainer.getDacType().equals((Object)DacType.DAC_CRYPT_ZSAV)) {
                DocUtil.DataEncryptionTestResults dataEncryptionTestResults = new DocUtil.DataEncryptionTestResults();
                String string = "";
                HashMap hashMap = CommandLine.getFilenamesToPasswords();
                String string2 = dataAccessContainer.getDataSpec();
                if (hashMap.size() > 0) {
                    string = (String)hashMap.get(string2);
                }
                if (string != null && !string.isEmpty()) {
                    CommandLine.removeFilenamesToPasswordsKey((String)string2);
                    String string3 = PassEncrypt.manglePassword((String)string);
                    boolean bl2 = DacMgr.isEncryptionPasswordValid((String)string2, (DacMgr.FileType)DacMgr.FileType.Data, (String)string3);
                    if (bl2) {
                        dataEncryptionTestResults.setRetVal((short)0);
                        dataEncryptionTestResults.setErrorMsg(null);
                        DacMgr.SysFileVarInfoReturnInfo sysFileVarInfoReturnInfo = DacMgr.getSysFileVarInfoReturnInfo((String)string2, (String)string3);
                        Vector vector = sysFileVarInfoReturnInfo.getVarBlocks();
                        dataEncryptionTestResults.setRetVal(sysFileVarInfoReturnInfo.getRetVal());
                        dataEncryptionTestResults.setErrorMsg(sysFileVarInfoReturnInfo.getErrorMsg());
                        if (sysFileVarInfoReturnInfo.getRetVal() == 89) {
                            String string4 = String.format(ComponentState.getSPSSLocale(), CoreResUtil.getString((String)"IDS_ENCRYPT_PASSWORD_INVALID_SHORT"), new Object[0]);
                            System.err.println(string4);
                        } else {
                            dataEncryptionTestResults.setVarBlocks(vector);
                            dataEncryptionTestResults.setMangledPassword(PassEncrypt.manglePassword((String)string));
                        }
                        dataAccessContainer.setPassword(dataEncryptionTestResults.getMangledPassword());
                        dataAccessContainer.setScrambledPassword(true);
                    } else {
                        String string5 = String.format(ComponentState.getSPSSLocale(), CoreResUtil.getString((String)"ERR_FILE_OPEN_PASSWORD_FAILED"), new Object[0]);
                        System.err.println(string5);
                    }
                } else {
                    DocUtil.doEncryptPasswordDlg(this.mSpssFrame, dataAccessContainer.getDataSpec(), dataEncryptionTestResults, DacMgr.FileType.Data);
                    if (dataEncryptionTestResults.isPasswordDlgOKPressed()) {
                        dataAccessContainer.setPassword(dataEncryptionTestResults.getMangledPassword());
                        dataAccessContainer.setScrambledPassword(true);
                    }
                }
                bl = this.checkSavFileEncoding(dataAccessContainer);
                return bl;
            }
            if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_XLS) || dataAccessContainer.getDacType().equals((Object)DacType.DAC_XLSX)) {
                bl = DacMgrUICallback.runReadExcelDataDialog(this.mSpssFrame, dataAccessContainer);
            } else if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_ODF_CALC)) {
                bl = SelectRangeDlg.runODFCalcRangeDialog(this.mSpssFrame, dataAccessContainer);
            } else if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_TXT)) {
                bl = DacMgrUICallback.runReadTextDataDialog(this.mSpssFrame, dataAccessContainer);
            } else if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_SYNTAX)) {
                bl = true;
                SpssSyntaxDacFileType spssSyntaxDacFileType = ((SpssSyntaxDacDescriptor)dataAccessContainer.getDacData()).getDacFileType();
                if (spssSyntaxDacFileType == SpssSyntaxDacFileType.ExcelXLS || spssSyntaxDacFileType == SpssSyntaxDacFileType.LotusWK || spssSyntaxDacFileType == SpssSyntaxDacFileType.SylkFile) {
                    bl = OpenFileOptionsDlg.runOpenFileOptionsDlg(this.mSpssFrame, dataAccessContainer);
                }
            }
        }
        return bl;
    }

    protected boolean checkSavFileEncoding(DataAccessContainer dataAccessContainer) {
        boolean bl = true;
        if (ComponentState.isUnicodeServer()) {
            DacMgr.SysFileEncodingReturnInfo sysFileEncodingReturnInfo = DacMgr.getSysFileEncodingInfo((String)dataAccessContainer.getDataSpec(), (String)dataAccessContainer.getPassword());
            String string = sysFileEncodingReturnInfo.getEncoding();
            Vector vector = new Vector();
            SysFileProxy.getSysFileProxy().getSysFileVarInfo(dataAccessContainer.getDataSpec(), vector, dataAccessContainer.getPassword());
            if (vector.size() > 0) {
                boolean bl2 = false;
                for (VariableBlock variableBlock : vector) {
                    if (variableBlock.getDiType() <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && !string.equalsIgnoreCase("UTF-8")) {
                    JFrame jFrame = this.mSpssFrame != null ? this.mSpssFrame : this.mJFrame;
                    switch (SpssAlertOptionPane.showConfirmDialog(jFrame, CoreResUtil.getString((String)"IDS_UNICODE_MIN_STRING_WIDTHS_TEXT"), CoreResUtil.getString((String)"IDS_UNICODE_MIN_STRING_WIDTHS_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION)) {
                        case 1: {
                            dataAccessContainer.setMinimizeStringWidths(true);
                            break;
                        }
                        case 2: {
                            dataAccessContainer.setMinimizeStringWidths(false);
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public void displayDacError(String string) {
        SpssAlertOptionPane.showErrorMessageDialog(this.mSpssFrame, string, VersionInfo.getAppVersionString());
    }

    @Deprecated
    public void displayFileError(String string) {
        this.displayDacError(String.format(ResUtil.getString("ERR_FILE_NOT_OF_DATA_TYPE_ERROR"), string));
    }

    public boolean proceedWithNewDataset() {
        return SpssMgr.getSpssMgr().proceedWithNewDataset();
    }

    public boolean canProcessPasteSyntax() {
        return this.mSpssFrame instanceof SyntaxFrame;
    }

    public void pasteSyntax(String string) {
        SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
        boolean bl = syntaxEditorState.isPasteAtCursor();
        if (!bl) {
            string = "\n" + string;
        }
        ISyntaxDocument iSyntaxDocument = SyntaxMgr.getSyntaxMgr().getDesignatedDocument();
        iSyntaxDocument.pasteSyntax(string);
    }

    public static boolean runReadExcelDataDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        ResourceBundle resourceBundle;
        boolean bl = true;
        ExcelReadInfo excelReadInfo = DacMgrUICallback.retrieveXlsSheetVector(dataAccessContainer);
        DACErrorResponse dACErrorResponse = excelReadInfo.getRetVal();
        if (dACErrorResponse.getResourceId() != 0) {
            resourceBundle = ResUtil.getBundle(DacResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            switch (dACErrorResponse.getResourceId()) {
                case 2005: {
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame, UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_JVM_CREATE_ERROR_MSG"), UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_RTD_WARNING_TITLE"));
                    break;
                }
                default: {
                    String string = dACErrorResponse.getTextStr();
                    if (string != null && string.length() > 0) {
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, string, UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_RTD_WARNING_TITLE"));
                        break;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame, string, UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_FILE_ACCESS_ERROR_MSG"));
                }
            }
            bl = false;
        }
        if (bl) {
            resourceBundle = (BaseExcelDacData)dataAccessContainer.getDacData();
            if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_XLSX)) {
                if (excelReadInfo.getVersionNumber() < 5) {
                    resourceBundle.setVersionNumber(7);
                } else {
                    resourceBundle.setVersionNumber(excelReadInfo.getVersionNumber());
                }
            } else {
                resourceBundle.setVersionNumber(excelReadInfo.getVersionNumber());
            }
            if (excelReadInfo.getVersionNumber() >= 4) {
                bl = ReadExcelFileDialog.runExcelRangeDialog(spssFrame, dataAccessContainer, excelReadInfo.getSheetInfos());
            } else {
                SelectRangeDlg.setSheetInfos(excelReadInfo.getSheetInfos());
                bl = SelectRangeDlg.runExcelRangeDialog(spssFrame, dataAccessContainer);
            }
        }
        return bl;
    }

    public static ExcelReadInfo retrieveXlsSheetVector(DataAccessContainer dataAccessContainer) {
        DACErrorResponse dACErrorResponse;
        Vector<ExcelSheetInfo> vector = new Vector<ExcelSheetInfo>();
        int n = -1;
        if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_ODF_CALC)) {
            ODFCalcDataProxy oDFCalcDataProxy = ODFCalcDataProxy.getODFCalcProxy();
            dACErrorResponse = oDFCalcDataProxy.openAndReadExtents(dataAccessContainer.getDataSpec(), vector);
        } else if (dataAccessContainer.getDacType().equals((Object)DacType.DAC_XLSX)) {
            ExcelXDataProxy excelXDataProxy = ExcelXDataProxy.getExcelXProxy();
            dACErrorResponse = excelXDataProxy.openAndReadExtents(dataAccessContainer.getDataSpec(), vector);
        } else {
            ExcelDataProxy excelDataProxy = ExcelDataProxy.getExcelProxy();
            dACErrorResponse = excelDataProxy.openAndReadExtents(dataAccessContainer.getDataSpec(), vector);
        }
        n = DacMgrUICallback.getVersionNumber(dataAccessContainer.getDataSpec());
        if (dACErrorResponse.getResourceId() != 0) {
            vector = null;
        }
        return new ExcelReadInfo(dACErrorResponse, vector, n);
    }

    private static int getVersionNumber(String string) {
        int n = -1;
        if (string != null) {
            String string2 = string.substring(string.lastIndexOf("."));
            if (string2.equals(".xls")) {
                n = 4;
            } else if (string2.equals(".xlsx") || string2.equals(".xlsm")) {
                n = 7;
            }
        }
        return n;
    }

    public static boolean runReadTextDataDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer) {
        boolean bl = true;
        if (dataAccessContainer.getUserSpecifiedDacType().equals((Object)DacType.DAC_TXT_CSV)) {
            ReadCSVFileDialog readCSVFileDialog = new ReadCSVFileDialog(spssFrame, dataAccessContainer, null);
            if (readCSVFileDialog.isOkToContinue()) {
                dataAccessContainer.setIsPaste(readCSVFileDialog.isPaste());
                dataAccessContainer.setIsPasteOrRun(readCSVFileDialog.isPasteOrRun());
            }
            bl = readCSVFileDialog.isOkToContinue();
            DacMgrUICallback.closeFile();
        } else {
            ReadTextDataWizardDlg.setDacInfo(dataAccessContainer, null);
            ReadTextDataWizardDlg readTextDataWizardDlg = new ReadTextDataWizardDlg(spssFrame);
            dataAccessContainer.setIsPaste(readTextDataWizardDlg.isPaste());
            dataAccessContainer.setIsPasteOrRun(readTextDataWizardDlg.isPasteOrRun());
            readTextDataWizardDlg.setGeneratedSyntax(dataAccessContainer.getGeneratedSyntax());
            bl = readTextDataWizardDlg.isOkToContinue();
            DacMgrUICallback.closeFile();
        }
        return bl;
    }

    public static void closeFile() {
        if (mProxy != null) {
            mProxy.closeFile();
        }
        mOldLastRecordReadLineNum = 0;
        mEndOfFileReached = false;
        mKillUpdateDate = false;
    }

    public static int openFileInitTextDacData(DataAccessContainer dataAccessContainer) {
        int n = -1;
        mProxy = TextDacProxy.getTextDacProxy();
        if (mProxy.openFile(dataAccessContainer, false)) {
            mProxy.seekBegin();
            n = DacMgrUICallback.updateTextDacData(dataAccessContainer, 200, false, true, null);
            ((TextDac.TextDacData)dataAccessContainer.getDacData()).getCaseDescriptor().setLinesToScanForDataFormat(200);
        }
        return n;
    }

    public static int updateTextDacData(DataAccessContainer dataAccessContainer, Integer n, boolean bl, boolean bl2, LinesReadProgressListener linesReadProgressListener) {
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (dataAccessContainer == null || dataAccessContainer.getDataSpec() == null) {
            return -1;
        }
        if (mEndOfFileReached) {
            return -4;
        }
        TextDac.TextDacData textDacData = (TextDac.TextDacData)dataAccessContainer.getDacData();
        int n3 = textDacData.getCaseMap().size();
        n = n == null ? 200 : n;
        int n4 = n - mOldLastRecordReadLineNum;
        int n5 = mOldLastRecordReadLineNum;
        if (n4 > 0) {
            int n6;
            if (n != null) {
                mProxy.setRecommendedSampleSize(n.intValue());
            }
            boolean bl5 = mProxy.getNoNewLineMode();
            textDacData.getCaseDescriptor().setNoNewLineMode(bl5);
            for (n6 = 0; n6 < n4 && !mKillUpdateDate; ++n6) {
                String string = mProxy.getRecord();
                if (string == null) {
                    mEndOfFileReached = true;
                    if (linesReadProgressListener == null) break;
                    linesReadProgressListener.endOfFileReached();
                    break;
                }
                ++mOldLastRecordReadLineNum;
                if (string.trim().length() != 0) {
                    bl3 = true;
                }
                if (string.length() > 199998) {
                    bl4 = true;
                    break;
                }
                if (textDacData.getDataSize() + string.length() > 4000000) break;
                boolean bl6 = n6 % 100 == 0;
                textDacData.fillRecord(n5 + n6, string);
                if (linesReadProgressListener == null) continue;
                linesReadProgressListener.linesReadProgressProgress(n5 + n6, n, (int)((double)mOldLastRecordReadLineNum / (double)n.intValue() * 100.0));
            }
            if (!mKillUpdateDate) {
                if (n6 == n4 && linesReadProgressListener != null) {
                    linesReadProgressListener.allLinesReadSuccessfully();
                }
                if (bl2) {
                    textDacData.setupDelimInfo(dataAccessContainer.getUserSpecifiedDacType().equals((Object)DacType.DAC_TXT_CSV));
                }
                textDacData.setEncoding(dataAccessContainer.getTextFileEncoding());
                textDacData.setPasteButtonClick(dataAccessContainer.getIsPaste());
                if (bl) {
                    ReadTextDataWizardDlg.clearVarTypes(textDacData);
                }
                if (n4 > 0 && !bl3) {
                    n2 = -2;
                } else if (bl4) {
                    n2 = -3;
                }
            } else {
                if (linesReadProgressListener != null) {
                    linesReadProgressListener.updateStopped();
                }
                n2 = -2;
            }
        }
        mKillUpdateDate = false;
        return n2;
    }

    public static void killUpdateTextDacData() {
        mKillUpdateDate = true;
    }

    public static int getOldLastRecordReadLineNum() {
        return mOldLastRecordReadLineNum;
    }

    public static boolean isEndOfFileReached() {
        return mEndOfFileReached;
    }

    public static class ExcelReadInfo {
        DACErrorResponse mRetVal;
        Vector<ExcelSheetInfo> mSheetInfos = new Vector();
        int mVersionNumber = -1;

        ExcelReadInfo(DACErrorResponse dACErrorResponse, Vector<ExcelSheetInfo> vector, int n) {
            this.mRetVal = dACErrorResponse;
            this.mSheetInfos = vector;
            this.mVersionNumber = n;
        }

        public DACErrorResponse getRetVal() {
            return this.mRetVal;
        }

        public Vector<ExcelSheetInfo> getSheetInfos() {
            return this.mSheetInfos;
        }

        public int getVersionNumber() {
            return this.mVersionNumber;
        }
    }

    public static interface LinesReadProgressListener {
        public void linesReadProgressProgress(int var1, int var2, int var3);

        public void endOfFileReached();

        public void allLinesReadSuccessfully();

        public void updateStopped();
    }
}

